# OpenTelemetry Collector Example

This example illustrates how to export trace and metric data from the
OpenTelemetry-Go SDK to the OpenTelemetry Collector. From there, we bring the
trace data to Jaeger and the metric data to Prometheus
The complete flow is:

```
                                          -----> Jaeger (trace)
App + SDK ---> OpenTelemetry Collector ---|
                                          -----> Prometheus (metrics)
```

# Prerequisites

You will need [Docker Compose V2](https://docs.docker.com/compose/) installed for this demo.

# Deploying to docker compose

This command will bring up the OpenTelemetry Collector, Jaeger, and Prometheus, and
expose the necessary ports for you to view the data.

```bash
docker compose up -d
```

# Running the code

You can find the complete code for this example in the [main.go](./main.go)
file. To run it, ensure you have a somewhat recent version of Go (preferably >=
1.13) and do

```bash
go run main.go
```

The example simulates an application, hard at work, computing for ten seconds
then finishing.

# Viewing instrumentation data

Now the exciting part! Let's check out the telemetry data generated by our
sample application

## Jaeger UI

The Jaeger UI is available at
[http://localhost:16686](http://localhost:16686). Navigate there in your favorite
web-browser to view the generated traces.

## Prometheus

The Prometheus UI is available at
[http://localhost:9090](http://localhost:9090). Navigate there in your favorite
web-browser to view the generated metrics, for instance, `testapp_run_total`.

# Shutting down

To shut down and clean the example, run

```bash
docker compose down
```
