// Package render is the X client API for the RENDER extension.
package render

// This file is automatically generated from render.xml. Edit at your peril!

import (
	"github.com/BurntSushi/xgb"

	"github.com/BurntSushi/xgb/xproto"
)

// Init must be called before using the RENDER extension.
func Init(c *xgb.Conn) error {
	reply, err := xproto.QueryExtension(c, 6, "RENDER").Reply()
	switch {
	case err != nil:
		return err
	case !reply.Present:
		return xgb.Errorf("No extension named RENDER could be found on on the server.")
	}

	c.ExtLock.Lock()
	c.Extensions["RENDER"] = reply.MajorOpcode
	c.ExtLock.Unlock()
	for evNum, fun := range xgb.NewExtEventFuncs["RENDER"] {
		xgb.NewEventFuncs[int(reply.FirstEvent)+evNum] = fun
	}
	for errNum, fun := range xgb.NewExtErrorFuncs["RENDER"] {
		xgb.NewErrorFuncs[int(reply.FirstError)+errNum] = fun
	}
	return nil
}

func init() {
	xgb.NewExtEventFuncs["RENDER"] = make(map[int]xgb.NewEventFun)
	xgb.NewExtErrorFuncs["RENDER"] = make(map[int]xgb.NewErrorFun)
}

type Animcursorelt struct {
	Cursor xproto.Cursor
	Delay  uint32
}

// AnimcursoreltRead reads a byte slice into a Animcursorelt value.
func AnimcursoreltRead(buf []byte, v *Animcursorelt) int {
	b := 0

	v.Cursor = xproto.Cursor(xgb.Get32(buf[b:]))
	b += 4

	v.Delay = xgb.Get32(buf[b:])
	b += 4

	return b
}

// AnimcursoreltReadList reads a byte slice into a list of Animcursorelt values.
func AnimcursoreltReadList(buf []byte, dest []Animcursorelt) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Animcursorelt{}
		b += AnimcursoreltRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Animcursorelt value to a byte slice.
func (v Animcursorelt) Bytes() []byte {
	buf := make([]byte, 8)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Cursor))
	b += 4

	xgb.Put32(buf[b:], v.Delay)
	b += 4

	return buf[:b]
}

// AnimcursoreltListBytes writes a list of Animcursorelt values to a byte slice.
func AnimcursoreltListBytes(buf []byte, list []Animcursorelt) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Color struct {
	Red   uint16
	Green uint16
	Blue  uint16
	Alpha uint16
}

// ColorRead reads a byte slice into a Color value.
func ColorRead(buf []byte, v *Color) int {
	b := 0

	v.Red = xgb.Get16(buf[b:])
	b += 2

	v.Green = xgb.Get16(buf[b:])
	b += 2

	v.Blue = xgb.Get16(buf[b:])
	b += 2

	v.Alpha = xgb.Get16(buf[b:])
	b += 2

	return b
}

// ColorReadList reads a byte slice into a list of Color values.
func ColorReadList(buf []byte, dest []Color) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Color{}
		b += ColorRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Color value to a byte slice.
func (v Color) Bytes() []byte {
	buf := make([]byte, 8)
	b := 0

	xgb.Put16(buf[b:], v.Red)
	b += 2

	xgb.Put16(buf[b:], v.Green)
	b += 2

	xgb.Put16(buf[b:], v.Blue)
	b += 2

	xgb.Put16(buf[b:], v.Alpha)
	b += 2

	return buf[:b]
}

// ColorListBytes writes a list of Color values to a byte slice.
func ColorListBytes(buf []byte, list []Color) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

const (
	CpRepeat           = 1
	CpAlphaMap         = 2
	CpAlphaXOrigin     = 4
	CpAlphaYOrigin     = 8
	CpClipXOrigin      = 16
	CpClipYOrigin      = 32
	CpClipMask         = 64
	CpGraphicsExposure = 128
	CpSubwindowMode    = 256
	CpPolyEdge         = 512
	CpPolyMode         = 1024
	CpDither           = 2048
	CpComponentAlpha   = 4096
)

type Directformat struct {
	RedShift   uint16
	RedMask    uint16
	GreenShift uint16
	GreenMask  uint16
	BlueShift  uint16
	BlueMask   uint16
	AlphaShift uint16
	AlphaMask  uint16
}

// DirectformatRead reads a byte slice into a Directformat value.
func DirectformatRead(buf []byte, v *Directformat) int {
	b := 0

	v.RedShift = xgb.Get16(buf[b:])
	b += 2

	v.RedMask = xgb.Get16(buf[b:])
	b += 2

	v.GreenShift = xgb.Get16(buf[b:])
	b += 2

	v.GreenMask = xgb.Get16(buf[b:])
	b += 2

	v.BlueShift = xgb.Get16(buf[b:])
	b += 2

	v.BlueMask = xgb.Get16(buf[b:])
	b += 2

	v.AlphaShift = xgb.Get16(buf[b:])
	b += 2

	v.AlphaMask = xgb.Get16(buf[b:])
	b += 2

	return b
}

// DirectformatReadList reads a byte slice into a list of Directformat values.
func DirectformatReadList(buf []byte, dest []Directformat) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Directformat{}
		b += DirectformatRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Directformat value to a byte slice.
func (v Directformat) Bytes() []byte {
	buf := make([]byte, 16)
	b := 0

	xgb.Put16(buf[b:], v.RedShift)
	b += 2

	xgb.Put16(buf[b:], v.RedMask)
	b += 2

	xgb.Put16(buf[b:], v.GreenShift)
	b += 2

	xgb.Put16(buf[b:], v.GreenMask)
	b += 2

	xgb.Put16(buf[b:], v.BlueShift)
	b += 2

	xgb.Put16(buf[b:], v.BlueMask)
	b += 2

	xgb.Put16(buf[b:], v.AlphaShift)
	b += 2

	xgb.Put16(buf[b:], v.AlphaMask)
	b += 2

	return buf[:b]
}

// DirectformatListBytes writes a list of Directformat values to a byte slice.
func DirectformatListBytes(buf []byte, list []Directformat) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Fixed int32

type Glyph uint32

// BadGlyph is the error number for a BadGlyph.
const BadGlyph = 4

type GlyphError struct {
	Sequence uint16
	NiceName string
}

// GlyphErrorNew constructs a GlyphError value that implements xgb.Error from a byte slice.
func GlyphErrorNew(buf []byte) xgb.Error {
	v := GlyphError{}
	v.NiceName = "Glyph"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadGlyph error.
// This is mostly used internally.
func (err GlyphError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadGlyph error. If no bad value exists, 0 is returned.
func (err GlyphError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadGlyph error.

func (err GlyphError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadGlyph {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["RENDER"][4] = GlyphErrorNew
}

// BadGlyphSet is the error number for a BadGlyphSet.
const BadGlyphSet = 3

type GlyphSetError struct {
	Sequence uint16
	NiceName string
}

// GlyphSetErrorNew constructs a GlyphSetError value that implements xgb.Error from a byte slice.
func GlyphSetErrorNew(buf []byte) xgb.Error {
	v := GlyphSetError{}
	v.NiceName = "GlyphSet"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadGlyphSet error.
// This is mostly used internally.
func (err GlyphSetError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadGlyphSet error. If no bad value exists, 0 is returned.
func (err GlyphSetError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadGlyphSet error.

func (err GlyphSetError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadGlyphSet {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["RENDER"][3] = GlyphSetErrorNew
}

type Glyphinfo struct {
	Width  uint16
	Height uint16
	X      int16
	Y      int16
	XOff   int16
	YOff   int16
}

// GlyphinfoRead reads a byte slice into a Glyphinfo value.
func GlyphinfoRead(buf []byte, v *Glyphinfo) int {
	b := 0

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.X = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Y = int16(xgb.Get16(buf[b:]))
	b += 2

	v.XOff = int16(xgb.Get16(buf[b:]))
	b += 2

	v.YOff = int16(xgb.Get16(buf[b:]))
	b += 2

	return b
}

// GlyphinfoReadList reads a byte slice into a list of Glyphinfo values.
func GlyphinfoReadList(buf []byte, dest []Glyphinfo) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Glyphinfo{}
		b += GlyphinfoRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Glyphinfo value to a byte slice.
func (v Glyphinfo) Bytes() []byte {
	buf := make([]byte, 12)
	b := 0

	xgb.Put16(buf[b:], v.Width)
	b += 2

	xgb.Put16(buf[b:], v.Height)
	b += 2

	xgb.Put16(buf[b:], uint16(v.X))
	b += 2

	xgb.Put16(buf[b:], uint16(v.Y))
	b += 2

	xgb.Put16(buf[b:], uint16(v.XOff))
	b += 2

	xgb.Put16(buf[b:], uint16(v.YOff))
	b += 2

	return buf[:b]
}

// GlyphinfoListBytes writes a list of Glyphinfo values to a byte slice.
func GlyphinfoListBytes(buf []byte, list []Glyphinfo) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Glyphset uint32

func NewGlyphsetId(c *xgb.Conn) (Glyphset, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Glyphset(id), nil
}

type Indexvalue struct {
	Pixel uint32
	Red   uint16
	Green uint16
	Blue  uint16
	Alpha uint16
}

// IndexvalueRead reads a byte slice into a Indexvalue value.
func IndexvalueRead(buf []byte, v *Indexvalue) int {
	b := 0

	v.Pixel = xgb.Get32(buf[b:])
	b += 4

	v.Red = xgb.Get16(buf[b:])
	b += 2

	v.Green = xgb.Get16(buf[b:])
	b += 2

	v.Blue = xgb.Get16(buf[b:])
	b += 2

	v.Alpha = xgb.Get16(buf[b:])
	b += 2

	return b
}

// IndexvalueReadList reads a byte slice into a list of Indexvalue values.
func IndexvalueReadList(buf []byte, dest []Indexvalue) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Indexvalue{}
		b += IndexvalueRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Indexvalue value to a byte slice.
func (v Indexvalue) Bytes() []byte {
	buf := make([]byte, 12)
	b := 0

	xgb.Put32(buf[b:], v.Pixel)
	b += 4

	xgb.Put16(buf[b:], v.Red)
	b += 2

	xgb.Put16(buf[b:], v.Green)
	b += 2

	xgb.Put16(buf[b:], v.Blue)
	b += 2

	xgb.Put16(buf[b:], v.Alpha)
	b += 2

	return buf[:b]
}

// IndexvalueListBytes writes a list of Indexvalue values to a byte slice.
func IndexvalueListBytes(buf []byte, list []Indexvalue) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Linefix struct {
	P1 Pointfix
	P2 Pointfix
}

// LinefixRead reads a byte slice into a Linefix value.
func LinefixRead(buf []byte, v *Linefix) int {
	b := 0

	v.P1 = Pointfix{}
	b += PointfixRead(buf[b:], &v.P1)

	v.P2 = Pointfix{}
	b += PointfixRead(buf[b:], &v.P2)

	return b
}

// LinefixReadList reads a byte slice into a list of Linefix values.
func LinefixReadList(buf []byte, dest []Linefix) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Linefix{}
		b += LinefixRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Linefix value to a byte slice.
func (v Linefix) Bytes() []byte {
	buf := make([]byte, 16)
	b := 0

	{
		structBytes := v.P1.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	{
		structBytes := v.P2.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	return buf[:b]
}

// LinefixListBytes writes a list of Linefix values to a byte slice.
func LinefixListBytes(buf []byte, list []Linefix) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

// BadPictFormat is the error number for a BadPictFormat.
const BadPictFormat = 0

type PictFormatError struct {
	Sequence uint16
	NiceName string
}

// PictFormatErrorNew constructs a PictFormatError value that implements xgb.Error from a byte slice.
func PictFormatErrorNew(buf []byte) xgb.Error {
	v := PictFormatError{}
	v.NiceName = "PictFormat"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadPictFormat error.
// This is mostly used internally.
func (err PictFormatError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadPictFormat error. If no bad value exists, 0 is returned.
func (err PictFormatError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadPictFormat error.

func (err PictFormatError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadPictFormat {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["RENDER"][0] = PictFormatErrorNew
}

// BadPictOp is the error number for a BadPictOp.
const BadPictOp = 2

type PictOpError struct {
	Sequence uint16
	NiceName string
}

// PictOpErrorNew constructs a PictOpError value that implements xgb.Error from a byte slice.
func PictOpErrorNew(buf []byte) xgb.Error {
	v := PictOpError{}
	v.NiceName = "PictOp"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadPictOp error.
// This is mostly used internally.
func (err PictOpError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadPictOp error. If no bad value exists, 0 is returned.
func (err PictOpError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadPictOp error.

func (err PictOpError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadPictOp {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["RENDER"][2] = PictOpErrorNew
}

const (
	PictOpClear               = 0
	PictOpSrc                 = 1
	PictOpDst                 = 2
	PictOpOver                = 3
	PictOpOverReverse         = 4
	PictOpIn                  = 5
	PictOpInReverse           = 6
	PictOpOut                 = 7
	PictOpOutReverse          = 8
	PictOpAtop                = 9
	PictOpAtopReverse         = 10
	PictOpXor                 = 11
	PictOpAdd                 = 12
	PictOpSaturate            = 13
	PictOpDisjointClear       = 16
	PictOpDisjointSrc         = 17
	PictOpDisjointDst         = 18
	PictOpDisjointOver        = 19
	PictOpDisjointOverReverse = 20
	PictOpDisjointIn          = 21
	PictOpDisjointInReverse   = 22
	PictOpDisjointOut         = 23
	PictOpDisjointOutReverse  = 24
	PictOpDisjointAtop        = 25
	PictOpDisjointAtopReverse = 26
	PictOpDisjointXor         = 27
	PictOpConjointClear       = 32
	PictOpConjointSrc         = 33
	PictOpConjointDst         = 34
	PictOpConjointOver        = 35
	PictOpConjointOverReverse = 36
	PictOpConjointIn          = 37
	PictOpConjointInReverse   = 38
	PictOpConjointOut         = 39
	PictOpConjointOutReverse  = 40
	PictOpConjointAtop        = 41
	PictOpConjointAtopReverse = 42
	PictOpConjointXor         = 43
	PictOpMultiply            = 48
	PictOpScreen              = 49
	PictOpOverlay             = 50
	PictOpDarken              = 51
	PictOpLighten             = 52
	PictOpColorDodge          = 53
	PictOpColorBurn           = 54
	PictOpHardLight           = 55
	PictOpSoftLight           = 56
	PictOpDifference          = 57
	PictOpExclusion           = 58
	PictOpHSLHue              = 59
	PictOpHSLSaturation       = 60
	PictOpHSLColor            = 61
	PictOpHSLLuminosity       = 62
)

const (
	PictTypeIndexed = 0
	PictTypeDirect  = 1
)

type Pictdepth struct {
	Depth byte
	// padding: 1 bytes
	NumVisuals uint16
	// padding: 4 bytes
	Visuals []Pictvisual // size: xgb.Pad((int(NumVisuals) * 8))
}

// PictdepthRead reads a byte slice into a Pictdepth value.
func PictdepthRead(buf []byte, v *Pictdepth) int {
	b := 0

	v.Depth = buf[b]
	b += 1

	b += 1 // padding

	v.NumVisuals = xgb.Get16(buf[b:])
	b += 2

	b += 4 // padding

	v.Visuals = make([]Pictvisual, v.NumVisuals)
	b += PictvisualReadList(buf[b:], v.Visuals)

	return b
}

// PictdepthReadList reads a byte slice into a list of Pictdepth values.
func PictdepthReadList(buf []byte, dest []Pictdepth) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Pictdepth{}
		b += PictdepthRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Pictdepth value to a byte slice.
func (v Pictdepth) Bytes() []byte {
	buf := make([]byte, (8 + xgb.Pad((int(v.NumVisuals) * 8))))
	b := 0

	buf[b] = v.Depth
	b += 1

	b += 1 // padding

	xgb.Put16(buf[b:], v.NumVisuals)
	b += 2

	b += 4 // padding

	b += PictvisualListBytes(buf[b:], v.Visuals)

	return buf[:b]
}

// PictdepthListBytes writes a list of Pictdepth values to a byte slice.
func PictdepthListBytes(buf []byte, list []Pictdepth) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

// PictdepthListSize computes the size (bytes) of a list of Pictdepth values.
func PictdepthListSize(list []Pictdepth) int {
	size := 0
	for _, item := range list {
		size += (8 + xgb.Pad((int(item.NumVisuals) * 8)))
	}
	return size
}

type Pictformat uint32

func NewPictformatId(c *xgb.Conn) (Pictformat, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Pictformat(id), nil
}

type Pictforminfo struct {
	Id    Pictformat
	Type  byte
	Depth byte
	// padding: 2 bytes
	Direct   Directformat
	Colormap xproto.Colormap
}

// PictforminfoRead reads a byte slice into a Pictforminfo value.
func PictforminfoRead(buf []byte, v *Pictforminfo) int {
	b := 0

	v.Id = Pictformat(xgb.Get32(buf[b:]))
	b += 4

	v.Type = buf[b]
	b += 1

	v.Depth = buf[b]
	b += 1

	b += 2 // padding

	v.Direct = Directformat{}
	b += DirectformatRead(buf[b:], &v.Direct)

	v.Colormap = xproto.Colormap(xgb.Get32(buf[b:]))
	b += 4

	return b
}

// PictforminfoReadList reads a byte slice into a list of Pictforminfo values.
func PictforminfoReadList(buf []byte, dest []Pictforminfo) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Pictforminfo{}
		b += PictforminfoRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Pictforminfo value to a byte slice.
func (v Pictforminfo) Bytes() []byte {
	buf := make([]byte, 28)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Id))
	b += 4

	buf[b] = v.Type
	b += 1

	buf[b] = v.Depth
	b += 1

	b += 2 // padding

	{
		structBytes := v.Direct.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	xgb.Put32(buf[b:], uint32(v.Colormap))
	b += 4

	return buf[:b]
}

// PictforminfoListBytes writes a list of Pictforminfo values to a byte slice.
func PictforminfoListBytes(buf []byte, list []Pictforminfo) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Pictscreen struct {
	NumDepths uint32
	Fallback  Pictformat
	Depths    []Pictdepth // size: PictdepthListSize(Depths)
}

// PictscreenRead reads a byte slice into a Pictscreen value.
func PictscreenRead(buf []byte, v *Pictscreen) int {
	b := 0

	v.NumDepths = xgb.Get32(buf[b:])
	b += 4

	v.Fallback = Pictformat(xgb.Get32(buf[b:]))
	b += 4

	v.Depths = make([]Pictdepth, v.NumDepths)
	b += PictdepthReadList(buf[b:], v.Depths)

	return b
}

// PictscreenReadList reads a byte slice into a list of Pictscreen values.
func PictscreenReadList(buf []byte, dest []Pictscreen) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Pictscreen{}
		b += PictscreenRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Pictscreen value to a byte slice.
func (v Pictscreen) Bytes() []byte {
	buf := make([]byte, (8 + PictdepthListSize(v.Depths)))
	b := 0

	xgb.Put32(buf[b:], v.NumDepths)
	b += 4

	xgb.Put32(buf[b:], uint32(v.Fallback))
	b += 4

	b += PictdepthListBytes(buf[b:], v.Depths)

	return buf[:b]
}

// PictscreenListBytes writes a list of Pictscreen values to a byte slice.
func PictscreenListBytes(buf []byte, list []Pictscreen) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

// PictscreenListSize computes the size (bytes) of a list of Pictscreen values.
func PictscreenListSize(list []Pictscreen) int {
	size := 0
	for _, item := range list {
		size += (8 + PictdepthListSize(item.Depths))
	}
	return size
}

type Picture uint32

func NewPictureId(c *xgb.Conn) (Picture, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Picture(id), nil
}

// BadPicture is the error number for a BadPicture.
const BadPicture = 1

type PictureError struct {
	Sequence uint16
	NiceName string
}

// PictureErrorNew constructs a PictureError value that implements xgb.Error from a byte slice.
func PictureErrorNew(buf []byte) xgb.Error {
	v := PictureError{}
	v.NiceName = "Picture"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadPicture error.
// This is mostly used internally.
func (err PictureError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadPicture error. If no bad value exists, 0 is returned.
func (err PictureError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadPicture error.

func (err PictureError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadPicture {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["RENDER"][1] = PictureErrorNew
}

const (
	PictureNone = 0
)

type Pictvisual struct {
	Visual xproto.Visualid
	Format Pictformat
}

// PictvisualRead reads a byte slice into a Pictvisual value.
func PictvisualRead(buf []byte, v *Pictvisual) int {
	b := 0

	v.Visual = xproto.Visualid(xgb.Get32(buf[b:]))
	b += 4

	v.Format = Pictformat(xgb.Get32(buf[b:]))
	b += 4

	return b
}

// PictvisualReadList reads a byte slice into a list of Pictvisual values.
func PictvisualReadList(buf []byte, dest []Pictvisual) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Pictvisual{}
		b += PictvisualRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Pictvisual value to a byte slice.
func (v Pictvisual) Bytes() []byte {
	buf := make([]byte, 8)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Visual))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Format))
	b += 4

	return buf[:b]
}

// PictvisualListBytes writes a list of Pictvisual values to a byte slice.
func PictvisualListBytes(buf []byte, list []Pictvisual) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Pointfix struct {
	X Fixed
	Y Fixed
}

// PointfixRead reads a byte slice into a Pointfix value.
func PointfixRead(buf []byte, v *Pointfix) int {
	b := 0

	v.X = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Y = Fixed(xgb.Get32(buf[b:]))
	b += 4

	return b
}

// PointfixReadList reads a byte slice into a list of Pointfix values.
func PointfixReadList(buf []byte, dest []Pointfix) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Pointfix{}
		b += PointfixRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Pointfix value to a byte slice.
func (v Pointfix) Bytes() []byte {
	buf := make([]byte, 8)
	b := 0

	xgb.Put32(buf[b:], uint32(v.X))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Y))
	b += 4

	return buf[:b]
}

// PointfixListBytes writes a list of Pointfix values to a byte slice.
func PointfixListBytes(buf []byte, list []Pointfix) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

const (
	PolyEdgeSharp  = 0
	PolyEdgeSmooth = 1
)

const (
	PolyModePrecise   = 0
	PolyModeImprecise = 1
)

const (
	RepeatNone    = 0
	RepeatNormal  = 1
	RepeatPad     = 2
	RepeatReflect = 3
)

type Spanfix struct {
	L Fixed
	R Fixed
	Y Fixed
}

// SpanfixRead reads a byte slice into a Spanfix value.
func SpanfixRead(buf []byte, v *Spanfix) int {
	b := 0

	v.L = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.R = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Y = Fixed(xgb.Get32(buf[b:]))
	b += 4

	return b
}

// SpanfixReadList reads a byte slice into a list of Spanfix values.
func SpanfixReadList(buf []byte, dest []Spanfix) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Spanfix{}
		b += SpanfixRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Spanfix value to a byte slice.
func (v Spanfix) Bytes() []byte {
	buf := make([]byte, 12)
	b := 0

	xgb.Put32(buf[b:], uint32(v.L))
	b += 4

	xgb.Put32(buf[b:], uint32(v.R))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Y))
	b += 4

	return buf[:b]
}

// SpanfixListBytes writes a list of Spanfix values to a byte slice.
func SpanfixListBytes(buf []byte, list []Spanfix) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

const (
	SubPixelUnknown       = 0
	SubPixelHorizontalRGB = 1
	SubPixelHorizontalBGR = 2
	SubPixelVerticalRGB   = 3
	SubPixelVerticalBGR   = 4
	SubPixelNone          = 5
)

type Transform struct {
	Matrix11 Fixed
	Matrix12 Fixed
	Matrix13 Fixed
	Matrix21 Fixed
	Matrix22 Fixed
	Matrix23 Fixed
	Matrix31 Fixed
	Matrix32 Fixed
	Matrix33 Fixed
}

// TransformRead reads a byte slice into a Transform value.
func TransformRead(buf []byte, v *Transform) int {
	b := 0

	v.Matrix11 = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Matrix12 = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Matrix13 = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Matrix21 = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Matrix22 = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Matrix23 = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Matrix31 = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Matrix32 = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Matrix33 = Fixed(xgb.Get32(buf[b:]))
	b += 4

	return b
}

// TransformReadList reads a byte slice into a list of Transform values.
func TransformReadList(buf []byte, dest []Transform) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Transform{}
		b += TransformRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Transform value to a byte slice.
func (v Transform) Bytes() []byte {
	buf := make([]byte, 36)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Matrix11))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Matrix12))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Matrix13))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Matrix21))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Matrix22))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Matrix23))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Matrix31))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Matrix32))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Matrix33))
	b += 4

	return buf[:b]
}

// TransformListBytes writes a list of Transform values to a byte slice.
func TransformListBytes(buf []byte, list []Transform) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Trap struct {
	Top Spanfix
	Bot Spanfix
}

// TrapRead reads a byte slice into a Trap value.
func TrapRead(buf []byte, v *Trap) int {
	b := 0

	v.Top = Spanfix{}
	b += SpanfixRead(buf[b:], &v.Top)

	v.Bot = Spanfix{}
	b += SpanfixRead(buf[b:], &v.Bot)

	return b
}

// TrapReadList reads a byte slice into a list of Trap values.
func TrapReadList(buf []byte, dest []Trap) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Trap{}
		b += TrapRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Trap value to a byte slice.
func (v Trap) Bytes() []byte {
	buf := make([]byte, 24)
	b := 0

	{
		structBytes := v.Top.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	{
		structBytes := v.Bot.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	return buf[:b]
}

// TrapListBytes writes a list of Trap values to a byte slice.
func TrapListBytes(buf []byte, list []Trap) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Trapezoid struct {
	Top    Fixed
	Bottom Fixed
	Left   Linefix
	Right  Linefix
}

// TrapezoidRead reads a byte slice into a Trapezoid value.
func TrapezoidRead(buf []byte, v *Trapezoid) int {
	b := 0

	v.Top = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Bottom = Fixed(xgb.Get32(buf[b:]))
	b += 4

	v.Left = Linefix{}
	b += LinefixRead(buf[b:], &v.Left)

	v.Right = Linefix{}
	b += LinefixRead(buf[b:], &v.Right)

	return b
}

// TrapezoidReadList reads a byte slice into a list of Trapezoid values.
func TrapezoidReadList(buf []byte, dest []Trapezoid) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Trapezoid{}
		b += TrapezoidRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Trapezoid value to a byte slice.
func (v Trapezoid) Bytes() []byte {
	buf := make([]byte, 40)
	b := 0

	xgb.Put32(buf[b:], uint32(v.Top))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Bottom))
	b += 4

	{
		structBytes := v.Left.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	{
		structBytes := v.Right.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	return buf[:b]
}

// TrapezoidListBytes writes a list of Trapezoid values to a byte slice.
func TrapezoidListBytes(buf []byte, list []Trapezoid) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

type Triangle struct {
	P1 Pointfix
	P2 Pointfix
	P3 Pointfix
}

// TriangleRead reads a byte slice into a Triangle value.
func TriangleRead(buf []byte, v *Triangle) int {
	b := 0

	v.P1 = Pointfix{}
	b += PointfixRead(buf[b:], &v.P1)

	v.P2 = Pointfix{}
	b += PointfixRead(buf[b:], &v.P2)

	v.P3 = Pointfix{}
	b += PointfixRead(buf[b:], &v.P3)

	return b
}

// TriangleReadList reads a byte slice into a list of Triangle values.
func TriangleReadList(buf []byte, dest []Triangle) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Triangle{}
		b += TriangleRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Triangle value to a byte slice.
func (v Triangle) Bytes() []byte {
	buf := make([]byte, 24)
	b := 0

	{
		structBytes := v.P1.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	{
		structBytes := v.P2.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	{
		structBytes := v.P3.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	return buf[:b]
}

// TriangleListBytes writes a list of Triangle values to a byte slice.
func TriangleListBytes(buf []byte, list []Triangle) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

// Skipping definition for base type 'Bool'

// Skipping definition for base type 'Byte'

// Skipping definition for base type 'Card8'

// Skipping definition for base type 'Char'

// Skipping definition for base type 'Void'

// Skipping definition for base type 'Double'

// Skipping definition for base type 'Float'

// Skipping definition for base type 'Int16'

// Skipping definition for base type 'Int32'

// Skipping definition for base type 'Int8'

// Skipping definition for base type 'Card16'

// Skipping definition for base type 'Card32'

// AddGlyphsCookie is a cookie used only for AddGlyphs requests.
type AddGlyphsCookie struct {
	*xgb.Cookie
}

// AddGlyphs sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func AddGlyphs(c *xgb.Conn, Glyphset Glyphset, GlyphsLen uint32, Glyphids []uint32, Glyphs []Glyphinfo, Data []byte) AddGlyphsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'AddGlyphs' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(addGlyphsRequest(c, Glyphset, GlyphsLen, Glyphids, Glyphs, Data), cookie)
	return AddGlyphsCookie{cookie}
}

// AddGlyphsChecked sends a checked request.
// If an error occurs, it can be retrieved using AddGlyphsCookie.Check()
func AddGlyphsChecked(c *xgb.Conn, Glyphset Glyphset, GlyphsLen uint32, Glyphids []uint32, Glyphs []Glyphinfo, Data []byte) AddGlyphsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'AddGlyphs' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(addGlyphsRequest(c, Glyphset, GlyphsLen, Glyphids, Glyphs, Data), cookie)
	return AddGlyphsCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook AddGlyphsCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for AddGlyphs
// addGlyphsRequest writes a AddGlyphs request to a byte slice.
func addGlyphsRequest(c *xgb.Conn, Glyphset Glyphset, GlyphsLen uint32, Glyphids []uint32, Glyphs []Glyphinfo, Data []byte) []byte {
	size := xgb.Pad(((((12 + xgb.Pad((int(GlyphsLen) * 4))) + 4) + xgb.Pad((int(GlyphsLen) * 12))) + xgb.Pad((len(Data) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 20 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], uint32(Glyphset))
	b += 4

	xgb.Put32(buf[b:], GlyphsLen)
	b += 4

	for i := 0; i < int(GlyphsLen); i++ {
		xgb.Put32(buf[b:], Glyphids[i])
		b += 4
	}

	b = (b + 3) & ^3 // alignment gap

	b += GlyphinfoListBytes(buf[b:], Glyphs)

	copy(buf[b:], Data[:len(Data)])
	b += int(len(Data))

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// AddTrapsCookie is a cookie used only for AddTraps requests.
type AddTrapsCookie struct {
	*xgb.Cookie
}

// AddTraps sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func AddTraps(c *xgb.Conn, Picture Picture, XOff int16, YOff int16, Traps []Trap) AddTrapsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'AddTraps' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(addTrapsRequest(c, Picture, XOff, YOff, Traps), cookie)
	return AddTrapsCookie{cookie}
}

// AddTrapsChecked sends a checked request.
// If an error occurs, it can be retrieved using AddTrapsCookie.Check()
func AddTrapsChecked(c *xgb.Conn, Picture Picture, XOff int16, YOff int16, Traps []Trap) AddTrapsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'AddTraps' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(addTrapsRequest(c, Picture, XOff, YOff, Traps), cookie)
	return AddTrapsCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook AddTrapsCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for AddTraps
// addTrapsRequest writes a AddTraps request to a byte slice.
func addTrapsRequest(c *xgb.Conn, Picture Picture, XOff int16, YOff int16, Traps []Trap) []byte {
	size := xgb.Pad((12 + xgb.Pad((len(Traps) * 24))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 32 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	xgb.Put16(buf[b:], uint16(XOff))
	b += 2

	xgb.Put16(buf[b:], uint16(YOff))
	b += 2

	b += TrapListBytes(buf[b:], Traps)

	return buf
}

// ChangePictureCookie is a cookie used only for ChangePicture requests.
type ChangePictureCookie struct {
	*xgb.Cookie
}

// ChangePicture sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ChangePicture(c *xgb.Conn, Picture Picture, ValueMask uint32, ValueList []uint32) ChangePictureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'ChangePicture' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(changePictureRequest(c, Picture, ValueMask, ValueList), cookie)
	return ChangePictureCookie{cookie}
}

// ChangePictureChecked sends a checked request.
// If an error occurs, it can be retrieved using ChangePictureCookie.Check()
func ChangePictureChecked(c *xgb.Conn, Picture Picture, ValueMask uint32, ValueList []uint32) ChangePictureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'ChangePicture' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(changePictureRequest(c, Picture, ValueMask, ValueList), cookie)
	return ChangePictureCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ChangePictureCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ChangePicture
// changePictureRequest writes a ChangePicture request to a byte slice.
func changePictureRequest(c *xgb.Conn, Picture Picture, ValueMask uint32, ValueList []uint32) []byte {
	size := xgb.Pad((8 + (4 + xgb.Pad((4 * xgb.PopCount(int(ValueMask)))))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 5 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	xgb.Put32(buf[b:], ValueMask)
	b += 4
	for i := 0; i < xgb.PopCount(int(ValueMask)); i++ {
		xgb.Put32(buf[b:], ValueList[i])
		b += 4
	}
	b = xgb.Pad(b)

	return buf
}

// CompositeCookie is a cookie used only for Composite requests.
type CompositeCookie struct {
	*xgb.Cookie
}

// Composite sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func Composite(c *xgb.Conn, Op byte, Src Picture, Mask Picture, Dst Picture, SrcX int16, SrcY int16, MaskX int16, MaskY int16, DstX int16, DstY int16, Width uint16, Height uint16) CompositeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'Composite' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(compositeRequest(c, Op, Src, Mask, Dst, SrcX, SrcY, MaskX, MaskY, DstX, DstY, Width, Height), cookie)
	return CompositeCookie{cookie}
}

// CompositeChecked sends a checked request.
// If an error occurs, it can be retrieved using CompositeCookie.Check()
func CompositeChecked(c *xgb.Conn, Op byte, Src Picture, Mask Picture, Dst Picture, SrcX int16, SrcY int16, MaskX int16, MaskY int16, DstX int16, DstY int16, Width uint16, Height uint16) CompositeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'Composite' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(compositeRequest(c, Op, Src, Mask, Dst, SrcX, SrcY, MaskX, MaskY, DstX, DstY, Width, Height), cookie)
	return CompositeCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CompositeCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for Composite
// compositeRequest writes a Composite request to a byte slice.
func compositeRequest(c *xgb.Conn, Op byte, Src Picture, Mask Picture, Dst Picture, SrcX int16, SrcY int16, MaskX int16, MaskY int16, DstX int16, DstY int16, Width uint16, Height uint16) []byte {
	size := 36
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 8 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Op
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put32(buf[b:], uint32(Mask))
	b += 4

	xgb.Put32(buf[b:], uint32(Dst))
	b += 4

	xgb.Put16(buf[b:], uint16(SrcX))
	b += 2

	xgb.Put16(buf[b:], uint16(SrcY))
	b += 2

	xgb.Put16(buf[b:], uint16(MaskX))
	b += 2

	xgb.Put16(buf[b:], uint16(MaskY))
	b += 2

	xgb.Put16(buf[b:], uint16(DstX))
	b += 2

	xgb.Put16(buf[b:], uint16(DstY))
	b += 2

	xgb.Put16(buf[b:], Width)
	b += 2

	xgb.Put16(buf[b:], Height)
	b += 2

	return buf
}

// CompositeGlyphs16Cookie is a cookie used only for CompositeGlyphs16 requests.
type CompositeGlyphs16Cookie struct {
	*xgb.Cookie
}

// CompositeGlyphs16 sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CompositeGlyphs16(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, Glyphset Glyphset, SrcX int16, SrcY int16, Glyphcmds []byte) CompositeGlyphs16Cookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CompositeGlyphs16' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(compositeGlyphs16Request(c, Op, Src, Dst, MaskFormat, Glyphset, SrcX, SrcY, Glyphcmds), cookie)
	return CompositeGlyphs16Cookie{cookie}
}

// CompositeGlyphs16Checked sends a checked request.
// If an error occurs, it can be retrieved using CompositeGlyphs16Cookie.Check()
func CompositeGlyphs16Checked(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, Glyphset Glyphset, SrcX int16, SrcY int16, Glyphcmds []byte) CompositeGlyphs16Cookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CompositeGlyphs16' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(compositeGlyphs16Request(c, Op, Src, Dst, MaskFormat, Glyphset, SrcX, SrcY, Glyphcmds), cookie)
	return CompositeGlyphs16Cookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CompositeGlyphs16Cookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CompositeGlyphs16
// compositeGlyphs16Request writes a CompositeGlyphs16 request to a byte slice.
func compositeGlyphs16Request(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, Glyphset Glyphset, SrcX int16, SrcY int16, Glyphcmds []byte) []byte {
	size := xgb.Pad((28 + xgb.Pad((len(Glyphcmds) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 24 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Op
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put32(buf[b:], uint32(Dst))
	b += 4

	xgb.Put32(buf[b:], uint32(MaskFormat))
	b += 4

	xgb.Put32(buf[b:], uint32(Glyphset))
	b += 4

	xgb.Put16(buf[b:], uint16(SrcX))
	b += 2

	xgb.Put16(buf[b:], uint16(SrcY))
	b += 2

	copy(buf[b:], Glyphcmds[:len(Glyphcmds)])
	b += int(len(Glyphcmds))

	return buf
}

// CompositeGlyphs32Cookie is a cookie used only for CompositeGlyphs32 requests.
type CompositeGlyphs32Cookie struct {
	*xgb.Cookie
}

// CompositeGlyphs32 sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CompositeGlyphs32(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, Glyphset Glyphset, SrcX int16, SrcY int16, Glyphcmds []byte) CompositeGlyphs32Cookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CompositeGlyphs32' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(compositeGlyphs32Request(c, Op, Src, Dst, MaskFormat, Glyphset, SrcX, SrcY, Glyphcmds), cookie)
	return CompositeGlyphs32Cookie{cookie}
}

// CompositeGlyphs32Checked sends a checked request.
// If an error occurs, it can be retrieved using CompositeGlyphs32Cookie.Check()
func CompositeGlyphs32Checked(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, Glyphset Glyphset, SrcX int16, SrcY int16, Glyphcmds []byte) CompositeGlyphs32Cookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CompositeGlyphs32' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(compositeGlyphs32Request(c, Op, Src, Dst, MaskFormat, Glyphset, SrcX, SrcY, Glyphcmds), cookie)
	return CompositeGlyphs32Cookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CompositeGlyphs32Cookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CompositeGlyphs32
// compositeGlyphs32Request writes a CompositeGlyphs32 request to a byte slice.
func compositeGlyphs32Request(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, Glyphset Glyphset, SrcX int16, SrcY int16, Glyphcmds []byte) []byte {
	size := xgb.Pad((28 + xgb.Pad((len(Glyphcmds) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 25 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Op
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put32(buf[b:], uint32(Dst))
	b += 4

	xgb.Put32(buf[b:], uint32(MaskFormat))
	b += 4

	xgb.Put32(buf[b:], uint32(Glyphset))
	b += 4

	xgb.Put16(buf[b:], uint16(SrcX))
	b += 2

	xgb.Put16(buf[b:], uint16(SrcY))
	b += 2

	copy(buf[b:], Glyphcmds[:len(Glyphcmds)])
	b += int(len(Glyphcmds))

	return buf
}

// CompositeGlyphs8Cookie is a cookie used only for CompositeGlyphs8 requests.
type CompositeGlyphs8Cookie struct {
	*xgb.Cookie
}

// CompositeGlyphs8 sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CompositeGlyphs8(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, Glyphset Glyphset, SrcX int16, SrcY int16, Glyphcmds []byte) CompositeGlyphs8Cookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CompositeGlyphs8' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(compositeGlyphs8Request(c, Op, Src, Dst, MaskFormat, Glyphset, SrcX, SrcY, Glyphcmds), cookie)
	return CompositeGlyphs8Cookie{cookie}
}

// CompositeGlyphs8Checked sends a checked request.
// If an error occurs, it can be retrieved using CompositeGlyphs8Cookie.Check()
func CompositeGlyphs8Checked(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, Glyphset Glyphset, SrcX int16, SrcY int16, Glyphcmds []byte) CompositeGlyphs8Cookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CompositeGlyphs8' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(compositeGlyphs8Request(c, Op, Src, Dst, MaskFormat, Glyphset, SrcX, SrcY, Glyphcmds), cookie)
	return CompositeGlyphs8Cookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CompositeGlyphs8Cookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CompositeGlyphs8
// compositeGlyphs8Request writes a CompositeGlyphs8 request to a byte slice.
func compositeGlyphs8Request(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, Glyphset Glyphset, SrcX int16, SrcY int16, Glyphcmds []byte) []byte {
	size := xgb.Pad((28 + xgb.Pad((len(Glyphcmds) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 23 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Op
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put32(buf[b:], uint32(Dst))
	b += 4

	xgb.Put32(buf[b:], uint32(MaskFormat))
	b += 4

	xgb.Put32(buf[b:], uint32(Glyphset))
	b += 4

	xgb.Put16(buf[b:], uint16(SrcX))
	b += 2

	xgb.Put16(buf[b:], uint16(SrcY))
	b += 2

	copy(buf[b:], Glyphcmds[:len(Glyphcmds)])
	b += int(len(Glyphcmds))

	return buf
}

// CreateAnimCursorCookie is a cookie used only for CreateAnimCursor requests.
type CreateAnimCursorCookie struct {
	*xgb.Cookie
}

// CreateAnimCursor sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateAnimCursor(c *xgb.Conn, Cid xproto.Cursor, Cursors []Animcursorelt) CreateAnimCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateAnimCursor' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createAnimCursorRequest(c, Cid, Cursors), cookie)
	return CreateAnimCursorCookie{cookie}
}

// CreateAnimCursorChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateAnimCursorCookie.Check()
func CreateAnimCursorChecked(c *xgb.Conn, Cid xproto.Cursor, Cursors []Animcursorelt) CreateAnimCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateAnimCursor' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createAnimCursorRequest(c, Cid, Cursors), cookie)
	return CreateAnimCursorCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateAnimCursorCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateAnimCursor
// createAnimCursorRequest writes a CreateAnimCursor request to a byte slice.
func createAnimCursorRequest(c *xgb.Conn, Cid xproto.Cursor, Cursors []Animcursorelt) []byte {
	size := xgb.Pad((8 + xgb.Pad((len(Cursors) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 31 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Cid))
	b += 4

	b += AnimcursoreltListBytes(buf[b:], Cursors)

	return buf
}

// CreateConicalGradientCookie is a cookie used only for CreateConicalGradient requests.
type CreateConicalGradientCookie struct {
	*xgb.Cookie
}

// CreateConicalGradient sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateConicalGradient(c *xgb.Conn, Picture Picture, Center Pointfix, Angle Fixed, NumStops uint32, Stops []Fixed, Colors []Color) CreateConicalGradientCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateConicalGradient' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createConicalGradientRequest(c, Picture, Center, Angle, NumStops, Stops, Colors), cookie)
	return CreateConicalGradientCookie{cookie}
}

// CreateConicalGradientChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateConicalGradientCookie.Check()
func CreateConicalGradientChecked(c *xgb.Conn, Picture Picture, Center Pointfix, Angle Fixed, NumStops uint32, Stops []Fixed, Colors []Color) CreateConicalGradientCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateConicalGradient' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createConicalGradientRequest(c, Picture, Center, Angle, NumStops, Stops, Colors), cookie)
	return CreateConicalGradientCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateConicalGradientCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateConicalGradient
// createConicalGradientRequest writes a CreateConicalGradient request to a byte slice.
func createConicalGradientRequest(c *xgb.Conn, Picture Picture, Center Pointfix, Angle Fixed, NumStops uint32, Stops []Fixed, Colors []Color) []byte {
	size := xgb.Pad((((24 + xgb.Pad((int(NumStops) * 4))) + 4) + xgb.Pad((int(NumStops) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 36 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	{
		structBytes := Center.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	xgb.Put32(buf[b:], uint32(Angle))
	b += 4

	xgb.Put32(buf[b:], NumStops)
	b += 4

	for i := 0; i < int(NumStops); i++ {
		xgb.Put32(buf[b:], uint32(Stops[i]))
		b += 4
	}

	b = (b + 3) & ^3 // alignment gap

	b += ColorListBytes(buf[b:], Colors)

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// CreateCursorCookie is a cookie used only for CreateCursor requests.
type CreateCursorCookie struct {
	*xgb.Cookie
}

// CreateCursor sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateCursor(c *xgb.Conn, Cid xproto.Cursor, Source Picture, X uint16, Y uint16) CreateCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateCursor' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createCursorRequest(c, Cid, Source, X, Y), cookie)
	return CreateCursorCookie{cookie}
}

// CreateCursorChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateCursorCookie.Check()
func CreateCursorChecked(c *xgb.Conn, Cid xproto.Cursor, Source Picture, X uint16, Y uint16) CreateCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateCursor' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createCursorRequest(c, Cid, Source, X, Y), cookie)
	return CreateCursorCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateCursorCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateCursor
// createCursorRequest writes a CreateCursor request to a byte slice.
func createCursorRequest(c *xgb.Conn, Cid xproto.Cursor, Source Picture, X uint16, Y uint16) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 27 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Cid))
	b += 4

	xgb.Put32(buf[b:], uint32(Source))
	b += 4

	xgb.Put16(buf[b:], X)
	b += 2

	xgb.Put16(buf[b:], Y)
	b += 2

	return buf
}

// CreateGlyphSetCookie is a cookie used only for CreateGlyphSet requests.
type CreateGlyphSetCookie struct {
	*xgb.Cookie
}

// CreateGlyphSet sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateGlyphSet(c *xgb.Conn, Gsid Glyphset, Format Pictformat) CreateGlyphSetCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateGlyphSet' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createGlyphSetRequest(c, Gsid, Format), cookie)
	return CreateGlyphSetCookie{cookie}
}

// CreateGlyphSetChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateGlyphSetCookie.Check()
func CreateGlyphSetChecked(c *xgb.Conn, Gsid Glyphset, Format Pictformat) CreateGlyphSetCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateGlyphSet' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createGlyphSetRequest(c, Gsid, Format), cookie)
	return CreateGlyphSetCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateGlyphSetCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateGlyphSet
// createGlyphSetRequest writes a CreateGlyphSet request to a byte slice.
func createGlyphSetRequest(c *xgb.Conn, Gsid Glyphset, Format Pictformat) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 17 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Gsid))
	b += 4

	xgb.Put32(buf[b:], uint32(Format))
	b += 4

	return buf
}

// CreateLinearGradientCookie is a cookie used only for CreateLinearGradient requests.
type CreateLinearGradientCookie struct {
	*xgb.Cookie
}

// CreateLinearGradient sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateLinearGradient(c *xgb.Conn, Picture Picture, P1 Pointfix, P2 Pointfix, NumStops uint32, Stops []Fixed, Colors []Color) CreateLinearGradientCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateLinearGradient' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createLinearGradientRequest(c, Picture, P1, P2, NumStops, Stops, Colors), cookie)
	return CreateLinearGradientCookie{cookie}
}

// CreateLinearGradientChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateLinearGradientCookie.Check()
func CreateLinearGradientChecked(c *xgb.Conn, Picture Picture, P1 Pointfix, P2 Pointfix, NumStops uint32, Stops []Fixed, Colors []Color) CreateLinearGradientCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateLinearGradient' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createLinearGradientRequest(c, Picture, P1, P2, NumStops, Stops, Colors), cookie)
	return CreateLinearGradientCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateLinearGradientCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateLinearGradient
// createLinearGradientRequest writes a CreateLinearGradient request to a byte slice.
func createLinearGradientRequest(c *xgb.Conn, Picture Picture, P1 Pointfix, P2 Pointfix, NumStops uint32, Stops []Fixed, Colors []Color) []byte {
	size := xgb.Pad((((28 + xgb.Pad((int(NumStops) * 4))) + 4) + xgb.Pad((int(NumStops) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 34 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	{
		structBytes := P1.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	{
		structBytes := P2.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	xgb.Put32(buf[b:], NumStops)
	b += 4

	for i := 0; i < int(NumStops); i++ {
		xgb.Put32(buf[b:], uint32(Stops[i]))
		b += 4
	}

	b = (b + 3) & ^3 // alignment gap

	b += ColorListBytes(buf[b:], Colors)

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// CreatePictureCookie is a cookie used only for CreatePicture requests.
type CreatePictureCookie struct {
	*xgb.Cookie
}

// CreatePicture sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreatePicture(c *xgb.Conn, Pid Picture, Drawable xproto.Drawable, Format Pictformat, ValueMask uint32, ValueList []uint32) CreatePictureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreatePicture' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createPictureRequest(c, Pid, Drawable, Format, ValueMask, ValueList), cookie)
	return CreatePictureCookie{cookie}
}

// CreatePictureChecked sends a checked request.
// If an error occurs, it can be retrieved using CreatePictureCookie.Check()
func CreatePictureChecked(c *xgb.Conn, Pid Picture, Drawable xproto.Drawable, Format Pictformat, ValueMask uint32, ValueList []uint32) CreatePictureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreatePicture' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createPictureRequest(c, Pid, Drawable, Format, ValueMask, ValueList), cookie)
	return CreatePictureCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreatePictureCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreatePicture
// createPictureRequest writes a CreatePicture request to a byte slice.
func createPictureRequest(c *xgb.Conn, Pid Picture, Drawable xproto.Drawable, Format Pictformat, ValueMask uint32, ValueList []uint32) []byte {
	size := xgb.Pad((16 + (4 + xgb.Pad((4 * xgb.PopCount(int(ValueMask)))))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 4 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Pid))
	b += 4

	xgb.Put32(buf[b:], uint32(Drawable))
	b += 4

	xgb.Put32(buf[b:], uint32(Format))
	b += 4

	xgb.Put32(buf[b:], ValueMask)
	b += 4
	for i := 0; i < xgb.PopCount(int(ValueMask)); i++ {
		xgb.Put32(buf[b:], ValueList[i])
		b += 4
	}
	b = xgb.Pad(b)

	return buf
}

// CreateRadialGradientCookie is a cookie used only for CreateRadialGradient requests.
type CreateRadialGradientCookie struct {
	*xgb.Cookie
}

// CreateRadialGradient sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateRadialGradient(c *xgb.Conn, Picture Picture, Inner Pointfix, Outer Pointfix, InnerRadius Fixed, OuterRadius Fixed, NumStops uint32, Stops []Fixed, Colors []Color) CreateRadialGradientCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateRadialGradient' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createRadialGradientRequest(c, Picture, Inner, Outer, InnerRadius, OuterRadius, NumStops, Stops, Colors), cookie)
	return CreateRadialGradientCookie{cookie}
}

// CreateRadialGradientChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateRadialGradientCookie.Check()
func CreateRadialGradientChecked(c *xgb.Conn, Picture Picture, Inner Pointfix, Outer Pointfix, InnerRadius Fixed, OuterRadius Fixed, NumStops uint32, Stops []Fixed, Colors []Color) CreateRadialGradientCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateRadialGradient' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createRadialGradientRequest(c, Picture, Inner, Outer, InnerRadius, OuterRadius, NumStops, Stops, Colors), cookie)
	return CreateRadialGradientCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateRadialGradientCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateRadialGradient
// createRadialGradientRequest writes a CreateRadialGradient request to a byte slice.
func createRadialGradientRequest(c *xgb.Conn, Picture Picture, Inner Pointfix, Outer Pointfix, InnerRadius Fixed, OuterRadius Fixed, NumStops uint32, Stops []Fixed, Colors []Color) []byte {
	size := xgb.Pad((((36 + xgb.Pad((int(NumStops) * 4))) + 4) + xgb.Pad((int(NumStops) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 35 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	{
		structBytes := Inner.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	{
		structBytes := Outer.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	xgb.Put32(buf[b:], uint32(InnerRadius))
	b += 4

	xgb.Put32(buf[b:], uint32(OuterRadius))
	b += 4

	xgb.Put32(buf[b:], NumStops)
	b += 4

	for i := 0; i < int(NumStops); i++ {
		xgb.Put32(buf[b:], uint32(Stops[i]))
		b += 4
	}

	b = (b + 3) & ^3 // alignment gap

	b += ColorListBytes(buf[b:], Colors)

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// CreateSolidFillCookie is a cookie used only for CreateSolidFill requests.
type CreateSolidFillCookie struct {
	*xgb.Cookie
}

// CreateSolidFill sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateSolidFill(c *xgb.Conn, Picture Picture, Color Color) CreateSolidFillCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateSolidFill' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createSolidFillRequest(c, Picture, Color), cookie)
	return CreateSolidFillCookie{cookie}
}

// CreateSolidFillChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateSolidFillCookie.Check()
func CreateSolidFillChecked(c *xgb.Conn, Picture Picture, Color Color) CreateSolidFillCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'CreateSolidFill' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createSolidFillRequest(c, Picture, Color), cookie)
	return CreateSolidFillCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateSolidFillCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateSolidFill
// createSolidFillRequest writes a CreateSolidFill request to a byte slice.
func createSolidFillRequest(c *xgb.Conn, Picture Picture, Color Color) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 33 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	{
		structBytes := Color.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	return buf
}

// FillRectanglesCookie is a cookie used only for FillRectangles requests.
type FillRectanglesCookie struct {
	*xgb.Cookie
}

// FillRectangles sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func FillRectangles(c *xgb.Conn, Op byte, Dst Picture, Color Color, Rects []xproto.Rectangle) FillRectanglesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'FillRectangles' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(fillRectanglesRequest(c, Op, Dst, Color, Rects), cookie)
	return FillRectanglesCookie{cookie}
}

// FillRectanglesChecked sends a checked request.
// If an error occurs, it can be retrieved using FillRectanglesCookie.Check()
func FillRectanglesChecked(c *xgb.Conn, Op byte, Dst Picture, Color Color, Rects []xproto.Rectangle) FillRectanglesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'FillRectangles' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(fillRectanglesRequest(c, Op, Dst, Color, Rects), cookie)
	return FillRectanglesCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook FillRectanglesCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for FillRectangles
// fillRectanglesRequest writes a FillRectangles request to a byte slice.
func fillRectanglesRequest(c *xgb.Conn, Op byte, Dst Picture, Color Color, Rects []xproto.Rectangle) []byte {
	size := xgb.Pad((20 + xgb.Pad((len(Rects) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 26 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Op
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], uint32(Dst))
	b += 4

	{
		structBytes := Color.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	b += xproto.RectangleListBytes(buf[b:], Rects)

	return buf
}

// FreeGlyphSetCookie is a cookie used only for FreeGlyphSet requests.
type FreeGlyphSetCookie struct {
	*xgb.Cookie
}

// FreeGlyphSet sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func FreeGlyphSet(c *xgb.Conn, Glyphset Glyphset) FreeGlyphSetCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'FreeGlyphSet' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(freeGlyphSetRequest(c, Glyphset), cookie)
	return FreeGlyphSetCookie{cookie}
}

// FreeGlyphSetChecked sends a checked request.
// If an error occurs, it can be retrieved using FreeGlyphSetCookie.Check()
func FreeGlyphSetChecked(c *xgb.Conn, Glyphset Glyphset) FreeGlyphSetCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'FreeGlyphSet' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(freeGlyphSetRequest(c, Glyphset), cookie)
	return FreeGlyphSetCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook FreeGlyphSetCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for FreeGlyphSet
// freeGlyphSetRequest writes a FreeGlyphSet request to a byte slice.
func freeGlyphSetRequest(c *xgb.Conn, Glyphset Glyphset) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 19 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Glyphset))
	b += 4

	return buf
}

// FreeGlyphsCookie is a cookie used only for FreeGlyphs requests.
type FreeGlyphsCookie struct {
	*xgb.Cookie
}

// FreeGlyphs sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func FreeGlyphs(c *xgb.Conn, Glyphset Glyphset, Glyphs []Glyph) FreeGlyphsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'FreeGlyphs' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(freeGlyphsRequest(c, Glyphset, Glyphs), cookie)
	return FreeGlyphsCookie{cookie}
}

// FreeGlyphsChecked sends a checked request.
// If an error occurs, it can be retrieved using FreeGlyphsCookie.Check()
func FreeGlyphsChecked(c *xgb.Conn, Glyphset Glyphset, Glyphs []Glyph) FreeGlyphsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'FreeGlyphs' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(freeGlyphsRequest(c, Glyphset, Glyphs), cookie)
	return FreeGlyphsCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook FreeGlyphsCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for FreeGlyphs
// freeGlyphsRequest writes a FreeGlyphs request to a byte slice.
func freeGlyphsRequest(c *xgb.Conn, Glyphset Glyphset, Glyphs []Glyph) []byte {
	size := xgb.Pad((8 + xgb.Pad((len(Glyphs) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 22 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Glyphset))
	b += 4

	for i := 0; i < int(len(Glyphs)); i++ {
		xgb.Put32(buf[b:], uint32(Glyphs[i]))
		b += 4
	}

	return buf
}

// FreePictureCookie is a cookie used only for FreePicture requests.
type FreePictureCookie struct {
	*xgb.Cookie
}

// FreePicture sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func FreePicture(c *xgb.Conn, Picture Picture) FreePictureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'FreePicture' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(freePictureRequest(c, Picture), cookie)
	return FreePictureCookie{cookie}
}

// FreePictureChecked sends a checked request.
// If an error occurs, it can be retrieved using FreePictureCookie.Check()
func FreePictureChecked(c *xgb.Conn, Picture Picture) FreePictureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'FreePicture' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(freePictureRequest(c, Picture), cookie)
	return FreePictureCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook FreePictureCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for FreePicture
// freePictureRequest writes a FreePicture request to a byte slice.
func freePictureRequest(c *xgb.Conn, Picture Picture) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 7 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	return buf
}

// QueryFiltersCookie is a cookie used only for QueryFilters requests.
type QueryFiltersCookie struct {
	*xgb.Cookie
}

// QueryFilters sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryFiltersCookie.Reply()
func QueryFilters(c *xgb.Conn, Drawable xproto.Drawable) QueryFiltersCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'QueryFilters' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryFiltersRequest(c, Drawable), cookie)
	return QueryFiltersCookie{cookie}
}

// QueryFiltersUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryFiltersUnchecked(c *xgb.Conn, Drawable xproto.Drawable) QueryFiltersCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'QueryFilters' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryFiltersRequest(c, Drawable), cookie)
	return QueryFiltersCookie{cookie}
}

// QueryFiltersReply represents the data returned from a QueryFilters request.
type QueryFiltersReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	NumAliases uint32
	NumFilters uint32
	// padding: 16 bytes
	Aliases []uint16     // size: xgb.Pad((int(NumAliases) * 2))
	Filters []xproto.Str // size: xproto.StrListSize(Filters)
}

// Reply blocks and returns the reply data for a QueryFilters request.
func (cook QueryFiltersCookie) Reply() (*QueryFiltersReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryFiltersReply(buf), nil
}

// queryFiltersReply reads a byte slice into a QueryFiltersReply value.
func queryFiltersReply(buf []byte) *QueryFiltersReply {
	v := new(QueryFiltersReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NumAliases = xgb.Get32(buf[b:])
	b += 4

	v.NumFilters = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	v.Aliases = make([]uint16, v.NumAliases)
	for i := 0; i < int(v.NumAliases); i++ {
		v.Aliases[i] = xgb.Get16(buf[b:])
		b += 2
	}

	v.Filters = make([]xproto.Str, v.NumFilters)
	b += xproto.StrReadList(buf[b:], v.Filters)

	return v
}

// Write request to wire for QueryFilters
// queryFiltersRequest writes a QueryFilters request to a byte slice.
func queryFiltersRequest(c *xgb.Conn, Drawable xproto.Drawable) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 29 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Drawable))
	b += 4

	return buf
}

// QueryPictFormatsCookie is a cookie used only for QueryPictFormats requests.
type QueryPictFormatsCookie struct {
	*xgb.Cookie
}

// QueryPictFormats sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryPictFormatsCookie.Reply()
func QueryPictFormats(c *xgb.Conn) QueryPictFormatsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'QueryPictFormats' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryPictFormatsRequest(c), cookie)
	return QueryPictFormatsCookie{cookie}
}

// QueryPictFormatsUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryPictFormatsUnchecked(c *xgb.Conn) QueryPictFormatsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'QueryPictFormats' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryPictFormatsRequest(c), cookie)
	return QueryPictFormatsCookie{cookie}
}

// QueryPictFormatsReply represents the data returned from a QueryPictFormats request.
type QueryPictFormatsReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	NumFormats  uint32
	NumScreens  uint32
	NumDepths   uint32
	NumVisuals  uint32
	NumSubpixel uint32
	// padding: 4 bytes
	Formats []Pictforminfo // size: xgb.Pad((int(NumFormats) * 28))
	// alignment gap to multiple of 4
	Screens []Pictscreen // size: PictscreenListSize(Screens)
	// alignment gap to multiple of 4
	Subpixels []uint32 // size: xgb.Pad((int(NumSubpixel) * 4))
}

// Reply blocks and returns the reply data for a QueryPictFormats request.
func (cook QueryPictFormatsCookie) Reply() (*QueryPictFormatsReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryPictFormatsReply(buf), nil
}

// queryPictFormatsReply reads a byte slice into a QueryPictFormatsReply value.
func queryPictFormatsReply(buf []byte) *QueryPictFormatsReply {
	v := new(QueryPictFormatsReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NumFormats = xgb.Get32(buf[b:])
	b += 4

	v.NumScreens = xgb.Get32(buf[b:])
	b += 4

	v.NumDepths = xgb.Get32(buf[b:])
	b += 4

	v.NumVisuals = xgb.Get32(buf[b:])
	b += 4

	v.NumSubpixel = xgb.Get32(buf[b:])
	b += 4

	b += 4 // padding

	v.Formats = make([]Pictforminfo, v.NumFormats)
	b += PictforminfoReadList(buf[b:], v.Formats)

	b = (b + 3) & ^3 // alignment gap

	v.Screens = make([]Pictscreen, v.NumScreens)
	b += PictscreenReadList(buf[b:], v.Screens)

	b = (b + 3) & ^3 // alignment gap

	v.Subpixels = make([]uint32, v.NumSubpixel)
	for i := 0; i < int(v.NumSubpixel); i++ {
		v.Subpixels[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for QueryPictFormats
// queryPictFormatsRequest writes a QueryPictFormats request to a byte slice.
func queryPictFormatsRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 1 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// QueryPictIndexValuesCookie is a cookie used only for QueryPictIndexValues requests.
type QueryPictIndexValuesCookie struct {
	*xgb.Cookie
}

// QueryPictIndexValues sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryPictIndexValuesCookie.Reply()
func QueryPictIndexValues(c *xgb.Conn, Format Pictformat) QueryPictIndexValuesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'QueryPictIndexValues' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryPictIndexValuesRequest(c, Format), cookie)
	return QueryPictIndexValuesCookie{cookie}
}

// QueryPictIndexValuesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryPictIndexValuesUnchecked(c *xgb.Conn, Format Pictformat) QueryPictIndexValuesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'QueryPictIndexValues' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryPictIndexValuesRequest(c, Format), cookie)
	return QueryPictIndexValuesCookie{cookie}
}

// QueryPictIndexValuesReply represents the data returned from a QueryPictIndexValues request.
type QueryPictIndexValuesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	NumValues uint32
	// padding: 20 bytes
	Values []Indexvalue // size: xgb.Pad((int(NumValues) * 12))
}

// Reply blocks and returns the reply data for a QueryPictIndexValues request.
func (cook QueryPictIndexValuesCookie) Reply() (*QueryPictIndexValuesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryPictIndexValuesReply(buf), nil
}

// queryPictIndexValuesReply reads a byte slice into a QueryPictIndexValuesReply value.
func queryPictIndexValuesReply(buf []byte) *QueryPictIndexValuesReply {
	v := new(QueryPictIndexValuesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NumValues = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Values = make([]Indexvalue, v.NumValues)
	b += IndexvalueReadList(buf[b:], v.Values)

	return v
}

// Write request to wire for QueryPictIndexValues
// queryPictIndexValuesRequest writes a QueryPictIndexValues request to a byte slice.
func queryPictIndexValuesRequest(c *xgb.Conn, Format Pictformat) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 2 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Format))
	b += 4

	return buf
}

// QueryVersionCookie is a cookie used only for QueryVersion requests.
type QueryVersionCookie struct {
	*xgb.Cookie
}

// QueryVersion sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryVersionCookie.Reply()
func QueryVersion(c *xgb.Conn, ClientMajorVersion uint32, ClientMinorVersion uint32) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryVersionRequest(c, ClientMajorVersion, ClientMinorVersion), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryVersionUnchecked(c *xgb.Conn, ClientMajorVersion uint32, ClientMinorVersion uint32) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryVersionRequest(c, ClientMajorVersion, ClientMinorVersion), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionReply represents the data returned from a QueryVersion request.
type QueryVersionReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	MajorVersion uint32
	MinorVersion uint32
	// padding: 16 bytes
}

// Reply blocks and returns the reply data for a QueryVersion request.
func (cook QueryVersionCookie) Reply() (*QueryVersionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryVersionReply(buf), nil
}

// queryVersionReply reads a byte slice into a QueryVersionReply value.
func queryVersionReply(buf []byte) *QueryVersionReply {
	v := new(QueryVersionReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.MajorVersion = xgb.Get32(buf[b:])
	b += 4

	v.MinorVersion = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	return v
}

// Write request to wire for QueryVersion
// queryVersionRequest writes a QueryVersion request to a byte slice.
func queryVersionRequest(c *xgb.Conn, ClientMajorVersion uint32, ClientMinorVersion uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 0 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], ClientMajorVersion)
	b += 4

	xgb.Put32(buf[b:], ClientMinorVersion)
	b += 4

	return buf
}

// ReferenceGlyphSetCookie is a cookie used only for ReferenceGlyphSet requests.
type ReferenceGlyphSetCookie struct {
	*xgb.Cookie
}

// ReferenceGlyphSet sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ReferenceGlyphSet(c *xgb.Conn, Gsid Glyphset, Existing Glyphset) ReferenceGlyphSetCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'ReferenceGlyphSet' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(referenceGlyphSetRequest(c, Gsid, Existing), cookie)
	return ReferenceGlyphSetCookie{cookie}
}

// ReferenceGlyphSetChecked sends a checked request.
// If an error occurs, it can be retrieved using ReferenceGlyphSetCookie.Check()
func ReferenceGlyphSetChecked(c *xgb.Conn, Gsid Glyphset, Existing Glyphset) ReferenceGlyphSetCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'ReferenceGlyphSet' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(referenceGlyphSetRequest(c, Gsid, Existing), cookie)
	return ReferenceGlyphSetCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ReferenceGlyphSetCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ReferenceGlyphSet
// referenceGlyphSetRequest writes a ReferenceGlyphSet request to a byte slice.
func referenceGlyphSetRequest(c *xgb.Conn, Gsid Glyphset, Existing Glyphset) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 18 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Gsid))
	b += 4

	xgb.Put32(buf[b:], uint32(Existing))
	b += 4

	return buf
}

// SetPictureClipRectanglesCookie is a cookie used only for SetPictureClipRectangles requests.
type SetPictureClipRectanglesCookie struct {
	*xgb.Cookie
}

// SetPictureClipRectangles sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetPictureClipRectangles(c *xgb.Conn, Picture Picture, ClipXOrigin int16, ClipYOrigin int16, Rectangles []xproto.Rectangle) SetPictureClipRectanglesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'SetPictureClipRectangles' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setPictureClipRectanglesRequest(c, Picture, ClipXOrigin, ClipYOrigin, Rectangles), cookie)
	return SetPictureClipRectanglesCookie{cookie}
}

// SetPictureClipRectanglesChecked sends a checked request.
// If an error occurs, it can be retrieved using SetPictureClipRectanglesCookie.Check()
func SetPictureClipRectanglesChecked(c *xgb.Conn, Picture Picture, ClipXOrigin int16, ClipYOrigin int16, Rectangles []xproto.Rectangle) SetPictureClipRectanglesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'SetPictureClipRectangles' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setPictureClipRectanglesRequest(c, Picture, ClipXOrigin, ClipYOrigin, Rectangles), cookie)
	return SetPictureClipRectanglesCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetPictureClipRectanglesCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetPictureClipRectangles
// setPictureClipRectanglesRequest writes a SetPictureClipRectangles request to a byte slice.
func setPictureClipRectanglesRequest(c *xgb.Conn, Picture Picture, ClipXOrigin int16, ClipYOrigin int16, Rectangles []xproto.Rectangle) []byte {
	size := xgb.Pad((12 + xgb.Pad((len(Rectangles) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 6 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	xgb.Put16(buf[b:], uint16(ClipXOrigin))
	b += 2

	xgb.Put16(buf[b:], uint16(ClipYOrigin))
	b += 2

	b += xproto.RectangleListBytes(buf[b:], Rectangles)

	return buf
}

// SetPictureFilterCookie is a cookie used only for SetPictureFilter requests.
type SetPictureFilterCookie struct {
	*xgb.Cookie
}

// SetPictureFilter sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetPictureFilter(c *xgb.Conn, Picture Picture, FilterLen uint16, Filter string, Values []Fixed) SetPictureFilterCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'SetPictureFilter' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setPictureFilterRequest(c, Picture, FilterLen, Filter, Values), cookie)
	return SetPictureFilterCookie{cookie}
}

// SetPictureFilterChecked sends a checked request.
// If an error occurs, it can be retrieved using SetPictureFilterCookie.Check()
func SetPictureFilterChecked(c *xgb.Conn, Picture Picture, FilterLen uint16, Filter string, Values []Fixed) SetPictureFilterCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'SetPictureFilter' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setPictureFilterRequest(c, Picture, FilterLen, Filter, Values), cookie)
	return SetPictureFilterCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetPictureFilterCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetPictureFilter
// setPictureFilterRequest writes a SetPictureFilter request to a byte slice.
func setPictureFilterRequest(c *xgb.Conn, Picture Picture, FilterLen uint16, Filter string, Values []Fixed) []byte {
	size := xgb.Pad((((12 + xgb.Pad((int(FilterLen) * 1))) + 4) + xgb.Pad((len(Values) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 30 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	xgb.Put16(buf[b:], FilterLen)
	b += 2

	b += 2 // padding

	copy(buf[b:], Filter[:FilterLen])
	b += int(FilterLen)

	b = (b + 3) & ^3 // alignment gap

	for i := 0; i < int(len(Values)); i++ {
		xgb.Put32(buf[b:], uint32(Values[i]))
		b += 4
	}

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// SetPictureTransformCookie is a cookie used only for SetPictureTransform requests.
type SetPictureTransformCookie struct {
	*xgb.Cookie
}

// SetPictureTransform sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetPictureTransform(c *xgb.Conn, Picture Picture, Transform Transform) SetPictureTransformCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'SetPictureTransform' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setPictureTransformRequest(c, Picture, Transform), cookie)
	return SetPictureTransformCookie{cookie}
}

// SetPictureTransformChecked sends a checked request.
// If an error occurs, it can be retrieved using SetPictureTransformCookie.Check()
func SetPictureTransformChecked(c *xgb.Conn, Picture Picture, Transform Transform) SetPictureTransformCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'SetPictureTransform' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setPictureTransformRequest(c, Picture, Transform), cookie)
	return SetPictureTransformCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetPictureTransformCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetPictureTransform
// setPictureTransformRequest writes a SetPictureTransform request to a byte slice.
func setPictureTransformRequest(c *xgb.Conn, Picture Picture, Transform Transform) []byte {
	size := 44
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 28 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	{
		structBytes := Transform.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	return buf
}

// TrapezoidsCookie is a cookie used only for Trapezoids requests.
type TrapezoidsCookie struct {
	*xgb.Cookie
}

// Trapezoids sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func Trapezoids(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Traps []Trapezoid) TrapezoidsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'Trapezoids' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(trapezoidsRequest(c, Op, Src, Dst, MaskFormat, SrcX, SrcY, Traps), cookie)
	return TrapezoidsCookie{cookie}
}

// TrapezoidsChecked sends a checked request.
// If an error occurs, it can be retrieved using TrapezoidsCookie.Check()
func TrapezoidsChecked(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Traps []Trapezoid) TrapezoidsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'Trapezoids' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(trapezoidsRequest(c, Op, Src, Dst, MaskFormat, SrcX, SrcY, Traps), cookie)
	return TrapezoidsCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook TrapezoidsCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for Trapezoids
// trapezoidsRequest writes a Trapezoids request to a byte slice.
func trapezoidsRequest(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Traps []Trapezoid) []byte {
	size := xgb.Pad((24 + xgb.Pad((len(Traps) * 40))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 10 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Op
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put32(buf[b:], uint32(Dst))
	b += 4

	xgb.Put32(buf[b:], uint32(MaskFormat))
	b += 4

	xgb.Put16(buf[b:], uint16(SrcX))
	b += 2

	xgb.Put16(buf[b:], uint16(SrcY))
	b += 2

	b += TrapezoidListBytes(buf[b:], Traps)

	return buf
}

// TriFanCookie is a cookie used only for TriFan requests.
type TriFanCookie struct {
	*xgb.Cookie
}

// TriFan sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func TriFan(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Points []Pointfix) TriFanCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'TriFan' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(triFanRequest(c, Op, Src, Dst, MaskFormat, SrcX, SrcY, Points), cookie)
	return TriFanCookie{cookie}
}

// TriFanChecked sends a checked request.
// If an error occurs, it can be retrieved using TriFanCookie.Check()
func TriFanChecked(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Points []Pointfix) TriFanCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'TriFan' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(triFanRequest(c, Op, Src, Dst, MaskFormat, SrcX, SrcY, Points), cookie)
	return TriFanCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook TriFanCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for TriFan
// triFanRequest writes a TriFan request to a byte slice.
func triFanRequest(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Points []Pointfix) []byte {
	size := xgb.Pad((24 + xgb.Pad((len(Points) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 13 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Op
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put32(buf[b:], uint32(Dst))
	b += 4

	xgb.Put32(buf[b:], uint32(MaskFormat))
	b += 4

	xgb.Put16(buf[b:], uint16(SrcX))
	b += 2

	xgb.Put16(buf[b:], uint16(SrcY))
	b += 2

	b += PointfixListBytes(buf[b:], Points)

	return buf
}

// TriStripCookie is a cookie used only for TriStrip requests.
type TriStripCookie struct {
	*xgb.Cookie
}

// TriStrip sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func TriStrip(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Points []Pointfix) TriStripCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'TriStrip' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(triStripRequest(c, Op, Src, Dst, MaskFormat, SrcX, SrcY, Points), cookie)
	return TriStripCookie{cookie}
}

// TriStripChecked sends a checked request.
// If an error occurs, it can be retrieved using TriStripCookie.Check()
func TriStripChecked(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Points []Pointfix) TriStripCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'TriStrip' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(triStripRequest(c, Op, Src, Dst, MaskFormat, SrcX, SrcY, Points), cookie)
	return TriStripCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook TriStripCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for TriStrip
// triStripRequest writes a TriStrip request to a byte slice.
func triStripRequest(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Points []Pointfix) []byte {
	size := xgb.Pad((24 + xgb.Pad((len(Points) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 12 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Op
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put32(buf[b:], uint32(Dst))
	b += 4

	xgb.Put32(buf[b:], uint32(MaskFormat))
	b += 4

	xgb.Put16(buf[b:], uint16(SrcX))
	b += 2

	xgb.Put16(buf[b:], uint16(SrcY))
	b += 2

	b += PointfixListBytes(buf[b:], Points)

	return buf
}

// TrianglesCookie is a cookie used only for Triangles requests.
type TrianglesCookie struct {
	*xgb.Cookie
}

// Triangles sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func Triangles(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Triangles []Triangle) TrianglesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'Triangles' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(trianglesRequest(c, Op, Src, Dst, MaskFormat, SrcX, SrcY, Triangles), cookie)
	return TrianglesCookie{cookie}
}

// TrianglesChecked sends a checked request.
// If an error occurs, it can be retrieved using TrianglesCookie.Check()
func TrianglesChecked(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Triangles []Triangle) TrianglesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["RENDER"]; !ok {
		panic("Cannot issue request 'Triangles' using the uninitialized extension 'RENDER'. render.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(trianglesRequest(c, Op, Src, Dst, MaskFormat, SrcX, SrcY, Triangles), cookie)
	return TrianglesCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook TrianglesCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for Triangles
// trianglesRequest writes a Triangles request to a byte slice.
func trianglesRequest(c *xgb.Conn, Op byte, Src Picture, Dst Picture, MaskFormat Pictformat, SrcX int16, SrcY int16, Triangles []Triangle) []byte {
	size := xgb.Pad((24 + xgb.Pad((len(Triangles) * 24))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["RENDER"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 11 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Op
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put32(buf[b:], uint32(Dst))
	b += 4

	xgb.Put32(buf[b:], uint32(MaskFormat))
	b += 4

	xgb.Put16(buf[b:], uint16(SrcX))
	b += 2

	xgb.Put16(buf[b:], uint16(SrcY))
	b += 2

	b += TriangleListBytes(buf[b:], Triangles)

	return buf
}
