package storagedatalake

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"io"
	"net/http"
)

// PathClient is the azure Data Lake Storage provides storage for Hadoop and other big data workloads.
type PathClient struct {
	BaseClient
}

// NewPathClient creates an instance of the PathClient client.
func NewPathClient(xMsVersion string, accountName string) PathClient {
	return PathClient{New(xMsVersion, accountName)}
}

// Create create or rename a file or directory.    By default, the destination is overwritten and if the destination
// already exists and has a lease the lease is broken.  This operation supports conditional HTTP requests.  For more
// information, see [Specifying Conditional Headers for Blob Service
// Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
// To fail if the destination already exists, use a conditional request with If-None-Match: "*".
// Parameters:
// filesystem - the filesystem identifier.
// pathParameter - the file or directory path.
// resource - required only for Create File and Create Directory. The value must be "file" or "directory".
// continuation - optional.  When renaming a directory, the number of paths that are renamed with each
// invocation is limited.  If the number of paths to be renamed exceeds this limit, a continuation token is
// returned in this response header.  When a continuation token is returned in the response, it must be
// specified in a subsequent invocation of the rename operation to continue renaming the directory.
// mode - optional. Valid only when namespace is enabled. This parameter determines the behavior of the rename
// operation. The value must be "legacy" or "posix", and the default value will be "posix".
// cacheControl - optional.  The service stores this value and includes it in the "Cache-Control" response
// header for "Read File" operations for "Read File" operations.
// contentEncoding - optional.  Specifies which content encodings have been applied to the file. This value is
// returned to the client when the "Read File" operation is performed.
// contentLanguage - optional.  Specifies the natural language used by the intended audience for the file.
// contentDisposition - optional.  The service stores this value and includes it in the "Content-Disposition"
// response header for "Read File" operations.
// xMsCacheControl - optional.  The service stores this value and includes it in the "Cache-Control" response
// header for "Read File" operations.
// xMsContentType - optional.  The service stores this value and includes it in the "Content-Type" response
// header for "Read File" operations.
// xMsContentEncoding - optional.  The service stores this value and includes it in the "Content-Encoding"
// response header for "Read File" operations.
// xMsContentLanguage - optional.  The service stores this value and includes it in the "Content-Language"
// response header for "Read File" operations.
// xMsContentDisposition - optional.  The service stores this value and includes it in the
// "Content-Disposition" response header for "Read File" operations.
// xMsRenameSource - an optional file or directory to be renamed.  The value must have the following format:
// "/{filesystem}/{path}".  If "x-ms-properties" is specified, the properties will overwrite the existing
// properties; otherwise, the existing properties will be preserved. This value must be a URL percent-encoded
// string. Note that the string may only contain ASCII characters in the ISO-8859-1 character set.
// xMsLeaseID - optional.  A lease ID for the path specified in the URI.  The path to be overwritten must have
// an active lease and the lease ID must match.
// xMsSourceLeaseID - optional for rename operations.  A lease ID for the source path.  The source path must
// have an active lease and the lease ID must match.
// xMsProperties - optional.  User-defined properties to be stored with the file or directory, in the format of
// a comma-separated list of name and value pairs "n1=v1, n2=v2, ...", where each value is a base64 encoded
// string. Note that the string may only contain ASCII characters in the ISO-8859-1 character set.
// xMsPermissions - optional and only valid if Hierarchical Namespace is enabled for the account. Sets POSIX
// access permissions for the file owner, the file owning group, and others. Each class may be granted read,
// write, or execute permission.  The sticky bit is also supported.  Both symbolic (rwxrw-rw-) and 4-digit
// octal notation (e.g. 0766) are supported.
// xMsUmask - optional and only valid if Hierarchical Namespace is enabled for the account. When creating a
// file or directory and the parent folder does not have a default ACL, the umask restricts the permissions of
// the file or directory to be created.  The resulting permission is given by p & ^u, where p is the permission
// and u is the umask.  For example, if p is 0777 and u is 0057, then the resulting permission is 0720.  The
// default permission is 0777 for a directory and 0666 for a file.  The default umask is 0027.  The umask must
// be specified in 4-digit octal notation (e.g. 0766).
// ifMatch - optional.  An ETag value. Specify this header to perform the operation only if the resource's ETag
// matches the value specified. The ETag must be specified in quotes.
// ifNoneMatch - optional.  An ETag value or the special wildcard ("*") value. Specify this header to perform
// the operation only if the resource's ETag does not match the value specified. The ETag must be specified in
// quotes.
// ifModifiedSince - optional. A date and time value. Specify this header to perform the operation only if the
// resource has been modified since the specified date and time.
// ifUnmodifiedSince - optional. A date and time value. Specify this header to perform the operation only if
// the resource has not been modified since the specified date and time.
// xMsSourceIfMatch - optional.  An ETag value. Specify this header to perform the rename operation only if the
// source's ETag matches the value specified. The ETag must be specified in quotes.
// xMsSourceIfNoneMatch - optional.  An ETag value or the special wildcard ("*") value. Specify this header to
// perform the rename operation only if the source's ETag does not match the value specified. The ETag must be
// specified in quotes.
// xMsSourceIfModifiedSince - optional. A date and time value. Specify this header to perform the rename
// operation only if the source has been modified since the specified date and time.
// xMsSourceIfUnmodifiedSince - optional. A date and time value. Specify this header to perform the rename
// operation only if the source has not been modified since the specified date and time.
// xMsClientRequestID - a UUID recorded in the analytics logs for troubleshooting and correlation.
// timeout - an optional operation timeout value in seconds. The period begins when the request is received by
// the service. If the timeout value elapses before the operation completes, the operation fails.
// xMsDate - specifies the Coordinated Universal Time (UTC) for the request.  This is required when using
// shared key authorization.
func (client PathClient) Create(ctx context.Context, filesystem string, pathParameter string, resource PathResourceType, continuation string, mode PathRenameMode, cacheControl string, contentEncoding string, contentLanguage string, contentDisposition string, xMsCacheControl string, xMsContentType string, xMsContentEncoding string, xMsContentLanguage string, xMsContentDisposition string, xMsRenameSource string, xMsLeaseID string, xMsSourceLeaseID string, xMsProperties string, xMsPermissions string, xMsUmask string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsSourceIfMatch string, xMsSourceIfNoneMatch string, xMsSourceIfModifiedSince string, xMsSourceIfUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PathClient.Create")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: xMsLeaseID,
			Constraints: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: xMsSourceLeaseID,
			Constraints: []validation.Constraint{{Target: "xMsSourceLeaseID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsSourceLeaseID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: filesystem,
			Constraints: []validation.Constraint{{Target: "filesystem", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "filesystem", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: xMsClientRequestID,
			Constraints: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagedatalake.PathClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, filesystem, pathParameter, resource, continuation, mode, cacheControl, contentEncoding, contentLanguage, contentDisposition, xMsCacheControl, xMsContentType, xMsContentEncoding, xMsContentLanguage, xMsContentDisposition, xMsRenameSource, xMsLeaseID, xMsSourceLeaseID, xMsProperties, xMsPermissions, xMsUmask, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince, xMsSourceIfMatch, xMsSourceIfNoneMatch, xMsSourceIfModifiedSince, xMsSourceIfUnmodifiedSince, xMsClientRequestID, timeout, xMsDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Create", resp, "Failure responding to request")
	}

	return
}

// CreatePreparer prepares the Create request.
func (client PathClient) CreatePreparer(ctx context.Context, filesystem string, pathParameter string, resource PathResourceType, continuation string, mode PathRenameMode, cacheControl string, contentEncoding string, contentLanguage string, contentDisposition string, xMsCacheControl string, xMsContentType string, xMsContentEncoding string, xMsContentLanguage string, xMsContentDisposition string, xMsRenameSource string, xMsLeaseID string, xMsSourceLeaseID string, xMsProperties string, xMsPermissions string, xMsUmask string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsSourceIfMatch string, xMsSourceIfNoneMatch string, xMsSourceIfModifiedSince string, xMsSourceIfUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName": client.AccountName,
		"dnsSuffix":   client.DNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"filesystem": autorest.Encode("path", filesystem),
		"path":       autorest.Encode("path", pathParameter),
	}

	queryParameters := map[string]interface{}{}
	if len(string(resource)) > 0 {
		queryParameters["resource"] = autorest.Encode("query", resource)
	}
	if len(continuation) > 0 {
		queryParameters["continuation"] = autorest.Encode("query", continuation)
	}
	if len(string(mode)) > 0 {
		queryParameters["mode"] = autorest.Encode("query", mode)
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{accountName}.{dnsSuffix}", urlParameters),
		autorest.WithPathParameters("/{filesystem}/{path}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if len(cacheControl) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Cache-Control", autorest.String(cacheControl)))
	}
	if len(contentEncoding) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Content-Encoding", autorest.String(contentEncoding)))
	}
	if len(contentLanguage) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Content-Language", autorest.String(contentLanguage)))
	}
	if len(contentDisposition) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Content-Disposition", autorest.String(contentDisposition)))
	}
	if len(xMsCacheControl) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-cache-control", autorest.String(xMsCacheControl)))
	}
	if len(xMsContentType) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-content-type", autorest.String(xMsContentType)))
	}
	if len(xMsContentEncoding) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-content-encoding", autorest.String(xMsContentEncoding)))
	}
	if len(xMsContentLanguage) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-content-language", autorest.String(xMsContentLanguage)))
	}
	if len(xMsContentDisposition) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-content-disposition", autorest.String(xMsContentDisposition)))
	}
	if len(xMsRenameSource) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-rename-source", autorest.String(xMsRenameSource)))
	}
	if len(xMsLeaseID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-lease-id", autorest.String(xMsLeaseID)))
	}
	if len(xMsSourceLeaseID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-source-lease-id", autorest.String(xMsSourceLeaseID)))
	}
	if len(xMsProperties) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-properties", autorest.String(xMsProperties)))
	}
	if len(xMsPermissions) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-permissions", autorest.String(xMsPermissions)))
	}
	if len(xMsUmask) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-umask", autorest.String(xMsUmask)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if len(ifModifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if len(ifUnmodifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	if len(xMsSourceIfMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-source-if-match", autorest.String(xMsSourceIfMatch)))
	}
	if len(xMsSourceIfNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-source-if-none-match", autorest.String(xMsSourceIfNoneMatch)))
	}
	if len(xMsSourceIfModifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-source-if-modified-since", autorest.String(xMsSourceIfModifiedSince)))
	}
	if len(xMsSourceIfUnmodifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-source-if-unmodified-since", autorest.String(xMsSourceIfUnmodifiedSince)))
	}
	if len(xMsClientRequestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(xMsClientRequestID)))
	}
	if len(xMsDate) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-date", autorest.String(xMsDate)))
	}
	if len(client.XMsVersion) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-version", autorest.String(client.XMsVersion)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client PathClient) CreateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client PathClient) CreateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Delete delete the file or directory. This operation supports conditional HTTP requests.  For more information, see
// [Specifying Conditional Headers for Blob Service
// Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
// Parameters:
// filesystem - the filesystem identifier.
// pathParameter - the file or directory path.
// recursive - required and valid only when the resource is a directory.  If "true", all paths beneath the
// directory will be deleted. If "false" and the directory is non-empty, an error occurs.
// continuation - optional.  When deleting a directory, the number of paths that are deleted with each
// invocation is limited.  If the number of paths to be deleted exceeds this limit, a continuation token is
// returned in this response header.  When a continuation token is returned in the response, it must be
// specified in a subsequent invocation of the delete operation to continue deleting the directory.
// xMsLeaseID - the lease ID must be specified if there is an active lease.
// ifMatch - optional.  An ETag value. Specify this header to perform the operation only if the resource's ETag
// matches the value specified. The ETag must be specified in quotes.
// ifNoneMatch - optional.  An ETag value or the special wildcard ("*") value. Specify this header to perform
// the operation only if the resource's ETag does not match the value specified. The ETag must be specified in
// quotes.
// ifModifiedSince - optional. A date and time value. Specify this header to perform the operation only if the
// resource has been modified since the specified date and time.
// ifUnmodifiedSince - optional. A date and time value. Specify this header to perform the operation only if
// the resource has not been modified since the specified date and time.
// xMsClientRequestID - a UUID recorded in the analytics logs for troubleshooting and correlation.
// timeout - an optional operation timeout value in seconds. The period begins when the request is received by
// the service. If the timeout value elapses before the operation completes, the operation fails.
// xMsDate - specifies the Coordinated Universal Time (UTC) for the request.  This is required when using
// shared key authorization.
func (client PathClient) Delete(ctx context.Context, filesystem string, pathParameter string, recursive *bool, continuation string, xMsLeaseID string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PathClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: xMsLeaseID,
			Constraints: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: filesystem,
			Constraints: []validation.Constraint{{Target: "filesystem", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "filesystem", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: xMsClientRequestID,
			Constraints: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagedatalake.PathClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, filesystem, pathParameter, recursive, continuation, xMsLeaseID, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince, xMsClientRequestID, timeout, xMsDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client PathClient) DeletePreparer(ctx context.Context, filesystem string, pathParameter string, recursive *bool, continuation string, xMsLeaseID string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName": client.AccountName,
		"dnsSuffix":   client.DNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"filesystem": autorest.Encode("path", filesystem),
		"path":       autorest.Encode("path", pathParameter),
	}

	queryParameters := map[string]interface{}{}
	if recursive != nil {
		queryParameters["recursive"] = autorest.Encode("query", *recursive)
	}
	if len(continuation) > 0 {
		queryParameters["continuation"] = autorest.Encode("query", continuation)
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{accountName}.{dnsSuffix}", urlParameters),
		autorest.WithPathParameters("/{filesystem}/{path}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if len(xMsLeaseID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-lease-id", autorest.String(xMsLeaseID)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if len(ifModifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if len(ifUnmodifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	if len(xMsClientRequestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(xMsClientRequestID)))
	}
	if len(xMsDate) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-date", autorest.String(xMsDate)))
	}
	if len(client.XMsVersion) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-version", autorest.String(client.XMsVersion)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client PathClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client PathClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetProperties get Properties returns all system and user defined properties for a path. Get Status returns all
// system defined properties for a path. Get Access Control List returns the access control list for a path. This
// operation supports conditional HTTP requests.  For more information, see [Specifying Conditional Headers for Blob
// Service
// Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
// Parameters:
// filesystem - the filesystem identifier.
// pathParameter - the file or directory path.
// action - optional. If the value is "getStatus" only the system defined properties for the path are returned.
// If the value is "getAccessControl" the access control list is returned in the response headers (Hierarchical
// Namespace must be enabled for the account), otherwise the properties are returned.
// upn - optional. Valid only when Hierarchical Namespace is enabled for the account. If "true", the user
// identity values returned in the x-ms-owner, x-ms-group, and x-ms-acl response headers will be transformed
// from Azure Active Directory Object IDs to User Principal Names.  If "false", the values will be returned as
// Azure Active Directory Object IDs. The default value is false. Note that group and application Object IDs
// are not translated because they do not have unique friendly names.
// xMsLeaseID - optional. If this header is specified, the operation will be performed only if both of the
// following conditions are met: i) the path's lease is currently active and ii) the lease ID specified in the
// request matches that of the path.
// ifMatch - optional.  An ETag value. Specify this header to perform the operation only if the resource's ETag
// matches the value specified. The ETag must be specified in quotes.
// ifNoneMatch - optional.  An ETag value or the special wildcard ("*") value. Specify this header to perform
// the operation only if the resource's ETag does not match the value specified. The ETag must be specified in
// quotes.
// ifModifiedSince - optional. A date and time value. Specify this header to perform the operation only if the
// resource has been modified since the specified date and time.
// ifUnmodifiedSince - optional. A date and time value. Specify this header to perform the operation only if
// the resource has not been modified since the specified date and time.
// xMsClientRequestID - a UUID recorded in the analytics logs for troubleshooting and correlation.
// timeout - an optional operation timeout value in seconds. The period begins when the request is received by
// the service. If the timeout value elapses before the operation completes, the operation fails.
// xMsDate - specifies the Coordinated Universal Time (UTC) for the request.  This is required when using
// shared key authorization.
func (client PathClient) GetProperties(ctx context.Context, filesystem string, pathParameter string, action PathGetPropertiesAction, upn *bool, xMsLeaseID string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PathClient.GetProperties")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: xMsLeaseID,
			Constraints: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: filesystem,
			Constraints: []validation.Constraint{{Target: "filesystem", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "filesystem", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: xMsClientRequestID,
			Constraints: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagedatalake.PathClient", "GetProperties", err.Error())
	}

	req, err := client.GetPropertiesPreparer(ctx, filesystem, pathParameter, action, upn, xMsLeaseID, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince, xMsClientRequestID, timeout, xMsDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "GetProperties", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPropertiesSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "GetProperties", resp, "Failure sending request")
		return
	}

	result, err = client.GetPropertiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "GetProperties", resp, "Failure responding to request")
	}

	return
}

// GetPropertiesPreparer prepares the GetProperties request.
func (client PathClient) GetPropertiesPreparer(ctx context.Context, filesystem string, pathParameter string, action PathGetPropertiesAction, upn *bool, xMsLeaseID string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName": client.AccountName,
		"dnsSuffix":   client.DNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"filesystem": autorest.Encode("path", filesystem),
		"path":       autorest.Encode("path", pathParameter),
	}

	queryParameters := map[string]interface{}{}
	if len(string(action)) > 0 {
		queryParameters["action"] = autorest.Encode("query", action)
	}
	if upn != nil {
		queryParameters["upn"] = autorest.Encode("query", *upn)
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsHead(),
		autorest.WithCustomBaseURL("https://{accountName}.{dnsSuffix}", urlParameters),
		autorest.WithPathParameters("/{filesystem}/{path}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if len(xMsLeaseID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-lease-id", autorest.String(xMsLeaseID)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if len(ifModifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if len(ifUnmodifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	if len(xMsClientRequestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(xMsClientRequestID)))
	}
	if len(xMsDate) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-date", autorest.String(xMsDate)))
	}
	if len(client.XMsVersion) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-version", autorest.String(client.XMsVersion)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPropertiesSender sends the GetProperties request. The method will close the
// http.Response Body if it receives an error.
func (client PathClient) GetPropertiesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPropertiesResponder handles the response to the GetProperties request. The method always
// closes the http.Response Body.
func (client PathClient) GetPropertiesResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Lease create and manage a lease to restrict write and delete access to the path. This operation supports conditional
// HTTP requests.  For more information, see [Specifying Conditional Headers for Blob Service
// Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
// Parameters:
// xMsLeaseAction - there are five lease actions: "acquire", "break", "change", "renew", and "release". Use
// "acquire" and specify the "x-ms-proposed-lease-id" and "x-ms-lease-duration" to acquire a new lease. Use
// "break" to break an existing lease. When a lease is broken, the lease break period is allowed to elapse,
// during which time no lease operation except break and release can be performed on the file. When a lease is
// successfully broken, the response indicates the interval in seconds until a new lease can be acquired. Use
// "change" and specify the current lease ID in "x-ms-lease-id" and the new lease ID in
// "x-ms-proposed-lease-id" to change the lease ID of an active lease. Use "renew" and specify the
// "x-ms-lease-id" to renew an existing lease. Use "release" and specify the "x-ms-lease-id" to release a
// lease.
// filesystem - the filesystem identifier.
// pathParameter - the file or directory path.
// xMsLeaseDuration - the lease duration is required to acquire a lease, and specifies the duration of the
// lease in seconds.  The lease duration must be between 15 and 60 seconds or -1 for infinite lease.
// xMsLeaseBreakPeriod - the lease break period duration is optional to break a lease, and  specifies the break
// period of the lease in seconds.  The lease break  duration must be between 0 and 60 seconds.
// xMsLeaseID - required when "x-ms-lease-action" is "renew", "change" or "release". For the renew and release
// actions, this must match the current lease ID.
// xMsProposedLeaseID - required when "x-ms-lease-action" is "acquire" or "change".  A lease will be acquired
// with this lease ID if the operation is successful.
// ifMatch - optional.  An ETag value. Specify this header to perform the operation only if the resource's ETag
// matches the value specified. The ETag must be specified in quotes.
// ifNoneMatch - optional.  An ETag value or the special wildcard ("*") value. Specify this header to perform
// the operation only if the resource's ETag does not match the value specified. The ETag must be specified in
// quotes.
// ifModifiedSince - optional. A date and time value. Specify this header to perform the operation only if the
// resource has been modified since the specified date and time.
// ifUnmodifiedSince - optional. A date and time value. Specify this header to perform the operation only if
// the resource has not been modified since the specified date and time.
// xMsClientRequestID - a UUID recorded in the analytics logs for troubleshooting and correlation.
// timeout - an optional operation timeout value in seconds. The period begins when the request is received by
// the service. If the timeout value elapses before the operation completes, the operation fails.
// xMsDate - specifies the Coordinated Universal Time (UTC) for the request.  This is required when using
// shared key authorization.
func (client PathClient) Lease(ctx context.Context, xMsLeaseAction PathLeaseAction, filesystem string, pathParameter string, xMsLeaseDuration *int32, xMsLeaseBreakPeriod *int32, xMsLeaseID string, xMsProposedLeaseID string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PathClient.Lease")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: xMsLeaseID,
			Constraints: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: xMsProposedLeaseID,
			Constraints: []validation.Constraint{{Target: "xMsProposedLeaseID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsProposedLeaseID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: filesystem,
			Constraints: []validation.Constraint{{Target: "filesystem", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "filesystem", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: xMsClientRequestID,
			Constraints: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagedatalake.PathClient", "Lease", err.Error())
	}

	req, err := client.LeasePreparer(ctx, xMsLeaseAction, filesystem, pathParameter, xMsLeaseDuration, xMsLeaseBreakPeriod, xMsLeaseID, xMsProposedLeaseID, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince, xMsClientRequestID, timeout, xMsDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Lease", nil, "Failure preparing request")
		return
	}

	resp, err := client.LeaseSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Lease", resp, "Failure sending request")
		return
	}

	result, err = client.LeaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Lease", resp, "Failure responding to request")
	}

	return
}

// LeasePreparer prepares the Lease request.
func (client PathClient) LeasePreparer(ctx context.Context, xMsLeaseAction PathLeaseAction, filesystem string, pathParameter string, xMsLeaseDuration *int32, xMsLeaseBreakPeriod *int32, xMsLeaseID string, xMsProposedLeaseID string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName": client.AccountName,
		"dnsSuffix":   client.DNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"filesystem": autorest.Encode("path", filesystem),
		"path":       autorest.Encode("path", pathParameter),
	}

	queryParameters := map[string]interface{}{}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{accountName}.{dnsSuffix}", urlParameters),
		autorest.WithPathParameters("/{filesystem}/{path}", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-lease-action", autorest.String(xMsLeaseAction)))
	if xMsLeaseDuration != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-lease-duration", autorest.String(*xMsLeaseDuration)))
	}
	if xMsLeaseBreakPeriod != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-lease-break-period", autorest.String(*xMsLeaseBreakPeriod)))
	}
	if len(xMsLeaseID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-lease-id", autorest.String(xMsLeaseID)))
	}
	if len(xMsProposedLeaseID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-proposed-lease-id", autorest.String(xMsProposedLeaseID)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if len(ifModifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if len(ifUnmodifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	if len(xMsClientRequestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(xMsClientRequestID)))
	}
	if len(xMsDate) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-date", autorest.String(xMsDate)))
	}
	if len(client.XMsVersion) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-version", autorest.String(client.XMsVersion)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// LeaseSender sends the Lease request. The method will close the
// http.Response Body if it receives an error.
func (client PathClient) LeaseSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// LeaseResponder handles the response to the Lease request. The method always
// closes the http.Response Body.
func (client PathClient) LeaseResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// List list filesystem paths and their properties.
// Parameters:
// recursive - if "true", all paths are listed; otherwise, only paths at the root of the filesystem are listed.
// If "directory" is specified, the list will only include paths that share the same root.
// filesystem - the filesystem identifier.  The value must start and end with a letter or number and must
// contain only letters, numbers, and the dash (-) character.  Consecutive dashes are not permitted.  All
// letters must be lowercase.  The value must have between 3 and 63 characters.
// directory - filters results to paths within the specified directory. An error occurs if the directory does
// not exist.
// continuation - the number of paths returned with each invocation is limited. If the number of paths to be
// returned exceeds this limit, a continuation token is returned in the response header x-ms-continuation. When
// a continuation token is  returned in the response, it must be specified in a subsequent invocation of the
// list operation to continue listing the paths.
// maxResults - an optional value that specifies the maximum number of items to return. If omitted or greater
// than 5,000, the response will include up to 5,000 items.
// upn - optional. Valid only when Hierarchical Namespace is enabled for the account. If "true", the user
// identity values returned in the owner and group fields of each list entry will be transformed from Azure
// Active Directory Object IDs to User Principal Names.  If "false", the values will be returned as Azure
// Active Directory Object IDs. The default value is false. Note that group and application Object IDs are not
// translated because they do not have unique friendly names.
// xMsClientRequestID - a UUID recorded in the analytics logs for troubleshooting and correlation.
// timeout - an optional operation timeout value in seconds. The period begins when the request is received by
// the service. If the timeout value elapses before the operation completes, the operation fails.
// xMsDate - specifies the Coordinated Universal Time (UTC) for the request.  This is required when using
// shared key authorization.
func (client PathClient) List(ctx context.Context, recursive bool, filesystem string, directory string, continuation string, maxResults *int32, upn *bool, xMsClientRequestID string, timeout *int32, xMsDate string) (result PathList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PathClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: maxResults,
			Constraints: []validation.Constraint{{Target: "maxResults", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "maxResults", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}},
		{TargetValue: filesystem,
			Constraints: []validation.Constraint{{Target: "filesystem", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "filesystem", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: xMsClientRequestID,
			Constraints: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagedatalake.PathClient", "List", err.Error())
	}

	req, err := client.ListPreparer(ctx, recursive, filesystem, directory, continuation, maxResults, upn, xMsClientRequestID, timeout, xMsDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client PathClient) ListPreparer(ctx context.Context, recursive bool, filesystem string, directory string, continuation string, maxResults *int32, upn *bool, xMsClientRequestID string, timeout *int32, xMsDate string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName": client.AccountName,
		"dnsSuffix":   client.DNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"filesystem": autorest.Encode("path", filesystem),
	}

	queryParameters := map[string]interface{}{
		"recursive": autorest.Encode("query", recursive),
		"resource":  autorest.Encode("query", "filesystem"),
	}
	if len(directory) > 0 {
		queryParameters["directory"] = autorest.Encode("query", directory)
	}
	if len(continuation) > 0 {
		queryParameters["continuation"] = autorest.Encode("query", continuation)
	}
	if maxResults != nil {
		queryParameters["maxResults"] = autorest.Encode("query", *maxResults)
	}
	if upn != nil {
		queryParameters["upn"] = autorest.Encode("query", *upn)
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{dnsSuffix}", urlParameters),
		autorest.WithPathParameters("/{filesystem}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if len(xMsClientRequestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(xMsClientRequestID)))
	}
	if len(xMsDate) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-date", autorest.String(xMsDate)))
	}
	if len(client.XMsVersion) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-version", autorest.String(client.XMsVersion)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client PathClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client PathClient) ListResponder(resp *http.Response) (result PathList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Read read the contents of a file.  For read operations, range requests are supported. This operation supports
// conditional HTTP requests.  For more information, see [Specifying Conditional Headers for Blob Service
// Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
// Parameters:
// filesystem - the filesystem identifier.
// pathParameter - the file or directory path.
// rangeParameter - the HTTP Range request header specifies one or more byte ranges of the resource to be
// retrieved.
// xMsLeaseID - optional. If this header is specified, the operation will be performed only if both of the
// following conditions are met: i) the path's lease is currently active and ii) the lease ID specified in the
// request matches that of the path.
// xMsRangeGetContentMd5 - optional. When this header is set to "true" and specified together with the Range
// header, the service returns the MD5 hash for the range, as long as the range is less than or equal to 4MB in
// size. If this header is specified without the Range header, the service returns status code 400 (Bad
// Request). If this header is set to true when the range exceeds 4 MB in size, the service returns status code
// 400 (Bad Request).
// ifMatch - optional.  An ETag value. Specify this header to perform the operation only if the resource's ETag
// matches the value specified. The ETag must be specified in quotes.
// ifNoneMatch - optional.  An ETag value or the special wildcard ("*") value. Specify this header to perform
// the operation only if the resource's ETag does not match the value specified. The ETag must be specified in
// quotes.
// ifModifiedSince - optional. A date and time value. Specify this header to perform the operation only if the
// resource has been modified since the specified date and time.
// ifUnmodifiedSince - optional. A date and time value. Specify this header to perform the operation only if
// the resource has not been modified since the specified date and time.
// xMsClientRequestID - a UUID recorded in the analytics logs for troubleshooting and correlation.
// timeout - an optional operation timeout value in seconds. The period begins when the request is received by
// the service. If the timeout value elapses before the operation completes, the operation fails.
// xMsDate - specifies the Coordinated Universal Time (UTC) for the request.  This is required when using
// shared key authorization.
func (client PathClient) Read(ctx context.Context, filesystem string, pathParameter string, rangeParameter string, xMsLeaseID string, xMsRangeGetContentMd5 *bool, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PathClient.Read")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: xMsLeaseID,
			Constraints: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: filesystem,
			Constraints: []validation.Constraint{{Target: "filesystem", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "filesystem", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: xMsClientRequestID,
			Constraints: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagedatalake.PathClient", "Read", err.Error())
	}

	req, err := client.ReadPreparer(ctx, filesystem, pathParameter, rangeParameter, xMsLeaseID, xMsRangeGetContentMd5, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince, xMsClientRequestID, timeout, xMsDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Read", nil, "Failure preparing request")
		return
	}

	resp, err := client.ReadSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Read", resp, "Failure sending request")
		return
	}

	result, err = client.ReadResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Read", resp, "Failure responding to request")
	}

	return
}

// ReadPreparer prepares the Read request.
func (client PathClient) ReadPreparer(ctx context.Context, filesystem string, pathParameter string, rangeParameter string, xMsLeaseID string, xMsRangeGetContentMd5 *bool, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, xMsClientRequestID string, timeout *int32, xMsDate string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName": client.AccountName,
		"dnsSuffix":   client.DNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"filesystem": autorest.Encode("path", filesystem),
		"path":       autorest.Encode("path", pathParameter),
	}

	queryParameters := map[string]interface{}{}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{accountName}.{dnsSuffix}", urlParameters),
		autorest.WithPathParameters("/{filesystem}/{path}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if len(rangeParameter) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Range", autorest.String(rangeParameter)))
	}
	if len(xMsLeaseID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-lease-id", autorest.String(xMsLeaseID)))
	}
	if xMsRangeGetContentMd5 != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-range-get-content-md5", autorest.String(xMsRangeGetContentMd5)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if len(ifModifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if len(ifUnmodifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	if len(xMsClientRequestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(xMsClientRequestID)))
	}
	if len(xMsDate) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-date", autorest.String(xMsDate)))
	}
	if len(client.XMsVersion) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-version", autorest.String(client.XMsVersion)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ReadSender sends the Read request. The method will close the
// http.Response Body if it receives an error.
func (client PathClient) ReadSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ReadResponder handles the response to the Read request. The method always
// closes the http.Response Body.
func (client PathClient) ReadResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusPartialContent))
	result.Response = autorest.Response{Response: resp}
	return
}

// Update uploads data to be appended to a file, flushes (writes) previously uploaded data to a file, sets properties
// for a file or directory, or sets access control for a file or directory. Data can only be appended to a file. This
// operation supports conditional HTTP requests. For more information, see [Specifying Conditional Headers for Blob
// Service
// Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
// Parameters:
// action - the action must be "append" to upload data to be appended to a file, "flush" to flush previously
// uploaded data to a file, "setProperties" to set the properties of a file or directory, or "setAccessControl"
// to set the owner, group, permissions, or access control list for a file or directory.  Note that
// Hierarchical Namespace must be enabled for the account in order to use access control.  Also note that the
// Access Control List (ACL) includes permissions for the owner, owning group, and others, so the
// x-ms-permissions and x-ms-acl request headers are mutually exclusive.
// filesystem - the filesystem identifier.
// pathParameter - the file or directory path.
// position - this parameter allows the caller to upload data in parallel and control the order in which it is
// appended to the file.  It is required when uploading data to be appended to the file and when flushing
// previously uploaded data to the file.  The value must be the position where the data is to be appended.
// Uploaded data is not immediately flushed, or written, to the file.  To flush, the previously uploaded data
// must be contiguous, the position parameter must be specified and equal to the length of the file after all
// data has been written, and there must not be a request entity body included with the request.
// retainUncommittedData - valid only for flush operations.  If "true", uncommitted data is retained after the
// flush operation completes; otherwise, the uncommitted data is deleted after the flush operation.  The
// default is false.  Data at offsets less than the specified position are written to the file when flush
// succeeds, but this optional parameter allows data after the flush position to be retained for a future flush
// operation.
// closeParameter - azure Storage Events allow applications to receive notifications when files change. When
// Azure Storage Events are enabled, a file changed event is raised. This event has a property indicating
// whether this is the final change to distinguish the difference between an intermediate flush to a file
// stream and the final close of a file stream. The close query parameter is valid only when the action is
// "flush" and change notifications are enabled. If the value of close is "true" and the flush operation
// completes successfully, the service raises a file change notification with a property indicating that this
// is the final update (the file stream has been closed). If "false" a change notification is raised indicating
// the file has changed. The default is false. This query parameter is set to true by the Hadoop ABFS driver to
// indicate that the file stream has been closed."
// contentLength - required for "Append Data" and "Flush Data".  Must be 0 for "Flush Data".  Must be the
// length of the request content in bytes for "Append Data".
// contentMD5 - optional. An MD5 hash of the request content. This header is valid on "Append" and "Flush"
// operations. This hash is used to verify the integrity of the request content during transport. When this
// header is specified, the storage service compares the hash of the content that has arrived with this header
// value. If the two hashes do not match, the operation will fail with error code 400 (Bad Request). Note that
// this MD5 hash is not stored with the file. This header is associated with the request content, and not with
// the stored content of the file itself.
// xMsLeaseID - the lease ID must be specified if there is an active lease.
// xMsCacheControl - optional and only valid for flush and set properties operations.  The service stores this
// value and includes it in the "Cache-Control" response header for "Read File" operations.
// xMsContentType - optional and only valid for flush and set properties operations.  The service stores this
// value and includes it in the "Content-Type" response header for "Read File" operations.
// xMsContentDisposition - optional and only valid for flush and set properties operations.  The service stores
// this value and includes it in the "Content-Disposition" response header for "Read File" operations.
// xMsContentEncoding - optional and only valid for flush and set properties operations.  The service stores
// this value and includes it in the "Content-Encoding" response header for "Read File" operations.
// xMsContentLanguage - optional and only valid for flush and set properties operations.  The service stores
// this value and includes it in the "Content-Language" response header for "Read File" operations.
// xMsContentMd5 - optional and only valid for "Flush & Set Properties" operations.  The service stores this
// value and includes it in the "Content-Md5" response header for "Read & Get Properties" operations. If this
// property is not specified on the request, then the property will be cleared for the file. Subsequent calls
// to "Read & Get Properties" will not return this property unless it is explicitly set on that file again.
// xMsProperties - optional.  User-defined properties to be stored with the file or directory, in the format of
// a comma-separated list of name and value pairs "n1=v1, n2=v2, ...", where each value is a base64 encoded
// string. Note that the string may only contain ASCII characters in the ISO-8859-1 character set. Valid only
// for the setProperties operation. If the file or directory exists, any properties not included in the list
// will be removed.  All properties are removed if the header is omitted.  To merge new and existing
// properties, first get all existing properties and the current E-Tag, then make a conditional request with
// the E-Tag and include values for all properties.
// xMsOwner - optional and valid only for the setAccessControl operation. Sets the owner of the file or
// directory.
// xMsGroup - optional and valid only for the setAccessControl operation. Sets the owning group of the file or
// directory.
// xMsPermissions - optional and only valid if Hierarchical Namespace is enabled for the account. Sets POSIX
// access permissions for the file owner, the file owning group, and others. Each class may be granted read,
// write, or execute permission.  The sticky bit is also supported.  Both symbolic (rwxrw-rw-) and 4-digit
// octal notation (e.g. 0766) are supported. Invalid in conjunction with x-ms-acl.
// xMsACL - optional and valid only for the setAccessControl operation. Sets POSIX access control rights on
// files and directories. The value is a comma-separated list of access control entries that fully replaces the
// existing access control list (ACL).  Each access control entry (ACE) consists of a scope, a type, a user or
// group identifier, and permissions in the format "[scope:][type]:[id]:[permissions]". The scope must be
// "default" to indicate the ACE belongs to the default ACL for a directory; otherwise scope is implicit and
// the ACE belongs to the access ACL.  There are four ACE types: "user" grants rights to the owner or a named
// user, "group" grants rights to the owning group or a named group, "mask" restricts rights granted to named
// users and the members of groups, and "other" grants rights to all users not found in any of the other
// entries. The user or group identifier is omitted for entries of type "mask" and "other".  The user or group
// identifier is also omitted for the owner and owning group.  The permission field is a 3-character sequence
// where the first character is 'r' to grant read access, the second character is 'w' to grant write access,
// and the third character is 'x' to grant execute permission.  If access is not granted, the '-' character is
// used to denote that the permission is denied. For example, the following ACL grants read, write, and execute
// rights to the file owner and john.doe@contoso, the read right to the owning group, and nothing to everyone
// else: "user::rwx,user:john.doe@contoso:rwx,group::r--,other::---,mask=rwx". Invalid in conjunction with
// x-ms-permissions.
// ifMatch - optional for Flush Data and Set Properties, but invalid for Append Data.  An ETag value. Specify
// this header to perform the operation only if the resource's ETag matches the value specified. The ETag must
// be specified in quotes.
// ifNoneMatch - optional for Flush Data and Set Properties, but invalid for Append Data.  An ETag value or the
// special wildcard ("*") value. Specify this header to perform the operation only if the resource's ETag does
// not match the value specified. The ETag must be specified in quotes.
// ifModifiedSince - optional for Flush Data and Set Properties, but invalid for Append Data. A date and time
// value. Specify this header to perform the operation only if the resource has been modified since the
// specified date and time.
// ifUnmodifiedSince - optional for Flush Data and Set Properties, but invalid for Append Data. A date and time
// value. Specify this header to perform the operation only if the resource has not been modified since the
// specified date and time.
// requestBody - valid only for append operations.  The data to be uploaded and appended to the file.
// xMsClientRequestID - a UUID recorded in the analytics logs for troubleshooting and correlation.
// timeout - an optional operation timeout value in seconds. The period begins when the request is received by
// the service. If the timeout value elapses before the operation completes, the operation fails.
// xMsDate - specifies the Coordinated Universal Time (UTC) for the request.  This is required when using
// shared key authorization.
func (client PathClient) Update(ctx context.Context, action PathUpdateAction, filesystem string, pathParameter string, position *int64, retainUncommittedData *bool, closeParameter *bool, contentLength *int64, contentMD5 string, xMsLeaseID string, xMsCacheControl string, xMsContentType string, xMsContentDisposition string, xMsContentEncoding string, xMsContentLanguage string, xMsContentMd5 string, xMsProperties string, xMsOwner string, xMsGroup string, xMsPermissions string, xMsACL string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, requestBody io.ReadCloser, xMsClientRequestID string, timeout *int32, xMsDate string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PathClient.Update")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: contentLength,
			Constraints: []validation.Constraint{{Target: "contentLength", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "contentLength", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: xMsLeaseID,
			Constraints: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsLeaseID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: filesystem,
			Constraints: []validation.Constraint{{Target: "filesystem", Name: validation.MaxLength, Rule: 63, Chain: nil},
				{Target: "filesystem", Name: validation.MinLength, Rule: 3, Chain: nil}}},
		{TargetValue: xMsClientRequestID,
			Constraints: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Empty, Rule: false,
				Chain: []validation.Constraint{{Target: "xMsClientRequestID", Name: validation.Pattern, Rule: `^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$`, Chain: nil}}}}},
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagedatalake.PathClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, action, filesystem, pathParameter, position, retainUncommittedData, closeParameter, contentLength, contentMD5, xMsLeaseID, xMsCacheControl, xMsContentType, xMsContentDisposition, xMsContentEncoding, xMsContentLanguage, xMsContentMd5, xMsProperties, xMsOwner, xMsGroup, xMsPermissions, xMsACL, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince, requestBody, xMsClientRequestID, timeout, xMsDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagedatalake.PathClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client PathClient) UpdatePreparer(ctx context.Context, action PathUpdateAction, filesystem string, pathParameter string, position *int64, retainUncommittedData *bool, closeParameter *bool, contentLength *int64, contentMD5 string, xMsLeaseID string, xMsCacheControl string, xMsContentType string, xMsContentDisposition string, xMsContentEncoding string, xMsContentLanguage string, xMsContentMd5 string, xMsProperties string, xMsOwner string, xMsGroup string, xMsPermissions string, xMsACL string, ifMatch string, ifNoneMatch string, ifModifiedSince string, ifUnmodifiedSince string, requestBody io.ReadCloser, xMsClientRequestID string, timeout *int32, xMsDate string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"accountName": client.AccountName,
		"dnsSuffix":   client.DNSSuffix,
	}

	pathParameters := map[string]interface{}{
		"filesystem": autorest.Encode("path", filesystem),
		"path":       autorest.Encode("path", pathParameter),
	}

	queryParameters := map[string]interface{}{
		"action": autorest.Encode("query", action),
	}
	if position != nil {
		queryParameters["position"] = autorest.Encode("query", *position)
	}
	if retainUncommittedData != nil {
		queryParameters["retainUncommittedData"] = autorest.Encode("query", *retainUncommittedData)
	}
	if closeParameter != nil {
		queryParameters["close"] = autorest.Encode("query", *closeParameter)
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/octet-stream"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("https://{accountName}.{dnsSuffix}", urlParameters),
		autorest.WithPathParameters("/{filesystem}/{path}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if requestBody != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithFile(requestBody))
	}
	if contentLength != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Content-Length", autorest.String(*contentLength)))
	}
	if len(contentMD5) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Content-MD5", autorest.String(contentMD5)))
	}
	if len(xMsLeaseID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-lease-id", autorest.String(xMsLeaseID)))
	}
	if len(xMsCacheControl) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-cache-control", autorest.String(xMsCacheControl)))
	}
	if len(xMsContentType) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-content-type", autorest.String(xMsContentType)))
	}
	if len(xMsContentDisposition) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-content-disposition", autorest.String(xMsContentDisposition)))
	}
	if len(xMsContentEncoding) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-content-encoding", autorest.String(xMsContentEncoding)))
	}
	if len(xMsContentLanguage) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-content-language", autorest.String(xMsContentLanguage)))
	}
	if len(xMsContentMd5) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-content-md5", autorest.String(xMsContentMd5)))
	}
	if len(xMsProperties) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-properties", autorest.String(xMsProperties)))
	}
	if len(xMsOwner) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-owner", autorest.String(xMsOwner)))
	}
	if len(xMsGroup) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-group", autorest.String(xMsGroup)))
	}
	if len(xMsPermissions) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-permissions", autorest.String(xMsPermissions)))
	}
	if len(xMsACL) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-acl", autorest.String(xMsACL)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if len(ifModifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if len(ifUnmodifiedSince) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	if len(xMsClientRequestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(xMsClientRequestID)))
	}
	if len(xMsDate) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-date", autorest.String(xMsDate)))
	}
	if len(client.XMsVersion) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-version", autorest.String(client.XMsVersion)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client PathClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client PathClient) UpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
