// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package timestreamwrite

import (
	"fmt"
	"net/url"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/crr"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateDatabase = "CreateDatabase"

// CreateDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatabase for more information on using the CreateDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatabaseRequest method.
//    req, resp := client.CreateDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateDatabase
func (c *TimestreamWrite) CreateDatabaseRequest(input *CreateDatabaseInput) (req *request.Request, output *CreateDatabaseOutput) {
	op := &request.Operation{
		Name:       opCreateDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatabaseInput{}
	}

	output = &CreateDatabaseOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CreateDatabase API operation for Amazon Timestream Write.
//
// Creates a new Timestream database. If the KMS key is not specified, the database
// will be encrypted with a Timestream managed KMS key located in your account.
// Refer to AWS managed KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk)
// for more info. Service quotas apply. For more information, see Access Management
// (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
// in the Timestream Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation CreateDatabase for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Timestream was unable to process this request because it contains resource
//   that already exists.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * ServiceQuotaExceededException
//   Instance quota of resource exceeded for this account.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateDatabase
func (c *TimestreamWrite) CreateDatabase(input *CreateDatabaseInput) (*CreateDatabaseOutput, error) {
	req, out := c.CreateDatabaseRequest(input)
	return out, req.Send()
}

// CreateDatabaseWithContext is the same as CreateDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) CreateDatabaseWithContext(ctx aws.Context, input *CreateDatabaseInput, opts ...request.Option) (*CreateDatabaseOutput, error) {
	req, out := c.CreateDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTable = "CreateTable"

// CreateTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTable for more information on using the CreateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTableRequest method.
//    req, resp := client.CreateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateTable
func (c *TimestreamWrite) CreateTableRequest(input *CreateTableInput) (req *request.Request, output *CreateTableOutput) {
	op := &request.Operation{
		Name:       opCreateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTableInput{}
	}

	output = &CreateTableOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CreateTable API operation for Amazon Timestream Write.
//
// The CreateTable operation adds a new table to an existing database in your
// account. In an AWS account, table names must be at least unique within each
// Region if they are in the same database. You may have identical table names
// in the same Region if the tables are in seperate databases. While creating
// the table, you must specify the table name, database name, and the retention
// properties. Service quotas apply. For more information, see Access Management
// (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
// in the Timestream Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation CreateTable for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Timestream was unable to process this request because it contains resource
//   that already exists.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * ServiceQuotaExceededException
//   Instance quota of resource exceeded for this account.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateTable
func (c *TimestreamWrite) CreateTable(input *CreateTableInput) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	return out, req.Send()
}

// CreateTableWithContext is the same as CreateTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) CreateTableWithContext(ctx aws.Context, input *CreateTableInput, opts ...request.Option) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatabase = "DeleteDatabase"

// DeleteDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatabase for more information on using the DeleteDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatabaseRequest method.
//    req, resp := client.DeleteDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteDatabase
func (c *TimestreamWrite) DeleteDatabaseRequest(input *DeleteDatabaseInput) (req *request.Request, output *DeleteDatabaseOutput) {
	op := &request.Operation{
		Name:       opDeleteDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatabaseInput{}
	}

	output = &DeleteDatabaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DeleteDatabase API operation for Amazon Timestream Write.
//
// Deletes a given Timestream database. This is an irreversible operation. After
// a database is deleted, the time series data from its tables cannot be recovered.
//
// All tables in the database must be deleted first, or a ValidationException
// error will be thrown.
//
// Due to the nature of distributed retries, the operation can return either
// success or a ResourceNotFoundException. Clients should consider them equivalent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DeleteDatabase for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteDatabase
func (c *TimestreamWrite) DeleteDatabase(input *DeleteDatabaseInput) (*DeleteDatabaseOutput, error) {
	req, out := c.DeleteDatabaseRequest(input)
	return out, req.Send()
}

// DeleteDatabaseWithContext is the same as DeleteDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DeleteDatabaseWithContext(ctx aws.Context, input *DeleteDatabaseInput, opts ...request.Option) (*DeleteDatabaseOutput, error) {
	req, out := c.DeleteDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTable = "DeleteTable"

// DeleteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTable for more information on using the DeleteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTableRequest method.
//    req, resp := client.DeleteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteTable
func (c *TimestreamWrite) DeleteTableRequest(input *DeleteTableInput) (req *request.Request, output *DeleteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableInput{}
	}

	output = &DeleteTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DeleteTable API operation for Amazon Timestream Write.
//
// Deletes a given Timestream table. This is an irreversible operation. After
// a Timestream database table is deleted, the time series data stored in the
// table cannot be recovered.
//
// Due to the nature of distributed retries, the operation can return either
// success or a ResourceNotFoundException. Clients should consider them equivalent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DeleteTable for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteTable
func (c *TimestreamWrite) DeleteTable(input *DeleteTableInput) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	return out, req.Send()
}

// DeleteTableWithContext is the same as DeleteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DeleteTableWithContext(ctx aws.Context, input *DeleteTableInput, opts ...request.Option) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatabase = "DescribeDatabase"

// DescribeDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatabase for more information on using the DescribeDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatabaseRequest method.
//    req, resp := client.DescribeDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeDatabase
func (c *TimestreamWrite) DescribeDatabaseRequest(input *DescribeDatabaseInput) (req *request.Request, output *DescribeDatabaseOutput) {
	op := &request.Operation{
		Name:       opDescribeDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatabaseInput{}
	}

	output = &DescribeDatabaseOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeDatabase API operation for Amazon Timestream Write.
//
// Returns information about the database, including the database name, time
// that the database was created, and the total number of tables found within
// the database. Service quotas apply. For more information, see Access Management
// (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
// in the Timestream Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DescribeDatabase for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeDatabase
func (c *TimestreamWrite) DescribeDatabase(input *DescribeDatabaseInput) (*DescribeDatabaseOutput, error) {
	req, out := c.DescribeDatabaseRequest(input)
	return out, req.Send()
}

// DescribeDatabaseWithContext is the same as DescribeDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DescribeDatabaseWithContext(ctx aws.Context, input *DescribeDatabaseInput, opts ...request.Option) (*DescribeDatabaseOutput, error) {
	req, out := c.DescribeDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoints = "DescribeEndpoints"

// DescribeEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoints for more information on using the DescribeEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointsRequest method.
//    req, resp := client.DescribeEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeEndpoints
func (c *TimestreamWrite) DescribeEndpointsRequest(input *DescribeEndpointsInput) (req *request.Request, output *DescribeEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointsInput{}
	}

	output = &DescribeEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoints API operation for Amazon Timestream Write.
//
// DescribeEndpoints returns a list of available endpoints to make Timestream
// API calls against. This API is available through both Write and Query.
//
// Because Timestream’s SDKs are designed to transparently work with the service’s
// architecture, including the management and mapping of the service endpoints,
// it is not recommended that you use this API unless:
//
//    * Your application uses a programming language that does not yet have
//    SDK support
//
//    * You require better control over the client-side implementation
//
// For detailed information on how to use DescribeEndpoints, see The Endpoint
// Discovery Pattern and REST APIs (https://docs.aws.amazon.com/timestream/latest/developerguide/Using-API.endpoint-discovery.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DescribeEndpoints for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeEndpoints
func (c *TimestreamWrite) DescribeEndpoints(input *DescribeEndpointsInput) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	return out, req.Send()
}

// DescribeEndpointsWithContext is the same as DescribeEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DescribeEndpointsWithContext(ctx aws.Context, input *DescribeEndpointsInput, opts ...request.Option) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type discovererDescribeEndpoints struct {
	Client        *TimestreamWrite
	Required      bool
	EndpointCache *crr.EndpointCache
	Params        map[string]*string
	Key           string
	req           *request.Request
}

func (d *discovererDescribeEndpoints) Discover() (crr.Endpoint, error) {
	input := &DescribeEndpointsInput{}

	resp, err := d.Client.DescribeEndpoints(input)
	if err != nil {
		return crr.Endpoint{}, err
	}

	endpoint := crr.Endpoint{
		Key: d.Key,
	}

	for _, e := range resp.Endpoints {
		if e.Address == nil {
			continue
		}

		address := *e.Address

		var scheme string
		if idx := strings.Index(address, "://"); idx != -1 {
			scheme = address[:idx]
		}

		if len(scheme) == 0 {
			address = fmt.Sprintf("%s://%s", d.req.HTTPRequest.URL.Scheme, address)
		}

		cachedInMinutes := aws.Int64Value(e.CachePeriodInMinutes)
		u, err := url.Parse(address)
		if err != nil {
			continue
		}

		addr := crr.WeightedAddress{
			URL:     u,
			Expired: time.Now().Add(time.Duration(cachedInMinutes) * time.Minute),
		}

		endpoint.Add(addr)
	}

	d.EndpointCache.Add(endpoint)

	return endpoint, nil
}

func (d *discovererDescribeEndpoints) Handler(r *request.Request) {
	endpointKey := crr.BuildEndpointKey(d.Params)
	d.Key = endpointKey
	d.req = r

	endpoint, err := d.EndpointCache.Get(d, endpointKey, d.Required)
	if err != nil {
		r.Error = err
		return
	}

	if endpoint.URL != nil && len(endpoint.URL.String()) > 0 {
		r.HTTPRequest.URL = endpoint.URL
	}
}

const opDescribeTable = "DescribeTable"

// DescribeTableRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTable for more information on using the DescribeTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTableRequest method.
//    req, resp := client.DescribeTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeTable
func (c *TimestreamWrite) DescribeTableRequest(input *DescribeTableInput) (req *request.Request, output *DescribeTableOutput) {
	op := &request.Operation{
		Name:       opDescribeTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableInput{}
	}

	output = &DescribeTableOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeTable API operation for Amazon Timestream Write.
//
// Returns information about the table, including the table name, database name,
// retention duration of the memory store and the magnetic store. Service quotas
// apply. For more information, see Access Management (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
// in the Timestream Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DescribeTable for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeTable
func (c *TimestreamWrite) DescribeTable(input *DescribeTableInput) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	return out, req.Send()
}

// DescribeTableWithContext is the same as DescribeTable with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DescribeTableWithContext(ctx aws.Context, input *DescribeTableInput, opts ...request.Option) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDatabases = "ListDatabases"

// ListDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the ListDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatabases for more information on using the ListDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatabasesRequest method.
//    req, resp := client.ListDatabasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListDatabases
func (c *TimestreamWrite) ListDatabasesRequest(input *ListDatabasesInput) (req *request.Request, output *ListDatabasesOutput) {
	op := &request.Operation{
		Name:       opListDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatabasesInput{}
	}

	output = &ListDatabasesOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListDatabases API operation for Amazon Timestream Write.
//
// Returns a list of your Timestream databases. Service quotas apply. For more
// information, see Access Management (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
// in the Timestream Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation ListDatabases for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListDatabases
func (c *TimestreamWrite) ListDatabases(input *ListDatabasesInput) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	return out, req.Send()
}

// ListDatabasesWithContext is the same as ListDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListDatabasesWithContext(ctx aws.Context, input *ListDatabasesInput, opts ...request.Option) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatabasesPages iterates over the pages of a ListDatabases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatabases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatabases operation.
//    pageNum := 0
//    err := client.ListDatabasesPages(params,
//        func(page *timestreamwrite.ListDatabasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TimestreamWrite) ListDatabasesPages(input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool) error {
	return c.ListDatabasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatabasesPagesWithContext same as ListDatabasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListDatabasesPagesWithContext(ctx aws.Context, input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatabasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatabasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatabasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTables = "ListTables"

// ListTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTables for more information on using the ListTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTablesRequest method.
//    req, resp := client.ListTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTables
func (c *TimestreamWrite) ListTablesRequest(input *ListTablesInput) (req *request.Request, output *ListTablesOutput) {
	op := &request.Operation{
		Name:       opListTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTablesInput{}
	}

	output = &ListTablesOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListTables API operation for Amazon Timestream Write.
//
// A list of tables, along with the name, status and retention properties of
// each table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation ListTables for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTables
func (c *TimestreamWrite) ListTables(input *ListTablesInput) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	return out, req.Send()
}

// ListTablesWithContext is the same as ListTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListTablesWithContext(ctx aws.Context, input *ListTablesInput, opts ...request.Option) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTablesPages iterates over the pages of a ListTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTables operation.
//    pageNum := 0
//    err := client.ListTablesPages(params,
//        func(page *timestreamwrite.ListTablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TimestreamWrite) ListTablesPages(input *ListTablesInput, fn func(*ListTablesOutput, bool) bool) error {
	return c.ListTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTablesPagesWithContext same as ListTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListTablesPagesWithContext(ctx aws.Context, input *ListTablesInput, fn func(*ListTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTagsForResource
func (c *TimestreamWrite) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListTagsForResource API operation for Amazon Timestream Write.
//
// List all tags on a Timestream resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTagsForResource
func (c *TimestreamWrite) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/TagResource
func (c *TimestreamWrite) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// TagResource API operation for Amazon Timestream Write.
//
// Associate a set of tags with a Timestream resource. You can then activate
// these user-defined tags so that they appear on the Billing and Cost Management
// console for cost allocation tracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * ServiceQuotaExceededException
//   Instance quota of resource exceeded for this account.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/TagResource
func (c *TimestreamWrite) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UntagResource
func (c *TimestreamWrite) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UntagResource API operation for Amazon Timestream Write.
//
// Removes the association of tags from a Timestream resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Invalid or malformed request.
//
//   * ServiceQuotaExceededException
//   Instance quota of resource exceeded for this account.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UntagResource
func (c *TimestreamWrite) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatabase = "UpdateDatabase"

// UpdateDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatabase for more information on using the UpdateDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDatabaseRequest method.
//    req, resp := client.UpdateDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateDatabase
func (c *TimestreamWrite) UpdateDatabaseRequest(input *UpdateDatabaseInput) (req *request.Request, output *UpdateDatabaseOutput) {
	op := &request.Operation{
		Name:       opUpdateDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDatabaseInput{}
	}

	output = &UpdateDatabaseOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateDatabase API operation for Amazon Timestream Write.
//
// Modifies the KMS key for an existing database. While updating the database,
// you must specify the database name and the identifier of the new KMS key
// to be used (KmsKeyId). If there are any concurrent UpdateDatabase requests,
// first writer wins.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation UpdateDatabase for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Invalid or malformed request.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * ServiceQuotaExceededException
//   Instance quota of resource exceeded for this account.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateDatabase
func (c *TimestreamWrite) UpdateDatabase(input *UpdateDatabaseInput) (*UpdateDatabaseOutput, error) {
	req, out := c.UpdateDatabaseRequest(input)
	return out, req.Send()
}

// UpdateDatabaseWithContext is the same as UpdateDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) UpdateDatabaseWithContext(ctx aws.Context, input *UpdateDatabaseInput, opts ...request.Option) (*UpdateDatabaseOutput, error) {
	req, out := c.UpdateDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTable = "UpdateTable"

// UpdateTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTable for more information on using the UpdateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTableRequest method.
//    req, resp := client.UpdateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateTable
func (c *TimestreamWrite) UpdateTableRequest(input *UpdateTableInput) (req *request.Request, output *UpdateTableOutput) {
	op := &request.Operation{
		Name:       opUpdateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTableInput{}
	}

	output = &UpdateTableOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateTable API operation for Amazon Timestream Write.
//
// Modifies the retention duration of the memory store and magnetic store for
// your Timestream table. Note that the change in retention duration takes effect
// immediately. For example, if the retention period of the memory store was
// initially set to 2 hours and then changed to 24 hours, the memory store will
// be capable of holding 24 hours of data, but will be populated with 24 hours
// of data 22 hours after this change was made. Timestream does not retrieve
// data from the magnetic store to populate the memory store.
//
// Service quotas apply. For more information, see Access Management (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
// in the Timestream Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation UpdateTable for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateTable
func (c *TimestreamWrite) UpdateTable(input *UpdateTableInput) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	return out, req.Send()
}

// UpdateTableWithContext is the same as UpdateTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) UpdateTableWithContext(ctx aws.Context, input *UpdateTableInput, opts ...request.Option) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opWriteRecords = "WriteRecords"

// WriteRecordsRequest generates a "aws/request.Request" representing the
// client's request for the WriteRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See WriteRecords for more information on using the WriteRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the WriteRecordsRequest method.
//    req, resp := client.WriteRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/WriteRecords
func (c *TimestreamWrite) WriteRecordsRequest(input *WriteRecordsInput) (req *request.Request, output *WriteRecordsOutput) {
	op := &request.Operation{
		Name:       opWriteRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &WriteRecordsInput{}
	}

	output = &WriteRecordsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// WriteRecords API operation for Amazon Timestream Write.
//
// The WriteRecords operation enables you to write your time series data into
// Timestream. You can specify a single data point or a batch of data points
// to be inserted into the system. Timestream offers you with a flexible schema
// that auto detects the column names and data types for your Timestream tables
// based on the dimension names and data types of the data points you specify
// when invoking writes into the database. Timestream support eventual consistency
// read semantics. This means that when you query data immediately after writing
// a batch of data into Timestream, the query results might not reflect the
// results of a recently completed write operation. The results may also include
// some stale data. If you repeat the query request after a short time, the
// results should return the latest data. Service quotas apply. For more information,
// see Access Management (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
// in the Timestream Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation WriteRecords for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   Too many requests were made by a user exceeding service quotas. The request
//   was throttled.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * ResourceNotFoundException
//   The operation tried to access a nonexistent resource. The resource might
//   not be specified correctly, or its status might not be ACTIVE.
//
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * RejectedRecordsException
//   WriteRecords would throw this exception in the following cases:
//
//      * Records with duplicate data where there are multiple records with the
//      same dimensions, timestamps, and measure names but different measure values.
//
//      * Records with timestamps that lie outside the retention duration of the
//      memory store
//
//      * Records with dimensions or measures that exceed the Timestream defined
//      limits.
//
//   For more information, see Access Management (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
//   in the Timestream Developer Guide.
//
//   * InvalidEndpointException
//   The requested endpoint was invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/WriteRecords
func (c *TimestreamWrite) WriteRecords(input *WriteRecordsInput) (*WriteRecordsOutput, error) {
	req, out := c.WriteRecordsRequest(input)
	return out, req.Send()
}

// WriteRecordsWithContext is the same as WriteRecords with the addition of
// the ability to pass a context and additional request options.
//
// See WriteRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) WriteRecordsWithContext(ctx aws.Context, input *WriteRecordsInput, opts ...request.Option) (*WriteRecordsOutput, error) {
	req, out := c.WriteRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You are not authorized to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Timestream was unable to process this request because it contains resource
// that already exists.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"3" type:"string" required:"true"`

	// The KMS key for the database. If the KMS key is not specified, the database
	// will be encrypted with a Timestream managed KMS key located in your account.
	// Refer to AWS managed KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk)
	// for more info.
	KmsKeyId *string `min:"1" type:"string"`

	// A list of key-value pairs to label the table.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatabaseInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateDatabaseInput) SetDatabaseName(v string) *CreateDatabaseInput {
	s.DatabaseName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDatabaseInput) SetKmsKeyId(v string) *CreateDatabaseInput {
	s.KmsKeyId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatabaseInput) SetTags(v []*Tag) *CreateDatabaseInput {
	s.Tags = v
	return s
}

type CreateDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// The newly created Timestream database.
	Database *Database `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *CreateDatabaseOutput) SetDatabase(v *Database) *CreateDatabaseOutput {
	s.Database = v
	return s
}

type CreateTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"3" type:"string" required:"true"`

	// The duration for which your time series data must be stored in the memory
	// store and the magnetic store.
	RetentionProperties *RetentionProperties `type:"structure"`

	// The name of the Timestream table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// A list of key-value pairs to label the table.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTableInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.RetentionProperties != nil {
		if err := s.RetentionProperties.Validate(); err != nil {
			invalidParams.AddNested("RetentionProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateTableInput) SetDatabaseName(v string) *CreateTableInput {
	s.DatabaseName = &v
	return s
}

// SetRetentionProperties sets the RetentionProperties field's value.
func (s *CreateTableInput) SetRetentionProperties(v *RetentionProperties) *CreateTableInput {
	s.RetentionProperties = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CreateTableInput) SetTableName(v string) *CreateTableInput {
	s.TableName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTableInput) SetTags(v []*Tag) *CreateTableInput {
	s.Tags = v
	return s
}

type CreateTableOutput struct {
	_ struct{} `type:"structure"`

	// The newly created Timestream table.
	Table *Table `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableOutput) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *CreateTableOutput) SetTable(v *Table) *CreateTableOutput {
	s.Table = v
	return s
}

// A top level container for a table. Databases and tables are the fundamental
// management concepts in Amazon Timestream. All tables in a database are encrypted
// with the same KMS key.
type Database struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name that uniquely identifies this database.
	Arn *string `type:"string"`

	// The time when the database was created, calculated from the Unix epoch time.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the Timestream database.
	DatabaseName *string `min:"3" type:"string"`

	// The identifier of the KMS key used to encrypt the data stored in the database.
	KmsKeyId *string `min:"1" type:"string"`

	// The last time that this database was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The total number of tables found within a Timestream database.
	TableCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Database) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Database) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Database) SetArn(v string) *Database {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Database) SetCreationTime(v time.Time) *Database {
	s.CreationTime = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Database) SetDatabaseName(v string) *Database {
	s.DatabaseName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Database) SetKmsKeyId(v string) *Database {
	s.KmsKeyId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Database) SetLastUpdatedTime(v time.Time) *Database {
	s.LastUpdatedTime = &v
	return s
}

// SetTableCount sets the TableCount field's value.
func (s *Database) SetTableCount(v int64) *Database {
	s.TableCount = &v
	return s
}

type DeleteDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database to be deleted.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatabaseInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteDatabaseInput) SetDatabaseName(v string) *DeleteDatabaseInput {
	s.DatabaseName = &v
	return s
}

type DeleteDatabaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatabaseOutput) GoString() string {
	return s.String()
}

type DeleteTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the database where the Timestream database is to be deleted.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"3" type:"string" required:"true"`

	// The name of the Timestream table to be deleted.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTableInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteTableInput) SetDatabaseName(v string) *DeleteTableInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DeleteTableInput) SetTableName(v string) *DeleteTableInput {
	s.TableName = &v
	return s
}

type DeleteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableOutput) GoString() string {
	return s.String()
}

type DescribeDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatabaseInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DescribeDatabaseInput) SetDatabaseName(v string) *DescribeDatabaseInput {
	s.DatabaseName = &v
	return s
}

type DescribeDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream table.
	Database *Database `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *DescribeDatabaseOutput) SetDatabase(v *Database) *DescribeDatabaseOutput {
	s.Database = v
	return s
}

type DescribeEndpointsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) GoString() string {
	return s.String()
}

type DescribeEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// An Endpoints object is returned when a DescribeEndpoints request is made.
	//
	// Endpoints is a required field
	Endpoints []*Endpoint `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *DescribeEndpointsOutput) SetEndpoints(v []*Endpoint) *DescribeEndpointsOutput {
	s.Endpoints = v
	return s
}

type DescribeTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"3" type:"string" required:"true"`

	// The name of the Timestream table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DescribeTableInput) SetDatabaseName(v string) *DescribeTableInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DescribeTableInput) SetTableName(v string) *DescribeTableInput {
	s.TableName = &v
	return s
}

type DescribeTableOutput struct {
	_ struct{} `type:"structure"`

	// The Timestream table.
	Table *Table `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableOutput) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *DescribeTableOutput) SetTable(v *Table) *DescribeTableOutput {
	s.Table = v
	return s
}

// Dimension represents the meta data attributes of the time series. For example,
// the name and availability zone of an EC2 instance or the name of the manufacturer
// of a wind turbine are dimensions.
type Dimension struct {
	_ struct{} `type:"structure"`

	// The data type of the dimension for the time series data point.
	DimensionValueType *string `type:"string" enum:"DimensionValueType"`

	// Dimension represents the meta data attributes of the time series. For example,
	// the name and availability zone of an EC2 instance or the name of the manufacturer
	// of a wind turbine are dimensions.
	//
	// For constraints on Dimension names, see Naming Constraints (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming).
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionValueType sets the DimensionValueType field's value.
func (s *Dimension) SetDimensionValueType(v string) *Dimension {
	s.DimensionValueType = &v
	return s
}

// SetName sets the Name field's value.
func (s *Dimension) SetName(v string) *Dimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Dimension) SetValue(v string) *Dimension {
	s.Value = &v
	return s
}

// Represents an available endpoint against which to make API calls agaisnt,
// as well as the TTL for that endpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// An endpoint address.
	//
	// Address is a required field
	Address *string `type:"string" required:"true"`

	// The TTL for the endpoint, in minutes.
	//
	// CachePeriodInMinutes is a required field
	CachePeriodInMinutes *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetCachePeriodInMinutes sets the CachePeriodInMinutes field's value.
func (s *Endpoint) SetCachePeriodInMinutes(v int64) *Endpoint {
	s.CachePeriodInMinutes = &v
	return s
}

// Timestream was unable to fully process this request because of an internal
// server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested endpoint was invalid.
type InvalidEndpointException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEndpointException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEndpointException) GoString() string {
	return s.String()
}

func newErrorInvalidEndpointException(v protocol.ResponseMetadata) error {
	return &InvalidEndpointException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidEndpointException) Code() string {
	return "InvalidEndpointException"
}

// Message returns the exception's message.
func (s *InvalidEndpointException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidEndpointException) OrigErr() error {
	return nil
}

func (s *InvalidEndpointException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidEndpointException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidEndpointException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDatabasesInput struct {
	_ struct{} `type:"structure"`

	// The total number of items to return in the output. If the total number of
	// items available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as argument
	// of a subsequent API invocation.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token. To resume pagination, provide the NextToken value as
	// argument of a subsequent API invocation.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatabasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatabasesInput) SetMaxResults(v int64) *ListDatabasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesInput) SetNextToken(v string) *ListDatabasesInput {
	s.NextToken = &v
	return s
}

type ListDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of database names.
	Databases []*Database `type:"list"`

	// The pagination token. This parameter is returned when the response is truncated.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesOutput) GoString() string {
	return s.String()
}

// SetDatabases sets the Databases field's value.
func (s *ListDatabasesOutput) SetDatabases(v []*Database) *ListDatabasesOutput {
	s.Databases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesOutput) SetNextToken(v string) *ListDatabasesOutput {
	s.NextToken = &v
	return s
}

type ListTablesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	DatabaseName *string `min:"3" type:"string"`

	// The total number of items to return in the output. If the total number of
	// items available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as argument
	// of a subsequent API invocation.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token. To resume pagination, provide the NextToken value as
	// argument of a subsequent API invocation.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTablesInput"}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ListTablesInput) SetDatabaseName(v string) *ListTablesInput {
	s.DatabaseName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTablesInput) SetMaxResults(v int64) *ListTablesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesInput) SetNextToken(v string) *ListTablesInput {
	s.NextToken = &v
	return s
}

type ListTablesOutput struct {
	_ struct{} `type:"structure"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `type:"string"`

	// A list of tables.
	Tables []*Table `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesOutput) SetNextToken(v string) *ListTablesOutput {
	s.NextToken = &v
	return s
}

// SetTables sets the Tables field's value.
func (s *ListTablesOutput) SetTables(v []*Table) *ListTablesOutput {
	s.Tables = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Timestream resource with tags to be listed. This value is an Amazon Resource
	// Name (ARN).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags currently associated with the Timestream resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Record represents a time series data point being written into Timestream.
// Each record contains an array of dimensions. Dimensions represent the meta
// data attributes of a time series data point such as the instance name or
// availability zone of an EC2 instance. A record also contains the measure
// name which is the name of the measure being collected for example the CPU
// utilization of an EC2 instance. A record also contains the measure value
// and the value type which is the data type of the measure value. In addition,
// the record contains the timestamp when the measure was collected that the
// timestamp unit which represents the granularity of the timestamp.
type Record struct {
	_ struct{} `type:"structure"`

	// Contains the list of dimensions for time series data points.
	Dimensions []*Dimension `type:"list"`

	// Measure represents the data attribute of the time series. For example, the
	// CPU utilization of an EC2 instance or the RPM of a wind turbine are measures.
	MeasureName *string `min:"1" type:"string"`

	// Contains the measure value for the time series data point.
	MeasureValue *string `min:"1" type:"string"`

	// Contains the data type of the measure value for the time series data point.
	MeasureValueType *string `type:"string" enum:"MeasureValueType"`

	// Contains the time at which the measure value for the data point was collected.
	// The time value plus the unit provides the time elapsed since the epoch. For
	// example, if the time value is 12345 and the unit is ms, then 12345 ms have
	// elapsed since the epoch.
	Time *string `min:"1" type:"string"`

	// The granularity of the timestamp unit. It indicates if the time value is
	// in seconds, milliseconds, nanoseconds or other supported values.
	TimeUnit *string `type:"string" enum:"TimeUnit"`

	// 64-bit attribute used for record updates. Write requests for duplicate data
	// with a higher version number will update the existing measure value and version.
	// In cases where the measure value is the same, Version will still be updated
	// . Default value is to 1.
	Version *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Record) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Record"}
	if s.MeasureName != nil && len(*s.MeasureName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureName", 1))
	}
	if s.MeasureValue != nil && len(*s.MeasureValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureValue", 1))
	}
	if s.Time != nil && len(*s.Time) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Time", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *Record) SetDimensions(v []*Dimension) *Record {
	s.Dimensions = v
	return s
}

// SetMeasureName sets the MeasureName field's value.
func (s *Record) SetMeasureName(v string) *Record {
	s.MeasureName = &v
	return s
}

// SetMeasureValue sets the MeasureValue field's value.
func (s *Record) SetMeasureValue(v string) *Record {
	s.MeasureValue = &v
	return s
}

// SetMeasureValueType sets the MeasureValueType field's value.
func (s *Record) SetMeasureValueType(v string) *Record {
	s.MeasureValueType = &v
	return s
}

// SetTime sets the Time field's value.
func (s *Record) SetTime(v string) *Record {
	s.Time = &v
	return s
}

// SetTimeUnit sets the TimeUnit field's value.
func (s *Record) SetTimeUnit(v string) *Record {
	s.TimeUnit = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Record) SetVersion(v int64) *Record {
	s.Version = &v
	return s
}

// Records that were not successfully inserted into Timestream due to data validation
// issues that must be resolved prior to reinserting time series data into the
// system.
type RejectedRecord struct {
	_ struct{} `type:"structure"`

	// The existing version of the record. This value is populated in scenarios
	// where an identical record exists with a higher version than the version in
	// the write request.
	ExistingVersion *int64 `type:"long"`

	// The reason why a record was not successfully inserted into Timestream. Possible
	// causes of failure include:
	//
	//    * Records with duplicate data where there are multiple records with the
	//    same dimensions, timestamps, and measure names but different measure values.
	//
	//    * Records with timestamps that lie outside the retention duration of the
	//    memory store When the retention window is updated, you will receive a
	//    RejectedRecords exception if you immediately try to ingest data within
	//    the new window. To avoid a RejectedRecords exception, wait until the duration
	//    of the new window to ingest new data. For further information, see Best
	//    Practices for Configuring Timestream (https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration)
	//    and the explanation of how storage works in Timestream (https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html).
	//
	//    * Records with dimensions or measures that exceed the Timestream defined
	//    limits.
	//
	// For more information, see Access Management (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
	// in the Timestream Developer Guide.
	Reason *string `type:"string"`

	// The index of the record in the input request for WriteRecords. Indexes begin
	// with 0.
	RecordIndex *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectedRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectedRecord) GoString() string {
	return s.String()
}

// SetExistingVersion sets the ExistingVersion field's value.
func (s *RejectedRecord) SetExistingVersion(v int64) *RejectedRecord {
	s.ExistingVersion = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *RejectedRecord) SetReason(v string) *RejectedRecord {
	s.Reason = &v
	return s
}

// SetRecordIndex sets the RecordIndex field's value.
func (s *RejectedRecord) SetRecordIndex(v int64) *RejectedRecord {
	s.RecordIndex = &v
	return s
}

// WriteRecords would throw this exception in the following cases:
//
//    * Records with duplicate data where there are multiple records with the
//    same dimensions, timestamps, and measure names but different measure values.
//
//    * Records with timestamps that lie outside the retention duration of the
//    memory store
//
//    * Records with dimensions or measures that exceed the Timestream defined
//    limits.
//
// For more information, see Access Management (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
// in the Timestream Developer Guide.
type RejectedRecordsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RejectedRecords []*RejectedRecord `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectedRecordsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectedRecordsException) GoString() string {
	return s.String()
}

func newErrorRejectedRecordsException(v protocol.ResponseMetadata) error {
	return &RejectedRecordsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RejectedRecordsException) Code() string {
	return "RejectedRecordsException"
}

// Message returns the exception's message.
func (s *RejectedRecordsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RejectedRecordsException) OrigErr() error {
	return nil
}

func (s *RejectedRecordsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RejectedRecordsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RejectedRecordsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation tried to access a nonexistent resource. The resource might
// not be specified correctly, or its status might not be ACTIVE.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Retention properties contain the duration for which your time series data
// must be stored in the magnetic store and the memory store.
type RetentionProperties struct {
	_ struct{} `type:"structure"`

	// The duration for which data must be stored in the magnetic store.
	//
	// MagneticStoreRetentionPeriodInDays is a required field
	MagneticStoreRetentionPeriodInDays *int64 `min:"1" type:"long" required:"true"`

	// The duration for which data must be stored in the memory store.
	//
	// MemoryStoreRetentionPeriodInHours is a required field
	MemoryStoreRetentionPeriodInHours *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetentionProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetentionProperties"}
	if s.MagneticStoreRetentionPeriodInDays == nil {
		invalidParams.Add(request.NewErrParamRequired("MagneticStoreRetentionPeriodInDays"))
	}
	if s.MagneticStoreRetentionPeriodInDays != nil && *s.MagneticStoreRetentionPeriodInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MagneticStoreRetentionPeriodInDays", 1))
	}
	if s.MemoryStoreRetentionPeriodInHours == nil {
		invalidParams.Add(request.NewErrParamRequired("MemoryStoreRetentionPeriodInHours"))
	}
	if s.MemoryStoreRetentionPeriodInHours != nil && *s.MemoryStoreRetentionPeriodInHours < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MemoryStoreRetentionPeriodInHours", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMagneticStoreRetentionPeriodInDays sets the MagneticStoreRetentionPeriodInDays field's value.
func (s *RetentionProperties) SetMagneticStoreRetentionPeriodInDays(v int64) *RetentionProperties {
	s.MagneticStoreRetentionPeriodInDays = &v
	return s
}

// SetMemoryStoreRetentionPeriodInHours sets the MemoryStoreRetentionPeriodInHours field's value.
func (s *RetentionProperties) SetMemoryStoreRetentionPeriodInHours(v int64) *RetentionProperties {
	s.MemoryStoreRetentionPeriodInHours = &v
	return s
}

// Instance quota of resource exceeded for this account.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Table represents a database table in Timestream. Tables contain one or more
// related time series. You can modify the retention duration of the memory
// store and the magnetic store for a table.
type Table struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name that uniquely identifies this table.
	Arn *string `type:"string"`

	// The time when the Timestream table was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the Timestream database that contains this table.
	DatabaseName *string `min:"3" type:"string"`

	// The time when the Timestream table was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The retention duration for the memory store and magnetic store.
	RetentionProperties *RetentionProperties `type:"structure"`

	// The name of the Timestream table.
	TableName *string `min:"3" type:"string"`

	// The current state of the table:
	//
	//    * DELETING - The table is being deleted.
	//
	//    * ACTIVE - The table is ready for use.
	TableStatus *string `type:"string" enum:"TableStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Table) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Table) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Table) SetArn(v string) *Table {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Table) SetCreationTime(v time.Time) *Table {
	s.CreationTime = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Table) SetDatabaseName(v string) *Table {
	s.DatabaseName = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Table) SetLastUpdatedTime(v time.Time) *Table {
	s.LastUpdatedTime = &v
	return s
}

// SetRetentionProperties sets the RetentionProperties field's value.
func (s *Table) SetRetentionProperties(v *RetentionProperties) *Table {
	s.RetentionProperties = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Table) SetTableName(v string) *Table {
	s.TableName = &v
	return s
}

// SetTableStatus sets the TableStatus field's value.
func (s *Table) SetTableStatus(v string) *Table {
	s.TableStatus = &v
	return s
}

// A tag is a label that you assign to a Timestream database and/or table. Each
// tag consists of a key and an optional value, both of which you define. Tags
// enable you to categorize databases and/or tables, for example, by purpose,
// owner, or environment.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag. Tag keys are case sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag. Tag values are case-sensitive and can be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the Timestream resource to which tags should be added. This value
	// is an Amazon Resource Name (ARN).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tags to be assigned to the Timestream resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Too many requests were made by a user exceeding service quotas. The request
// was throttled.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Timestream resource that the tags will be removed from. This value is
	// an Amazon Resource Name (ARN).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tags keys. Existing tags of the resource whose keys are members
	// of this list will be removed from the Timestream resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the database.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"3" type:"string" required:"true"`

	// The identifier of the new KMS key (KmsKeyId) to be used to encrypt the data
	// stored in the database. If the KmsKeyId currently registered with the database
	// is the same as the KmsKeyId in the request, there will not be any update.
	//
	// You can specify the KmsKeyId using any of the following:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-1:111122223333:alias/ExampleAlias
	//
	// KmsKeyId is a required field
	KmsKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatabaseInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.KmsKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyId"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateDatabaseInput) SetDatabaseName(v string) *UpdateDatabaseInput {
	s.DatabaseName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateDatabaseInput) SetKmsKeyId(v string) *UpdateDatabaseInput {
	s.KmsKeyId = &v
	return s
}

type UpdateDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// A top level container for a table. Databases and tables are the fundamental
	// management concepts in Amazon Timestream. All tables in a database are encrypted
	// with the same KMS key.
	Database *Database `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *UpdateDatabaseOutput) SetDatabase(v *Database) *UpdateDatabaseOutput {
	s.Database = v
	return s
}

type UpdateTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"3" type:"string" required:"true"`

	// The retention duration of the memory store and the magnetic store.
	//
	// RetentionProperties is a required field
	RetentionProperties *RetentionProperties `type:"structure" required:"true"`

	// The name of the Timesream table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTableInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.RetentionProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionProperties"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.RetentionProperties != nil {
		if err := s.RetentionProperties.Validate(); err != nil {
			invalidParams.AddNested("RetentionProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateTableInput) SetDatabaseName(v string) *UpdateTableInput {
	s.DatabaseName = &v
	return s
}

// SetRetentionProperties sets the RetentionProperties field's value.
func (s *UpdateTableInput) SetRetentionProperties(v *RetentionProperties) *UpdateTableInput {
	s.RetentionProperties = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateTableInput) SetTableName(v string) *UpdateTableInput {
	s.TableName = &v
	return s
}

type UpdateTableOutput struct {
	_ struct{} `type:"structure"`

	// The updated Timestream table.
	Table *Table `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableOutput) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *UpdateTableOutput) SetTable(v *Table) *UpdateTableOutput {
	s.Table = v
	return s
}

// Invalid or malformed request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type WriteRecordsInput struct {
	_ struct{} `type:"structure"`

	// A record containing the common measure and dimension attributes shared across
	// all the records in the request. The measure and dimension attributes specified
	// in here will be merged with the measure and dimension attributes in the records
	// object when the data is written into Timestream.
	CommonAttributes *Record `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"3" type:"string" required:"true"`

	// An array of records containing the unique dimension and measure attributes
	// for each time series data point.
	//
	// Records is a required field
	Records []*Record `min:"1" type:"list" required:"true"`

	// The name of the Timesream table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WriteRecordsInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.Records == nil {
		invalidParams.Add(request.NewErrParamRequired("Records"))
	}
	if s.Records != nil && len(s.Records) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Records", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.CommonAttributes != nil {
		if err := s.CommonAttributes.Validate(); err != nil {
			invalidParams.AddNested("CommonAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.Records != nil {
		for i, v := range s.Records {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Records", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommonAttributes sets the CommonAttributes field's value.
func (s *WriteRecordsInput) SetCommonAttributes(v *Record) *WriteRecordsInput {
	s.CommonAttributes = v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *WriteRecordsInput) SetDatabaseName(v string) *WriteRecordsInput {
	s.DatabaseName = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *WriteRecordsInput) SetRecords(v []*Record) *WriteRecordsInput {
	s.Records = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *WriteRecordsInput) SetTableName(v string) *WriteRecordsInput {
	s.TableName = &v
	return s
}

type WriteRecordsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteRecordsOutput) GoString() string {
	return s.String()
}

const (
	// DimensionValueTypeVarchar is a DimensionValueType enum value
	DimensionValueTypeVarchar = "VARCHAR"
)

// DimensionValueType_Values returns all elements of the DimensionValueType enum
func DimensionValueType_Values() []string {
	return []string{
		DimensionValueTypeVarchar,
	}
}

const (
	// MeasureValueTypeDouble is a MeasureValueType enum value
	MeasureValueTypeDouble = "DOUBLE"

	// MeasureValueTypeBigint is a MeasureValueType enum value
	MeasureValueTypeBigint = "BIGINT"

	// MeasureValueTypeVarchar is a MeasureValueType enum value
	MeasureValueTypeVarchar = "VARCHAR"

	// MeasureValueTypeBoolean is a MeasureValueType enum value
	MeasureValueTypeBoolean = "BOOLEAN"
)

// MeasureValueType_Values returns all elements of the MeasureValueType enum
func MeasureValueType_Values() []string {
	return []string{
		MeasureValueTypeDouble,
		MeasureValueTypeBigint,
		MeasureValueTypeVarchar,
		MeasureValueTypeBoolean,
	}
}

const (
	// TableStatusActive is a TableStatus enum value
	TableStatusActive = "ACTIVE"

	// TableStatusDeleting is a TableStatus enum value
	TableStatusDeleting = "DELETING"
)

// TableStatus_Values returns all elements of the TableStatus enum
func TableStatus_Values() []string {
	return []string{
		TableStatusActive,
		TableStatusDeleting,
	}
}

const (
	// TimeUnitMilliseconds is a TimeUnit enum value
	TimeUnitMilliseconds = "MILLISECONDS"

	// TimeUnitSeconds is a TimeUnit enum value
	TimeUnitSeconds = "SECONDS"

	// TimeUnitMicroseconds is a TimeUnit enum value
	TimeUnitMicroseconds = "MICROSECONDS"

	// TimeUnitNanoseconds is a TimeUnit enum value
	TimeUnitNanoseconds = "NANOSECONDS"
)

// TimeUnit_Values returns all elements of the TimeUnit enum
func TimeUnit_Values() []string {
	return []string{
		TimeUnitMilliseconds,
		TimeUnitSeconds,
		TimeUnitMicroseconds,
		TimeUnitNanoseconds,
	}
}
