// Code generated by smithy-go-codegen DO NOT EDIT.

package codecommit

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codecommit/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns comments made on a pull request.
//
// Reaction counts might include numbers from user identities who were deleted
// after the reaction was made. For a count of reactions from active identities,
// use GetCommentReactions.
func (c *Client) GetCommentsForPullRequest(ctx context.Context, params *GetCommentsForPullRequestInput, optFns ...func(*Options)) (*GetCommentsForPullRequestOutput, error) {
	if params == nil {
		params = &GetCommentsForPullRequestInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCommentsForPullRequest", params, optFns, c.addOperationGetCommentsForPullRequestMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCommentsForPullRequestOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCommentsForPullRequestInput struct {

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// This member is required.
	PullRequestId *string

	// The full commit ID of the commit in the source branch that was the tip of the
	// branch at the time the comment was made. Requirement is conditional:
	// afterCommitId must be specified when repositoryName is included.
	AfterCommitId *string

	// The full commit ID of the commit in the destination branch that was the tip of
	// the branch at the time the pull request was created. Requirement is conditional:
	// beforeCommitId must be specified when repositoryName is included.
	BeforeCommitId *string

	// A non-zero, non-negative integer used to limit the number of returned results.
	// The default is 100 comments. You can return up to 500 comments with a single
	// request.
	MaxResults *int32

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string

	// The name of the repository that contains the pull request. Requirement is
	// conditional: repositoryName must be specified when beforeCommitId and
	// afterCommitId are included.
	RepositoryName *string

	noSmithyDocumentSerde
}

type GetCommentsForPullRequestOutput struct {

	// An array of comment objects on the pull request.
	CommentsForPullRequestData []types.CommentsForPullRequest

	// An enumeration token that can be used in a request to return the next batch of
	// the results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCommentsForPullRequestMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetCommentsForPullRequest{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetCommentsForPullRequest{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCommentsForPullRequest"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetCommentsForPullRequestValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCommentsForPullRequest(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetCommentsForPullRequestPaginatorOptions is the paginator options for
// GetCommentsForPullRequest
type GetCommentsForPullRequestPaginatorOptions struct {
	// A non-zero, non-negative integer used to limit the number of returned results.
	// The default is 100 comments. You can return up to 500 comments with a single
	// request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetCommentsForPullRequestPaginator is a paginator for GetCommentsForPullRequest
type GetCommentsForPullRequestPaginator struct {
	options   GetCommentsForPullRequestPaginatorOptions
	client    GetCommentsForPullRequestAPIClient
	params    *GetCommentsForPullRequestInput
	nextToken *string
	firstPage bool
}

// NewGetCommentsForPullRequestPaginator returns a new
// GetCommentsForPullRequestPaginator
func NewGetCommentsForPullRequestPaginator(client GetCommentsForPullRequestAPIClient, params *GetCommentsForPullRequestInput, optFns ...func(*GetCommentsForPullRequestPaginatorOptions)) *GetCommentsForPullRequestPaginator {
	if params == nil {
		params = &GetCommentsForPullRequestInput{}
	}

	options := GetCommentsForPullRequestPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetCommentsForPullRequestPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetCommentsForPullRequestPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetCommentsForPullRequest page.
func (p *GetCommentsForPullRequestPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetCommentsForPullRequestOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetCommentsForPullRequest(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetCommentsForPullRequestAPIClient is a client that implements the
// GetCommentsForPullRequest operation.
type GetCommentsForPullRequestAPIClient interface {
	GetCommentsForPullRequest(context.Context, *GetCommentsForPullRequestInput, ...func(*Options)) (*GetCommentsForPullRequestOutput, error)
}

var _ GetCommentsForPullRequestAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetCommentsForPullRequest(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCommentsForPullRequest",
	}
}
