// Code generated by smithy-go-codegen DO NOT EDIT.

package acmpca

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/acmpca/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists information about your private certificate authority (CA) or one that has
// been shared with you. You specify the private CA on input by its ARN (Amazon
// Resource Name). The output contains the status of your CA. This can be any of
// the following:
//
//   - CREATING - Amazon Web Services Private CA is creating your private
//     certificate authority.
//
//   - PENDING_CERTIFICATE - The certificate is pending. You must use your Amazon
//     Web Services Private CA-hosted or on-premises root or subordinate CA to sign
//     your private CA CSR and then import it into Amazon Web Services Private CA.
//
//   - ACTIVE - Your private CA is active.
//
//   - DISABLED - Your private CA has been disabled.
//
//   - EXPIRED - Your private CA certificate has expired.
//
//   - FAILED - Your private CA has failed. Your CA can fail because of problems
//     such a network outage or back-end Amazon Web Services failure or other errors. A
//     failed CA can never return to the pending state. You must create a new CA.
//
//   - DELETED - Your private CA is within the restoration period, after which it
//     is permanently deleted. The length of time remaining in the CA's restoration
//     period is also included in this action's output.
func (c *Client) DescribeCertificateAuthority(ctx context.Context, params *DescribeCertificateAuthorityInput, optFns ...func(*Options)) (*DescribeCertificateAuthorityOutput, error) {
	if params == nil {
		params = &DescribeCertificateAuthorityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCertificateAuthority", params, optFns, c.addOperationDescribeCertificateAuthorityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCertificateAuthorityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeCertificateAuthorityInput struct {

	// The Amazon Resource Name (ARN) that was returned when you called [CreateCertificateAuthority]. This must be
	// of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	// .
	//
	// [CreateCertificateAuthority]: https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreateCertificateAuthority.html
	//
	// This member is required.
	CertificateAuthorityArn *string

	noSmithyDocumentSerde
}

type DescribeCertificateAuthorityOutput struct {

	// A [CertificateAuthority] structure that contains information about your private CA.
	//
	// [CertificateAuthority]: https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthority.html
	CertificateAuthority *types.CertificateAuthority

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCertificateAuthorityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeCertificateAuthority{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeCertificateAuthority{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeCertificateAuthority"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeCertificateAuthorityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCertificateAuthority(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeCertificateAuthority(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeCertificateAuthority",
	}
}
