// Code generated by smithy-go-codegen DO NOT EDIT.

package appsync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/appsync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new introspection. Returns the introspectionId of the new
// introspection after its creation.
func (c *Client) StartDataSourceIntrospection(ctx context.Context, params *StartDataSourceIntrospectionInput, optFns ...func(*Options)) (*StartDataSourceIntrospectionOutput, error) {
	if params == nil {
		params = &StartDataSourceIntrospectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDataSourceIntrospection", params, optFns, c.addOperationStartDataSourceIntrospectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDataSourceIntrospectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDataSourceIntrospectionInput struct {

	// The rdsDataApiConfig object data.
	RdsDataApiConfig *types.RdsDataApiConfig

	noSmithyDocumentSerde
}

type StartDataSourceIntrospectionOutput struct {

	// The introspection ID. Each introspection contains a unique ID that can be used
	// to reference the instrospection record.
	IntrospectionId *string

	// The status of the introspection during creation. By default, when a new
	// instrospection has been created, the status will be set to PROCESSING . Once the
	// operation has been completed, the status will change to SUCCESS or FAILED
	// depending on how the data was parsed. A FAILED operation will return an error
	// and its details as an introspectionStatusDetail .
	IntrospectionStatus types.DataSourceIntrospectionStatus

	// The error detail field. When a FAILED introspectionStatus is returned, the
	// introspectionStatusDetail will also return the exact error that was generated
	// during the operation.
	IntrospectionStatusDetail *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDataSourceIntrospectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartDataSourceIntrospection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartDataSourceIntrospection{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartDataSourceIntrospection"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartDataSourceIntrospectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDataSourceIntrospection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartDataSourceIntrospection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartDataSourceIntrospection",
	}
}
