# metautils
`import "github.com/grpc-ecosystem/go-grpc-middleware/util/metautils"`

* [Overview](#pkg-overview)
* [Imported Packages](#pkg-imports)
* [Index](#pkg-index)

## <a name="pkg-overview">Overview</a>

## <a name="pkg-imports">Imported Packages</a>

- [golang.org/x/net/context](https://godoc.org/golang.org/x/net/context)
- [google.golang.org/grpc/metadata](https://godoc.org/google.golang.org/grpc/metadata)

## <a name="pkg-index">Index</a>
* [type NiceMD](#NiceMD)
  * [func ExtractIncoming(ctx context.Context) NiceMD](#ExtractIncoming)
  * [func ExtractOutgoing(ctx context.Context) NiceMD](#ExtractOutgoing)
  * [func (m NiceMD) Add(key string, value string) NiceMD](#NiceMD.Add)
  * [func (m NiceMD) Clone(copiedKeys ...string) NiceMD](#NiceMD.Clone)
  * [func (m NiceMD) Del(key string) NiceMD](#NiceMD.Del)
  * [func (m NiceMD) Get(key string) string](#NiceMD.Get)
  * [func (m NiceMD) Set(key string, value string) NiceMD](#NiceMD.Set)
  * [func (m NiceMD) ToIncoming(ctx context.Context) context.Context](#NiceMD.ToIncoming)
  * [func (m NiceMD) ToOutgoing(ctx context.Context) context.Context](#NiceMD.ToOutgoing)

#### <a name="pkg-files">Package files</a>
[doc.go](./doc.go) [nicemd.go](./nicemd.go) [single_key.go](./single_key.go) 

## <a name="NiceMD">type</a> [NiceMD](./nicemd.go#L14)
``` go
type NiceMD metadata.MD
```
NiceMD is a convenience wrapper definiting extra functions on the metadata.

### <a name="ExtractIncoming">func</a> [ExtractIncoming](./nicemd.go#L20)
``` go
func ExtractIncoming(ctx context.Context) NiceMD
```
ExtractIncoming extracts an inbound metadata from the server-side context.

This function always returns a NiceMD wrapper of the metadata.MD, in case the context doesn't have metadata it returns
a new empty NiceMD.

### <a name="ExtractOutgoing">func</a> [ExtractOutgoing](./nicemd.go#L32)
``` go
func ExtractOutgoing(ctx context.Context) NiceMD
```
ExtractOutgoing extracts an outbound metadata from the client-side context.

This function always returns a NiceMD wrapper of the metadata.MD, in case the context doesn't have metadata it returns
a new empty NiceMD.

### <a name="NiceMD.Add">func</a> (NiceMD) [Add](./nicemd.go#L122)
``` go
func (m NiceMD) Add(key string, value string) NiceMD
```
Add retrieves a single value from the metadata.

It works analogously to http.Header.Add, as it appends to any existing values associated with key.

The function is binary-key safe.

### <a name="NiceMD.Clone">func</a> (NiceMD) [Clone](./nicemd.go#L44)
``` go
func (m NiceMD) Clone(copiedKeys ...string) NiceMD
```
Clone performs a *deep* copy of the metadata.MD.

You can specify the lower-case copiedKeys to only copy certain whitelisted keys. If no keys are explicitly whitelisted
all keys get copied.

### <a name="NiceMD.Del">func</a> (NiceMD) [Del](./nicemd.go#L100)
``` go
func (m NiceMD) Del(key string) NiceMD
```

### <a name="NiceMD.Get">func</a> (NiceMD) [Get](./nicemd.go#L85)
``` go
func (m NiceMD) Get(key string) string
```
Get retrieves a single value from the metadata.

It works analogously to http.Header.Get, returning the first value if there are many set. If the value is not set,
an empty string is returned.

The function is binary-key safe.

### <a name="NiceMD.Set">func</a> (NiceMD) [Set](./nicemd.go#L111)
``` go
func (m NiceMD) Set(key string, value string) NiceMD
```
Set sets the given value in a metadata.

It works analogously to http.Header.Set, overwriting all previous metadata values.

The function is binary-key safe.

### <a name="NiceMD.ToIncoming">func</a> (NiceMD) [ToIncoming](./nicemd.go#L75)
``` go
func (m NiceMD) ToIncoming(ctx context.Context) context.Context
```
ToIncoming sets the given NiceMD as a server-side context for dispatching.

This is mostly useful in ServerInterceptors..

### <a name="NiceMD.ToOutgoing">func</a> (NiceMD) [ToOutgoing](./nicemd.go#L68)
``` go
func (m NiceMD) ToOutgoing(ctx context.Context) context.Context
```
ToOutgoing sets the given NiceMD as a client-side context for dispatching.

- - -
Generated by [godoc2ghmd](https://github.com/GandalfUK/godoc2ghmd)