.\" @(#)$RCSfile: gfal_get_ids.man,v $ $Revision: 1.5 $ $Date: 2008/12/18 13:19:12 $ CERN Remi Mollon
.\" Copyright (C) 2007 by CERN
.\" All rights reserved
.\"
.TH GFAL_GET_IDS 3 "$Date: 2008/12/18 13:19:12 $" GFAL "Library Functions"

.SH NAME
gfal_get_ids \- Extracts the SRM file/request ids from the 'gfal_internal' object

.SH SYNOPSIS
\fBimport gfal\fR
.sp
.BI "int gfal_get_ids (gfal_internal " gfal ,
.BI "int *" srm_reqid ,
.BI "int **" srm_fileids ,
.BI "char **" srmv2_reqtoken );
.sp
.BI "int gfal_get_ids_setype (gfal_internal " gfal ,
.BI "enum se_type *" setype ,
.BI "int *" srm_reqid ,
.BI "int **" srm_fileids ,
.BI "char **" srmv2_reqtoken );

.SH DESCRIPTION
.B gfal_get_ids
Extracts the SRM file/request ids of the last called GFAL function from the 
.B gfal_internal
object.

As it will return only a copy of different ids, you have to manually free variables
.B srm_fileids
and 
.B srmv2_reqtoken
if the corresponding value is not 
.B NULL

.TP
.I gfal
.B gfal_internal
object generated from user parameters.
.TP
.I setype
The SE type which has been used to get the TURL. Possible values are: TYPE_SRM, TYPE_SRMv2, TYPE_SE.
.TP
.I srm_reqid
The request id returned by a SRMv1 SE.
.TP
.I srm_fileids
The table of file ids returned by a SRMv1 SE.
.TP
.I srmv2_reqtoken
The request token returned by a SRMv2 SE.

.SH RETURN VALUE
This routine returns the number of files (useful if srm_fileids is not NULL) on a success,
or -1 in case of error.

.SH SEE ALSO
.BR gfal (3),
.BR gfal_request_new (3),
.BR gfal_internal_free (3),
.BR gfal_init (3),
.BR gfal_deletesurls (3),
.BR gfal_removedir (3),
.BR gfal_turlsfromsurls (3),
.BR gfal_ls (3),
.BR gfal_get (3),
.BR gfal_getstatus (3),
.BR gfal_prestage (3),
.BR gfal_prestagestatus (3),
.BR gfal_pin (3),
.BR gfal_release (3),
.BR gfal_abortrequest (3),
.BR gfal_abortfiles (3),
.BR gfal_set_xfer_done (3),
.BR gfal_set_xfer_running (3),
.BR gfal_get_ids (3),
.BR gfal_set_ids (3),
.BR gfal_get_results (3),
