# Feff85EXAFS example: uraninite, UO2

This is a data-bearing example, thus the tests will cover both the
computation and the results of the analysis.

Uraninite is a simple, cubic structure with uranium octahedrally
coordinated by oxygen.  It is included as an example of an f-electron
system.

The nonparticle uraninite data was measured at APS 10ID and kindly
provided by Shelly Kelly.  The data test follows her fitting model
from [DOI: 10.1021/es0208409](https://doi.org/10.1021/es0208409).


![Ball and stick figure of uraninite](uraninite.gif)


Canada apparently &hearts;s uraninite.
![Canada &#9829; uraninite!](stamp.jpg)


* [CIF file for uraninite](UO2.cif)
* [template for feff input file (generated from CIF file)](UO2.mustache) -- uses the [mustache](http://mustache.github.io/) templating system
* [XDI data file: chi(k)](UO2.chik)
* [Athena project file](UO2.prj) -- Data processed with a pre-release of Demeter 0.9.21 using the larch (0.9.23) backend and XDI 1.0

