# 🐍 🆎 🎶

🐍 ✔️ 🐕‍🦺 📦 "🆎 🔑".

👫 **"🆎 🔑"** 🎁 ❕ 👈 ✔ 📣 <abbr title="for example: str, int, float, bool">🆎</abbr> 🔢.

📣 🆎 👆 🔢, 👨‍🎨 &amp; 🧰 💪 🤝 👆 👍 🐕‍🦺.

👉 **⏩ 🔰 / ↗️** 🔃 🐍 🆎 🔑. ⚫️ 📔 🕴 💯 💪 ⚙️ 👫 ⏮️ **FastAPI**... ❔ 🤙 📶 🐥.

**FastAPI** 🌐 ⚓️ 🔛 👫 🆎 🔑, 👫 🤝 ⚫️ 📚 📈 &amp; 💰.

✋️ 🚥 👆 🙅 ⚙️ **FastAPI**, 👆 🔜 💰 ⚪️➡️ 🏫 🍖 🔃 👫.

!!! note
    🚥 👆 🐍 🕴, &amp; 👆 ⏪ 💭 🌐 🔃 🆎 🔑, 🚶 ⏭ 📃.

## 🎯

➡️ ▶️ ⏮️ 🙅 🖼:

```Python
{!../../../docs_src/python_types/tutorial001.py!}
```

🤙 👉 📋 🔢:

```
John Doe
```

🔢 🔨 📄:

* ✊ `first_name` &amp; `last_name`.
* 🗜 🥇 🔤 🔠 1️⃣ ↖ 💼 ⏮️ `title()`.
* <abbr title="Puts them together, as one. With the contents of one after the other.">🔢</abbr> 👫 ⏮️ 🚀 🖕.

```Python hl_lines="2"
{!../../../docs_src/python_types/tutorial001.py!}
```

### ✍ ⚫️

⚫️ 📶 🙅 📋.

✋️ 🔜 🌈 👈 👆 ✍ ⚫️ ⚪️➡️ 🖌.

☝ 👆 🔜 ✔️ ▶️ 🔑 🔢, 👆 ✔️ 🔢 🔜...

✋️ ⤴️ 👆 ✔️ 🤙 "👈 👩‍🔬 👈 🗜 🥇 🔤 ↖ 💼".

⚫️ `upper`❓ ⚫️ `uppercase`❓ `first_uppercase`❓ `capitalize`❓

⤴️, 👆 🔄 ⏮️ 🗝 👩‍💻 👨‍👧‍👦, 👨‍🎨 ✍.

👆 🆎 🥇 🔢 🔢, `first_name`, ⤴️ ❣ (`.`) &amp; ⤴️ 🎯 `Ctrl+Space` ⏲ 🛠️.

✋️, 😞, 👆 🤚 🕳 ⚠:

<img src="/img/python-types/image01.png">

### 🚮 🆎

➡️ 🔀 👁 ⏸ ⚪️➡️ ⏮️ ⏬.

👥 🔜 🔀 ⚫️❔ 👉 🧬, 🔢 🔢, ⚪️➡️:

```Python
    first_name, last_name
```

:

```Python
    first_name: str, last_name: str
```

👈 ⚫️.

👈 "🆎 🔑":

```Python hl_lines="1"
{!../../../docs_src/python_types/tutorial002.py!}
```

👈 🚫 🎏 📣 🔢 💲 💖 🔜 ⏮️:

```Python
    first_name="john", last_name="doe"
```

⚫️ 🎏 👜.

👥 ⚙️ ❤ (`:`), 🚫 🌓 (`=`).

&amp; ❎ 🆎 🔑 🛎 🚫 🔀 ⚫️❔ 🔨 ⚪️➡️ ⚫️❔ 🔜 🔨 🍵 👫.

✋️ 🔜, 🌈 👆 🔄 🖕 🏗 👈 🔢, ✋️ ⏮️ 🆎 🔑.

🎏 ☝, 👆 🔄 ⏲ 📋 ⏮️ `Ctrl+Space` &amp; 👆 👀:

<img src="/img/python-types/image02.png">

⏮️ 👈, 👆 💪 📜, 👀 🎛, ⏭ 👆 🔎 1️⃣ 👈 "💍 🔔":

<img src="/img/python-types/image03.png">

## 🌅 🎯

✅ 👉 🔢, ⚫️ ⏪ ✔️ 🆎 🔑:

```Python hl_lines="1"
{!../../../docs_src/python_types/tutorial003.py!}
```

↩️ 👨‍🎨 💭 🆎 🔢, 👆 🚫 🕴 🤚 🛠️, 👆 🤚 ❌ ✅:

<img src="/img/python-types/image04.png">

🔜 👆 💭 👈 👆 ✔️ 🔧 ⚫️, 🗜 `age` 🎻 ⏮️ `str(age)`:

```Python hl_lines="2"
{!../../../docs_src/python_types/tutorial004.py!}
```

## 📣 🆎

👆 👀 👑 🥉 📣 🆎 🔑. 🔢 🔢.

👉 👑 🥉 👆 🔜 ⚙️ 👫 ⏮️ **FastAPI**.

### 🙅 🆎

👆 💪 📣 🌐 🐩 🐍 🆎, 🚫 🕴 `str`.

👆 💪 ⚙️, 🖼:

* `int`
* `float`
* `bool`
* `bytes`

```Python hl_lines="1"
{!../../../docs_src/python_types/tutorial005.py!}
```

### 💊 🆎 ⏮️ 🆎 🔢

📤 📊 📊 👈 💪 🔌 🎏 💲, 💖 `dict`, `list`, `set` &amp; `tuple`. &amp; 🔗 💲 💪 ✔️ 👫 👍 🆎 💁‍♂️.

👉 🆎 👈 ✔️ 🔗 🆎 🤙 "**💊**" 🆎. &amp; ⚫️ 💪 📣 👫, ⏮️ 👫 🔗 🆎.

📣 👈 🆎 &amp; 🔗 🆎, 👆 💪 ⚙️ 🐩 🐍 🕹 `typing`. ⚫️ 🔀 🎯 🐕‍🦺 👫 🆎 🔑.

#### 🆕 ⏬ 🐍

❕ ⚙️ `typing` **🔗** ⏮️ 🌐 ⏬, ⚪️➡️ 🐍 3️⃣.6️⃣ ⏪ 🕐, ✅ 🐍 3️⃣.9️⃣, 🐍 3️⃣.1️⃣0️⃣, ♒️.

🐍 🏧, **🆕 ⏬** 👟 ⏮️ 📉 🐕‍🦺 👉 🆎 ✍ &amp; 📚 💼 👆 🏆 🚫 💪 🗄 &amp; ⚙️ `typing` 🕹 📣 🆎 ✍.

🚥 👆 💪 ⚒ 🌖 ⏮️ ⏬ 🐍 👆 🏗, 👆 🔜 💪 ✊ 📈 👈 ➕ 🦁. 👀 🖼 🔛.

#### 📇

🖼, ➡️ 🔬 🔢 `list` `str`.

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ⚪️➡️ `typing`, 🗄 `List` (⏮️ 🔠 `L`):

    ``` Python hl_lines="1"
    {!> ../../../docs_src/python_types/tutorial006.py!}
    ```

    📣 🔢, ⏮️ 🎏 ❤ (`:`) ❕.

    🆎, 🚮 `List` 👈 👆 🗄 ⚪️➡️ `typing`.

    📇 🆎 👈 🔌 🔗 🆎, 👆 🚮 👫 ⬜ 🗜:

    ```Python hl_lines="4"
    {!> ../../../docs_src/python_types/tutorial006.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    📣 🔢, ⏮️ 🎏 ❤ (`:`) ❕.

    🆎, 🚮 `list`.

    📇 🆎 👈 🔌 🔗 🆎, 👆 🚮 👫 ⬜ 🗜:

    ```Python hl_lines="1"
    {!> ../../../docs_src/python_types/tutorial006_py39.py!}
    ```

!!! info
    👈 🔗 🆎 ⬜ 🗜 🤙 "🆎 🔢".

    👉 💼, `str` 🆎 🔢 🚶‍♀️ `List` (⚖️ `list` 🐍 3️⃣.9️⃣ &amp; 🔛).

👈 ⛓: "🔢 `items` `list`, &amp; 🔠 🏬 👉 📇 `str`".

!!! tip
    🚥 👆 ⚙️ 🐍 3️⃣.9️⃣ ⚖️ 🔛, 👆 🚫 ✔️ 🗄 `List` ⚪️➡️ `typing`, 👆 💪 ⚙️ 🎏 🥔 `list` 🆎 ↩️.

🔨 👈, 👆 👨‍🎨 💪 🚚 🐕‍🦺 ⏪ 🏭 🏬 ⚪️➡️ 📇:

<img src="/img/python-types/image05.png">

🍵 🆎, 👈 🌖 💪 🏆.

👀 👈 🔢 `item` 1️⃣ 🔣 📇 `items`.

&amp; , 👨‍🎨 💭 ⚫️ `str`, &amp; 🚚 🐕‍🦺 👈.

#### 🔢 &amp; ⚒

👆 🔜 🎏 📣 `tuple`Ⓜ &amp; `set`Ⓜ:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="1  4"
    {!> ../../../docs_src/python_types/tutorial007.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="1"
    {!> ../../../docs_src/python_types/tutorial007_py39.py!}
    ```

👉 ⛓:

* 🔢 `items_t` `tuple` ⏮️ 3️⃣ 🏬, `int`, ➕1️⃣ `int`, &amp; `str`.
* 🔢 `items_s` `set`, &amp; 🔠 🚮 🏬 🆎 `bytes`.

####  #️⃣

🔬 `dict`, 👆 🚶‍♀️ 2️⃣ 🆎 🔢, 🎏 ❕.

🥇 🆎 🔢 🔑 `dict`.

🥈 🆎 🔢 💲 `dict`:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="1  4"
    {!> ../../../docs_src/python_types/tutorial008.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="1"
    {!> ../../../docs_src/python_types/tutorial008_py39.py!}
    ```

👉 ⛓:

* 🔢 `prices` `dict`:
    * 🔑 👉 `dict` 🆎 `str` (➡️ 💬, 📛 🔠 🏬).
    * 💲 👉 `dict` 🆎 `float` (➡️ 💬, 🔖 🔠 🏬).

#### 🇪🇺

👆 💪 📣 👈 🔢 💪 🙆 **📚 🆎**, 🖼, `int` ⚖️ `str`.

🐍 3️⃣.6️⃣ &amp; 🔛 (✅ 🐍 3️⃣.1️⃣0️⃣) 👆 💪 ⚙️ `Union` 🆎 ⚪️➡️ `typing` &amp; 🚮 🔘 ⬜ 🗜 💪 🆎 🚫.

🐍 3️⃣.1️⃣0️⃣ 📤 **🎛 ❕** 🌐❔ 👆 💪 🚮 💪 🆎 👽 <abbr title='also called "bitwise or operator", but that meaning is not relevant here'>⏸ ⏸ (`|`)</abbr>.

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="1  4"
    {!> ../../../docs_src/python_types/tutorial008b.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="1"
    {!> ../../../docs_src/python_types/tutorial008b_py310.py!}
    ```

👯‍♂️ 💼 👉 ⛓ 👈 `item` 💪 `int` ⚖️ `str`.

#### 🎲 `None`

👆 💪 📣 👈 💲 💪 ✔️ 🆎, 💖 `str`, ✋️ 👈 ⚫️ 💪 `None`.

🐍 3️⃣.6️⃣ &amp; 🔛 (✅ 🐍 3️⃣.1️⃣0️⃣) 👆 💪 📣 ⚫️ 🏭 &amp; ⚙️ `Optional` ⚪️➡️ `typing` 🕹.

```Python hl_lines="1  4"
{!../../../docs_src/python_types/tutorial009.py!}
```

⚙️ `Optional[str]` ↩️ `str` 🔜 ➡️ 👨‍🎨 ℹ 👆 🔍 ❌ 🌐❔ 👆 💪 🤔 👈 💲 🕧 `str`, 🕐❔ ⚫️ 💪 🤙 `None` 💁‍♂️.

`Optional[Something]` 🤙 ⌨ `Union[Something, None]`, 👫 🌓.

👉 ⛓ 👈 🐍 3️⃣.1️⃣0️⃣, 👆 💪 ⚙️ `Something | None`:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="1  4"
    {!> ../../../docs_src/python_types/tutorial009.py!}
    ```

=== "🐍 3️⃣.6️⃣ &amp; 🔛 - 🎛"

    ```Python hl_lines="1  4"
    {!> ../../../docs_src/python_types/tutorial009b.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="1"
    {!> ../../../docs_src/python_types/tutorial009_py310.py!}
    ```

#### ⚙️ `Union` ⚖️ `Optional`

🚥 👆 ⚙️ 🐍 ⏬ 🔛 3️⃣.1️⃣0️⃣, 📥 💁‍♂ ⚪️➡️ 👇 📶 **🤔** ☝ 🎑:

* 👶 ❎ ⚙️ `Optional[SomeType]`
* ↩️ 👶 **⚙️ `Union[SomeType, None]`** 👶.

👯‍♂️ 🌓 &amp; 🔘 👫 🎏, ✋️ 👤 🔜 👍 `Union` ↩️ `Optional` ↩️ 🔤 "**📦**" 🔜 😑 🔑 👈 💲 📦, &amp; ⚫️ 🤙 ⛓ "⚫️ 💪 `None`", 🚥 ⚫️ 🚫 📦 &amp; ✔.

👤 💭 `Union[SomeType, None]` 🌖 🔑 🔃 ⚫️❔ ⚫️ ⛓.

⚫️ 🔃 🔤 &amp; 📛. ✋️ 👈 🔤 💪 📉 ❔ 👆 &amp; 👆 🤽‍♂ 💭 🔃 📟.

🖼, ➡️ ✊ 👉 🔢:

```Python hl_lines="1  4"
{!../../../docs_src/python_types/tutorial009c.py!}
```

🔢 `name` 🔬 `Optional[str]`, ✋️ ⚫️ **🚫 📦**, 👆 🚫🔜 🤙 🔢 🍵 🔢:

```Python
say_hi()  # Oh, no, this throws an error! 😱
```

`name` 🔢 **✔** (🚫 *📦*) ↩️ ⚫️ 🚫 ✔️ 🔢 💲. , `name` 🚫 `None` 💲:

```Python
say_hi(name=None)  # This works, None is valid 🎉
```

👍 📰, 🕐 👆 🔛 🐍 3️⃣.1️⃣0️⃣ 👆 🏆 🚫 ✔️ 😟 🔃 👈, 👆 🔜 💪 🎯 ⚙️ `|` 🔬 🇪🇺 🆎:

```Python hl_lines="1  4"
{!../../../docs_src/python_types/tutorial009c_py310.py!}
```

&amp; ⤴️ 👆 🏆 🚫 ✔️ 😟 🔃 📛 💖 `Optional` &amp; `Union`. 👶

#### 💊 🆎

👉 🆎 👈 ✊ 🆎 🔢 ⬜ 🗜 🤙 **💊 🆎** ⚖️ **💊**, 🖼:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    * `List`
    * `Tuple`
    * `Set`
    * `Dict`
    * `Union`
    * `Optional`
    * ...&amp; 🎏.

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    👆 💪 ⚙️ 🎏 💽 🆎 💊 (⏮️ ⬜ 🗜 &amp; 🆎 🔘):

    * `list`
    * `tuple`
    * `set`
    * `dict`

     &amp; 🎏 ⏮️ 🐍 3️⃣.6️⃣, ⚪️➡️ `typing` 🕹:

    * `Union`
    * `Optional`
    * ...&amp; 🎏.

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    👆 💪 ⚙️ 🎏 💽 🆎 💊 (⏮️ ⬜ 🗜 &amp; 🆎 🔘):

    * `list`
    * `tuple`
    * `set`
    * `dict`

     &amp; 🎏 ⏮️ 🐍 3️⃣.6️⃣, ⚪️➡️ `typing` 🕹:

    * `Union`
    * `Optional` (🎏 ⏮️ 🐍 3️⃣.6️⃣)
    * ...&amp; 🎏.

    🐍 3️⃣.1️⃣0️⃣, 🎛 ⚙️ 💊 `Union` &amp; `Optional`, 👆 💪 ⚙️ <abbr title='also called "bitwise or operator", but that meaning is not relevant here'>⏸ ⏸ (`|`)</abbr> 📣 🇪🇺 🆎.

### 🎓 🆎

👆 💪 📣 🎓 🆎 🔢.

➡️ 💬 👆 ✔️ 🎓 `Person`, ⏮️ 📛:

```Python hl_lines="1-3"
{!../../../docs_src/python_types/tutorial010.py!}
```

⤴️ 👆 💪 📣 🔢 🆎 `Person`:

```Python hl_lines="6"
{!../../../docs_src/python_types/tutorial010.py!}
```

&amp; ⤴️, 🔄, 👆 🤚 🌐 👨‍🎨 🐕‍🦺:

<img src="/img/python-types/image06.png">

## Pydantic 🏷

<a href="https://pydantic-docs.helpmanual.io/" class="external-link" target="_blank">Pydantic</a> 🐍 🗃 🎭 📊 🔬.

👆 📣 "💠" 💽 🎓 ⏮️ 🔢.

&amp; 🔠 🔢 ✔️ 🆎.

⤴️ 👆 ✍ 👐 👈 🎓 ⏮️ 💲 &amp; ⚫️ 🔜 ✔ 💲, 🗜 👫 ☑ 🆎 (🚥 👈 💼) &amp; 🤝 👆 🎚 ⏮️ 🌐 💽.

&amp; 👆 🤚 🌐 👨‍🎨 🐕‍🦺 ⏮️ 👈 📉 🎚.

🖼 ⚪️➡️ 🛂 Pydantic 🩺:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python
    {!> ../../../docs_src/python_types/tutorial011.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python
    {!> ../../../docs_src/python_types/tutorial011_py39.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python
    {!> ../../../docs_src/python_types/tutorial011_py310.py!}
    ```

!!! info
    💡 🌖 🔃 <a href="https://pydantic-docs.helpmanual.io/" class="external-link" target="_blank">Pydantic, ✅ 🚮 🩺</a>.

**FastAPI** 🌐 ⚓️ 🔛 Pydantic.

👆 🔜 👀 📚 🌅 🌐 👉 💡 [🔰 - 👩‍💻 🦮](tutorial/index.md){.internal-link target=_blank}.

!!! tip
    Pydantic ✔️ 🎁 🎭 🕐❔ 👆 ⚙️ `Optional` ⚖️ `Union[Something, None]` 🍵 🔢 💲, 👆 💪 ✍ 🌅 🔃 ⚫️ Pydantic 🩺 🔃 <a href="https://pydantic-docs.helpmanual.io/usage/models/#required-optional-fields" class="external-link" target="_blank">✔ 📦 🏑</a>.

## 🆎 🔑 **FastAPI**

**FastAPI** ✊ 📈 👫 🆎 🔑 📚 👜.

⏮️ **FastAPI** 👆 📣 🔢 ⏮️ 🆎 🔑 &amp; 👆 🤚:

* **👨‍🎨 🐕‍🦺**.
* **🆎 ✅**.

...and **FastAPI** uses the same declarations :

* **🔬 📄**: ⚪️➡️ 📨 ➡ 🔢, 🔢 🔢, 🎚, 💪, 🔗, ♒️.
* **🗜 💽**: ⚪️➡️ 📨 🚚 🆎.
* **✔ 💽**: 👟 ⚪️➡️ 🔠 📨:
    * 🏭 **🏧 ❌** 📨 👩‍💻 🕐❔ 📊 ❌.
* **📄** 🛠️ ⚙️ 🗄:
    * ❔ ⤴️ ⚙️ 🏧 🎓 🧾 👩‍💻 🔢.

👉 5️⃣📆 🌐 🔊 📝. 🚫 😟. 👆 🔜 👀 🌐 👉 🎯 [🔰 - 👩‍💻 🦮](tutorial/index.md){.internal-link target=_blank}.

⚠ 👜 👈 ⚙️ 🐩 🐍 🆎, 👁 🥉 (↩️ ❎ 🌖 🎓, 👨‍🎨, ♒️), **FastAPI** 🔜 📚 👷 👆.

!!! info
    🚥 👆 ⏪ 🚶 🔘 🌐 🔰 &amp; 👟 🔙 👀 🌅 🔃 🆎, 👍 ℹ <a href="https://mypy.readthedocs.io/en/latest/cheat_sheet_py3.html" class="external-link" target="_blank"> "🎮 🎼" ⚪️➡️ `mypy`</a>.
