package bdvm.vm;

import java.io.File;

/**
 * This Interface exposes the public methods which can be used by external entities to interact with the BDVM.
 * 
 * The BDVM is NOT thread safe, external synchronization is needed if multiple thread access the same BDVM.
 * 
 * @author KenD00
 */
public interface BDVMInterface {
   
   /**
    * Returns a String describing the version of the BDVM.
    * 
    * @return The version of the BDVM
    */
   public String getVersionString();
   
   /**
    * Initializes the VM to be ready to run.
    * 
    * The VM needs to know the mountpath of the BD+ protected disc to load the Content Code and execute it.
    * It is highly recommended to supply the Volume ID of the disc too because the Content Code may use it too. 
    * 
    * @param mountpath The mountpath of the disc, needs to be the root directory of the disc
    * @param vid The Volume ID of the disc, may be null
    * @throws BDVMException An error occurred
    */
   public void initVM(File mountpath, byte[] vid) throws BDVMException;
   
   /**
    * Starts the VM.
    * 
    * It runs until the content code finished. To restart the VM it has to be initialized again first!
    * 
    * TODO: Maybe throw BDVMException on error?
    */
   public void run();
   
   /**
    * Returns the generated raw conversion table, as specified by the BDVM documentation.
    * 
    * If the VM failed to properly execute the Content Code null is returned. If this method is called before
    * the VM was run the result is unspecified.
    * 
    * @return The raw conversion table, null if it could not be created
    */
   public byte[] getRAWConversionTable();

}
