/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2011-09-01
 * Description : a plugin to create photo layouts by fusion of several images.
 * Acknowledge : based on the expoblending plugin
 *
 * Copyright (C) 2011 by Łukasz Spas <lukasz dot spas at gmail dot com>
 * Copyright (C) 2009-2015 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// This file is generated by kconfig_compiler from photoframeseditor.kcfg.
// All changes you do to this file will be lost.

#include "PLEConfigSkeleton.h"

#include <kglobal.h>
#include <QtCore/QFile>

namespace PhotoLayoutsEditor
{

class PLEConfigSkeletonHelper
{
  public:
    PLEConfigSkeletonHelper() : q(0) {}
    ~PLEConfigSkeletonHelper() { delete q; }
    PLEConfigSkeleton *q;
};
}

Q_GLOBAL_STATIC(PLEConfigSkeletonHelper, s_globalPLEConfigSkeleton)
PLEConfigSkeleton *PLEConfigSkeleton::self()
{
  if (!s_globalPLEConfigSkeleton->q) {
    new PLEConfigSkeleton;
    s_globalPLEConfigSkeleton->q->readConfig();
  }

  return s_globalPLEConfigSkeleton->q;
}

PLEConfigSkeleton::PLEConfigSkeleton(  )
  : KConfigSkeleton( QLatin1String( "kipipferc" ) )
{
  Q_ASSERT(!s_globalPLEConfigSkeleton->q);
  s_globalPLEConfigSkeleton->q = this;
  setCurrentGroup( QLatin1String( "Saving" ) );

  KConfigSkeleton::ItemBool  *itemEmbedImages;
  itemEmbedImages = new KConfigSkeleton::ItemBool( currentGroup(), QLatin1String( "EmbedImages" ), mEmbedImages, PFEConfig::embedImagesData() );
  addItem( itemEmbedImages, QLatin1String( "EmbedImages" ) );

  setCurrentGroup( QLatin1String( "View" ) );

  KConfigSkeleton::ItemDouble  *itemHorizontalGrid;
  itemHorizontalGrid = new KConfigSkeleton::ItemDouble( currentGroup(), QLatin1String( "HorizontalGrid" ), mHorizontalGrid, PFEConfig::gridX() );
  addItem( itemHorizontalGrid, QLatin1String( "HorizontalGrid" ) );
  KConfigSkeleton::ItemDouble  *itemVerticalGrid;
  itemVerticalGrid = new KConfigSkeleton::ItemDouble( currentGroup(), QLatin1String( "VerticalGrid" ), mVerticalGrid, PFEConfig::gridY() );
  addItem( itemVerticalGrid, QLatin1String( "VerticalGrid" ) );
}

PLEConfigSkeleton::~PLEConfigSkeleton()
{
  if (!s_globalPLEConfigSkeleton.isDestroyed()) {
    s_globalPLEConfigSkeleton->q = 0;
  }
}

} // namespace PhotoLayoutsEditor
