#ifndef REMOVEFROMLAYERWALKER_H_
#define REMOVEFROMLAYERWALKER_H_

#include "ilayer.h"

namespace scene {

class RemoveFromLayerWalker :
    public selection::SelectionSystem::Visitor,
	public NodeVisitor
{
	int _layer;

public:
	/**
	 * Pass the ID of the layer the items should be removed from.
	 */
	RemoveFromLayerWalker(int layer) :
		_layer(layer)
	{}

	// SelectionSystem::Visitor
	void visit(const INodePtr& node) const {
		// Remove the node from this layer
		node->removeFromLayer(_layer);

		if (Node_isEntity(node)) {
			// We have an entity, traverse all children too
			node->traverseChildren(const_cast<RemoveFromLayerWalker&>(*this));
		}
	}

	// scene::NodeVisitor
	bool pre(const INodePtr& node) {
		node->removeFromLayer(_layer);
		return true;
	}
};

} // namespace scene

#endif /* REMOVEFROMLAYERWALKER_H_ */
