/**************************************************************************\
 * Copyright (c) Kongsberg Oil & Gas Technologies AS
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\**************************************************************************/

#ifndef COIN_INTERNAL
#error this is a private header file
#endif /* !COIN_INTERNAL */

#ifndef SO_TRANSFORMERDRAGGER_IV_H
#define SO_TRANSFORMERDRAGGER_IV_H

static const char TRANSFORMERDRAGGER_draggergeometry[] =
  "#Inventor V2.1 ascii\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMER_INACTIVE_MATERIAL Material { diffuseColor 0.5 0.5 0.5  emissiveColor 0.5 0.5 0.5 }\n"
  "DEF TRANSFORMER_ACTIVE_MATERIAL Material { diffuseColor 0.5 0.5 0  emissiveColor 0.5 0.5 0 }\n"
  "DEF TRANSFORMER_FEEDBACK_MATERIAL Material { diffuseColor 0.5 0 0.5  emissiveColor 0.5 0 0.5 }\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMER_FEEDBACK_TRANSPARENT_MATERIAL Material { diffuseColor 0.5 0 0.5  emissiveColor 0.5 0 0.5  transparency 0.5 }\n"
  "DEF TRANSFORMER_GREEN_MATERIAL Material { diffuseColor 0.0 0.5 0  emissiveColor 0.0 0.5 0 }\n"
  "\n"
  "DEF transformerOverallStyle Group { USE TRANSFORMER_INACTIVE_MATERIAL }\n"
  "DEF transformerLocateMaterial Material { diffuseColor 0.8 0.3 0  emissiveColor 0.8 0.3 0 }\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMER_SIDE_COORDS Group {\n"
  "   Coordinate3 {\n"
  "      point [\n"
  "       -1.001 -1.001 1.001, 1.001 -1.001 1.001, 1.001 1.001 1.001, -1.001 1.001 1.001,     # front face, ccw, from bottom left\n"
  "       -1.001 -1.001 -1.001, 1.001 -1.001 -1.001, 1.001 1.001 -1.001, -1.001 1.001 -1.001  # back face, cw, from bottom left\n"
  "      ]\n"
  "   }\n"
  "}\n"
  "\n"
  "DEF TRANSFORMER_SIDE_DATA Group {\n"
  "   USE TRANSFORMER_SIDE_COORDS\n"
  "\n"
  "\n"
  "   DrawStyle { style LINES }\n"
  "\n"
  "   ShapeHints { vertexOrdering UNKNOWN_ORDERING }\n"
  "}\n"
  "\n"
  "DEF TRANSFORMER_TRANSLATOR_ACTIVE Group {\n"
  "   USE TRANSFORMER_ACTIVE_MATERIAL\n"
  "   DrawStyle { style LINES  lineWidth 3.0 }\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerTranslator1 Separator {\n"
  "   USE TRANSFORMER_SIDE_DATA\n"
  "   IndexedFaceSet { coordIndex [ 3, 2, 6, 7, -1 ] }\n"
  "}\n"
  "DEF transformerTranslator1Active Separator {\n"
  "   USE TRANSFORMER_TRANSLATOR_ACTIVE\n"
  "   USE transformerTranslator1\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerTranslator2 Separator {\n"
  "   USE TRANSFORMER_SIDE_DATA\n"
  "   IndexedFaceSet { coordIndex [ 4, 5, 1, 0, -1 ] }\n"
  "}\n"
  "DEF transformerTranslator2Active Separator {\n"
  "   USE TRANSFORMER_TRANSLATOR_ACTIVE\n"
  "   USE transformerTranslator2\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerTranslator3 Separator {\n"
  "   USE TRANSFORMER_SIDE_DATA\n"
  "   IndexedFaceSet { coordIndex [ 4, 0, 3, 7, -1 ] }\n"
  "}\n"
  "DEF transformerTranslator3Active Separator {\n"
  "   USE TRANSFORMER_TRANSLATOR_ACTIVE\n"
  "   USE transformerTranslator3\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerTranslator4 Separator {\n"
  "   USE TRANSFORMER_SIDE_DATA\n"
  "   IndexedFaceSet { coordIndex [ 1, 5, 6, 2, -1] }\n"
  "}\n"
  "DEF transformerTranslator4Active Separator {\n"
  "   USE TRANSFORMER_TRANSLATOR_ACTIVE\n"
  "   USE transformerTranslator4\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerTranslator5 Separator {\n"
  "   USE TRANSFORMER_SIDE_DATA\n"
  "   IndexedFaceSet { coordIndex [ 0, 1, 2, 3, -1 ] }\n"
  "}\n"
  "DEF transformerTranslator5Active Separator {\n"
  "   USE TRANSFORMER_TRANSLATOR_ACTIVE\n"
  "   USE transformerTranslator5\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerTranslator6 Separator {\n"
  "   USE TRANSFORMER_SIDE_DATA\n"
  "   IndexedFaceSet { coordIndex [ 4, 7, 6, 5, -1 ] }\n"
  "}\n"
  "DEF transformerTranslator6Active Separator {\n"
  "   USE TRANSFORMER_TRANSLATOR_ACTIVE\n"
  "   USE transformerTranslator6\n"
  "}\n"
  "\n"
  "\n"
  "\n"
  "DEF transformerTranslateBoxFeedback Separator {\n"
  "   USE TRANSFORMER_FEEDBACK_MATERIAL\n"
  "   DrawStyle { style LINES }\n"
  "   Cube { }\n"
  "   USE TRANSFORMER_TRANSLATOR_ACTIVE\n"
  "   Coordinate3 { point [ -1.001 1.001 1.001, 1.001 1.001 1.001, 1.001 1.001 -1.001, -1.001 1.001 -1.001 ] }\n"
  "   IndexedLineSet { coordIndex [ 0, 1, 2, 3, 0, -1 ] }\n"
  "}\n"
  "\n"
  "DEF TRANSFORMER_SINGLE_AXIS Group {\n"
  "   USE TRANSFORMER_ACTIVE_MATERIAL\n"
  "\n"
  "   Coordinate3 { point [ 0 0.5 0, 0 -0.5 0 ] }\n"
  "   IndexedLineSet { coordIndex [ 0, 1, -1 ] }\n"
  "\n"
  "   Translation { translation 0 0.5 0 }\n"
  "   DEF TRANSFORMER_AXIS_MARKER Cone { height 0.05  bottomRadius 0.05 }\n"
  "\n"
  "   Translation { translation 0 -1 0 }\n"
  "   Rotation { rotation 0 0 1  3.14 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_AXIS_MARKER\n"
  "}\n"
  "\n"
  "DEF transformerXAxisFeedbackActive Separator {\n"
  "   Rotation { rotation 0 0 1  1.57 }\n"
  "   USE TRANSFORMER_SINGLE_AXIS\n"
  "}\n"
  "DEF transformerYAxisFeedbackActive Separator {\n"
  "   USE TRANSFORMER_SINGLE_AXIS\n"
  "}\n"
  "DEF transformerZAxisFeedbackActive Separator {\n"
  "   Rotation { rotation 1 0 0  1.57 }\n"
  "   USE TRANSFORMER_SINGLE_AXIS\n"
  "}\n"
  "\n"
  "DEF transformerXAxisFeedbackSelect Separator {\n"
  "   USE transformerXAxisFeedbackActive\n"
  "}\n"
  "DEF transformerYAxisFeedbackSelect Separator {\n"
  "   USE transformerYAxisFeedbackActive\n"
  "}\n"
  "DEF transformerZAxisFeedbackSelect Separator {\n"
  "   USE transformerZAxisFeedbackActive\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerXCrosshairFeedback Separator { }\n"
  "DEF transformerYCrosshairFeedback Separator { }\n"
  "DEF transformerZCrosshairFeedback Separator { }\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMER_ROTATOR_ACTIVE Group {\n"
  "   USE TRANSFORMER_ACTIVE_MATERIAL\n"
  "   DrawStyle { lineWidth 3.0 }\n"
  "}\n"
  "\n"
  "DEF TRANSFORMER_ROTATOR_COORDS Coordinate3 {\n"
  "   point [ 0 0 0, 1.5 0 0, -1.5 0 0, 0 1.5 0, 0 -1.5 0, 0 0 1.5, 0 0 -1.5 ]\n"
  "}\n"
  "DEF TRANSFORMER_ROTATOR_MARKER Sphere { radius 0.05 }\n"
  "\n"
  "DEF TRANSFORMER_ROTATOR_PART1 Group {\n"
  "   USE TRANSFORMER_ROTATOR_COORDS\n"
  "   IndexedLineSet { coordIndex [ 0, 3, -1 ] }\n"
  "   Translation { translation 0 1.5 0 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_ROTATOR_MARKER\n"
  "}\n"
  "DEF TRANSFORMER_ROTATOR_PART2 Group {\n"
  "   USE TRANSFORMER_ROTATOR_COORDS\n"
  "   IndexedLineSet { coordIndex [ 0, 4, -1 ] }\n"
  "   Translation { translation 0 -1.5 0 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_ROTATOR_MARKER\n"
  "}\n"
  "DEF TRANSFORMER_ROTATOR_PART3 Group {\n"
  "   USE TRANSFORMER_ROTATOR_COORDS\n"
  "   IndexedLineSet { coordIndex [ 0, 2, -1 ] }\n"
  "   Translation { translation -1.5 0 0 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_ROTATOR_MARKER\n"
  "}\n"
  "DEF TRANSFORMER_ROTATOR_PART4 Group {\n"
  "   USE TRANSFORMER_ROTATOR_COORDS\n"
  "   IndexedLineSet { coordIndex [ 0, 1, -1 ] }\n"
  "   Translation { translation 1.5 0 0 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_ROTATOR_MARKER\n"
  "}\n"
  "DEF TRANSFORMER_ROTATOR_PART5 Group {\n"
  "   USE TRANSFORMER_ROTATOR_COORDS\n"
  "   IndexedLineSet { coordIndex [ 0, 5, -1 ] }\n"
  "   Translation { translation 0 0 1.5 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_ROTATOR_MARKER\n"
  "}\n"
  "DEF TRANSFORMER_ROTATOR_PART6 Group {\n"
  "   USE TRANSFORMER_ROTATOR_COORDS\n"
  "   IndexedLineSet { coordIndex [ 0, 6, -1 ] }\n"
  "   Translation { translation 0 0 -1.5 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_ROTATOR_MARKER\n"
  "}\n"
  "\n"
  "DEF transformerRotator1 Separator {\n"
  "   USE TRANSFORMER_GREEN_MATERIAL\n"
  "   USE TRANSFORMER_ROTATOR_PART1\n"
  "}\n"
  "DEF transformerRotator1Active Separator {\n"
  "   USE TRANSFORMER_ROTATOR_ACTIVE\n"
  "   USE TRANSFORMER_ROTATOR_PART1\n"
  "}\n"
  "DEF transformerRotator2 Separator {\n"
  "   USE TRANSFORMER_GREEN_MATERIAL\n"
  "   USE TRANSFORMER_ROTATOR_PART2\n"
  "}\n"
  "DEF transformerRotator2Active Separator {\n"
  "   USE TRANSFORMER_ROTATOR_ACTIVE\n"
  "   USE TRANSFORMER_ROTATOR_PART2\n"
  "}\n"
  "DEF transformerRotator3 Separator {\n"
  "   USE TRANSFORMER_GREEN_MATERIAL\n"
  "   USE TRANSFORMER_ROTATOR_PART3\n"
  "}\n"
  "DEF transformerRotator3Active Separator {\n"
  "   USE TRANSFORMER_ROTATOR_ACTIVE\n"
  "   USE TRANSFORMER_ROTATOR_PART3\n"
  "}\n"
  "DEF transformerRotator4 Separator {\n"
  "   USE TRANSFORMER_GREEN_MATERIAL\n"
  "   USE TRANSFORMER_ROTATOR_PART4\n"
  "}\n"
  "DEF transformerRotator4Active Separator {\n"
  "   USE TRANSFORMER_ROTATOR_ACTIVE\n"
  "   USE TRANSFORMER_ROTATOR_PART4\n"
  "}\n"
  "DEF transformerRotator5 Separator {\n"
  "   USE TRANSFORMER_GREEN_MATERIAL\n"
  "   USE TRANSFORMER_ROTATOR_PART5\n"
  "}\n"
  "DEF transformerRotator5Active Separator {\n"
  "   USE TRANSFORMER_ROTATOR_ACTIVE\n"
  "   USE TRANSFORMER_ROTATOR_PART5\n"
  "}\n"
  "DEF transformerRotator6 Separator {\n"
  "   USE TRANSFORMER_GREEN_MATERIAL\n"
  "   USE TRANSFORMER_ROTATOR_PART6\n"
  "}\n"
  "DEF transformerRotator6Active Separator {\n"
  "   USE TRANSFORMER_ROTATOR_ACTIVE\n"
  "   USE TRANSFORMER_ROTATOR_PART6\n"
  "}\n"
  "\n"
  "\n"
  "\n"
  "DEF transformerYCircleFeedback Separator {\n"
  "   USE TRANSFORMER_FEEDBACK_MATERIAL\n"
  "   ShapeHints { vertexOrdering UNKNOWN_ORDERING }\n"
  "   Cylinder { height 0.03  parts SIDES }\n"
  "}\n"
  "\n"
  "DEF transformerXCircleFeedback Separator {\n"
  "   Rotation { rotation 0 0 1  1.57 }\n"
  "   USE transformerYCircleFeedback\n"
  "}\n"
  "\n"
  "DEF transformerZCircleFeedback Separator {\n"
  "   Rotation { rotation 1 0 0  1.57 }\n"
  "   USE transformerYCircleFeedback\n"
  "}\n"
  "\n"
  "DEF TRANSFORMER_ROUNDWALL_MARKER Group {\n"
  "   USE TRANSFORMER_FEEDBACK_MATERIAL\n"
  "   Coordinate3 { point [ 1.001 0 0, -1.001 0 0, 0 1.001 0, 0 -1.001 0, 0 0 1.001, 0 0 -1.001 ] }\n"
  "   IndexedLineSet { coordIndex [ 0, 1, -1, 2, 3, -1, 4, 5, -1 ] }\n"
  "}\n"
  "\n"
  "DEF transformerPosXRoundWallFeedback Separator {\n"
  "   Transform { rotation 0 0 1 1.57  translation 1 0 0 }\n"
  "   USE TRANSFORMER_ROUNDWALL_MARKER\n"
  "}\n"
  "DEF transformerNegXRoundWallFeedback Separator {\n"
  "   Transform { rotation 0 0 1 1.57  translation -1 0 0 }\n"
  "   USE TRANSFORMER_ROUNDWALL_MARKER\n"
  "}\n"
  "DEF transformerPosYRoundWallFeedback Separator {\n"
  "   Transform { translation 0 1 0 }\n"
  "   USE TRANSFORMER_ROUNDWALL_MARKER\n"
  "}\n"
  "DEF transformerNegYRoundWallFeedback Separator {\n"
  "   Transform { translation 0 -1 0 }\n"
  "   USE TRANSFORMER_ROUNDWALL_MARKER\n"
  "}\n"
  "DEF transformerPosZRoundWallFeedback Separator {\n"
  "   Transform { rotation 1 0 0 1.57  translation 0 0 1 }\n"
  "   USE TRANSFORMER_ROUNDWALL_MARKER\n"
  "}\n"
  "DEF transformerNegZRoundWallFeedback Separator {\n"
  "   Transform { rotation 1 0 0 1.57  translation 0 0 -1 }\n"
  "   USE TRANSFORMER_ROUNDWALL_MARKER\n"
  "}\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMER_SCALE_ACTIVE Group {\n"
  "   DrawStyle { lineWidth 3.0 }\n"
  "   USE TRANSFORMER_ACTIVE_MATERIAL\n"
  "}\n"
  "\n"
  "DEF TRANSFORMER_SCALE_MARKER Cube { width 0.1  height 0.1  depth 0.1 }\n"
  "\n"
  "DEF transformerScale1 Separator {\n"
  "   Translation { translation 1 1 1 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_SCALE_MARKER\n"
  "}\n"
  "DEF transformerScale1Active Separator {\n"
  "   USE TRANSFORMER_SCALE_ACTIVE\n"
  "   USE transformerScale1\n"
  "}\n"
  "\n"
  "DEF transformerScale2 Separator {\n"
  "   Translation { translation 1 1 -1 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_SCALE_MARKER\n"
  "}\n"
  "DEF transformerScale2Active Separator {\n"
  "   USE TRANSFORMER_SCALE_ACTIVE\n"
  "   USE transformerScale2\n"
  "}\n"
  "\n"
  "DEF transformerScale3 Separator {\n"
  "   Translation { translation 1 -1 1 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_SCALE_MARKER\n"
  "}\n"
  "DEF transformerScale3Active Separator {\n"
  "   USE TRANSFORMER_SCALE_ACTIVE\n"
  "   USE transformerScale3\n"
  "}\n"
  "\n"
  "DEF transformerScale4 Separator {\n"
  "   Translation { translation 1 -1 -1 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_SCALE_MARKER\n"
  "}\n"
  "DEF transformerScale4Active Separator {\n"
  "   USE TRANSFORMER_SCALE_ACTIVE\n"
  "   USE transformerScale4\n"
  "}\n"
  "\n"
  "DEF transformerScale5 Separator {\n"
  "   Translation { translation -1 1 1 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_SCALE_MARKER\n"
  "}\n"
  "DEF transformerScale5Active Separator {\n"
  "   USE TRANSFORMER_SCALE_ACTIVE\n"
  "   USE transformerScale5\n"
  "}\n"
  "\n"
  "DEF transformerScale6 Separator {\n"
  "   Translation { translation -1 1 -1 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_SCALE_MARKER\n"
  "}\n"
  "DEF transformerScale6Active Separator {\n"
  "   USE TRANSFORMER_SCALE_ACTIVE\n"
  "   USE transformerScale6\n"
  "}\n"
  "\n"
  "DEF transformerScale7 Separator {\n"
  "   Translation { translation -1 -1 1 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_SCALE_MARKER\n"
  "}\n"
  "DEF transformerScale7Active Separator {\n"
  "   USE TRANSFORMER_SCALE_ACTIVE\n"
  "   USE transformerScale7\n"
  "}\n"
  "\n"
  "DEF transformerScale8 Separator {\n"
  "   Translation { translation -1 -1 -1 }\n"
  "   AntiSquish { recalcAlways FALSE }\n"
  "   USE TRANSFORMER_SCALE_MARKER\n"
  "}\n"
  "DEF transformerScale8Active Separator {\n"
  "   USE TRANSFORMER_SCALE_ACTIVE\n"
  "   USE transformerScale8\n"
  "}\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMER_SCALE_DIAGONAL Group {\n"
  "   Coordinate3 { point [ -1.001 1.001 1.001, 1.001 -1.001 -1.001 ] }\n"
  "   IndexedLineSet { coordIndex [ 0, 1, -1 ] }\n"
  "}\n"
  "\n"
  "DEF transformerRadialFeedback Separator {\n"
  "   USE TRANSFORMER_FEEDBACK_MATERIAL\n"
  "\n"
  "   USE TRANSFORMER_SCALE_DIAGONAL\n"
  "   Rotation { rotation 0 1 0  1.57 }\n"
  "   USE TRANSFORMER_SCALE_DIAGONAL\n"
  "   Rotation { rotation 0 1 0  1.57 }\n"
  "   USE TRANSFORMER_SCALE_DIAGONAL\n"
  "   Rotation { rotation 0 1 0  1.57 }\n"
  "   USE TRANSFORMER_SCALE_DIAGONAL\n"
  "}\n"
  "\n"
  "DEF transformerScaleBoxFeedback Separator {\n"
  "   USE TRANSFORMER_FEEDBACK_MATERIAL\n"
  "   DrawStyle { style LINES  lineWidth 2 }\n"
  "   Cube { }\n"
  "}\n"
  "\n"
  "DEF TRANSFORMER_SCALE_WALLDATA Group {\n"
  "   USE TRANSFORMER_FEEDBACK_TRANSPARENT_MATERIAL\n"
  "   USE TRANSFORMER_SIDE_COORDS\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerPosXWallFeedback Separator {\n"
  "   USE TRANSFORMER_SCALE_WALLDATA\n"
  "   IndexedFaceSet { coordIndex [ 5, 1, 2, 6, -1 ] }\n"
  "}\n"
  "\n"
  "DEF transformerNegXWallFeedback Separator {\n"
  "   USE TRANSFORMER_SCALE_WALLDATA\n"
  "   IndexedFaceSet { coordIndex [ 0, 4, 7, 3, -1 ] }\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerPosYWallFeedback Separator {\n"
  "   USE TRANSFORMER_SCALE_WALLDATA\n"
  "   IndexedFaceSet { coordIndex [ 7, 6, 2, 3, -1 ] }\n"
  "}\n"
  "\n"
  "DEF transformerNegYWallFeedback Separator {\n"
  "   USE TRANSFORMER_SCALE_WALLDATA\n"
  "   IndexedFaceSet { coordIndex [ 0, 1, 5, 4, -1 ] }\n"
  "}\n"
  "\n"
  "\n"
  "DEF transformerPosZWallFeedback Separator {\n"
  "   USE TRANSFORMER_SCALE_WALLDATA\n"
  "   IndexedFaceSet { coordIndex [ 1, 0, 3, 2, -1 ] }\n"
  "}\n"
  "\n"
  "DEF transformerNegZWallFeedback Separator {\n"
  "   USE TRANSFORMER_SCALE_WALLDATA\n"
  "   IndexedFaceSet { coordIndex [ 4, 5, 6, 7, -1 ] } \n"
  "}\n";

#endif /* ! SO_TRANSFORMERDRAGGER_IV_H */
