#ifndef VERIFYGRID_H
#define VERIFYGRID_H

struct Point
{
  double x = 0.0, y = 0.0;
};
struct Point3D
{
  double X, Y, Z;
};

int get_actual_number_of_corners(int ncorner, const Varray<Point3D> &cell_corners_xyz_open_cell);
int get_no_duplicates(int actual_number_of_corners, const Varray<Point3D> &cell_corners_xyz_open_cell,
                      std::vector<bool> &marked_duplicate_indices);
void copy_unique_corners(int actual_number_of_corners, const Varray<Point3D> &cell_corners_xyz_open_cell,
                         const std::vector<bool> &marked_duplicate_indices, Varray<Point3D> &cell_corners_xyz_without_duplicates);

void set_cell_corners_xyz(int ncorner, const double *cell_corners_lon, const double *cell_corners_lat,
                          Varray<Point3D> &cell_corners_xyz);
void set_center_point_plane_projection(int coordinate_to_ignore, const Point3D &center_point_xyz,
                                       Point &center_point_plane_projection);
void set_cell_corners_plane_projection(int coordinate_to_ignore, int ncorner, const Varray<Point3D> &cell_corners_xyz,
                                       Varray<Point> &cell_corners_plane_projection);
int find_coordinate_to_ignore(const Varray<Point3D> &cell_corners_xyz);
double calculate_the_polygon_area(const Varray<Point> &cell_corners, int number_corners);
bool are_polygon_vertices_arranged_in_clockwise_order(double cell_area);
int winding_numbers_algorithm(const Varray<Point> &cell_corners, int number_corners, const Point &point);

#endif /* VERIFYGRID_H */
