/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

// -------------------------------------------------------------------
// GridPicture.cpp
// -------------------------------------------------------------------
#include "GridPicture.H"
#include "GlobalUtilities.H"
#include <climits>
#include <cfloat>

// -------------------------------------------------------------------
GridPicture::GridPicture() {
}


// -------------------------------------------------------------------
void GridPicture::GridPictureInit(int level,
			int rratio, int scale, int picSizeH, int picSizeV,
			const Box &overlapbox,
			const Box &boxWithData, int slicedir)
{
  sliceDir = slicedir;
  refRatio = rratio;
  currentScale = scale; 
  pictureSizeH = picSizeH;
  pictureSizeV = picSizeV;
  overlapBox = overlapbox;

  BL_ASSERT(overlapBox.sameSize(boxWithData));

  imageBox = overlapBox; 
  imageBox.refine(refRatio * currentScale);

  if(sliceDir == ZDIR) {
    dataSizeH = boxWithData.length(XDIR);
    dataSizeV = boxWithData.length(YDIR);
  } else if(sliceDir == YDIR) {
    dataSizeV = boxWithData.length(ZDIR);
    dataSizeH = boxWithData.length(XDIR);
  } else {
    dataSizeH = boxWithData.length(YDIR);
    dataSizeV = boxWithData.length(ZDIR);
  }
  imageSizeH = dataSizeH * refRatio * currentScale;
  imageSizeV = dataSizeV * refRatio * currentScale;

}  // end GridPictureInit


// -------------------------------------------------------------------
GridPicture::~GridPicture() {
}


// -------------------------------------------------------------------
void  GridPicture::ChangeScale(int newScale, int picSizeH, int picSizeV) {
  currentScale = newScale;
  imageBox = overlapBox; 
  imageBox.refine(refRatio * currentScale); 

  // use datasize instead of imageBox.length() for node centered boxes
  imageSizeH = dataSizeH * refRatio * currentScale;
  imageSizeV = dataSizeV * refRatio * currentScale;
  pictureSizeH = picSizeH;
  pictureSizeV = picSizeV;
}


// -------------------------------------------------------------------
int GridPicture::HPositionInPicture() {
  int endLoc;
  if(sliceDir == ZDIR) {
    endLoc = imageBox.smallEnd()[XDIR];
  } else if(sliceDir == YDIR) {
    endLoc = imageBox.smallEnd()[XDIR];
  } else {
    endLoc = imageBox.smallEnd()[YDIR];
  }
  return (endLoc - ((int) imageSizeH % refRatio));
}


// -------------------------------------------------------------------
int GridPicture::VPositionInPicture() {
  int endLoc, nodeAdjustment;
  if(sliceDir == ZDIR) {
    endLoc = imageBox.bigEnd()[YDIR];
    nodeAdjustment = imageBox.type()[YDIR] * (currentScale - 1) * refRatio;
  } else if(sliceDir == YDIR) {
    endLoc = imageBox.bigEnd()[ZDIR];
    nodeAdjustment = imageBox.type()[ZDIR] * (currentScale - 1) * refRatio;
  } else {
    endLoc = imageBox.bigEnd()[ZDIR];
    nodeAdjustment = imageBox.type()[ZDIR] * (currentScale - 1) * refRatio;
  }
  return ((pictureSizeV-1) - endLoc - ((int) imageSizeV % refRatio) - 
	  nodeAdjustment);
}
// -------------------------------------------------------------------
// -------------------------------------------------------------------
