# Calamares modules

Calamares modules are plugins that provide features like installer pages,
batch jobs, etc. An installer page (visible to the user) is called a "view",
while other modules are "jobs".

Each Calamares module lives in its own directory.

All modules are installed in `$DESTDIR/lib/calamares/modules`.

# Module types

There are two types of Calamares module:
* viewmodule, for user-visible modules. These may be in C++, or PythonQt.
* jobmodule, for not-user-visible modules. These may be done in C++,
  Python, or as external processes.

# Module interfaces

There are three (four) interfaces for Calamares modules:
* qtplugin,
* python (jobmodules only),
* pythonqt (optional),
* process (jobmodules only).

# Module directory

Each Calamares module lives in its own directory. The contents
of the directory depend on the interface and type of the module.

## Module descriptor

A Calamares module must have a *module descriptor file*, named
`module.desc`. For C++ (qtplugin) modules using CMake as a build-
system and using the calamares_add_plugin() function -- this is the
recommended way to create such modules -- the module descriptor
file is optional, since it can be generated by the build system.
For other module interfaces, the module descriptor file is required.

The module descriptor file must be placed in the module's directory.
The module descriptor file is a YAML 1.2 document which defines the
module's name, type, interface and possibly other properties. The name
of the module as defined in `module.desc` must be the same as the name
of the module's directory.

Module descriptors must have the following keys:
- *name* (an identifier; must be the same as the directory name)
- *type* ("job" or "view")
- *interface* (see below for the different interfaces; generally we
  refer to the kinds of modules by their interface)

## Module-specific configuration

A Calamares module *may* read a module configuration file,
named `<modulename>.conf`. If such a file is present in the
module's directory, it is shipped as a *default* configuration file.
The module configuration file, if it exists, is a YAML 1.2 document
which contains a YAML map of anything.

All default module configuration files are installed in
`$DESTDIR/share/calamares/modules` but can be overridden by
files with the same name placed manually (or by the packager)
in `/etc/calamares/modules`.

## C++ modules

Currently the recommended way to write a module which exposes one or more
installer pages (viewmodule) is through a C++ and Qt plugin. Viewmodules must
implement `Calamares::ViewStep`. They can also implement `Calamares::Job`
to provide jobs.

To add a Qt plugin module, put it in a subdirectory and make sure it has
a `CMakeLists.txt` with a `calamares_add_plugin` call. It will be picked
up automatically by our CMake magic. The `module.desc` file is optional.

## Python modules

Modules may use one of the python interfaces, which may be present
in a Calamares installation (but also may not be). These modules must have
a `module.desc` file. The Python script must implement one or more of the
Python interfaces for Calamares -- either the python jobmodule interface,
or the experimental pythonqt job- and viewmodule interfaces.

To add a Python or process jobmodule, put it in a subdirectory and make sure
it has a `module.desc`. It will be picked up automatically by our CMake magic.
For all kinds of Python jobs, the key *script* must be set to the name of
the main python file for the job. This is almost universally "main.py".

`CMakeLists.txt` is *not* used for Python and process jobmodules.

Calamares offers a Python API for module developers, the core Calamares
functionality is exposed as `libcalamares.job` for job data,
`libcalamares.globalstorage` for shared data and `libcalamares.utils` for
generic utility functions. Documentation is inline.

All code in Python job modules must obey PEP8, the only exception are
`libcalamares.globalstorage` keys, which should always be
camelCaseWithLowerCaseInitial to match the C++ identifier convention.

For testing and debugging we provide the `testmodule.py` script which
fakes a limited Calamares Python environment for running a single jobmodule.

### Python Jobmodule

A Python jobmodule is a Python program which imports libcalamares and has a
function `run()` as entry point. The function `run()` must return `None` if
everything went well, or a tuple `(str,str)` with an error message and
description if something went wrong.

### PythonQt Jobmodule

A PythonQt jobmodule implements the experimental Job interface by defining
a subclass of something.

### PythonQt Viewmodule

A PythonQt viewmodule implements the experimental View interface by defining
a subclass of something.

## Process jobmodules

A process jobmodule runs a (single) command. The interface is "process",
while the module type must be "job" or "jobmodule".

The key *command* should have a string as value, which is passed to the
shell -- remember to quote it properly.

