
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsejanitor.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bseplugin.hh>
#include <bse/bseprocedure.hh>
#include <bse/bsejanitor.hh>
#include <bse/bseserver.hh>
#include <string.h>
/* --- trigger-action --- */
static void
trigger_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 9 "bsejanitor.proc"
 {
#line 11 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 16 "bsejanitor.proc"
 }
static BseErrorType
#line 16 "bsejanitor.proc"
trigger_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 19 "bsejanitor.proc"
{
#line 20 "bsejanitor.proc"
  
  BseJanitor  *self = (BseJanitor*) bse_value_get_object (in_values++);
  const gchar *action = sfi_value_get_string (in_values++);
#line 23 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 26 "bsejanitor.proc"
  
  bse_janitor_trigger_action (self, action);
  return BSE_ERROR_NONE;
}
/* --- get-script-name --- */
static void
get_script_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 30 "bsejanitor.proc"
 {
#line 32 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(out_pspecs++)    = sfi_pspec_string ("script_name", "Script Name", NULL,
			     NULL, SFI_PARAM_STANDARD);
}
#line 37 "bsejanitor.proc"
 }
static BseErrorType
#line 37 "bsejanitor.proc"
get_script_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 40 "bsejanitor.proc"
{
#line 41 "bsejanitor.proc"
  
  BseJanitor *self = (BseJanitor*) bse_value_get_object (in_values++);
#line 43 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 46 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, self->script_name);
  return BSE_ERROR_NONE;
}
/* --- get-proc-name --- */
static void
get_proc_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 50 "bsejanitor.proc"
 {
#line 52 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(out_pspecs++)    = sfi_pspec_string ("proc_name", "Proc Name", NULL,
			     NULL, SFI_PARAM_STANDARD);
}
#line 57 "bsejanitor.proc"
 }
static BseErrorType
#line 57 "bsejanitor.proc"
get_proc_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 60 "bsejanitor.proc"
{
#line 61 "bsejanitor.proc"
  
  BseJanitor *self = (BseJanitor*) bse_value_get_object (in_values++);
#line 63 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 66 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, self->proc_name);
  return BSE_ERROR_NONE;
}
/* --- n-actions --- */
static void
n_actions_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 70 "bsejanitor.proc"
 {
#line 72 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_actions", "N Actions", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 77 "bsejanitor.proc"
 }
static BseErrorType
#line 77 "bsejanitor.proc"
n_actions_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 80 "bsejanitor.proc"
{
#line 81 "bsejanitor.proc"
  
  BseJanitor *self = (BseJanitor*) bse_value_get_object (in_values++);
#line 83 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 86 "bsejanitor.proc"
  
  sfi_value_set_int (out_values++, g_slist_length (self->actions));
  return BSE_ERROR_NONE;
}
/* --- get-action --- */
static void
get_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 90 "bsejanitor.proc"
 {
#line 92 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 99 "bsejanitor.proc"
 }
static BseErrorType
#line 99 "bsejanitor.proc"
get_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 102 "bsejanitor.proc"
{
#line 103 "bsejanitor.proc"
  
  BseJanitor *self = (BseJanitor*) bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
#line 106 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  BseJanitorAction *a = (BseJanitorAction*) g_slist_nth_data (self->actions, nth);
#line 110 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? g_quark_to_string (a->action) : NULL);
  return BSE_ERROR_NONE;
}
/* --- get-action-name --- */
static void
get_action_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 114 "bsejanitor.proc"
 {
#line 116 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("action-name", "Action Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 123 "bsejanitor.proc"
 }
static BseErrorType
#line 123 "bsejanitor.proc"
get_action_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 126 "bsejanitor.proc"
{
#line 127 "bsejanitor.proc"
  
  BseJanitor *self = (BseJanitor*) bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
#line 130 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  BseJanitorAction *a = (BseJanitorAction*) g_slist_nth_data (self->actions, nth);
#line 134 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->name : NULL);
  return BSE_ERROR_NONE;
}
/* --- get-action-blurb --- */
static void
get_action_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 138 "bsejanitor.proc"
 {
#line 140 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("action-blurb", "Action Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 147 "bsejanitor.proc"
 }
static BseErrorType
#line 147 "bsejanitor.proc"
get_action_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 150 "bsejanitor.proc"
{
#line 151 "bsejanitor.proc"
  
  BseJanitor *self = (BseJanitor*) bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
#line 154 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  BseJanitorAction *a = (BseJanitorAction*) g_slist_nth_data (self->actions, nth);
#line 158 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->blurb : NULL);
  return BSE_ERROR_NONE;
}
/* --- kill --- */
static void
kill_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 162 "bsejanitor.proc"
 {
#line 164 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
}
#line 167 "bsejanitor.proc"
 }
static BseErrorType
#line 167 "bsejanitor.proc"
kill_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 170 "bsejanitor.proc"
{
#line 171 "bsejanitor.proc"
  
  BseJanitor *self = (BseJanitor*) bse_value_get_object (in_values++);
#line 173 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 176 "bsejanitor.proc"
  
  bse_janitor_kill (self);
  return BSE_ERROR_NONE;
}
/* --- bse-script-janitor --- */
static void
bse_script_janitor_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 180 "bsejanitor.proc"
 {
#line 182 "bsejanitor.proc"
  *(out_pspecs++)   = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_STANDARD);
}
#line 185 "bsejanitor.proc"
 }
static BseErrorType
#line 185 "bsejanitor.proc"
bse_script_janitor_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 188 "bsejanitor.proc"
{
  BseJanitor *self = bse_janitor_get_current ();
#line 190 "bsejanitor.proc"
  
  if (!self || !self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
#line 193 "bsejanitor.proc"
  
  bse_value_set_object (out_values++, self);
  return BSE_ERROR_NONE;
}
/* --- bse-script-add-action --- */
static void
bse_script_add_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 197 "bsejanitor.proc"
 {
#line 199 "bsejanitor.proc"
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("blurb", "Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 206 "bsejanitor.proc"
 }
static BseErrorType
#line 206 "bsejanitor.proc"
bse_script_add_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 209 "bsejanitor.proc"
{
#line 210 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_janitor_get_current ();
  const gchar *action = sfi_value_get_string (in_values++);
  const gchar *name   = sfi_value_get_string (in_values++);
  const gchar *blurb  = sfi_value_get_string (in_values++);
#line 215 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 218 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
#line 221 "bsejanitor.proc"
  
  bse_janitor_add_action (self, action, name, blurb);
  return BSE_ERROR_NONE;
}
/* --- bse-script-remove-action --- */
static void
bse_script_remove_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 225 "bsejanitor.proc"
 {
#line 227 "bsejanitor.proc"
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 230 "bsejanitor.proc"
 }
static BseErrorType
#line 230 "bsejanitor.proc"
bse_script_remove_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 233 "bsejanitor.proc"
{
#line 234 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_janitor_get_current ();
  const gchar *action = sfi_value_get_string (in_values++);
#line 237 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 240 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
#line 243 "bsejanitor.proc"
  
  bse_janitor_remove_action (self, action);
  return BSE_ERROR_NONE;
}
/* --- bse-script-set-status --- */
static void
bse_script_set_status_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 247 "bsejanitor.proc"
 {
#line 249 "bsejanitor.proc"
  *(in_pspecs++)    = sfi_pspec_string ("message", "Message", NULL,
			    NULL, SFI_PARAM_STANDARD);
#line 251 "bsejanitor.proc"
}  }
static BseErrorType
#line 251 "bsejanitor.proc"
bse_script_set_status_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 254 "bsejanitor.proc"
{
#line 255 "bsejanitor.proc"
  
  BseJanitor    *self    = bse_janitor_get_current ();
  const gchar   *message = sfi_value_get_string (in_values++);
#line 258 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 261 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
  if (!message)
    message = "";
#line 266 "bsejanitor.proc"
  
  bse_item_set (self, "status-message", message, NULL);
  return BSE_ERROR_NONE;
}
/* --- bse-script-progress --- */
static void
bse_script_progress_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 270 "bsejanitor.proc"
 {
#line 272 "bsejanitor.proc"
  *(in_pspecs++)    = sfi_pspec_real ("progress", "Progress", NULL,
			  -1, -1, 1.0, 0.1,
			  SFI_PARAM_STANDARD);
#line 275 "bsejanitor.proc"
}  }
static BseErrorType
#line 275 "bsejanitor.proc"
bse_script_progress_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 278 "bsejanitor.proc"
{
#line 279 "bsejanitor.proc"
  
  BseJanitor *self = bse_janitor_get_current ();
  gfloat progress  = sfi_value_get_real (in_values++);
#line 282 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 285 "bsejanitor.proc"
  
  if (!self->port || self->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
#line 288 "bsejanitor.proc"
  
  bse_janitor_progress (self, progress);
  return BSE_ERROR_NONE;
}
/* --- bse-script-send-message --- */
static void
bse_script_send_message_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 292 "bsejanitor.proc"
 {
#line 294 "bsejanitor.proc"
  
  *(in_pspecs++)    = sfi_pspec_string ("domain", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("msg-type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("title", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("primary", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("secondary", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("details", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("config-check", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 302 "bsejanitor.proc"
}  }
static BseErrorType
#line 302 "bsejanitor.proc"
bse_script_send_message_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 305 "bsejanitor.proc"
{
#line 306 "bsejanitor.proc"
  
  BseJanitor *janitor = bse_janitor_get_current();
  const gchar *domain = sfi_value_get_string (in_values++);
  const gchar *mtype  = sfi_value_get_string (in_values++);
  const gchar *text0  = sfi_value_get_string (in_values++);
  const gchar *text1  = sfi_value_get_string (in_values++);
  const gchar *text2  = sfi_value_get_string (in_values++);
  const gchar *text3  = sfi_value_get_string (in_values++);
  const gchar *check  = sfi_value_get_string (in_values++);
  SfiMsgType type  = mtype ? sfi_msg_lookup_type (mtype) : SfiMsgType (0);
#line 316 "bsejanitor.proc"
  
  if (!mtype || !(text1 || text2))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 319 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (janitor) || !janitor->port || janitor->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
#line 322 "bsejanitor.proc"
  
  bse_server_message (bse_server_get (), domain, BseMsgType (type), text0, text1, text2, text3, check, janitor, NULL, janitor->port->remote_pid);
  return BSE_ERROR_NONE;
}
/* --- bse-script-quit --- */
static void
bse_script_quit_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 326 "bsejanitor.proc"
 {
#line 328 "bsejanitor.proc"
}  }
static BseErrorType
#line 328 "bsejanitor.proc"
bse_script_quit_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 331 "bsejanitor.proc"
{
#line 332 "bsejanitor.proc"
  
  BseJanitor *janitor = bse_janitor_get_current();
#line 334 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (janitor) || !janitor->port || janitor->port_closed)
    return BSE_ERROR_PROC_EXECUTION;
#line 337 "bsejanitor.proc"
  
  janitor->force_normal_exit = TRUE;
  bse_janitor_close (janitor);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_trigger_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Trigger an installed user action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 10;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_trigger_action = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseJanitor+trigger-action", 
    NULL,
    "/Methods/BseJanitor/General/Trigger Action",
    NULL,
    __enode_trigger_action__fill_strings,
  },
  0, trigger_action_setup, trigger_action_exec, 
};
static void
__enode_get_script_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the script name of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 31;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_script_name = {
  { (BseExportNode*) &__enode_trigger_action, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-script-name", 
    NULL,
    "/Methods/BseJanitor/General/Get Script Name",
    NULL,
    __enode_get_script_name__fill_strings,
  },
  0, get_script_name_setup, get_script_name_exec, 
};
static void
__enode_get_proc_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the procedure name of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 51;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_proc_name = {
  { (BseExportNode*) &__enode_get_script_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-proc-name", 
    NULL,
    "/Methods/BseJanitor/General/Get Proc Name",
    NULL,
    __enode_get_proc_name__fill_strings,
  },
  0, get_proc_name_setup, get_proc_name_exec, 
};
static void
__enode_n_actions__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve number of user actions of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 71;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_actions = {
  { (BseExportNode*) &__enode_get_proc_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+n-actions", 
    NULL,
    "/Methods/BseJanitor/General/N Actions",
    NULL,
    __enode_n_actions__fill_strings,
  },
  0, n_actions_setup, n_actions_exec, 
};
static void
__enode_get_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve an action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 91;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_action = {
  { (BseExportNode*) &__enode_n_actions, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action", 
    NULL,
    "/Methods/BseJanitor/General/Get Action",
    NULL,
    __enode_get_action__fill_strings,
  },
  0, get_action_setup, get_action_exec, 
};
static void
__enode_get_action_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the name of an action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 115;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_action_name = {
  { (BseExportNode*) &__enode_get_action, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action-name", 
    NULL,
    "/Methods/BseJanitor/General/Get Action Name",
    NULL,
    __enode_get_action_name__fill_strings,
  },
  0, get_action_name_setup, get_action_name_exec, 
};
static void
__enode_get_action_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the help string of an action of this janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 139;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_action_blurb = {
  { (BseExportNode*) &__enode_get_action_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action-blurb", 
    NULL,
    "/Methods/BseJanitor/General/Get Action Blurb",
    NULL,
    __enode_get_action_blurb__fill_strings,
  },
  0, get_action_blurb_setup, get_action_blurb_exec, 
};
static void
__enode_kill__fill_strings (BseExportStrings *es)
{
  es->blurb = "Kill a currently running janitor.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 163;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_kill = {
  { (BseExportNode*) &__enode_get_action_blurb, BSE_EXPORT_NODE_PROC,
    "BseJanitor+kill", 
    NULL,
    "/Methods/BseJanitor/General/Kill",
    NULL,
    __enode_kill__fill_strings,
  },
  0, kill_setup, kill_exec, 
};
static void
__enode_bse_script_janitor__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the connection dependant janitor object.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 181;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_janitor = {
  { (BseExportNode*) &__enode_kill, BSE_EXPORT_NODE_PROC,
    "bse-script-janitor", 
    NULL,
    "/Proc/Script/Get Janitor",
    NULL,
    __enode_bse_script_janitor__fill_strings,
  },
  0, bse_script_janitor_setup, bse_script_janitor_exec, 
};
static void
__enode_bse_script_add_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Install a user action for script control.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 198;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_add_action = {
  { (BseExportNode*) &__enode_bse_script_janitor, BSE_EXPORT_NODE_PROC,
    "bse-script-add-action", 
    NULL,
    "/Proc/Script/Add Action",
    NULL,
    __enode_bse_script_add_action__fill_strings,
  },
  0, bse_script_add_action_setup, bse_script_add_action_exec, 
};
static void
__enode_bse_script_remove_action__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove a previously installed user action from script control.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 226;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_remove_action = {
  { (BseExportNode*) &__enode_bse_script_add_action, BSE_EXPORT_NODE_PROC,
    "bse-script-remove-action", 
    NULL,
    "/Proc/Script/Remove Action",
    NULL,
    __enode_bse_script_remove_action__fill_strings,
  },
  0, bse_script_remove_action_setup, bse_script_remove_action_exec, 
};
static void
__enode_bse_script_set_status__fill_strings (BseExportStrings *es)
{
  es->blurb = "Alter script status message.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 248;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_set_status = {
  { (BseExportNode*) &__enode_bse_script_remove_action, BSE_EXPORT_NODE_PROC,
    "bse-script-set-status", 
    NULL,
    "/Proc/Script/Set Status",
    NULL,
    __enode_bse_script_set_status__fill_strings,
  },
  0, bse_script_set_status_setup, bse_script_set_status_exec, 
};
static void
__enode_bse_script_progress__fill_strings (BseExportStrings *es)
{
  es->blurb = "Indicate progress (from 0.0 to 1.0 or -1 for unknown amount).";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 271;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_progress = {
  { (BseExportNode*) &__enode_bse_script_set_status, BSE_EXPORT_NODE_PROC,
    "bse-script-progress", 
    NULL,
    "/Proc/Script/Progress",
    NULL,
    __enode_bse_script_progress__fill_strings,
  },
  0, bse_script_progress_setup, bse_script_progress_exec, 
};
static void
__enode_bse_script_send_message__fill_strings (BseExportStrings *es)
{
  es->blurb = "Send a message from a script.";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 293;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_send_message = {
  { (BseExportNode*) &__enode_bse_script_progress, BSE_EXPORT_NODE_PROC,
    "bse-script-send-message", 
    NULL,
    "/Proc/Script/Message",
    NULL,
    __enode_bse_script_send_message__fill_strings,
  },
  0, bse_script_send_message_setup, bse_script_send_message_exec, 
};
static void
__enode_bse_script_quit__fill_strings (BseExportStrings *es)
{
  es->blurb = "Exit a script succesfully (server side).";
  es->file = "/opt/src/beast/bse/bsejanitor.proc";
  es->line = 327;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_script_quit = {
  { (BseExportNode*) &__enode_bse_script_send_message, BSE_EXPORT_NODE_PROC,
    "bse-script-quit", 
    NULL,
    "/Proc/Script/Quit",
    NULL,
    __enode_bse_script_quit__fill_strings,
  },
  0, bse_script_quit_setup, bse_script_quit_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsejanitor_genprc_cc (void)
{
  return (BseExportNode*) &__enode_bse_script_quit;
}

/*
 * Generated data ends here
 */
