/*
 *  audiopreview.h
 *
 *  Copyright 2009 Arnaud Soyez <weboide@codealpha.net>
 *
 *  This file is part of AudioPreview.
 *
 *  AudioPreview is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  AudioPreview is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AudioPreview.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef AUDIOPREVIEW_H
#define AUDIOPREVIEW_H



#define SHORTDESCRIPTION _("FILE/URI... - play previews of your audio and video\
 files, and internet media streams")

#define SUMMARY _(" AudioPreview is a command-line tool that play previews of\
 any audio or video file (as long as you have corresponding gstreamer plugins\
 installed). It is very easy to use this tool and it tends to be very generic:\
 you can even use it for previewing internet media streams (radio, mp3 or video\
 streams, ...) or also use it a normal media player (using 'audiopreview\
 -e somefile.ext').\
\n Here are some usage examples:\
\n\taudiopreview somefile.ogg someotherfile.avi anotherfile.mpg ...\
\n\taudiopreview 'http://some-radio/' 'http://another-radio/'\
\n\n See the man page audiopreview(1) for more examples.")

#define COPYRIGHT_TXT "License GPLv3+: GNU GPL version 3 or later\
 <http://gnu.org/licenses/gpl.html>\nThis is free software: you are free to\
 change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by\
 law."

#define COPYRIGHT "Copyright 2009  Arnaud Soyez <weboide@codealpha.net>"

#define DESCRIPTION ""

#define BUG_REPORT_TEXT _("\nReport any bug to:\
 https://bugs.launchpad.net/audiopreview (bugs@audiopreview.codealpha.net)\n")

static    GMainLoop         *loop;
static    gchar             **remaining_args;
static    gint              exit_status_code;

void      error_quit        ();
void      quit              (gint error_status);
void      done_playing      ();

static GOptionEntry entries[] = {
  
  {"colors",
    '\0',
    0,
    G_OPTION_ARG_STRING,
    &(ap_config.colors),
    N_("TYPE can be either: no, auto or yes. Default: auto"),
    "TYPE"
  },
  
  {"duration",
    'd',
    0,
    G_OPTION_ARG_INT,
    &(ap_config.duration),
    N_("Preview duration. Use SECONDS < 0 for no limit. Default: 10"),
    "SECONDS"
  },
  
  {"debug",
    'D',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.debug),
    N_("Debug output"),
    NULL
  },
  
  
  {"entirely",
    'e',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.entirely),
    N_("Play each stream entirely from the start. Overrides -p and -d"),
    NULL
  },
  
  {"fast-seek",
    '\0',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.fastseek),
    N_("Seeking is less accurate but faster"),
    NULL
  },
  
  {"loop",
    'l',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.loop),
    N_("Loop mode: when last stream has been played, go back to first one"),
    NULL
  },
  
  {"file",
    'f',
    0,
    G_OPTION_ARG_STRING,
    &(ap_config.playlist_from_file),
    N_("Add content of FILE to playlist (added after args if any)"),
    "FILE"
  },
  
  {"max-duration",
    'm',
    0,
    G_OPTION_ARG_INT,
    &(ap_config.maxduration),
    N_("Maximum Preview duration when using --entirely."),
    "SECONDS"
  },
  
  {"position",
    'p',
    0,
    G_OPTION_ARG_INT,
    &(ap_config.position),
    N_("Start playing from: 0 (Start), 1 (Middle), 2 (End), 3 (Anywhere).\
 Ignored for endless streams (e.g. radios)"),
    "POSITION"
  },
  
  {"no-audio",
    '\0',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.no_audio),
    N_("Disable audio output"),
    NULL
  },
  
  {"no-video",
    '\0',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.no_video),
    N_("Disable video output"),
    NULL
  },
  
  {"quiet",
    'q',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.quiet),
    N_("Quiet text output"),
    NULL
  },
  
  
  {"shuffle",
    'S',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.shuffle),
    N_("Shuffle playlist (once at launch time)"),
    NULL
  },
  
  {"verbose",
    'v',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.verbose),
    N_("Verbose text output"),
    NULL
  },
  
  {"version",
    '\0',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.show_version),
    N_("Display the current version"),
    NULL
  },
  
  
  {"volume",
    'V',
    0,
    G_OPTION_ARG_INT,
    &(ap_config.volume),
    N_("Audio Volume PERCENTAGE, from 0 to 200. Default: 100"),
    "PERCENTAGE"
  },
  
   {G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_STRING_ARRAY, &remaining_args,
     NULL, NULL },
  {NULL}
};

static GOptionEntry debug_entries[] = {
  
  {"playbin2",
    '\0',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.use_playbin2),
    N_("Use playbin2 instead of playbin"),
    NULL
  },
  
  
  {"skip-null",
    '\0',
    0,
    G_OPTION_ARG_NONE,
    &(ap_config.skip_null_state),
    N_("Skip GST_STATE_NULL before GST_STATE_READY"),
    NULL
  },

  {NULL}
};

#endif /* AUDIOPREVIEW_H */
