<!-- Copyright © SixtyFPS GmbH <info@slint.dev> ; SPDX-License-Identifier: MIT -->

# Getting Started

Using Slint in your projects needs two components:

1. `.slint` files, which contain a textual description of the user interface, written in the Slint language.
2. The programming language of the project where you embed the `.slint` files.

    - Slint supports C++, Rust, and JavaScript.

There are three different pathways to get started with Slint:

1. [SlintPad](https://slint.dev/editor) - Use this browser-based tool to get a feel for the Slint language.
2. As a **UI Designer**, working with Slint files locally, we recommend the following combination of software tools:

    - [Visual Studio Code](https://code.visualstudio.com)
    - [The Slint for Visual Studio Code Extension](https://marketplace.visualstudio.com/items?itemName=Slint.slint)

3. As a **Software Developer**, integrating Slint into a new or existing code base, [follow the quickstart](slint-qs:index.html) and then for more in-depth next steps read the language-specific documentation:

    - [C++](slint-cpp:index.html)
    - [Rust](slint-rust:index.html)
    - [JavaScript](slint-node:index.html)
