/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public final class FloatValue
extends NumericValue {
    private float value;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$FloatValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$net$sf$saxon$value$DoubleValue;

    public FloatValue(float f) {
        this.value = f;
    }

    public float getValue() {
        return this.value;
    }

    public double asDouble() {
        return this.value;
    }

    public int hashCode() {
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return (int)this.value;
        }
        return new Double(this.asDouble()).hashCode();
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return (double)this.value != 0.0 && !Float.isNaN(this.value);
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 514: {
                return BooleanValue.get((double)this.value != 0.0 && !Float.isNaN(this.value));
            }
            case 88: 
            case 516: 
            case 643: 
            case 646: {
                return this;
            }
            case 532: {
                if (Float.isNaN(this.value)) {
                    throw new XPathException.Dynamic("Cannot convert float NaN to an integer");
                }
                return new IntegerValue((long)this.value);
            }
            case 515: {
                return new DecimalValue(this.value);
            }
            case 517: {
                return new DoubleValue(this.value);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException.Dynamic("Cannot convert float to " + StandardNames.getDisplayName(n));
    }

    public String getStringValue() {
        if (this.value == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return "" + this.value;
    }

    public ItemType getItemType() {
        return Type.FLOAT_TYPE;
    }

    public NumericValue negate() {
        return new FloatValue(-this.value);
    }

    public NumericValue floor() {
        return new FloatValue((float)Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new FloatValue((float)Math.ceil(this.value));
    }

    public NumericValue round() {
        if (Float.isNaN(this.value)) {
            return this;
        }
        if (Float.isInfinite(this.value)) {
            return this;
        }
        if ((double)this.value == 0.0) {
            return this;
        }
        if ((double)this.value > -0.5 && (double)this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return new FloatValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue roundToHalfEven(int n) {
        try {
            return (FloatValue)new DoubleValue(this.value).roundToHalfEven(n).convert(516);
        }
        catch (XPathException xPathException) {
            System.err.println(xPathException);
            return this;
        }
    }

    public boolean isWholeNumber() {
        return (double)this.value == Math.floor(this.value);
    }

    public NumericValue arithmetic(int n, NumericValue numericValue) throws XPathException {
        if (numericValue instanceof FloatValue) {
            switch (n) {
                case 15: {
                    return new FloatValue(this.value + ((FloatValue)numericValue).value);
                }
                case 16: {
                    return new FloatValue(this.value - ((FloatValue)numericValue).value);
                }
                case 17: {
                    return new FloatValue(this.value * ((FloatValue)numericValue).value);
                }
                case 18: {
                    return new FloatValue(this.value / ((FloatValue)numericValue).value);
                }
                case 19: {
                    return new FloatValue(this.value % ((FloatValue)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        if (numericValue instanceof DoubleValue) {
            return ((DoubleValue)this.convert(517)).arithmetic(n, numericValue);
        }
        return this.arithmetic(n, (FloatValue)numericValue.convert(516));
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = FloatValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$FloatValue == null ? (class$net$sf$saxon$value$FloatValue = FloatValue.class$("net.sf.saxon.value.FloatValue")) : class$net$sf$saxon$value$FloatValue)) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return 21;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FloatValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 22;
        }
        if (clazz == Byte.TYPE) {
            return 18;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = FloatValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 19;
        }
        if (clazz == Character.TYPE) {
            return 16;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = FloatValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 17;
        }
        if (clazz == Double.TYPE) {
            return 3;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = FloatValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 4;
        }
        if (clazz == Float.TYPE) {
            return 1;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = FloatValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 2;
        }
        if (clazz == Integer.TYPE) {
            return 12;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = FloatValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 13;
        }
        if (clazz == Long.TYPE) {
            return 10;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = FloatValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 11;
        }
        if (clazz == Short.TYPE) {
            return 14;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = FloatValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 15;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = FloatValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = FloatValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 25;
        }
        return super.conversionPreference(clazz);
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = FloatValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Double(this.value);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DoubleValue == null ? (class$net$sf$saxon$value$DoubleValue = FloatValue.class$("net.sf.saxon.value.DoubleValue")) : class$net$sf$saxon$value$DoubleValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FloatValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new Boolean((double)this.value != 0.0 && !Float.isNaN(this.value));
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = FloatValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = FloatValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = FloatValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = FloatValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = FloatValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((long)this.value);
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = FloatValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = FloatValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = FloatValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = FloatValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value);
        }
        Object object = super.convertToJava(clazz);
        if (object == null) {
            throw new XPathException.Dynamic("Conversion of float to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "float (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

