/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.io.Serializable;

public class IntVector
implements Cloneable,
Serializable {
    protected int[] elementData_;
    protected int elementCount_;
    protected int capacityIncrement_;

    public IntVector(int n, int n2) {
        this.elementData_ = new int[n];
        this.capacityIncrement_ = n2;
    }

    public IntVector(int n) {
        this(n, 0);
    }

    public IntVector() {
        this(10);
    }

    public final synchronized void copyInto(int[] nArray) {
        int n = this.elementCount_;
        while (n-- > 0) {
            nArray[n] = this.elementData_[n];
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData_.length;
        if (this.elementCount_ < n) {
            int[] nArray = this.elementData_;
            this.elementData_ = new int[this.elementCount_];
            System.arraycopy(nArray, 0, this.elementData_, 0, this.elementCount_);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData_.length;
        if (n > n2) {
            int n3;
            int[] nArray = this.elementData_;
            int n4 = n3 = this.capacityIncrement_ > 0 ? n2 + this.capacityIncrement_ : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData_ = new int[n3];
            System.arraycopy(nArray, 0, this.elementData_, 0, this.elementCount_);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount_) {
            this.ensureCapacity(n);
        }
        this.elementCount_ = n;
    }

    public final int capacity() {
        return this.elementData_.length;
    }

    public final int size() {
        return this.elementCount_;
    }

    public final boolean isEmpty() {
        return this.elementCount_ == 0;
    }

    public final synchronized int elementAt(int n) {
        if (n >= this.elementCount_) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount_);
        }
        try {
            return this.elementData_[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized void setElementAt(int n, int n2) {
        if (n2 >= this.elementCount_) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount_);
        }
        this.elementData_[n2] = n;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount_) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount_);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount_ - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData_, n + 1, this.elementData_, n, n2);
        }
        --this.elementCount_;
    }

    public final synchronized void insertElementAt(int n, int n2) {
        if (n2 >= this.elementCount_ + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.elementCount_);
        }
        this.ensureCapacity(this.elementCount_ + 1);
        System.arraycopy(this.elementData_, n2, this.elementData_, n2 + 1, this.elementCount_ - n2);
        this.elementData_[n2] = n;
        ++this.elementCount_;
    }

    public final synchronized void addElement(int n) {
        this.ensureCapacity(this.elementCount_ + 1);
        this.elementData_[this.elementCount_++] = n;
    }

    public final synchronized boolean removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        this.elementCount_ = 0;
    }

    public final int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public final synchronized int indexOf(int n, int n2) {
        for (int i = n2; i < this.elementCount_; ++i) {
            if (n != this.elementData_[i]) continue;
            return i;
        }
        return -1;
    }

    public synchronized Object clone() {
        try {
            IntVector intVector = (IntVector)super.clone();
            intVector.elementData_ = new int[this.elementCount_];
            System.arraycopy(this.elementData_, 0, intVector.elementData_, 0, this.elementCount_);
            return intVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final boolean contains(int n) {
        return this.indexOf(n, 0) >= 0;
    }

    public int[] toArray() {
        int[] nArray = new int[this.elementCount_];
        System.arraycopy(this.elementData_, 0, nArray, 0, this.elementCount_);
        return nArray;
    }
}

