/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:36:08 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import java.io.Writer;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.MSPcrunchStreamFeature;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class MSPcrunchStreamFeature_ESTest extends MSPcrunchStreamFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(key0, (Location) null, (QualifierVector) null);
      Writer writer0 = mock(Writer.class, new ViolatedAssumptionAnswer());
      mSPcrunchStreamFeature0.writeToStream(writer0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      // Undeclared exception!
      try { 
        MSPcrunchStreamFeature.readFromStream((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.MSPcrunchStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(key0, (Location) null, (QualifierVector) null);
      MSPcrunchStreamFeature mSPcrunchStreamFeature1 = new MSPcrunchStreamFeature(mSPcrunchStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      MSPcrunchStreamFeature.readFromStream(linePushBackReader0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("invalid MSPcrunch line (not enough fields): ").when(linePushBackReader0).readLine();
      // Undeclared exception!
      try { 
        MSPcrunchStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"line\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn(0).when(linePushBackReader0).getLineNumber();
      doReturn("").when(linePushBackReader0).readLine();
      try { 
        MSPcrunchStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // invalid MSPcrunch line (not enough fields): 
         //
         verifyException("uk.ac.sanger.artemis.io.MSPcrunchStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("Genbank sequence dta should begin with \"BASE COUNT\" r \"ORIGIN\"").when(linePushBackReader0).readLine();
      // Undeclared exception!
      try { 
        MSPcrunchStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"dta\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("read only - featur  cannoX be removed").when(linePushBackReader0).readLine();
      // Undeclared exception!
      try { 
        MSPcrunchStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"-\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = null;
      try {
        mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.MSPcrunchStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(key0, (Location) null, (QualifierVector) null);
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      try { 
        mSPcrunchStreamFeature0.setFromStream((EntryInformation) null, linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.MSPcrunchStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(key0, (Location) null, (QualifierVector) null);
      Feature feature0 = mSPcrunchStreamFeature0.copy();
      assertNotSame(feature0, mSPcrunchStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      Location location0 = mock(Location.class, new ViolatedAssumptionAnswer());
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(key0, location0, (QualifierVector) null);
      // Undeclared exception!
      try { 
        mSPcrunchStreamFeature0.writeToStream((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.MSPcrunchStreamFeature", e);
      }
  }
}
