# H.4 Didn't Engels refute anarchism in _"On Authority"_?

No, far from it. Engels (in)famous essay _"On Authority"_ is often pointed to
by Marxists of various schools as refuting anarchism. Indeed, it is often
considered the essential Marxist work for this and is often trotted out (pun
intended) when anarchist influence is on the rise. However this is not the
case. In fact, his essay is both politically flawed and misrepresentative. As
such, anarchists do not think that Engels refuted anarchism in his essay but
rather just showed his ignorance of the ideas he was critiquing. This
ignorance essentially rests on the fact that the whole concept of authority
was defined and understood differently by Bakunin and Engels, meaning that the
latter's critique was flawed. While Engels may have thought that they both
were speaking of the same thing, in fact they were not.

For Engels, all forms of group activity meant the subjection of the
individuals that make it up. As he put it, _"whoever mentions combined action
speaks of organisation"_ and so it is not possible _"to have organisation
without authority,"_ as authority means _"the imposition of the will of
another upon ours . . . authority presupposes subordination."_ [**Marx-Engels
Reader**, p. 731 and p. 730] Given that, Engels considered the ideas of
Bakunin to fly in the face of common sense and so show that he, Bakunin, did
not know what he was talking about. However, in reality, it was Engels who did
this.

The first fallacy in Engels account is that anarchists, as we indicated in
[section B.1](secB1.md), do not oppose all forms of authority. Bakunin was
extremely clear on this issue and differentiated between **types** of
authority, of which he opposed only certain kinds. For example, he asked the
question _"[d]oes it follow that I reject all authority?"_ and answered quite
clearly: _"No, far be it from me to entertain such a thought."_ He
acknowledged the difference between being **an** authority - an expert - and
being **in** authority. This meant that _"[i]f I bow before the authority of
the specialists and declare myself ready to follow, to a certain extent and so
long as it may seem to me to be necessary, their general indications and even
their directions, it is because their authority is imposed upon me by no one .
. . I bow before the authority of specialists because it is imposed upon me by
my own reason."_ Similarly, he argued that anarchists _"recognise all natural
authority, and all influence of fact upon us, but none of right; for all
authority and all influence of right, officially imposed upon us, immediately
becomes a falsehood and an oppression."_ He stressed that the _"only great and
omnipotent authority, at once natural and rational, the only one we respect,
will be that of the collective and public spirit of a society founded on
equality and solidarity and the mutual respect of all its members."_ [**The
Political Philosophy of Bakunin**, p. 253, p. 241 and p. 255]

Bakunin contrasted this position with the Marxist one, whom he argued were
_"champions of the social order built from the top down, always in the name of
universal suffrage and the sovereignty of the masses upon whom they bestow the
honour of obeying their leaders, their elected masters."_ In other words, a
system based on delegated **power** and so **hierarchical** authority. This
excludes the masses from governing themselves (as in the state) and this, in
turn, _"means domination, and any domination presupposes the subjugation of
the masses and, consequently, their exploitation for the benefit of some
ruling minority."_ [**Bakunin on Anarchism**, p. 277]

So while Bakunin and other anarchists, on occasion, **did** argue that
anarchists reject _"all authority"_ they, as Carole Pateman correctly notes,
_"tended to treat 'authority' as a synonym for 'authoritarian,' and so have
identified 'authority' with hierarchical power structures, especially those of
the state. Nevertheless, their practical proposals and some of their
theoretical discussions present a different picture."_ [**The Problem of
Political Obligation**, p. 141] This can be seen when Bakunin noted that _"the
principle of **authority**"_ was the _"eminently theological, metaphysical and
political idea that the masses, **always** incapable of governing themselves,
must submit at all times to the benevolent yoke of a wisdom and a justice,
which in one way or another, is imposed from above."_ [**Marxism, Freedom and
the State**, p. 33] Clearly, by the term _"principle of authority"_ Bakunin
meant **hierarchy** rather than organisation and the need to make agreements
(what is now called self-management).

Bakunin, clearly, did not oppose **all** authority but rather a specific kind
of authority, namely **hierarchical** authority. This kind of authority placed
power into the hands of a few. For example, wage labour produced this kind of
authority, with a _"meeting . . . between master and slave . . . the worker
sells his person and his liberty for a given time."_ The state is also based
hierarchical authority, with _"those who govern"_ (i.e. _"those who frame the
laws of the country as well as those who exercise the executive power"_) being
in an _"exceptional position diametrically opposed to . . . popular
aspirations"_ towards liberty. They end up _"viewing society from the high
position in which they find themselves"_ and so _"[w]hoever says political
power says domination"_ over _"a more or less considerable section of the
population."_ [**The Political Philosophy of Bakunin**, p. 187 and p. 218]

Thus hierarchical authority is top-down, centralised and imposed. It is
**this** kind of authority Bakunin had in mind when he argued that anarchists
_"are in fact enemies of all authority"_ and it will _"corrupt those who
exercise [it] as much as those who are compelled to submit to [it]."_ [**Op.
Cit.**, p. 249] In other words, "authority" was used as shorthand for
"hierarchy" (or "hierarchical authority"), the imposition of decisions rather
than agreement to abide by the collective decisions you make with others when
you freely associate with them. In place of this kind of authority, Bakunin
proposed a _"natural authority"_ based on the masses _"governing themselves."_
He did not object to the need for individuals associating themselves into
groups and managing their own affairs, rather he opposed the idea that co-
operation necessitated hierarchy:

> _"Hence there results, for science as well as for industry, the necessity of
division and association of labour. I take and I give - such is human life.
Each is an authoritative leader and in turn is led by others. Accordingly
there is no fixed and constant authority, but continual exchange of mutual,
temporary, and, above all, voluntary authority and subordination."_ [**Op.
Cit.**, pp. 353-4]

This kind of free association would be the expression of liberty rather than
(as in hierarchical structures) its denial. Anarchists reject the idea of
giving a minority (a government) the power to make our decisions for us.
Rather, power should rest in the hands of all, not concentrated in the hands
of a few. We are well aware of the need to organise together and, therefore,
the need to stick by decisions reached. The importance of solidarity in
anarchist theory is an expression of this awareness. However, there are
different kinds of organisation. There can be no denying that in a capitalist
workplace or army there is "organisation" and "discipline" yet few, if any,
sane persons would argue that this distinctly top-down and hierarchical form
of working together is something to aspire to, particularly if you seek a free
society. This cannot be compared to making and sticking by a collective
decision reached by free discussion and debate within a self-governing
associations. As Bakunin argued:

> _"Discipline, mutual trust as well as unity are all excellent qualities when
properly understood and practised, but disastrous when abused . . . [one use
of the word] discipline almost always signifies despotism on the one hand and
blind automatic submission to authority on the other . . . _

> _"Hostile as I am to [this,] the authoritarian conception of discipline, I
nevertheless recognise that a certain kind of discipline, not automatic but
voluntary and intelligently understood is, and will ever be, necessary
whenever a greater number of individuals undertake any kind of collective work
or action. Under these circumstances, discipline is simply the voluntary and
considered co-ordination of all individual efforts for a common purpose. At
the moment of revolution, in the midst of the struggle, there is a natural
division of functions according to the aptitude of each, assessed and judged
by the collective whole: Some direct and others carry out orders. But no
function remains fixed and it will not remain permanently and irrevocably
attached to any one person. Hierarchical order and promotion do not exist, so
that the executive of yesterday can become the subordinate of tomorrow. No one
rises above the others, and if he does rise, it is only to fall back again a
moment later, like the waves of the sea forever returning to the salutary
level of equality. _

> _"In such a system, power, properly speaking, no longer exists. Power is
diffused to the collectivity and becomes the true expression of the liberty of
everyone, the faithful and sincere realisation of the will of all . . . this
is the only true discipline, the discipline necessary for the organisation of
freedom. This is not the kind of discipline preached by the State . . . which
wants the old, routine-like, automatic blind discipline. Passive discipline is
the foundation of every despotism."_ [**Bakunin on Anarchism**, pp. 414-5]

Clearly Engels misunderstood the anarchist conception of liberty. Rather than
seeing it as essentially negative, anarchists argue that liberty is expressed
in two different, but integrated, ways. Firstly, there is rebellion, the
expression of autonomy in the face of authority. This is the negative aspect
of it. Secondly, there is association, the expression of autonomy by working
with your equals. This is the positive aspect of it. As such, Engels
concentrates on the negative aspect of anarchist ideas, ignoring the positive,
and so paints a false picture of anarchism. Freedom, as Bakunin argued, is a
product of connection, not of isolation. How a group organises itself
determines whether it is authoritarian or libertarian. If the individuals who
take part in a group manage the affairs of that group (including what kinds of
decisions can be delegated) then that group is based on liberty. If that power
is left to a few individuals (whether elected or not) then that group is
structured in an authoritarian manner. This can be seen from Bakunin's
argument that power must be _"diffused"_ into the collective in an anarchist
society. Clearly, anarchists do not reject the need for organisation nor the
need to make and abide by collective decisions. Rather, the question is how
these decisions are to be made - are they to be made from below, by those
affected by them, or from above, imposed by a few people in authority.

Only a sophist would confuse hierarchical power with the power of people
managing their own affairs. It is an improper use of words to denote equally
as "authority" two such opposed concepts as individuals subjected to the
autocratic power of a boss and the voluntary co-operation of conscious
individuals working together as equals. The lifeless obedience of a governed
mass cannot be compared to the organised co-operation of free individuals, yet
this is what Engels did. The former is marked by hierarchical power and the
turning of the subjected into automatons performing mechanical movements
without will and thought. The latter is marked by participation, discussion
and agreement. Both are, of course, based on co-operation but to argue that
latter restricts liberty as much as the former simply confuses co-operation
with coercion. It also indicates a distinctly liberal conception of liberty,
seeing it restricted by association with others rather than seeing association
as an expression of liberty. As Malatesta argued:

> _"The basic error . . . is in believing that organisation is not possible
without authority. _

> _"Now, it seems to us that organisation, that is to say, association for a
specific purpose and with the structure and means required to attain it, is a
necessary aspect of social life. A man in isolation cannot even live the life
of a beast . . . Having therefore to join with other humans . . . he must
submit to the will of others (be enslaved) or subject others to his will (be
in authority) or live with others in fraternal agreement in the interests of
the greatest good of all (be an associate). Nobody can escape from this
necessity."_ [**Errico Malatesta: His Life and Ideas**, pp. 84-5]

Therefore, organisation is _"only the practice of co-operation and
solidarity"_ and is a _"natural and necessary condition of social life."_
[Malatesta, **Op. Cit.**, p. 83] Clearly, the question is not whether we
organise, but how do we do so. This means that, for anarchists, Engels
confused vastly different concepts: _"Co-ordination is dutifully confused with
command, organisation with hierarchy, agreement with domination - indeed,
'imperious' domination."_ [Murray Bookchin, **Towards an Ecological Society**,
pp. 126-7]

Socialism will only exist when the discipline currently enforced by the stick
in the hand of the boss is replaced by the conscious self-discipline of free
individuals. It is not by changing who holds the stick (from a capitalist to a
"socialist" boss) that socialism will be created. It is only by the breaking
up and uprooting of this slavish spirit of discipline, and its replacement by
self-management, that working people will create a new discipline what will be
the basis of socialism (the voluntary self-discipline Bakunin talked about).
As Kropotkin memorably put it:

> _"Having been brought up in a serf-owner's family, I entered active life,
like all young men of my time, with a great deal of confidence in the
necessity of commanding, ordering, scolding, punishing, and the like. But
when, at an early stage, I had to manage serious enterprises and to deal with
men, and when each mistake would lead at once to heavy consequences, I began
to appreciate the difference between acting on the principle of command and
discipline and acting on the principle of common understanding. The former
works admirably in a military parade, but it is worth nothing where real life
is concerned, and the aim can be achieved only through the severe effort of
many converging wills."_ [**Memoirs of a Revolutionist**, p. 202]

Clearly, then, Engels did not refute anarchism by his essay. Rather, he
refuted a straw man of his own creation. The question was **never** one of
whether certain tasks need co-operation, co-ordination, joint activity and
agreement. It was, in fact, a question of **how** that is achieved. As such,
Engels diatribe misses the point. Instead of addressing the actual politics of
anarchism or their actual use of the word "authority," he rather addressed a
series of logical deductions he draws from a false assumption regarding those
politics. Engels essay shows, to paraphrase Keynes cutting remarks against von
Hayek, the bedlam that can be created when a remorseless logician deduces away
from an incorrect starting assumption.

For collective activity anarchists recognise the need to make and stick by
agreements. Collective activity of course needs collective decision making and
organisation. In so far as Engels had a point to his diatribe (namely that
group efforts meant co-operating with others), Bakunin (like any anarchist)
would have agreed. The question was how are these decisions to be made, not
whether they should be or not. Ultimately, Engels confused agreement with
hierarchy. Anarchists do not.

## H.4.1 Does organisation imply the end of liberty?

Engels argument in _"On Authority"_ can be summed up as any form of collective
activity means co-operating with others and that this means the individual
subordinates themselves to others, specifically the group. As such, authority
cannot be abolished as organisation means that _"the will of a single
individual will always have to subordinate itself, which means that questions
are settled in an authoritarian way."_ [**Op. Cit.**, p. 731]

Engels argument proves too much. As every form of joint activity involves
agreement and _"subordination,"_ then life itself becomes _"authoritarian."_
The only free person, according to Engels' logic, would be the hermit.
Anarchists reject such nonsense. As George Barrett argued:

> _"To get the full meaning out of life we must co-operate, and to co-operate
we must make agreements with our fellow-men. But to suppose that such
agreements mean a limitation of freedom is surely an absurdity; on the
contrary, they are the exercise of our freedom. _

> _"If we are going to invent a dogma that to make agreements is to damage
freedom, then at once freedom becomes tyrannical, for it forbids men [and
women] to take the most ordinary everyday pleasures. For example, I cannot go
for a walk with my friend because it is against the principle of Liberty that
I should agree to be at a certain place at a certain time to meet him. I
cannot in the least extend my own power beyond myself, because to do so I must
co-operate with someone else, and co-operation implies an agreement, and that
is against Liberty. It will be seen at once that this argument is absurd. I do
not limit my liberty, but simply exercise it, when I agree with my friend to
go for a walk. _

> _"If, on the other hand, I decide from my superior knowledge that it is good
for my friend to take exercise, and therefore I attempt to compel him to go
for a walk, then I begin to limit freedom. This is the difference between free
agreement and government."_ [**Objections to Anarchism**, pp. 348-9]

If we took Engels' argument seriously then we would have to conclude that
living makes freedom impossible! After all by doing any joint activity you
"subordinate" yourself to others and so, ironically, exercising your liberty
by making decisions and associating with others would become a denial of
liberty. Clearly Engels argument is lacking something!

Perhaps this paradox can be explained once we recognise that Engels is using a
distinctly liberal view of freedom - i.e. freedom from. Anarchists reject
this. We see freedom as holistic - freedom from and freedom to. This means
that freedom is maintained by the kind of relationships we form with others,
**not** by isolation. As Bakunin argued, _"man in isolation can have no
awareness of his liberty. Being free for man means being acknowledged,
considered and treated as such by another man. Liberty is therefore a feature
not of isolation but of interaction, not of exclusion but rather of
connection"_. [**Michael Bakunin: Selected Writings**, p. 147] Liberty is
denied when we form hierarchical relationships with others not necessarily
when we associate with others. To combine with other individuals is an
expression of individual liberty, **not** its denial! We are aware that
freedom is impossible outside of association. Within an association absolute
"autonomy" cannot exist, but such a concept of "autonomy" would restrict
freedom to such a degree that it would be so self-defeating as to make a
mockery of the concept of autonomy and no sane person would seek it. To
requote Malatesta, the freedom we want _"is not an absolute metaphysical,
abstract freedom"_ but _"a real freedom, possible freedom, which is the
conscious community of interests, voluntary solidarity."_ [**Anarchy**, p. 43]

To state the obvious, anarchists are well aware that _"anyone who associates
and co-operates with others for a common purpose must feel the need to co-
ordinate his [or her] actions with those of his [or her] fellow members and do
nothing that harms the work of others and, thus, the common cause; and respect
the agreements that have been made - except when wishing sincerely to leave
the association when emerging differences of opinion or changed circumstances
or conflict over preferred methods make co-operation impossible or
inappropriate."_ [Malatesta, **The Anarchist Revolution**, pp. 107-8] For
anarchists, collective organisation and co-operation does not mean the end of
individuality. Bakunin expressed it well:

> _"You will think, you will exist, you will act collectively, which
nevertheless will not prevent in the least the full development of the
intellectual and moral faculties of each individual. Each of you will bring to
you his own talents, and in all joining together you will multiply your value
a hundred fold. Such is the law of collective action . . . in giving your
hands to each other for this action in common, you will promise to each other
a mutual fraternity which will be . . . a sort of free contract . . . Then
proceed collectively to action you will necessarily commence by practising
this fraternity between yourselves . . . by means of regional and local
organisations . . . you will find in yourselves strength that you had never
imagined, if each of you acted individually, according to his own inclination
and not as a consequence of a unanimous resolution, discussed and accepted
beforehand."_ [quoted by K.J. Kenafick, **Michael Bakunin and Karl Marx**, pp.
244-5]

So, unlike the essentially (classical) liberal position of Engels, anarchists
recognise that freedom is a product of how we associate. This need not imply
continual agreement nor an unrealistic assumption that conflict and
uncooperative behaviour will disappear. For those within an organisation who
refuse to co-operate, anarchists argue that this problem is easily solved.
Freedom of association implies the freedom **not** to associate and so those
who ignore the decisions reached collectively and disrupt the organisation's
workings would simply be _"compelled to leave"_ the association. In this way,
a free association _"could protect itself without the authoritarian
organisation we have nowadays."_ [Kropotkin, **The Conquest of Bread**, p.
152]

Clearly, Engels "critique" hides more than it explains. Yes, co-operation and
coercion both involve people working jointly together, but they are **not** to
be equated. While Bakunin recognised this fundamental difference and tried,
perhaps incompletely, to differentiate them (by arguing against _"the
principle of authority"_) and to base his politics on the difference, Engels
obscures the differences and muddies the water by confusing the two radically
different concepts within the word "authority." Any organisation or group is
based on co-operation and co-ordination (Engels' "principle of authority").
How that co-operation is achieved is dependent on the **type** of organisation
in question and that, in turn, specifies the **social** relationships within
it. It is these social relationships which determine whether an organisation
is authoritarian or libertarian, not the universal need to make and stick by
agreements.

Ultimately, Engels is simply confusing obedience with agreement, coercion with
co-operation, organisation with authority, objective reality with despotism.

Rather than seeing organisation as restricting freedom, anarchists argue that
the **kind** of organisation we create is what matters. We can form
relationships with others which are based on equality, not subordination. As
an example, we point to the differences between marriage and free love (see
[next section](secH4.md#sech42)). Once it is recognised that decisions can
be made on the basis of co-operation between equals, Engels essay can be seen
for what it is - a deeply flawed piece of cheap and inaccurate diatribe.

## H.4.2 Does free love show the weakness of Engels' argument?

Yes! Engels, let us not forget, argued, in effect, that any activities which
_"replace isolated action by combined action of individuals"_ meant _"the
imposition of the will of another upon ours"_ and so _"the will of the single
individual will have to subordinate itself, which means that questions are
settled in an authoritarian manner."_ This, for Engels, means that
_"authority"_ has not _"disappeared"_ under anarchism but rather it has only
_"changed its form."_ [**Op. Cit.**, pp. 730-1]

However, to say that authority just changes its form misses the qualitative
differences between authoritarian and libertarian organisation. Precisely the
differences which Bakunin and other anarchists tried to stress by calling
themselves anti-authoritarians and being against the _"principle of
authority."_ By arguing that all forms of association are necessarily
"authoritarian," Engels is impoverishing the liberatory potential of
socialism. He ensures that the key question of liberty within our associations
is hidden behind a mass of sophistry.

As an example, look at the difference between marriage and free love. Both
forms necessitate two individuals living together, sharing the same home,
organising their lives together. The same situation and the same commitments.
But do both imply the same social relationships? Are they both
_"authoritarian"_?

Traditionally, the marriage vow is based on the wife promising to obey the
husband. Her role is simply that of obedience (in theory, at least). As Carole
Pateman argues, _"[u]ntil late into the nineteenth century the legal and civil
position of a wife resembled that of a slave"_ and, in theory, she _"became
the property of her husband and stood to him as a slave/servant to a master."_
[**The Sexual Contract**, p. 119 and pp. 130-1] As such, an obvious social
relationship exists - an authoritarian one in which the man has power over the
woman. We have a relationship based on domination and subordination.

In free love, the couple are equals. They decide their own affairs, together.
The decisions they reach are agreed between them and no domination takes place
(unless you think making an agreement equals domination or subordination).
They both agree to the decisions they reach, based on mutual respect and give
and take. Subordination to individuals does not meaningfully exist (at best,
it could be argued that both parties are "dominated" by their decisions,
hardly a meaningful use of the word). Instead of subordination, there is free
agreement.

Both types of organisation apply to the same activities - a couple living
together. Has "authority" just changed its form as Engels argued? Of course
not. There is a substantial difference between the two. The former is
authoritarian. One part of the organisation dictates to the other. The latter
is libertarian as neither dominates (or they, as a couple, "dominate" each
other as individuals - surely an abuse of the language, we hope you agree!).
Each part of the organisation agrees to the decision. Do all these differences
just mean that we have changed the name of "authority" or has authority been
abolished and liberty created? This was the aim of Bakunin's terminology,
namely to draw attention to the qualitative change that has occurred in the
social relationships generated by the association of individuals when
organised in an anarchist way. A few Marxists have also seen this difference.
For example, Rosa Luxemburg repeated (probably unknowingly) Bakunin's
distinction between forms of discipline and organisation when she argued that:

> _"We misuse words and we practice self-deception when we apply the same term
- discipline - to such dissimilar notions as: (1) the absence of thought and
will in a body with a thousand automatically moving hands and legs, and (2)
the spontaneous co-ordination of the conscious, political acts of a body of
men. What is there in common between the regulated docility of an oppressed
class and the self-discipline and organisation of a class struggling for its
emancipation? . . . The working class will acquire the sense of the new
discipline, the freely assumed self-discipline of the social democracy, not as
a result of the discipline imposed on it by the capitalist state, but by
extirpating, to the last root, its old habits of obedience and servility."_
[**Rosa Luxemburg Speaks**, pp. 119-20]

Engels is confusing two radically different means of decision making by
arguing both involve subordination and authority. The difference is clear: the
first involves the domination of an individual over another while the second
involves the "subordination" of individuals to the decisions and agreements
they make. The first is authority, the second is liberty. As Kropotkin put it:

> _"This applies to all forms of association. Cohabitation of two individuals
under the same roof may lead to the enslavement of one by the will of the
other, as it may also lead to liberty for both. The same applies to the family
or . . . to large or small associations, to each social institution . . . _

> _"Communism is capable of assuming all forms of freedom or of oppression -
which other institutions are unable to do. It may produce a monastery where
all implicitly obey the orders of their superior, and it may produce an
absolutely free organisation, leaving his full freedom to the individual,
existing only as long as the associates wish to remain together, imposing
nothing on anybody, being anxious rather to defend, enlarge, extend in all
directions the liberty of the individual. Communism may be authoritarian (in
which case the community will soon decay) or it may be Anarchist. The State,
on the contrary, cannot be this. It is authoritarian or it ceases to be the
State."_ [**Small Communal Experiments and Why They Fail**, pp. 12-3]

Therefore, the example of free love indicates that, for anarchists, Engels
arguments are simply pedantic sophistry. It goes without saying that
organisation involves co-operation and that, by necessity, means that
individuals come to agreements between themselves to work together. The
question is **how** do they do that, not whether they do so or not. As such,
Engels' arguments confuse agreement with hierarchy, co-operation with
coercion. Simply put, the **way** people conduct joint activity determines
whether an organisation is libertarian or authoritarian. That was why
anarchists called themselves anti-authoritarians, to draw attention to the
different ways of organising collective life.

## H.4.3 How do anarchists propose to run a factory?

In his campaign against anti-authoritarian ideas within the First
International, Engels asks in a letter written in January 1872 _"how do these
people [the anarchists] propose to run a factory, operate a railway or steer a
ship without having in the last resort one deciding will, without a single
management"_? [**The Marx-Engels Reader**, p. 729]

This could only be asked if Engels was totally ignorant of Bakunin's ideas and
his many comments supporting co-operatives as the means by which workers would
_"organise and themselves conduct the economy without guardian angels, the
state or their former employers."_ Bakunin was _"convinced that the co-
operative movement will flourish and reach its full potential only in a
society where the land, the instruments of production, and hereditary property
will be owned and operated by the workers themselves: by their freely
organised federations of industrial and agricultural workers."_ [**Bakunin on
Anarchism**, p. 399 and p. 400] Which meant that Bakunin, like all anarchists,
was well aware of how a factory or other workplace would be organised:

> _"Only associated labour, that is, labour organised upon the principles of
reciprocity and co-operation, is adequate to the task of maintaining . . .
civilised society."_ [**The Political Philosophy of Bakunin**, p. 341]

By October of that year, Engels had finally _"submitted arguments like these
to the most rabid anti-authoritarians"_ who replied to run a factory, railway
or ship did require organisation _"but here it was not a case of authority
which we confer on our delegates, **but of a commission entrusted!**"_ Engels
commented that the anarchists _"think that when they have changed the names of
things they have changed the things themselves."_ He, therefore, thought that
authority will _"only have changed its form"_ rather than being abolished
under anarchism as _"whoever mentions combined action speaks of organisation"_
and it is not possible _"to have organisation without authority."_ [**Op.
Cit.**, p. 732 and p. 731]

However, Engels is simply confusing two different things, authority and
agreement. To make an agreement with another person is an exercise of your
freedom, not its restriction. As Malatesta argued, _"the advantages which
association and the consequent division of labour offer"_ meant that humanity
_"developed towards solidarity."_ However, under class society _"the
advantages of association, the good that Man could drive from the support of
his fellows"_ was distorted and a few gained _"the advantages of co-operation
by subjecting other men to [their] will instead of joining with them."_ This
oppression _"was still association and co-operation, outside of which there is
no possible human life; but it was a way of co-operation, imposed and
controlled by a few for their personal interest."_ [**Anarchy**, pp. 30-1]
Anarchists seek to organise association to eliminate domination. This would be
done by workers organising themselves collectively to make their own decisions
about their work (workers' self-management, to use modern terminology). This
did not necessitate the same authoritarian social relationships as exist under
capitalism:

> _"Of course in every large collective undertaking, a division of labour,
technical management, administration, etc., is necessary. But authoritarians
clumsily play on words to produce a **raison d'être** for government out of
the very real need for the organisation of work. Government . . . is the
concourse of individuals who have had, or have seized, the right and the means
to make laws and to oblige people to obey; the administrator, the engineer,
etc., instead are people who are appointed or assume the responsibility to
carry out a particular job and do so. Government means the delegation of
power, that is the abdication of initiative and sovereignty of all into the
hands of a few; administration means the delegation of work, that is tasks
given and received, free exchange of services based on free agreement. . . Let
one not confuse the function of government with that of administration, for
they are essentially different, and if today the two are often confused, it is
only because of economic and political privilege."_ [**Op. Cit.**, pp. 41-2]

For a given task, co-operation and joint activity may be required by its very
nature. Take, for example, a train network. The joint activity of numerous
workers are required to ensure that it operates successfully. The driver
depends on the work of signal operators, for example, and guards to inform
them of necessary information essential for the smooth running of the network.
The passengers are dependent on the driver and the other workers to ensure
their journey is safe and quick. As such, there is an objective need to co-
operate but this need is understood and agreed to by the people involved.

If a specific activity needs the co-operation of a number of people and can
only be achieved if these people work together as a team and, therefore, need
to make and stick by agreements, then this is undoubtedly a natural fact which
the individual can only rebel against by leaving the association. Similarly,
if an association considers it wise to elect a delegate whose tasks have been
allocated by that group then, again, this is a natural fact which the
individuals in question have agreed to and so has not been imposed upon them
by any external will - the individual has been convinced of the need to co-
operate and does so.

If an activity requires the co-operation of numerous individuals then,
clearly, that is a natural fact and there is not much the individuals involved
can do about it. Anarchists are not in the habit of denying common sense. The
question is simply **how** do these individuals co-ordinate their activities.
Is it by means of self-management or by hierarchy (authority)? So anarchists
have always been clear on how industry would be run - by the workers'
themselves in their own free associations. In this way the domination of the
boss would be replaced by agreements between equals.

## H.4.4 How does the class struggle refute Engels' arguments?

Engels argued that large-scale industry (or, indeed, any form of organisation)
meant that "authority" was required. He stated that factories should have
_"Lasciate ogni autonomia, voi che entrate"_ (_"Leave, ye that enter in, all
autonomy behind"_) written above their doors. That is the basis of capitalism,
with the wage worker being paid to obey. This obedience, Engels argued, was
necessary even under socialism, as applying the _"forces of nature"_ meant _"a
veritable despotism independent of all social organisation."_ This meant that
_"[w]anting to abolish authority in large-scale industry is tantamount to
wanting to abolish industry itself."_ [**Op. Cit.**, p. 731]

The best answer to Engels claims can be found in the class struggle. Given
that Engels was a capitalist (an actual owner of a factory), he may have not
been aware of the effectiveness of _"working to rule"_ when practised by
workers. This basically involves doing **exactly** what the boss tells you to
do, regardless of the consequences as regards efficiency, production and so
on. Quite simply, workers refusing to practice autonomy can be an extremely
effective and powerful weapon in the class struggle.

This weapon has long been used by workers and advocated by anarchists,
syndicalists and wobblies. For example, the IWW booklet **How to fire your
boss** argues that _"[w]orkers often violate orders, resort to their own
techniques of doing things, and disregard lines of authority simply to meet
the goals of the company. There is often a tacit understanding, even by the
managers whose job it is to enforce the rules, that these shortcuts must be
taken in order to meet production quotas on time."_ It argues, correctly, that
_"if each of these rules and regulations were followed to the letter"_ then
_"[c]onfusion would result - production and morale would plummet. And best of
all, the workers can't get in trouble with the tactic because they are, after
all, 'just following the rules.'"_ The British anarcho-syndicalists of the
**Direct Action Movement** agreed and even quoted an industrial expert on the
situation:

> _"If managers' orders were completely obeyed, confusion would result and
production and morale would be lowered. In order to achieve the goals of the
organisation workers must often violate orders, resort to their own techniques
of doing things, and disregard lines of authority. Without this kind of
systematic sabotage much work could not be done. This unsolicited sabotage in
the form of disobedience and subterfuge is especially necessary to enable
large bureaucracies to function effectively."_ [J.A.C. Brown, quoted in
**Direct Action in Industry**]

Another weapon of workers' resistance is what has been called _"Working
without enthusiasm"_ and is related to the "work to rule." This tactic aims at
_"slowing production"_ in order to win gains from management:

> _"Even the simplest repetitive job demands a certain minimum of initiative
and in this case it is failing to show any non-obligatory initiative . . .
[This] leads to a fall in production - above all in quality. The worker
carries out every operation minimally; the moment there is a hitch of any kind
he abandons all responsibility and hands over to the next man above him in the
hierarchy; he works mechanically, not checking the finished object, not
troubling to regulate his machine. In short he gets away with as much as he
can, but never actually does anything positively illegal."_ [Pierre Dubois,
**Sabotage in Industry**, p. 51]

The practice of _"working to rule"_ and _"working without enthusiasm"_ shows
how out of touch Engels (like any capitalist) was with the realities of shop
floor life. These forms of direct action are extremely effective **because**
the workers refuse to act autonomously in industry, to work out the problems
they face during the working day themselves, and instead place all the
decisions on the authority required, according to Engels, to run the factory.
The factory itself quickly grinds to a halt. What keeps it going is not the
_"imperious"_ will of authority, but rather the autonomous activity of workers
thinking and acting for themselves to solve the numerous problems they face
during the working day. In contrast, the hierarchical perspective _"ignores
essential features of any real, functioning social order. This truth is best
illustrated in a work-to-rule strike, which turns on the fact that any
production process depends on a host of informal practices and improvisations
that could never be codified. By merely following the rules meticulously, the
workforce can virtually halt production."_ [James C. Scott, **Seeing like a
State**, p. 6] As Cornelius Castoriadis argued:

> _"Resistance to exploitation expresses itself in a drop in **productivity as
well as exertion on the workers' part** . . . At the same time it is expressed
in the disappearance of the **minimum** collective and spontaneous
**management and organisation** of work that the workers normally and of
necessity puts out. No modern factory could function for twenty-four hours
without this spontaneous organisation of work that groups of workers,
independent of the official business management, carry out by filling in the
gaps of official production directives, by preparing for the unforeseen and
for regular breakdowns of equipment, by compensating for management's
mistakes, etc. _

> _"Under 'normal' conditions of exploitation, workers are torn between the
need to organise themselves in this way in order to carry out their work -
otherwise there are repercussions for them - and their natural desire to do
their work, on the one hand, and, on the other, the awareness that by doing so
they only are serving the boss's interests. Added to those conflicting
concerns are the continual efforts of factory's management apparatus to
'direct' all aspects of the workers' activity, which often results only in
preventing them from organising themselves."_ [**Political and Social
Writings**, vol. 2, p. 68]

Needless to say, co-operation and co-ordination are required in any collective
activity. Anarchists do not deny this fact of nature, but the example Engels
considered as irrefutable simply shows the fallacy of his argument. If large-
scale industry were run along the lines argued by Engels, it would quickly
grind to halt. So trying to eliminate workers' autonomy is difficult as
_"[i]ndustrial history shows"_ that _"such management attempts to control the
freedom of the work force invariably run up against the contradiction that the
freedom is necessary for quality production."_ [David Noble, **Forces of
Production**, p. 277]

Ironically, the example of Russia under Lenin and Trotsky reinforces this
fact. _"Administrative centralisation"_ was enforced on the railway workers
which, in turn, _"led more to ignorance of distance and the inability to
respond properly to local circumstances . . . 'I have no instructions' became
all the more effective as a defensive and self-protective rationalisation as
party officials vested with unilateral power insisted all their orders be
strictly obeyed. Cheka ruthlessness instilled fear, but repression . . . only
impaired the exercise of initiative that daily operations required."_ [William
G. Rosenberg, _"The Social Background to Tsektran"_, pp. 349-373, **Party,
State, and Society in the Russian Civil War**, Diane P. Koenker, William G.
Rosenberg and Ronald Grigor Suny (eds.), p. 369] Without the autonomy required
to manage local problems, the operation of the railways was seriously harmed
and, unsurprisingly, a few months after Trotsky subjected railway workers to
the _"militarisation of labour"_ in September 1920, there was a _"disastrous
collapse of the railway network in the winter of 1920-1."_ [Jonathan Aves,
**Workers against Lenin**, p. 102] There can be no better way to cripple an
economy than to impose Lenin's demand that the task of workers was that of
_"unquestioningly obeying the will of the Soviet leader, of the dictator,
**during** the work."_ [**Collected Works**, vol. 27, p. 270]

As the experience of workers' in struggle shows, it is the **abolition** of
autonomy which ensures the abolition of large-scale industry, not its
exercise. The conscious decision by workers to **not** exercise their autonomy
brings industry grinding to a halt and are effective tools in the class
struggle. As any worker knows, it is only our ability to make decisions
autonomously that keeps industry going.

Rather than abolishing authority making large-scale industry impossible, it is
the abolishing of autonomy which quickly achieves this. The issue is how do we
organise industry so that this essential autonomy is respected and co-
operation between workers achieved based on it. For anarchists, this is done
by self-managed workers associations in which hierarchical authority is
replaced by collective self-discipline.

## H.4.5 Is the way industry operates _"independent of all social
organisation"_?

As noted in the [last section](secH4.md#sech44), Engels argued that applying
the _"forces of nature"_ meant _"a veritable despotism independent of all
social organisation."_ This meant that _"[w]anting to abolish authority in
large-scale industry is tantamount to wanting to abolish industry itself."_
[**Op. Cit.**, p. 731]

For anarchists, Engels' comments ignore the reality of class society in an
important way. Modern (_"large-scale"_) industry has not developed neutrally
or naturally, independently of all social organisation as Engels claimed.
Rather it has been shaped by the class struggle along with technology (which
is often a weapon in that conflict - see [section D.10](secD10.md)). As
Castoriadis argued:

> _"Management organises production with a view of achieving 'maximum
efficiency.' But the first result of this sort of organisation is to stir up
the workers' revolt against production itself . . . To combat the resistance
of the workers, the management institutes an ever more minute division of
labour and tasks . . . Machines are invented, or selected, according to one
fundamental criterion: Do they assist in the struggle of management against
workers, do they reduce yet further the worker's margin of autonomy, do they
assist in eventually replacing him [or her] altogether? In this sense, the
organisation of production today . . . is **class organisation.** Technology
is predominantly **class technology.** No . . . manager would ever introduce
into his plant a machine which would increase the freedom of a particular
worker or of a group of workers to run the job themselves, even if such a
machine increased production. _

> _"The workers are by no means helpless in this struggle. They constantly
invent methods of self-defence. They break the rules, while 'officially'
keeping them. They organise informally, maintain a collective solidarity and
discipline."_ [**The Meaning of Socialism**, pp. 9-10]

So one of the key aspects of the class struggle is the conflict of workers
against attempts by management to eliminate their autonomy within the
production process. This struggle generates the machines which Engels claims
produce a _"veritable despotism independent of all social organisation."_
Regardless of what Engels implies, the way industry has developed is not
independent of class society and its "despotism" has been engineered that way.
For example, it may be a fact of nature that ten people may be required to
operate a machine, but that machine is not such a fact, it is a human
invention and so can be changed. Nor is it a fact of nature that work
organisation should be based on a manager dictating to the workers what to do
- rather it could be organised by the workers themselves, using collective
self-discipline to co-ordinate their joint effort.

David Noble quotes one shop steward who stated the obvious, namely that
workers are _"not automatons. We have eyes to see with, ears to hear with, and
mouths to talk."_ As Noble comments, _"[f]or management . . . that was
precisely the problem. Workers controlled the machines, and through their
unions had real authority over the division of labour and job content."_
[**Forces of Production**, p. 37] This autonomy was what managers constantly
struggled against and introduced technology to combat. So Engels' notion that
machinery was "despotic" hides the nature of class society and the fact that
authority is a social relationship, a relationship between people and not
people and things. And, equally, that different kinds of organisation meant
different social relationships to do collective tasks. It was precisely to
draw attention to this that anarchists called themselves anti-authoritarians.

Clearly, Engels is simply ignoring the actual relations of authority within
capitalist industry and, like the capitalism he claims to oppose, is raising
the needs of the bosses to the plane of "natural fact." Indeed, is this not
the refrain of every boss or supporter of capitalism? Right-wing "libertarian"
guru Ludwig von Mises spouted this kind of nonsense when he argued that
_"[t]he root of the syndicalist idea is to be seen in the belief that
entrepreneurs and capitalists are irresponsible autocrats who are free to
conduct their affairs arbitrarily. . . . The fundamental error of this
argument is obvious [sic!]. The entrepreneurs and capitalists are not
irresponsible autocrats. They are unconditionally subject to the sovereignty
of the consumers. The market is a consumers' democracy."_ [**Human Action**,
p. 814] In other words, it is not the bosses fault that they dictate to the
worker. No, of course not, it is the despotism of the machine, of nature, of
the market, of the customer, anyone and anything **but** the person **with**
authority who is actually giving the orders and punishing those who do not
obey!

Needless to say, like Engels, von Mises is fundamentally flawed simply because
the boss is not just repeating the instructions of the market (assuming that
it is a "consumers' democracy," which it is not). Rather, they give their own
instructions based on their own sovereignty over the workers. The workers
could, of course, manage their own affairs and meet the demands of consumers
directly. The "sovereignty" of the market (just like the "despotism" of
machines and joint action) is independent of the social relationships which
exist within the workplace, but the social relationships themselves are not
predetermined by it. Thus the same workshop can be organised in different ways
and so the way industry operates **is** dependent on social organisation. The
workers can manage their own affairs or be subjected to the rule of a boss. To
say that "authority" still exists simply means to confuse agreement with
obedience.

The importance of differentiating between types of organisation and ways of
making decisions can be seen from the experience of the class struggle. During
the Spanish Revolution anarchists organised militias to fight the fascists.
One was lead by anarchist militant Durruti. His military adviser, Pérez
Farras, a professional soldier, was concerned about the application of
libertarian principles to military organisation. Durruti replied:

> _"I've said it once and I'll say it again: I've been an anarchist my entire
life and the fact that I'm responsible for this human collectivity won't
change my convictions. It was as an anarchist that I agreed to carry out the
task that the Central Committee of the Anti-Fascist Militias entrusted me. _

> _"I don't believe - and everything happening around us confirms this - that
you can run a workers' militia according to classic military rules. I believe
that discipline, co-ordination, and planning are indispensable, but we
shouldn't define them in terms taken from the world that we're destroying. We
have to build on new foundations. My comrades and I are convinced that
solidarity is the best incentive for arousing an individual's sense of
responsibility and a willingness to accept discipline as an act of self-
discipline. _

> _"War has been imposed upon us . . . but our goal is revolutionary victory.
This means defeating the enemy, but also a radical change in men. For that
change to occur, man must learn to live and conduct himself as a free man, an
apprenticeship that develops his personality and sense of responsibility, his
capacity to be master of his own acts. The worker on the job not only
transforms the material on which he works, but also transforms himself through
that work. The combatant is nothing more than a worker whose tool is a rifle -
and he should strive toward the same objective as a worker. One can't behave
like an obedient soldier but rather as a conscious man who understands the
importance of what he's doing. I know that it's not easy to achieve this, but
I also know that what can't be accomplished with reason will not be obtained
by force. If we have to sustain our military apparatus by fear, then we won't
have changed anything except the colour of the fear. It's only by freeing
itself from fear that society can build itself in freedom."_ [quoted by Abel
Paz, **Durruti: In The Spanish Revolution**, p. 474]

Is it really convincing to argue that the individuals who made up the militia
are subject to the same social relationships as those in a capitalist or
Leninist army? The same, surely, goes for workers associations and wage
labour. Ultimately, the flaw in Engels' argument can be best seen simply
because he thinks that the _"automatic machinery of a big factory is much more
despotic than the small capitalist who employ workers ever have been."_ [**Op.
Cit.**, p. 731] Authority and liberty become detached from human beings, as if
authoritarian social relationships can exist independently of individuals! It
is a **social** relationship anarchists oppose, not an abstraction.

Engels' argument is applicable to **any** society and to **any** task which
requires joint effort. If, for example, a table needs four people to move it
then those four people are subject to the "despotism" of gravity! Under such
"despotism" can we say its irrelevant whether these four people are slaves to
a master who wants the table moved or whether they agree between themselves to
move the table and on the best way to do it? In both cases the table movers
are subject to the same "despotism" of gravity, yet in the latter example they
are **not** subject to the despotism of other human beings as they clearly are
in the former. Engels is simply playing with words!

The fallacy of Engels' basic argument can be seen from this simple example. He
essentially uses a **liberal** concept of freedom (i.e. freedom exists prior
to society and is reduced within it) when attacking anarchism. Rather than see
freedom as a product of interaction, as Bakunin did, Engels sees it as a
product of isolation. Collective activity is seen as a realm of necessity (to
use Marx's phrase) and not one of freedom. Indeed, machines and the forces of
nature are considered by Engels' as "despots"! As if despotism were not a
specific set of relationships between **humans.** As Bookchin argued:

> _"To Engels, the factory is a natural fact of technics, not a specifically
bourgeois mode of rationalising labour; hence it will exist under communism as
well as capitalism. It will persist 'independently of all social
organisation.' To co-ordinate a factory's operations requires 'imperious
obedience,' in which factory hands lack all 'autonomy.' Class society or
classless, the realm of necessity is also a realm of command and obedience, of
ruler and ruled. In a fashion totally congruent with all class ideologists
from the inception of class society, Engels weds Socialism to command and rule
as a natural fact. Domination is reworked from a social attribute into a
precondition for self-preservation in a technically advanced society."_
[**Toward an Ecological Society**, p. 206]

Given this, it can be argued that Engels' _"On Authority"_ had a significant
impact in the degeneration of the Russian Revolution into state capitalism. By
deliberately obscuring the differences between self-managed and authoritarian
organisation, he helped provide Bolshevism with ideological justification for
eliminating workers self-management in production. After all, if self-
management and hierarchical management both involve the same _"principle of
authority,"_ then it does not really matter how production is organised and
whether industry is managed by the workers or by appointed managers (as Engels
stressed, authority in industry was independent of the social system and all
forms of organisation meant subordination). Murray Bookchin draws the obvious
conclusion from Engels' (and Marx's) position: _"Obviously, the factory
conceived of as a 'realm of necessity' [as opposed to a 'realm of freedom']
requires no need for self-management."_ [**Op. Cit.**, p. 126] Thus it is no
great leap from the arguments of Engels in _"On Authority"_ to Lenin's
arguments justifying the imposition of capitalist organisational forms during
the Russian Revolution:

> _"Firstly, the question of principle, namely, is the appointment of
individuals, dictators with unlimited powers, in general compatible with the
fundamental principles of Soviet government? . . . concerning the significance
of individual dictatorial powers from the point of view of the specific tasks
of the present moment, it must be said that large-scale machine industry -
which is precisely the material source, the productive source, the foundation
of socialism - calls for absolute and strict unity of will, which directs the
joint labours of hundreds, thousands and tens of thousands of people . . . But
how can strict unity of will be ensured? By thousands subordinating their will
to the will of one . . . **unquestioning subordination** to a single will is
absolutely necessary for the success of processes organised on the pattern of
large-scale machine industry. On the railways it is twice and three times as
necessary . . . Today . . . revolution demands - precisely in the interests of
its development and consolidation, precisely in the interests of socialism -
that the people **unquestioningly obey the single will** of the leaders of
labour."_ [**Collected Works**, vol. 27, pp. 267-9]

Hence the Bolsheviks need not have to consider whether replacing factory
committees with appointed managers armed with _"dictatorial powers"_ would
have any effect on the position of workers in socialism (after all, the were
subject to subordination either way). Nor did they have to worry about putting
economic power into the hands of a state-appointed bureaucracy as "authority"
and subordination were required to run industry no matter what. Engels had
used the modern factory system of mass production as a direct analogy to argue
against the anarchist call for workers' councils, for autonomy, for
participation, for self-management. Authority, hierarchy, and the need for
submission and domination is inevitable given the current mode of production,
both Engels and Lenin argued. Little wonder, then, the worker became the serf
of the state under the Bolsheviks. In his own way, Engels contributed to the
degeneration of the Russian Revolution by providing the rationale for the
Bolsheviks disregard for workers' self-management of production.

Simply put, Engels was wrong. The need to co-operate and co-ordinate activity
may be independent of social development, but the nature of a society does
impact on how this co-operation is achieved. If it is achieved by hierarchical
means, then it is a class society. If it is achieved by agreements between
equals, then it is a socialist one. As such, how industry operates **is**
dependent on the society it is part of. An anarchist society would run
industry based on the free agreement of workers united in free associations.
This would necessitate making and sticking to joint decisions but this co-
ordination would be between equals, not master and servant. By not recognising
this fact, Engels fatally undermined the cause of socialism.

## H.4.6 Why does Engels' "On Authority" harm Marxism?

Ironically, Engels' essay _"On Authority"_ also strikes at the heart of
Marxism and its critique of anarchism. Forgetting what he had written in 1873,
Engels argued in 1894 that for him and Marx the _"ultimate political aim is to
overcome the whole state and therefore democracy as well."_ [quoted by Lenin,
_"State and Revolution"_, **Essential Works of Lenin**, p. 331] Lenin argued
that _"the abolition of the state means also the abolition of democracy."_
[**Op. Cit.**, p. 332]

The problems arise from the awkward fact that Engels' _"On Authority"_ had
stated that any form of collective activity meant "authority" and so the
subjection of the minority to the majority (_"if possible"_) and _"the
imposition of the will of another upon ours."_ [**Marx-Engels Reader**, p. 731
and p. 730] Aware of the contradiction, Lenin stresses that _"someone may even
begin to fear we are expecting the advent of an order of society in which the
subordination of the minority to the majority will not be respected."_ That
was not the case, however. He simply rejected the idea that democracy was
_"the recognition of this principle"_ arguing that _"democracy is a **state**
which recognises the subordination of the minority to the majority, i.e. an
organisation for the systematic use of **violence** by one class against the
other, by one section of the population against another."_ He argued that
_"the need for violence against people in general, the need for the
**subjection** of one man to another, will vanish, since people will **become
accustomed** to observing the elementary conditions of social life **without
force** and **without subordination.**"_ [**Op. Cit.**, pp. 332-3]

Talk about playing with words! Earlier in his work Lenin summarised Engels
**"On Authority"** by stating that _"is it not clear that . . . complex
technical units, based on the employment of machinery and the ordered co-
operation of many people, could function without a certain amount of
subordination, without some authority or power."_ [**Op. Cit.**, p. 316] Now,
however, he argued that communism would involve no _"subordination"_ while, at
the same time, be based on the _"the principle of the subordination of the
minority to the majority"_! A contradiction? Perhaps not, as he argued that
the minority would _"become accustomed"_ to the conditions of _"social life"_
\- in other words the recognition that sticking to your agreements you make
with others does not involve "subordination." This, ironically, would confirm
anarchist ideas as we argue that making agreements with others, as equals,
does not involve domination or subordination but rather is an expression of
autonomy, of liberty.

Similarly, we find Engels arguing in **Anti-Duhring** that socialism _"puts an
end to the former subjection of men to their own means of production"_ and
that _"productive labour, instead of being a means of subjugating men, will
become a means of their emancipation."_ This work was written in 1878, six
years after _"On Authority"_ where he stressed that _"the automatic machinery
of a big factory is much more despotic than the small capitalists who employ
workers ever have been"_ and _"subdu[ing] the forces of nature . . . avenge
themselves"_ upon _"man"_ by _"subjecting him . . . to a veritable despotism
independent of all social organisation."_ [**Op. Cit.**, p. 720, p. 721 and p.
731] Engels is clearly contradicting himself. When attacking the anarchists,
he argues that the _"subjection"_ of people to the means of production was
inevitable and utterly _"independent of all social organisation."_ Six years
later he proclaims that socialism will abolish this inescapable subjection to
the _"veritable despotism"_ of modern industry!

As can be seen from both Engels and Lenin, we have a contradiction within
Marxism. On the one hand, they argue that authority (_"subjection"_) will
always be with us, no matter what, as _"subordination"_ and _"authority"_ is
independent of the specific society we live in. On the other, they argue that
Marxist socialism will be without a state, _"without subordination"_,
_"without force"_ and will end the _"subjection of men to their own means of
production."_ The two positions cannot be reconciled.

Simply put, if **"On Authority"** is correct then, logically, it means that
not only is anarchism impossible but also Marxist socialism. Lenin and Engels
are trying to have it both ways. On the one hand, arguing that anarchism is
impossible as any collective activity means subjection and subordination, on
the other, that socialism will end that inevitable subjection. And, of course,
arguing that democracy will be "overcome" while, at the same time, arguing
that it can never be. Ultimately, it shows that Engels essay is little more
than a cheap polemic without much merit.

Even worse for Marxism is Engels' comment that authority and autonomy _"are
relative things whose spheres vary with the various phases of society"_ and
that _"the material conditions of production and circulation inevitably
develop with large-scale industry and large-scale agriculture, and
increasingly tend to enlarge the scope of this authority."_ Given that this is
_"a veritable despotism"_ and Marxism aims at _"one single vast plan"_ in
modern industry, then the scope for autonomy, for freedom, is continually
reduced during the working day. [**Op. Cit.**, p. 732, p. 731 and p. 723] If
machinery and industry means despotism, as Engels claimed against Bakunin,
then what does that mean for Lenin's aim to ensure _"the transformation of the
whole state economic mechanism into a single huge machine . . . as to enable
hundreds of millions of people to be guided by a single plan?"_ [**Collected
Works**, vol. 27, pp. 90-1] Surely such an economy would be, to use Engels'
words, _"a veritable despotism"_?

The only possible solution is reducing the working day to a minimum and so the
time spent as a slave to the machine (and plan) is reduced. The idea that work
should be transformed into creative, empowering and liberating experience is
automatically destroyed by Engels' argument. Like capitalism, Marxist-
Socialism is based on "work is hell" and the domination of the producer.
Hardly an inspiring vision of the future.

## H.4.7 Is revolution "the most authoritarian thing there is"?

As well as the argument that "authority" is essential for every collective
activity, Engels raises another argument against anarchism. This second
argument is that revolutions are by nature authoritarian. In his words, a
_"revolution is certainly the most authoritarian thing there is; it is the act
whereby one part of the population imposes its will upon the other part by
means of rifles, bayonets and cannon - authoritarian means, if such there be
at all; and if the victorious party does not want to have fought in vain, it
must maintain this rule by means of the terror its arms inspire in the
reactionaries."_ [**Marx-Engels Reader**, p. 733]

Yet such an analysis is without class analysis and so will, by necessity,
mislead the writer and the reader. Engels argues that revolution is the
imposition by _"one part of the population"_ on another. Very true - but
Engels fails to indicate the nature of class society and, therefore, of a
social revolution. In a class society _"one part of the population"_
constantly _"imposes its will upon the other part"_ \- those with power impose
their decisions to those beneath them in the social hierarchy. In other words,
the ruling class imposes its will on the working class everyday, in work by
the hierarchical structure of the workplace and in society by the state.
Discussing the "population" as if it were not divided by classes and so
subject to specific forms of authoritarian social relationships is liberal
nonsense.

Once we recognise that the "population" in question is divided into classes we
can easily see the fallacy of Engels argument. In a social revolution, the act
of revolution is the overthrow of the power and authority of an oppressing and
exploiting class by those subject to that oppression and exploitation. In
other words, it is an act of **liberation** in which the hierarchical power of
the few over the many is eliminated and replaced by the freedom of the many to
control their own lives. It is hardly authoritarian to destroy authority! Thus
a social revolution is, fundamentally, an act of liberation for the oppressed
who act in their own interests to end the system in which _"one part of the
population imposes its will upon the other"_ everyday. Malatesta stated the
obvious:

> _"To fight our enemies effectively, we do not need to deny the principle of
freedom, not even for one moment: it is sufficient for us to want real freedom
and to want it for all, for ourselves as well as for others. _

> _"We want to expropriate the property-owning class, and with violence, since
it is with violence that they hold on to social wealth and use it to exploit
the working class. Not because freedom is a good thing for the future, but
because it is a good thing, today as well as tomorrow, and the property
owners, by denying us the means of exercising our freedom, in effect, take it
away from us. _

> _"We want to overthrow the government, all governments - and overthrow them
with violence since it is by the use of violence that they force us into
obeying - and once again, not because we sneer at freedom when it does not
serve our interests but because governments are the negation of freedom and it
is not possible to be free without getting rid of them . . . _

> _"The freedom to oppress, to exploit . . . is the denial of freedom: and the
fact that our enemies make irrelevant and hypocritical use of the word freedom
is not enough to make us deny the principle of freedom which is the
outstanding characteristic of our movement and a permanent, constant and
necessary factor in the life and progress of humanity."_ [**Errico Malatesta:
His Life and Ideas**, p. 51]

It seems strange that Engels, in effect, is arguing that the abolition of
tyranny is tyranny against the tyrants! As Malatesta so clearly argued,
anarchists _"recognise violence only as a means of legitimate self-defence;
and if today they are in favour of violence it is because they maintain that
slaves are always in a state of legitimate defence."_ [**Op. Cit.**, p. 59] As
such, Engels fails to understand the revolution from a **working class**
perspective (perhaps unsurprisingly, as he was a capitalist). The "authority"
of the "armed workers" over the bourgeois is, simply, the defence of the
workers' freedom against those who seek to end it by exercising/recreating the
very authoritarian social relationships the revolution sought to end in the
first place. This explains why, as we discussed in [section
H.2.1](secH2.md#sech21) anarchists have always argued that a revolution
would need to defend itself against those seeking to return the masses to
their position at the bottom of the social hierarchy.

To equate the defence of freedom with "authority" is, in anarchist eyes, an
expression of confused politics. Ultimately, Engels is like the liberal who
equates the violence of the oppressed to end oppression with that of the
oppressors!

Needless to say, this applies to the class struggle as well. Is, for example,
a picket line really authoritarian because it tries to impose its will on the
boss, police or scabs? Rather, is it not defending the workers' freedom
against the authoritarian power of the boss and their lackeys (the police and
scabs)? Is it "authoritarian" to resist authority and create a structure - a
strike assembly and picket line - which allows the formally subordinated
workers to manage their own affairs directly and without bosses? Is it
"authoritarian" to combat the authority of the boss, to proclaim your freedom
and exercise it? Of course not.

Structurally, a strikers' assembly and picket line - which are forms of self-
managed association - cannot be compared to an "authority" (such as a state).
To try and do so fails to recognise the fundamental difference. In the
strikers' assembly and picket line the strikers themselves decide policy and
do not delegate power away into the hands of an authority (any strike
committee executes the strikers decisions or is replaced). In a state,
**power** is delegated into the hands of a few who then use that power as they
see fit. This by necessity disempowers those at the base, who are turned into
mere electors and order takers (i.e. an authoritarian relationship is
created). Such a situation can only spell death of a social revolution, which
requires the active participation of all if it is to succeed. It also,
incidentally, exposes a central fallacy of Marxism, namely that it claims to
desire a society based on the participation of everyone yet favours a form of
organisation - centralisation - that excludes that participation.

Georges Fontenis summarises anarchist ideas on this subject when he wrote:

> _"And so against the idea of State, where power is exercised by a
specialised group isolated from the masses, we put the idea of direct workers
power, where accountable and controlled elected delegates (who can be recalled
at any time and are remunerated at the same rate as other workers) replace
hierarchical, specialised and privileged bureaucracy; where militias,
controlled by administrative bodies such as soviets, unions and communes, with
no special privileges for military technicians, realising the idea of the
armed people, replace an army cut off from the body of Society and
subordinated to the arbitrary power of a State or government."_ [**Manifesto
of Libertarian Communism**, p. 24]

Anarchists, therefore, are no more impressed with this aspect of Engels
critique than his "organisation equals authority" argument. In summary, his
argument is simply a liberal analysis of revolution, totally without a class
basis or analysis and so fails to understand the anarchist case nor answer it.
To argue that a revolution is made up of two groups of people, one of which
_"imposes its will upon the other"_ fails to indicate the social relations
that exist between these groups (classes) and the relations of authority
between them which the revolution is seeking to overthrow. As such, Engels
critique totally misses the point.

[‹ H.3 What are the myths of state socialism?](secH3.md "Go to previous
page" ) [up](secHcon.md "Go to parent page" ) [H.5 What is vanguardism and
why do anarchists reject it? ›](secH5.md "Go to next page" )

