# Section G - Is individualist anarchism capitalistic?

The short answer is, no, it is not. While a diverse tendency, the
individualist anarchists were opposed to the exploitation of labour, all forms
of non-labour income (such as profits, interest and rent) as well as
capitalist property rights (particularly in land). While aiming for a free
market system, they considered laissez-faire capitalism to be based on various
kinds of state enforced class monopoly which ensured that labour was subjected
to rule, domination and exploitation by capital. As such it is deeply
**anti**-capitalist and many individualist anarchists, including its leading
figure Benjamin Tucker, explicitly called themselves socialists (indeed,
Tucker often referred to his theory as **_"Anarchistic-Socialism"_**).

So, in this section of our anarchist FAQ we indicate why the individualist
anarchists cannot be classified as "ancestors" of the bogus libertarians of
the "anarcho"-capitalist school. Rather, they must be classified as
libertarian **socialists** due to their opposition to exploitation, critique
of capitalist property rights and concern for equality, albeit being on the
liberal wing of anarchist thought. Moreover, while all wanted to have an
economy in which all incomes were based on labour, many also opposed wage
labour, i.e. the situation where one person sells their labour to another
rather than the product of that labour (a position which, we argue, their
ideas logically imply). So while **some** of their ideas do overlap with those
of the "anarcho"-capitalist school they are not capitalistic, no more than the
overlap between their ideas and anarcho-communism makes them communistic.

In this context, the creation of "anarcho"-capitalism may be regarded as yet
another tactic by capitalists to reinforce the public's perception that there
are no viable alternatives to capitalism, i.e. by claiming that "even
anarchism implies capitalism." In order to justify this claim, they have
searched the history of anarchism in an effort to find some thread in the
movement that can be used for this purpose. They think that with the
individualist anarchists they have found such a thread. However, such an
appropriation requires the systematic ignoring or dismissal of key aspects of
individualist-anarchism (which, of course, the right-"libertarian" does).
Somewhat ironically, this attempt by right-libertarians" to exclude
individualist anarchism from socialism parallels an earlier attempt by state
socialists to do the same. Tucker furiously refuted such attempts in an
article entitled _"Socialism and the Lexicographers"_, arguing that _"the
Anarchistic Socialists are not to be stripped of one half of their title by
the mere dictum of the last lexicographer."_ [**Instead of a Book**, p. 365]

Nevertheless, in the individualists we find anarchism coming closest to
"classical" liberalism and being influenced by the ideas of Herbert Spencer, a
forefather of "libertarian" capitalism (of the minimal state variety). As
Kropotkin summarised, their ideas were _"a combination of those of Proudhon
with those of Herbert Spencer."_ [**Anarchism**, p. 296] What the
"anarcho"-capitalist is trying is to ignore Proudhon's influence (i.e. the
socialist aspect of their theories) which just leaves Spencer, who was a
right-wing liberal. To reduce individualist anarchism so is to destroy what
makes it a unique political theory and movement. While both Kropotkin and
Tucker praised Spencer as a synthetic philosopher and social scientist, they
were both painfully aware of the limitations in his socio-political ideas.
Tucker considered his attacks on all forms of socialism (including Proudhon)
as authoritarian as being, at best, misinformed or, at worse, dishonest. He
also recognised the apologetic and limited nature of his attacks on state
intervention, noting that _"amid his multitudinous illustrations . . . of the
evils of legislation, he in every instance cites some law passed ostensibly at
least to protect labour, alleviating suffering, or promote the people's
welfare. But never once does he call attention to the far more deadly and
deep-seated evils growing out of the innumerable laws creating privilege and
sustaining monopoly."_ Unsurprisingly, he considered Spencer as a _"champion
of the capitalistic class."_ [quoted by James J. Martin, **Men Against the
State**, p. 240] As we will discuss in [section G.3](secG3.md), it is likely
that he would have drawn the same conclusion about "anarcho"-capitalism.

This does not mean that the majority thread within the anarchist movement is
uncritical of individualist anarchism. Far from it! Social anarchists have
argued that this influence of non-anarchist ideas means that while its
_"criticism of the State is very searching, and [its] defence of the rights of
the individual very powerful,"_ like Spencer it _"opens . . . the way for
reconstituting under the heading of 'defence' all the functions of the
State."_ [Kropotkin, **Op. Cit.**, p. 297] This flows, social anarchists
argue, from the impact of liberal principles and led some individualist
anarchists like Benjamin Tucker to support contract theory in the name of
freedom, without being aware of the authoritarian social relationships that
could be implied by it, as can be seen under capitalism (other individualist
anarchists were more aware of this contradiction as we will see). Therefore,
social anarchists tend to think of individualist anarchism as an inconsistent
form of anarchism, one which could become consistent by simply logically
applying its own principles (see [section G.4](secG4.md)). On their part,
many individualist anarchists simply denied that social anarchists were
anarchists, a position other anarchists refute (see [section
G.2](secG2.md)). As such, this section can also be considered, in part, as a
continuation of the discussion begun in [section A.3](secA3.md).

Few thinkers are completely consistent. Given Tucker's adamant anti-statism
and anti-capitalism, it is likely that had he realised the authoritarian
social relationships which contract theory tends to produce (and justify) when
involving employing labour, he would have modified his views in such a way as
to eliminate the contradiction (particularly as contracts involving wage
labour directly contradict his support for "occupancy and use"). It is
understandable why he failed to do so, however, given the social context in
which he lived and agitated. In Tucker's America, self-employment was still a
possibility on a wide scale (in fact, for much of the nineteenth century it
was the dominant form of economic activity). His reforms were aimed at making
it easier for workers to gain access to both land and machinery, so allowing
wage workers to become independent farmers or artisans. Unsurprisingly,
therefore, he viewed individualist anarchism as a society of workers, not one
of capitalists and workers. Moreover, as we will argue in [section
G.4.1](secG4.md#secg41), his love for freedom and opposition to usury
logically implies artisan and co-operative labour -- people selling the
products of their labour, as opposed to the labour itself -- which itself
implies self-management in production (and society in general), not
authoritarianism within the workplace (this was the conclusion of Proudhon as
well as Kropotkin). Nevertheless, it is this inconsistency -- the non-
anarchist aspect of individualist anarchism -- which right "libertarians" like
Murray Rothbard select and concentrate on, ignoring the anti-capitalist
context in which this aspect of individualist thought exists. As David Wieck
pointed out:

> _"Out of the history of anarchist thought and action Rothbard has pulled
forth a single thread, the thread of individualism, and defines that
individualism in a way alien even to the spirit of a Max Stirner or a Benjamin
Tucker, whose heritage I presume he would claim -- to say nothing of how alien
is his way to the spirit of Godwin, Proudhon, Bakunin, Kropotkin, Malatesta,
and the historically anonymous persons who through their thoughts and action
have tried to give anarchism a living meaning. Out of this thread Rothbard
manufactures one more bourgeois ideology."_ [**Anarchist Justice**, pp.
227-228]

It is with this in mind that we discuss the ideas of people like Tucker. As
this section of the FAQ will indicate, even at its most liberal,
individualist, extreme anarchism was fundamentally **anti**-capitalist. Any
concepts which "anarcho"-capitalism imports from the individualist tradition
ignore both the theoretical underpinnings of their ideas as well as the social
context of self-employment and artisan production within which those concepts
arose, thus turning them into something radically different from what was
intended by their originators. As we discuss in [section
G.1.4](secG1.md#secg14) the social context in which individualist anarchism
developed is essential to understanding both its politics and its limitations
(_"Anarchism in America is not a **foreign importation** but a product of the
social conditions of this country and its historical traditions,"_ although it
is _"true that American anarchism was also influenced later by European
ideas."_ [Rudolf Rocker, **Pioneers of American Freedom**, p. 163]).

Saying that, it would be a mistake to suggest (as some writers have) that
individualist anarchism can be viewed purely in American terms. While
understanding the nature of American society and economy at the time is
essential to understanding individualist anarchism, it would be false to imply
that only individualist anarchism was the product of American conditions and
subscribed to by Americans while social anarchism was imported from Europe by
immigrants. After all, Albert and Lucy Parsons were both native-born Americans
who became communist-anarchists while Emma Goldman and Alexander Berkman only
become anarchists once they had arrived in America. Native-born Voltairine de
Cleyre moved from individualist to communist anarchism. Josiah Warren may have
been born in Boston, but he developed his anarchism after his experiences in
an experimental community set up by Welsh socialist Robert Owen (who, in turn,
was inspired by William Godwin's ideas). While Warren and Proudhon may have
developed their ideas independently, American libertarians became aware of
Proudhon and other European socialists as radical journals had correspondents
in France during the 1848 revolution and partial translations of radical
writings from Europe appeared as quickly as they could be transmitted and
translated. Individualist anarchists like William Greene and Tucker were
heavily influenced by the ideas of Proudhon and so imported aspects of
European anarchism into American individualist anarchism while the likes of
the French individualist E. Armand brought aspects of American anarchism into
the European movement. Similarly, both Spooner and Greene had been members of
the First International while individualist anarchists Joseph Labadie and Dyer
Lum where organisers of the **Knights of Labor** union along with Albert and
Lucy Parsons. Lum later joined the anarcho-communist inspired **International
Working People's Association** (IWPA) and edited its English language paper
(the **Alarm**) when Parson was imprisoned awaiting execution. All forms of
anarchism were, in other words, a combination of European and American
influences, both in terms of ideas and in terms of social experiences and
struggles, even organisations.

While red-baiting and cries of "Un-American" may incline some to stress the
"native-born" aspect of individualist anarchism (particularly those seeking to
appropriate that tendency for their own ends), both wings of the US movement
had native-born and foreign members, aspects and influences (and, as Rocker
noted, the _"so-called white civilisation of [the American] continent is the
work of European immigrants."_ [**Op. Cit.**, p. 163]). While both sides
tended to denounce and attack the other (particularly after the Haymarket
events), they had more in common than the likes of Benjamin Tucker and Johann
Most would have been prepared to admit and each tendency, in its own way,
reflected aspects of American society and the drastic transformation it was
going through at the time. Moreover, it was changes in American society which
lead to the steady rise of social anarchism and its eclipse of individualist
anarchism from the 1880s onwards. While there has been a tendency to stress an
individualist tendency in accounts of American anarchism due to its unique
characteristics, only those _"without a background in anarchist history"_
would think _"that the individualist anarchists were the larger segment of the
anarchist movement in the U.S. at the time. Nothing could be farther from the
truth. The collectivist branch of anarchism was much stronger among radicals
and workers during the late nineteenth century and early twentieth century
than the individualist brand. Before the Civil War, the opposite would be
true."_ [Greg Hall, **Social Anarchism**, no. 30, pp. 90-91]

By the 1880s, social anarchism had probably exceeded the size of the "home-
grown" individualists in the United States. The IWPA had some five thousand
members at its peak with perhaps three times as many supporters. [Paul Avrich,
**The Haymarket Tragedy**, p. 83] Its journals had an aggregate circulation of
over 30,000. [George Woodcock, **Anarchism**, p. 395] In contrast, the leading
individualist newspaper **Liberty** _"probably never had more than 600 to 1000
subscribers, but it was undoubtedly read by more than that."_ [Charles H.
Hamilton, _"Introduction"_, p. 1-19, **Benjamin R. Tucker and the Champions of
Liberty**, Coughlin, Hamilton and Sullivan (eds.), p. 10] The repression after
Haymarket took its toll and the progress of social anarchism was hindered for
a decade. However, _"[b]y the turn of the century, the anarchist movement in
America had become predominantly communist in orientation."_ [Paul Avrich,
**Anarchist Voices**, p. 5] As an added irony for those who stress the
individualist nature of anarchism in America while dismissing social anarchism
as a foreign import, the first American newspaper to use the name **"An-
archist"** was published in Boston in 1881 by anarchists within the social
revolutionary branch of the movement. [Paul Avrich, **The Haymarket Tragedy**,
p. 57] Equally ironic, given the appropriation of the term by the American
right, the first anarchist journal to use the term "libertarian" (**La
Libertaire, Journal du Mouvement Social**) was published in New York between
1858 and 1861 by French communist-anarchist Joseph Déjacque. [Max Nettlau, **A
Short History of Anarchism**, pp. 75-6]

All this is not to suggest that individualist anarchism does not have American
roots nor that many of its ideas and visions were not significantly shaped by
American social conditions and developments. Far from it! It is simply to
stress that it did not develop in complete isolation of European anarchism
during the latter half of the nineteenth century and that the social anarchism
which overtook by the end of that century was also a product of American
conditions (in this case, the transformation of a pre-capitalist society into
a capitalist one). In other words, the rise of communist anarchism and the
decline of individualist anarchism by the end of the nineteenth century
reflected American society just as much as the development of the latter in
the first place. Thus the rise of capitalism in America meant the rise of an
anarchism more suitable to the social conditions and social relationships
produced by that change. Unsurprisingly, therefore, individualist anarchism
remains the minority trend in American anarchism to this day with such
comrades as Joe Peacott (see his pamphlet **Individualism Reconsidered**),
Kevin Carson (see his book **Studies in Mutualist Political Economy**) and
Shawn Wilbur (who has painstakingly placed many rare early individualist and
mutualist anarchist works onto the internet) keeping its ideas alive.

So like social anarchism, individualist anarchism developed as a response to
the rise of capitalism and the transformation of American society this
produced. As one academic put it, the _"early anarchists, though staunchly
individualistic, did not entertain a penchant for . . . capitalism. Rather,
they saw themselves as socialists opposed to the state socialism of Karl Marx.
The individualist anarchists saw no contradiction between their individualist
stance and their rejection of capitalism."_ She stresses that they were
_"fervent anti-capitalists"_ and thought that _"workers created value through
their labour, a value appropriated by owners of businesses . . . The
individualist anarchists blamed capitalism for creating inhumane working
conditions and for increasing inequalities of wealth. Their self-avowed
'socialism' was rooted in their firm belief in equality, material as well as
legal."_ This, however, did not stop her asserting that _"contemporary
anarcho-capitalists are descendants of nineteenth-century individualist
anarchists such as Josiah Warren, Lysander Spooner, and Benjamin Tucker."_
[Susan Love Brown, pp. 99-128, _"The Free Market as Salvation from
Government"_, **Meanings of the Market**, James G. Carrier (ed.), p. 104, p.
107, p. 104 and p. 103] Trust an academic to ignore the question of how
related **are** two theories which differ on such a key issue as whether to be
anti-capitalist or not!

Needless to say, some "anarcho"-capitalists are well aware of the fact that
individualist anarchists were extremely hostile to capitalism while supporting
the "free market." Unsurprisingly, they tend to downplay this opposition,
often arguing that the anarchists who point out the anti-capitalist positions
of the likes of Tucker and Spooner are quoting them out of context. The truth
is different. In fact, it is the "anarcho"-capitalist who takes the ideas of
the individualist anarchists from both the historical and theoretical context.
This can be seen from the "anarcho"-capitalist dismissal of the individualist
anarchists' "bad" economics as well as the nature of the free society wanted
by them.

It is possible, no doubt, to trawl through the many issues of, say,
**Liberty** or the works of individualist anarchism to find a few comments
which may be used to bolster a claim that anarchism need not imply socialism.
However, a few scattered comments here and there are hardly a firm basis to
ignore the vast bulk of anarchist theory and its history as a movement. This
is particularly the case when applying this criteria consistently would mean
that communist anarchism, for example, would be excommunicated from anarchism
simply because of the opinions of **some** individualist anarchists. Equally,
it may be possible to cobble together all the non-anarchist positions of
individualist anarchists and so construct an ideology which justified wage
labour, the land monopoly, usury, intellectual property rights, and so on but
such an ideology would be nothing more than a mockery of individualist
anarchism, distinctly at odds with its spirits and aims. It would only
convince those ignorant of the anarchist tradition.

It is not a fitting tribute to the individualist anarchists that their ideas
are today being associated with the capitalism that they so clearly despised
and wished to abolish. As one modern day Individualist Anarchist argues:

> _"It is time that anarchists recognise the valuable contributions of . . .
individualist anarchist theory and take advantage of its ideas. It would be
both futile and criminal to leave it to the capitalist libertarians, whose
claims on Tucker and the others can be made only by ignoring the violent
opposition they had to capitalist exploitation and monopolistic 'free
enterprise' supported by the state."_ [J.W. Baker, _"Native American
Anarchism,"_ pp. 43-62, **The Raven**, vol. 10, no. 1, pp. 61-2]

We hope that this section of the FAQ will go some way to explaining the ideas
and contributions of individualist anarchism to a new generation of rebels.
Given the diversity of individualist anarchism, it is hard to generalise about
it (some are closer to classical liberalism than others, for example, while a
few embraced revolutionary means of change such as Dyer Lum). However, we will
do our best to draw out the common themes of the movement, indicating where
certain people differed from others. Similarly, there are distinct differences
between European and American forms of mutualism, regardless of how often
Tucker invoked Proudhon's name to justify his own interpretations of anarchism
and we will indicate these (these differences, we think, justify calling the
American branch individualist anarchism rather than mutualism). We will also
seek to show why social anarchism rejects individualist anarchism (and vice
versa) as well as giving a critical evaluation of both positions. Given the
diverse nature of individualist anarchism, we are sure that we will not cover
all the positions and individuals associated with it but we hope to present
enough to indicate why the likes of Tucker, Labadie, Yarros and Spooner
deserve better than to be reduced to footnotes in books defending an even more
extreme version of the capitalism they spent their lives fighting.

[‹ Section G - Is individualist anarchism capitalistic?](secGcon.md "Go to
previous page" ) [up](secGcon.md "Go to parent page" ) [G.1 Are
individualist anarchists anti-capitalist? ›](secG1.md "Go to next page" )

