C------------------------------------------------------------------------
C  INCLUDE FILE: OED__JACOBI
C  MODULE      : ONE ELECTRON INTEGRALS DIRECT
C  MODULE-ID   : OED
C  DESCRIPTION : Include file containing:
C
C
C                a) The Jacobi moment recurence coefficients R2 and
C                   SINV to evaluate the Jacobi moments via:
C
C                    MOM (i-1) = SINV (i) * (MOM (i+1) - R(i) * MOM (i))
C
C                   with:
C
C                    R (i)    = (2i+1) / 2T  +  R2 (i)
C                    R2 (i)   = (2i+1)/(4i-1)(4i+3)
C                    SINV (i) = (4i-3)(4i+1)(4i-1)**2/2i(2i+1)(2i-1)**2
C
C                   All R2 and SINV values are tabulated from i=1,100
C                   with all significant figures up to quadruple
C                   precision.
C
C
C                b) The Jacobi proportionality coefficients CSMALL for
C                   evaluating Jacobi moments corresponding to very
C                   small T values.
C
C
C                c) Recurrence coefficients AJAC and BJAC for the
C                   shifted Jacobi polynomials:
C
C
C                        AJAC (i+1) = 4i*(2i+1)-1 / (4i+3)(4i-1)
C
C                        BJAC (i+1) = (4i**2)((4i**2)-4i+1) /
C                                     (4i-3)(4i+1)((4i-1)**2)
C
C                   in the range i=0,99 for A and i=1,99 for B.
C
C
C  AUTHOR      : Norbert Flocke
C------------------------------------------------------------------------
C
C
C             ...declare and set the data.
C
C
         DOUBLE PRECISION    R2     (1:100)
         DOUBLE PRECISION    SINV   (1:100)
         DOUBLE PRECISION    CSMALL (1:16)
         DOUBLE PRECISION    AJAC   (1:100)
         DOUBLE PRECISION    BJAC   (2:100)

         DATA  R2    /  0.142857142857143D0,0.064935064935065D0,
     +                  0.042424242424242D0,0.031578947368421D0,
     +                  0.025171624713959D0,0.020933977455717D0,
     +                  0.017921146953405D0,0.015668202764977D0,
     +                  0.013919413919414D0,0.012522361359571D0,
     +                  0.011380504700643D0,0.010429703796412D0,
     +                  0.009625668449198D0,0.008936825885978D0,
     +                  0.008340059187517D0,0.007818052594172D0,
     +                  0.007357578305655D0,0.006948356807512D0,
     +                  0.006582278481013D0,0.006252859539424D0,
     +                  0.005954853898352D0,0.005683971201213D0,
     +                  0.005436668594563D0,0.005209994683679D0,
     +                  0.005001471020888D0,0.004809000998095D0,
     +                  0.004630799023323D0,0.004465334900118D0,
     +                  0.004311289733285D0,0.004167520666803D0,
     +                  0.004033032456309D0,0.003906954378794D0,
     +                  0.003788521345773D0,0.003677058353317D0,
     +                  0.003571967600745D0,0.003472717758432D0,
     +                  0.003378834977700D0,0.003289895321512D0,
     +                  0.003205518360722D0,0.003125361731683D0,
     +                  0.003049116490944D0,0.002976503134083D0,
     +                  0.002907268170426D0,0.002841181165204D0,
     +                  0.002778032176329D0,0.002717629525730D0,
     +                  0.002659797855363D0,0.002604376426366D0,
     +                  0.002551217626595D0,0.002500185657351D0,
     +                  0.002451155374694D0,0.002404011264510D0,
     +                  0.002358646533671D0,0.002314962302219D0,
     +                  0.002272866883715D0,0.002232275142727D0,
     +                  0.002193107919980D0,0.002155291516994D0,
     +                  0.002118757233152D0,0.002083440949085D0,
     +                  0.002049282751037D0,0.002016226591609D0,
     +                  0.001984219982814D0,0.001953213717920D0,
     +                  0.001923161618979D0,0.001894020307315D0,
     +                  0.001865748994569D0,0.001838309292184D0,
     +                  0.001811665037471D0,0.001785782134580D0,
     +                  0.001760628408909D0,0.001736173473664D0,
     +                  0.001712388607374D0,0.001689246641347D0,
     +                  0.001666721856132D0,0.001644789886155D0,
     +                  0.001623427631786D0,0.001602613178176D0,
     +                  0.001582325720257D0,0.001562545493366D0,
     +                  0.001543253709016D0,0.001524432495357D0,
     +                  0.001506064841953D0,0.001488134548496D0,
     +                  0.001470626177146D0,0.001453525008192D0,
     +                  0.001436816998777D0,0.001420488744432D0,
     +                  0.001404527443211D0,0.001388920862205D0,
     +                  0.001373657306281D0,0.001358725588842D0,
     +                  0.001344115004492D0,0.001329815303430D0,
     +                  0.001315816667470D0,0.001302109687561D0,
     +                  0.001288685342691D0,0.001275534980090D0,
     +                  0.001262650296628D0,0.001250023321331D0/

         DATA  SINV  /  7.500000000000000D0,12.250000000000000D0,
     +                 13.482857142857143D0,14.094387755102041D0,
     +                 14.464309764309764D0,14.713127781309599D0,
     +                 14.892223161453931D0,15.027401960784314D0,
     +                 15.133096582286165D0,15.218025326474080D0,
     +                 15.287771234976204D0,15.346077504725898D0,
     +                 15.395548717948718D0,15.438053680390845D0,
     +                 15.474968355644202D0,15.507328422098193D0,
     +                 15.535928420955159D0,15.561388122816694D0,
     +                 15.584198105535232D0,15.604751767931881D0,
     +                 15.623368268768985D0,15.640309258075618D0,
     +                 15.655791276938363D0,15.669995080422391D0,
     +                 15.683072739299802D0,15.695153114605357D0,
     +                 15.706346124110453D0,15.716746100789163D0,
     +                 15.726434461064224D0,15.735481842884794D0,
     +                 15.743949832622666D0,15.751892370195942D0,
     +                 15.759356900275385D0,15.766385321550434D0,
     +                 15.773014774215552D0,15.779278296960359D0,
     +                 15.785205378018289D0,15.790822419685578D0,
     +                 15.796153131760562D0,15.801218866278552D0,
     +                 15.806038903514624D0,15.810630697336272D0,
     +                 15.815010086491316D0,15.819191477224651D0,
     +                 15.823188001662942D0,15.827011655637798D0,
     +                 15.830673418995937D0,15.834183360938972D0,
     +                 15.837550732522113D0,15.840784048101780D0,
     +                 15.843891157242565D0,15.846879308362483D0,
     +                 15.849755205203224D0,15.852525057051753D0,
     +                 15.855194623505372D0,15.857769254459640D0,
     +                 15.860253925903571D0,15.862653272026194D0,
     +                 15.864971614070471D0,15.867212986312658D0,
     +                 15.869381159495767D0,15.871479662003544D0,
     +                 15.873511799025122D0,15.875480669929363D0,
     +                 15.877389184041016D0,15.879240074987624D0,
     +                 15.881035913766011D0,15.882779120659708D0,
     +                 15.884471976123521D0,15.886116630738181D0,
     +                 15.887715114326480D0,15.889269344312146D0,
     +                 15.890781133393856D0,15.892252196598959D0,
     +                 15.893684157774648D0,15.895078555568213D0,
     +                 15.896436848942709D0,15.897760422269592D0,
     +                 15.899050590035714D0,15.900308601198307D0,
     +                 15.901535643218311D0,15.902732845799403D0,
     +                 15.903901284357502D0,15.905041983243135D0,
     +                 15.906155918736964D0,15.907244021836893D0,
     +                 15.908307180853471D0,15.909346243828810D0,
     +                 15.910362020792856D0,15.911355285869630D0,
     +                 15.912326779244961D0,15.913277209006209D0,
     +                 15.914207252863594D0,15.915117559761935D0,
     +                 15.916008751390837D0,15.916881423600730D0,
     +                 15.917736147731528D0,15.918573471860134D0,
     +                 15.919393921972521D0,15.920198003065655D0/

         DATA CSMALL / -0.8888888888888889D-1,
     +                 +0.2902494331065760D-2,
     +                 -0.6150655501304852D-4,
     +                 +0.9697564430413280D-6,
     +                 -0.1218995971140662D-7,
     +                 +0.1274629327641546D-9,
     +                 -0.1141203534061737D-11,
     +                 +0.8934294807029541D-14,
     +                 -0.6214538312345874D-16,
     +                 +0.3889208875361482D-18,
     +                 -0.2212173840910540D-20,
     +                 +0.1153219167688572D-22,
     +                 -0.5548593532844672D-25,
     +                 +0.2478690843269028D-27,
     +                 -0.1033382005056540D-29,
     +                 +0.4038684854215214D-32/

         DATA  AJAC  /  0.333333333333333D0,0.523809523809524D0,
     +                  0.506493506493506D0,0.503030303030303D0,
     +                  0.501754385964912D0,0.501144164759725D0,
     +                  0.500805152979066D0,0.500597371565114D0,
     +                  0.500460829493088D0,0.500366300366300D0,
     +                  0.500298151460942D0,0.500247402276101D0,
     +                  0.500208594075928D0,0.500178253119430D0,
     +                  0.500154083204931D0,0.500134517083670D0,
     +                  0.500118455342336D0,0.500105108261509D0,
     +                  0.500093896713615D0,0.500084388185654D0,
     +                  0.500076254384627D0,0.500069242487190D0,
     +                  0.500063155235569D0,0.500057836899942D0,
     +                  0.500053163211058D0,0.500049034029617D0,
     +                  0.500045367933944D0,0.500042098172939D0,
     +                  0.500039169604387D0,0.500036536353672D0,
     +                  0.500034160005466D0,0.500032008194098D0,
     +                  0.500030053495221D0,0.500028272547357D0,
     +                  0.500026645350386D0,0.500025154701414D0,
     +                  0.500023785738071D0,0.500022525566518D0,
     +                  0.500021362956633D0,0.500020288090891D0,
     +                  0.500019292356368D0,0.500018368171632D0,
     +                  0.500017508841965D0,0.500016708437761D0,
     +                  0.500015961691939D0,0.500015263913057D0,
     +                  0.500014610911429D0,0.500013998936081D0,
     +                  0.500013424620754D0,0.500012884937508D0,
     +                  0.500012377156720D0,0.500011898812499D0,
     +                  0.500011447672688D0,0.500011021712774D0,
     +                  0.500010619093129D0,0.500010238139116D0,
     +                  0.500009877323640D0,0.500009535251826D0,
     +                  0.500009210647509D0,0.500008902341316D0,
     +                  0.500008609260120D0,0.500008330417687D0,
     +                  0.500008064906366D0,0.500007811889696D0,
     +                  0.500007570595806D0,0.500007340311523D0,
     +                  0.500007120377095D0,0.500006910181461D0,
     +                  0.500006709158001D0,0.500006516780710D0,
     +                  0.500006332560761D0,0.500006156043388D0,
     +                  0.500005986805082D0,0.500005824451045D0,
     +                  0.500005668612890D0,0.500005518946543D0,
     +                  0.500005375130347D0,0.500005236863328D0,
     +                  0.500005103863625D0,0.500004975867045D0,
     +                  0.500004852625756D0,0.500004733907083D0,
     +                  0.500004619492410D0,0.500004509176174D0,
     +                  0.500004402764936D0,0.500004300076541D0,
     +                  0.500004200939330D0,0.500004105191425D0,
     +                  0.500004012680069D0,0.500003923261015D0,
     +                  0.500003836797962D0,0.500003753162039D0,
     +                  0.500003672231321D0,0.500003593890386D0,
     +                  0.500003518029903D0,0.500003444546250D0,
     +                  0.500003373341159D0,0.500003304321392D0,
     +                  0.500003237398427D0,0.500003172488182D0/

         DATA  BJAC  /  0.088888888888889D0,0.065306122448980D0,
     +                  0.063572790845518D0,0.063066867772750D0,
     +                  0.062850625014549D0,0.062738320280853D0,
     +                  0.062672532046734D0,0.062630684468569D0,
     +                  0.062602416888131D0,0.062582426559912D0,
     +                  0.062567768998404D0,0.062556702173853D0,
     +                  0.062548141713215D0,0.062541383866652D0,
     +                  0.062535955695890D0,0.062531529822709D0,
     +                  0.062527873784375D0,0.062524818820396D0,
     +                  0.062522240012651D0,0.062520043292355D0,
     +                  0.062518156728022D0,0.062516524554840D0,
     +                  0.062515103001981D0,0.062513857324599D0,
     +                  0.062512759658763D0,0.062511787448489D0,
     +                  0.062510922276889D0,0.062510148986981D0,
     +                  0.062509455012926D0,0.062508829866040D0,
     +                  0.062508264735943D0,0.062507752178295D0,
     +                  0.062507285868274D0,0.062506860404443D0,
     +                  0.062506471151567D0,0.062506114113787D0,
     +                  0.062505785831628D0,0.062505483297851D0,
     +                  0.062505203888325D0,0.062504945304910D0,
     +                  0.062504705528039D0,0.062504482777157D0,
     +                  0.062504275477560D0,0.062504082232482D0,
     +                  0.062503901799501D0,0.062503733070518D0,
     +                  0.062503575054692D0,0.062503426863865D0,
     +                  0.062503287700051D0,0.062503156844666D0,
     +                  0.062503033649233D0,0.062502917527334D0,
     +                  0.062502807947612D0,0.062502704427686D0,
     +                  0.062502606528831D0,0.062502513851318D0,
     +                  0.062502426030333D0,0.062502342732374D0,
     +                  0.062502263652084D0,0.062502188509448D0,
     +                  0.062502117047310D0,0.062502049029169D0,
     +                  0.062501984237218D0,0.062501922470604D0,
     +                  0.062501863543863D0,0.062501807285529D0,
     +                  0.062501753536883D0,0.062501702150837D0,
     +                  0.062501652990921D0,0.062501605930379D0,
     +                  0.062501560851350D0,0.062501517644130D0,
     +                  0.062501476206503D0,0.062501436443137D0,
     +                  0.062501398265032D0,0.062501361589028D0,
     +                  0.062501326337346D0,0.062501292437174D0,
     +                  0.062501259820299D0,0.062501228422754D0,
     +                  0.062501198184511D0,0.062501169049189D0,
     +                  0.062501140963795D0,0.062501113878480D0,
     +                  0.062501087746320D0,0.062501062523110D0,
     +                  0.062501038167178D0,0.062501014639214D0,
     +                  0.062500991902111D0,0.062500969920816D0,
     +                  0.062500948662196D0,0.062500928094918D0,
     +                  0.062500908189325D0,0.062500888917334D0,
     +                  0.062500870252338D0,0.062500852169111D0,
     +                  0.062500834643724D0,0.062500817653465D0,
     +                  0.062500801176768D0/
