
      SUBROUTINE GENNBO_GENFILE(NATOMS,NBAS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      DIMENSION COORD(3,NATOMS),NUCCHG(NATOMS),OVLAP(NBAS,NBAS)
      CHARACTER*80 FNAME
cOLD      CHARACTER*4 IJUNK,ATMLBL(NBAS),ANGLBL(NBAS),LABEL(10)
      INTEGER IJUNK
c      CHARACTER*4 ATMLBL(NBAS)
      INTEGER ATMLBL(NBAS)
      CHARACTER*4 ANGLBL(NBAS),LABEL(10)
      INTEGER CENTERBF(NBAS)

      DATA LABEL/'S','X','Y','Z','XX','YY','ZZ','XY','XZ','YZ'/

C                    (3,NATOMS)  (NATOMS)    (NBASIS)
C******************************
C     FILE47 IS THE NAME OF THE INPUT FILE READ BY THE NBO PROGRAM
C
C
C    THE FIRST LINE OF THE NBO INPUT FILE MUST BE:
C
C   $GENNBO NATOMS=# NBAS=# UPPER BODM $END
C    WHERE MOST VARIABLES ARE OBVIOUS AND UPPER AND BODM
C    SPECIFY UPPER TRIANGLE OF MATRICES AND BODM IS BOND ORDER/TRUE DENSITY
C    MATRIX
C     STEP ONE: READ THE RELEVANT INFORMATION FROM JOBARC
C***********************
      OPEN(UNIT=47,FILE='FILE47')

C      CALL GETREC(-1,'JOBARC','NREALATM',1,NATOMS)
C      CALL GETREC(-1,'JOBARC','NAOBASFN',1,NBAS)

C FOR NOW, I WILL ALWAYS ASSUME UPPER, UNLESS SOMEONE TELLS OF A SITUATION
C IN WHICH THIS WOULD NOT BE THE CASE
      WRITE(47,*)'$GENNBO'
      WRITE(47,'(T2,A,I3)')'NATOMS=',NATOMS
      WRITE(47,'(T2,A,I3)')'NBAS=',NBAS
C      WRITE(47,*)'UPPER'
C     HERE WE WILL NEED AN IF THEN CONSTRUCT TO DECIDE WHICH DENSITY WE HAVE
      WRITE(47,*)'BODM'
      WRITE(47,*)'BOHR'
      WRITE(47,*)'$END'
      WRITE(47,*)
      WRITE(47,*)'$NBO'
      WRITE(47,*)'AONBO=W22'
      WRITE(47,*)'$END'
      WRITE(47,*)

C     NEXT SECTION OF INPUT HAS THE ATOMIC COORDINATES AND NUCLEAR CHARGES
C     INPUT FILE REQUIRES Z Zeff X Y Z
C     USUALLY Z AND ZEFF WILL BE EQUAL, BUT FOR ECP CASE IT WILL DIFFER.
C     WE WON'T ASSUME USE OF ANY ECP YET
      WRITE(47,*)'$COORD'
      WRITE(47,*)'NATURAL ORBITAL ANALYSIS USING ACES2 INFORMATION'
      CALL GETREC(-1,'JOBARC','COORD',3*NATOMS*2,COORD)
      CALL GETREC(-1,'JOBARC','ATOMCHRG',NATOMS,NUCCHG)
      DO I = 1, NATOMS
         WRITE(47,*)NUCCHG(I),NUCCHG(I),COORD(1,I),COORD(2,I),COORD(3,I)
      END DO
      WRITE(47,*)'$END'

C     THIS SECTION DETAILS THE BASIS INFORMATION
C     CENTER = 1,1,1...2,2,2...ETC
C     LABEL = S,S,S,P,D,F,ETC.  SEE INPUT MANUAL OF NBO FOR CONVENTION USED
      CALL GETREC(-1,'JOBARC','CENTERBF',NBAS,CENTERBF)
      WRITE(47,*)
      WRITE(47,*)'$BASIS'
      WRITE(47,*)'CENTER =',CENTERBF(1)
      DO I = 2, NBAS
         WRITE(47,*)CENTERBF(I)
      END DO
      CALL GFNAME('IIII',FNAME,ILENGTH)
      OPEN(UNIT=10,FILE='IIII',FORM='UNFORMATTED',ACCESS='SEQUENTIAL')
      CALL LOCATE(10,'LABBASIS')
      DO I = 1, NBAS
         READ(10)J,ATMLBL(I),ANGLBL(I),IJUNK
      END DO
      WRITE(47,*)
      PRINT*,ANGLBL
      WRITE(47,*)'LABEL ='
      IDTYPE=0
      DO I = 1, NBAS
         IF(ANGLBL(I).EQ.LABEL(1))THEN
            WRITE(47,*)'1'
         ELSE IF(ANGLBL(I).EQ.LABEL(2))THEN
            WRITE(47,*)'101'
         ELSE IF(ANGLBL(I).EQ.LABEL(3))THEN
            WRITE(47,*)'102'
         ELSE IF(ANGLBL(I).EQ.LABEL(4))THEN
            WRITE(47,*)'103'
         ELSE IF(ANGLBL(I).EQ.LABEL(5))THEN
            WRITE(47,*)'201'
            IDTYPE=IDTYPE+1
         ELSE IF(ANGLBL(I).EQ.LABEL(6))THEN
            WRITE(47,*)'204'
            IDTYPE=IDTYPE+1
         ELSE IF(ANGLBL(I).EQ.LABEL(7))THEN
            WRITE(47,*)'206'
            IDTYPE=IDTYPE+1
         ELSE IF(ANGLBL(I).EQ.LABEL(8))THEN
            WRITE(47,*)'202'
         ELSE IF(ANGLBL(I).EQ.LABEL(9))THEN
            WRITE(47,*)'203'
         ELSE IF(ANGLBL(I).EQ.LABEL(10))THEN
            WRITE(47,*)'205'
         END IF
      END DO
      WRITE(47,*)'$END'
      print*,'there are',IDTYPE,'D ORBITALS'
      WRITE(47,*)

C     NOW, DECIDE IF THERE ARE D ORBITALS IN THE BASIS SET.  IF SO
C     WE NEED TO SCALE THE OVERLAP INTEGRALS CUZ VMOL USES UNNORMALIZED
C     GAUSSIAN PRIMITIVES FOR THE XX,YY,AND ZZ INTEGRALS.
      CALL GETREC(-1,'JOBARC','AOOVRLAP',NBAS*NBAS*2,OVLAP)
      WRITE(47,*)'$OVERLAP'
C      IF(IDTYPE.EQ.0)THEN
C     GO AHEAD AND WRITE THE OVERLAP MATRIX TO FILE B/C EVERYTHING IS KOSHER
      WRITE(47,*)OVLAP
C      ELSE
C      CALL SCALE(NBAS,IDTYPE,ANGLBL,OVLAP)
C      WRITE(47,*)OVLAP
C      END IF
      WRITE(47,*)'$END'

C     I DON'T KNOW WHY I WRITE THIS TO FILE 23 BUT LEAVE IT FOR NOW
      OPEN(UNIT=23,FILE='OVERLAPS')
      WRITE(23,*)OVLAP
      CLOSE(23)

      CALL GETREC(-1,'JOBARC','SCFDENSA',NBAS*NBAS*2,OVLAP)
      WRITE(47,*)
      WRITE(47,*)'$DENSITY'
      WRITE(47,*)OVLAP
      WRITE(47,*)'$END'

      CALL GETREC(-1,'JOBARC','FOCKA',NBAS*NBAS*2,OVLAP)
C     THIS IS FOR MY PERSONAL EDIFICATION AND NEED NOT BE IN THE INTERFACE
      OPEN(UNIT=1,FILE='FOCK')
      WRITE(1,*)OVLAP
      CLOSE(1)

      WRITE(47,*)
      WRITE(47,*)'$FOCK'
      WRITE(47,*)OVLAP
      WRITE(47,*)'$END'
      CLOSE(47)

      RETURN
      END

