/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.config;

import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.util.StringUtils;

public class ColumnConfig {
    private String header;
    private String source;
    private String type;
    private Integer colSize;
    private Integer minSize;
    private ColumnListType listColumn;
    private String helpDescription;
    private boolean nonEmpty;
    private SortType sortBy;

    public ColumnConfig(String header, String source, String type, Integer colSize, Integer minSize, ColumnListType listColumn, String sortBy, boolean nonEmpty) {
        this.header = header;
        this.source = source;
        this.type = type;
        this.colSize = colSize;
        this.minSize = minSize;
        this.listColumn = listColumn;
        this.sortBy = SortType.parse(sortBy);
        this.nonEmpty = nonEmpty;
    }

    public SortType getSortBy() {
        return this.sortBy;
    }

    public String getHelpDescription() {
        return this.helpDescription;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setHelpDescription(String helpDescription) {
        this.helpDescription = helpDescription;
    }

    public String getHeader() {
        return this.header;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public Integer getColSize() {
        return this.colSize;
    }

    public ColumnListType getListColumn() {
        return this.listColumn;
    }

    public void setSortBy(SortType sortBy) {
        this.sortBy = sortBy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.colSize == null ? 0 : this.colSize.hashCode());
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + (this.helpDescription == null ? 0 : this.helpDescription.hashCode());
        result = 31 * result + (this.listColumn == null ? 0 : this.listColumn.hashCode());
        result = 31 * result + (this.minSize == null ? 0 : this.minSize.hashCode());
        result = 31 * result + (this.sortBy == null ? 0 : this.sortBy.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnConfig)) {
            return false;
        }
        ColumnConfig other = (ColumnConfig)obj;
        if (this.colSize == null ? other.colSize != null : !this.colSize.equals(other.colSize)) {
            return false;
        }
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        if (this.helpDescription == null ? other.helpDescription != null : !this.helpDescription.equals(other.helpDescription)) {
            return false;
        }
        if (this.listColumn == null ? other.listColumn != null : !this.listColumn.equals((Object)other.listColumn)) {
            return false;
        }
        if (this.minSize == null ? other.minSize != null : !this.minSize.equals(other.minSize)) {
            return false;
        }
        if (this.sortBy == null ? other.sortBy != null : !this.sortBy.equals((Object)other.sortBy)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public boolean getNonEmpty() {
        return this.nonEmpty;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortType {
        ASC,
        DESC,
        DATEASC,
        DATEDESC;


        public static SortType parse(String stringType) throws IllegalArgumentException {
            if (StringUtils.notEmpty(stringType)) {
                for (SortType t : SortType.values()) {
                    if (!t.name().equalsIgnoreCase(stringType)) continue;
                    return t;
                }
                throw new ConfigurationErrorException("Illegal sort type: " + stringType);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColumnListType {
        ALL,
        SHORT,
        LONG;


        public static ColumnListType parse(String stringType) throws IllegalArgumentException {
            for (ColumnListType t : ColumnListType.values()) {
                if (!t.name().equalsIgnoreCase(stringType)) continue;
                return t;
            }
            throw new ConfigurationErrorException("Illegal column list type: " + stringType);
        }
    }
}

