// Editeur de playlist Freebox
// Copyright (C) 2005 Freebox S.A.
//
// playlist.h
// This file is part of fbx-playlist.
//
// fbx-playlist is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// fbx-playlist is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with fbx-playlist; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <QMainWindow>
#include <QTextStream>
#include <QDialog>

#include "ui_playlist.h"


class Playlist: public QMainWindow,
		private Ui::Playlist
{
    Q_OBJECT

    public:
	Playlist();
	void open(const QString &filename);

    private slots:
	void fileNew();
	void fileOpen();
	void fileSave();
	void fileSaveAs();

	void helpHelp();
	void helpLicense();
	void helpAbout();

	void itemNew();
	void itemAdd();
	void itemAddFilms();
	void itemAddMusic();
	void itemAddPhotos();
	void itemAddCD();
	void itemAddDVD();
	void itemAddWebMedia();
	void itemAddFiles(const QString &filter);
	void itemDel();
	void itemSelect();
	void itemUpdateName();
	void itemUpdateLocation();
	void itemUpdateSound();

	void moveUp();
	void moveDown();
	void enableButtons();

    private:
        bool modified;
	bool lock_modified;
	QString filename;
	QDialog add_window;

	QAction *fileNewAction;
	QAction *fileOpenAction;
	QAction *fileSaveAction;
	QAction *fileSaveAsAction;
	QAction *fileQuitAction;

	QAction *helpHelpAction;
	QAction *helpLicenseAction;
	QAction *helpAboutAction;

	void setupMenuBar();
	void setupConnections();
	void setModified(bool m);
	void switchItems(int idx1, int idx2);
	int checkSave();
	void closeEvent(QCloseEvent *event);
	void playlistToStream(QTextStream &stream);

	QTreeWidgetItem *getItem();
	QTreeWidgetItem *itemAddToPlaylist(const QString &name,
					   const QString &location);
};

#endif // PLAYLIST_H
