/*
 * Copyright (c) 2012-2016 VMware, Inc.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of EITHER the GNU General Public License
 * version 2 as published by the Free Software Foundation or the BSD
 * 2-Clause License. This program is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License version 2 for more details at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program available in the file COPYING in the main
 * directory of this source tree.
 *
 * The BSD 2-Clause License
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __PVRDMA_ABI_FIX_H__
#define __PVRDMA_ABI_FIX_H__

#include <infiniband/kern-abi.h>
#include <rdma/vmw_pvrdma-abi.h>

struct user_pvrdma_alloc_ucontext_resp {
	struct ib_uverbs_get_context_resp		ibv_resp;
	struct pvrdma_alloc_ucontext_resp	udata;
};

struct user_pvrdma_alloc_pd_resp {
	struct ib_uverbs_alloc_pd_resp	ibv_resp;
	struct pvrdma_alloc_pd_resp	udata;
};

struct user_pvrdma_create_cq {
	struct ibv_create_cq		ibv_cmd;
	struct pvrdma_create_cq		udata;
};

struct user_pvrdma_create_cq_resp {
	struct ib_uverbs_create_cq_resp	ibv_resp;
	struct pvrdma_create_cq_resp	udata;
};

struct user_pvrdma_create_srq {
	struct ibv_create_srq		ibv_cmd;
	struct pvrdma_create_srq	udata;
};

struct user_pvrdma_create_srq_resp {
	struct ib_uverbs_create_srq_resp	ibv_resp;
	struct pvrdma_create_srq_resp	udata;
};

struct user_pvrdma_create_qp {
	struct ibv_create_qp		ibv_cmd;
	struct pvrdma_create_qp		udata;
};

#endif /* __PVRDMA_ABI_FIX_H__ */
