; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -mattr=+2e3 | FileCheck %s

define i32 @selectRR_eq_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_eq_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_eq_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_eq_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_eq_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_eq_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmpne16 a0, a3
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_eq_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_eq_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_eq_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_eq_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    addu16 a0, sp
; CHECK-NEXT:    mov16 a1, a0
; CHECK-NEXT:    addi16 a0, sp, 8
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    ld16.w a0, (a1, 0)
; CHECK-NEXT:    ld16.w a1, (a1, 4)
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_eq_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_eq_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 4)
; CHECK-NEXT:    ld32.w t1, (sp, 0)
; CHECK-NEXT:    xori32 a0, a0, 10
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movf32 a2, t1
; CHECK-NEXT:    movf32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_eq_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_eq_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    xor16 a0, l0
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movf32 a2, t1
; CHECK-NEXT:    movf32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_eq_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_eq_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_eq_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_eq_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_eq_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_eq_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_eq_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_eq_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei32 a0, 2033
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_eq_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_eq_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_eq_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_eq_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_eq_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_eq_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_eq_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_eq_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei32 a0, 241
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_eq_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_eq_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_eq_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_eq_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    mov16 a0, a3
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_eq_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_eq_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_eq_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_eq_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_eq_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_eq_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_ne_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_ne_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_ne_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_ne_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_ne_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_ne_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmpne16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_ne_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_ne_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_ne_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_ne_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    addu16 a0, sp
; CHECK-NEXT:    mov16 a1, a0
; CHECK-NEXT:    addi16 a0, sp, 8
; CHECK-NEXT:    movt32 a1, a0
; CHECK-NEXT:    ld16.w a0, (a1, 0)
; CHECK-NEXT:    ld16.w a1, (a1, 4)
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_ne_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_ne_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 4)
; CHECK-NEXT:    ld32.w t1, (sp, 0)
; CHECK-NEXT:    xori32 a0, a0, 10
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_ne_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_ne_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    xor16 a0, l0
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_ne_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_ne_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_ne_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_ne_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_ne_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_ne_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_ne_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_ne_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei32 a0, 2033
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_ne_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_ne_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_ne_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_ne_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_ne_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_ne_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_ne_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_ne_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei32 a0, 241
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_ne_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_ne_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_ne_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_ne_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_ne_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_ne_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_ne_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_ne_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_ne_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_ne_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_ugt_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_ugt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_ugt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_ugt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_ugt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_ugt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_ugt_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_ugt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_ugt_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_ugt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 8
; CHECK-NEXT:    addi16 a0, sp, 16
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_ugt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_ugt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movi16 l0, 10
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_ugt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_ugt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_ugt_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_ugt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_ugt_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_ugt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_ugt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_ugt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_ugt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_ugt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi32 a3, 2033
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_ugt_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_ugt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_ugt_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_ugt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_ugt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_ugt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_ugt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_ugt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 241
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_ugt_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_ugt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_ugt_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_ugt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_ugt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_ugt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_ugt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_ugt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_ugt_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_ugt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_uge_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_uge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_uge_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_uge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_uge_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_uge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2032
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_uge_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_uge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_uge_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_uge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 16
; CHECK-NEXT:    addi16 a0, sp, 24
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_uge_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_uge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movi16 l0, 9
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_uge_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_uge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2032
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_uge_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_uge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_uge_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_uge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_uge_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_uge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_uge_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_uge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi32 a3, 2032
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_uge_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_uge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_uge_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_uge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_uge_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_uge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_uge_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_uge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 240
; CHECK-NEXT:    cmphs16 a3, a0
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_uge_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_uge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_uge_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_uge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mov16 a0, a3
; CHECK-NEXT:    movt32 a0, a2
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a0, a3
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_uge_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_uge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_uge_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_uge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_uge_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_uge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_ult_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_ult_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_ult_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_ult_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_ult_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_ult_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmphs16 a0, a3
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_ult_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_ult_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_ult_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_ult_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 8
; CHECK-NEXT:    addi16 a0, sp, 16
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_ult_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_ult_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    ld32.w t0, (sp, 12)
; CHECK-NEXT:    ld32.w t1, (sp, 8)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    st16.w a2, (sp, 0)
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    ld16.w a2, (sp, 0)
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_ult_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_ult_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    cmphs16 a0, l0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_ult_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_ult_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_ult_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_ult_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_ult_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_ult_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_ult_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_ult_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi32 a0, 2033
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_ult_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_ult_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_ult_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_ult_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_ult_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_ult_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_ult_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_ult_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi32 a0, 241
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_ult_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_ult_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_ult_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_ult_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_ult_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_ult_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_ult_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_ult_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_ult_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_ult_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}

define i32 @selectRR_ule_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_ule_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_ule_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_ule_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_ule_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_ule_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2034
; CHECK-NEXT:    cmphs16 a0, a3
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_ule_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_ule_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_ule_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_ule_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 16
; CHECK-NEXT:    addi16 a0, sp, 24
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_ule_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_ule_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    ld32.w t0, (sp, 12)
; CHECK-NEXT:    ld32.w t1, (sp, 8)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    st16.w a2, (sp, 0)
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    ld16.w a2, (sp, 0)
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_ule_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_ule_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    ld32.w t0, (sp, 8)
; CHECK-NEXT:    ld32.w t1, (sp, 4)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2034
; CHECK-NEXT:    cmphs16 a0, l0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_ule_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_ule_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_ule_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_ule_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_ule_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_ule_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_ule_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_ule_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi32 a0, 2034
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_ule_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_ule_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_ule_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_ule_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_ule_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_ule_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_ule_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_ule_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi32 a0, 242
; CHECK-NEXT:    movf32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_ule_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_ule_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_ule_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_ule_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_ule_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_ule_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_ule_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_ule_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_ule_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_ule_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_sgt_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_sgt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_sgt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_sgt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_sgt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_sgt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_sgt_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_sgt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_sgt_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_sgt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 12
; CHECK-NEXT:    addi16 a0, sp, 20
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_sgt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_sgt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 l0, a1
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movi16 l0, 10
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti32 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_sgt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_sgt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 l0, a1
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti32 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_sgt_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_sgt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_sgt_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_sgt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_sgt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_sgt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_sgt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_sgt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi32 a3, 2033
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_sgt_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_sgt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_sgt_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_sgt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_sgt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_sgt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 10
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_sgt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_sgt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a3, 65535
; CHECK-NEXT:    ori32 a3, a3, 65521
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_sgt_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_sgt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_sgt_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_sgt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_sgt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_sgt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_sgt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_sgt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_sgt_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_sgt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_sge_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_sge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_sge_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_sge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_sge_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_sge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2032
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_sge_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_sge_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_sge_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_sge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 a1, sp, 12
; CHECK-NEXT:    addi16 a2, sp, 20
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    ld16.w a0, (a1, 0)
; CHECK-NEXT:    ld16.w a1, (a1, 4)
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_sge_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_sge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 l0, a1
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movi16 l0, 9
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti32 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_sge_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_sge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 l0, a1
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2032
; CHECK-NEXT:    cmphs16 l0, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti32 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_sge_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_sge_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_sge_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_sge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_sge_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_sge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_sge_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_sge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi32 a3, 2032
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_sge_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_sge_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_sge_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_sge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_sge_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_sge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a3, 9
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_sge_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_sge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a3, 65535
; CHECK-NEXT:    ori32 a3, a3, 65520
; CHECK-NEXT:    cmplt16 a3, a0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_sge_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_sge_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_sge_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_sge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_sge_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_sge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a2, a1
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_sge_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_sge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_sge_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_sge_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}


define i32 @selectRR_slt_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_slt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_slt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_slt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_slt_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_slt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2033
; CHECK-NEXT:    cmplt16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_slt_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_slt_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_slt_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_slt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    addi16 a2, sp, 12
; CHECK-NEXT:    addi16 a0, sp, 20
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, a0
; CHECK-NEXT:    ld16.w a0, (a2, 0)
; CHECK-NEXT:    ld16.w a1, (a2, 4)
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_slt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_slt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 a1, l0
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 8)
; CHECK-NEXT:    btsti32 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_slt_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_slt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 a1, l0
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2033
; CHECK-NEXT:    cmphs16 a0, l0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti32 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_slt_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_slt_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_slt_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_slt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_slt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_slt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_slt_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_slt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti32 a0, 2033
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_slt_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_slt_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_slt_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_slt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_slt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_slt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_slt_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_slt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a3, 65535
; CHECK-NEXT:    ori32 a3, a3, 65521
; CHECK-NEXT:    cmplt16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_slt_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_slt_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_slt_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_slt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a3, a2
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_slt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_slt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_slt_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_slt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_slt_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_slt_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}

define i32 @selectRR_sle_i32(i32 %x, i32 %y, i32 %n, i32 %m) {
; CHECK-LABEL: selectRR_sle_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i32 %y, %x
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRI_sle_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRI_sle_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 10
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectRX_sle_i32(i32 %x, i32 %n, i32 %m) {
; CHECK-LABEL: selectRX_sle_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a3, 729
; CHECK-NEXT:    ori32 a3, a3, 2034
; CHECK-NEXT:    cmplt16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 47777777
  %ret = select i1 %icmp, i32 %m, i32 %n
  ret i32 %ret
}

define i32 @selectC_sle_i32(i1 %c, i32 %n, i32 %m) {
; CHECK-LABEL: selectC_sle_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i32 %m, i32 %n
  ret i32 %ret
}

define i64 @selectRR_sle_i64(i64 %x, i64 %y, i64 %n, i64 %m) {
; CHECK-LABEL: selectRR_sle_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 a1, sp, 12
; CHECK-NEXT:    addi16 a2, sp, 20
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    ld16.w a0, (a1, 0)
; CHECK-NEXT:    ld16.w a1, (a1, 4)
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i64 %y, %x
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRI_sle_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRI_sle_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 a1, l0
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 8)
; CHECK-NEXT:    btsti32 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i64 %x, 10
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectRX_sle_i64(i64 %x, i64 %n, i64 %m) {
; CHECK-LABEL: selectRX_sle_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset l0, -4
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ld32.w t0, (sp, 20)
; CHECK-NEXT:    ld32.w t1, (sp, 16)
; CHECK-NEXT:    movi16 l0, 0
; CHECK-NEXT:    cmplt16 a1, l0
; CHECK-NEXT:    mvc32 l0
; CHECK-NEXT:    st16.w l0, (sp, 8)
; CHECK-NEXT:    movih32 l0, 729
; CHECK-NEXT:    ori32 l0, l0, 2034
; CHECK-NEXT:    cmphs16 a0, l0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w l0, (sp, 4)
; CHECK-NEXT:    btsti32 l0, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a2, t1
; CHECK-NEXT:    movt32 a3, t0
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    mov16 a1, a3
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i64 %x, 47777777
  %ret = select i1 %icmp, i64 %m, i64 %n
  ret i64 %ret
}

define i64 @selectC_sle_i64(i1 %c, i64 %n, i64 %m) {
; CHECK-LABEL: selectC_sle_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld32.w t0, (sp, 0)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a3
; CHECK-NEXT:    movt32 a2, t0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    mov16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i64 %m, i64 %n
  ret i64 %ret
}


define i16 @selectRR_sle_i16(i16 %x, i16 %y, i16 %n, i16 %m) {
; CHECK-LABEL: selectRR_sle_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i16 %y, %x
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRI_sle_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRI_sle_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i16 %x, 10
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectRX_sle_i16(i16 %x, i16 %n, i16 %m) {
; CHECK-LABEL: selectRX_sle_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti32 a0, 2034
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i16 %x, 47777777
  %ret = select i1 %icmp, i16 %m, i16 %n
  ret i16 %ret
}

define i16 @selectC_sle_i16(i1 %c, i16 %n, i16 %m) {
; CHECK-LABEL: selectC_sle_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i16 %m, i16 %n
  ret i16 %ret
}


define i8 @selectRR_sle_i8(i8 %x, i8 %y, i8 %n, i8 %m) {
; CHECK-LABEL: selectRR_sle_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    movf32 a2, a3
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i8 %y, %x
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRI_sle_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRI_sle_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i8 %x, 10
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectRX_sle_i8(i8 %x, i8 %n, i8 %m) {
; CHECK-LABEL: selectRX_sle_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a3, 65535
; CHECK-NEXT:    ori32 a3, a3, 65522
; CHECK-NEXT:    cmplt16 a0, a3
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i8 %x, 47777777
  %ret = select i1 %icmp, i8 %m, i8 %n
  ret i8 %ret
}

define i8 @selectC_sle_i8(i1 %c, i8 %n, i8 %m) {
; CHECK-LABEL: selectC_sle_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i8 %m, i8 %n
  ret i8 %ret
}


define i1 @selectRR_sle_i1(i1 %x, i1 %y, i1 %n, i1 %m) {
; CHECK-LABEL: selectRR_sle_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mov16 a0, a3
; CHECK-NEXT:    movt32 a0, a2
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movt32 a0, a3
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i1 %y, %x
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRI_sle_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRI_sle_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i1 %x, 10
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectRX_sle_i1(i1 %x, i1 %n, i1 %m) {
; CHECK-LABEL: selectRX_sle_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i1 %x, 47777777
  %ret = select i1 %icmp, i1 %m, i1 %n
  ret i1 %ret
}

define i1 @selectC_sle_i1(i1 %c, i1 %n, i1 %m) {
; CHECK-LABEL: selectC_sle_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    movt32 a1, a2
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %ret = select i1 %c, i1 %m, i1 %n
  ret i1 %ret
}
