// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve.fp -mfloat-abi hard -fallow-half-arguments-and-returns -O0 -disable-O0-optnone -S -emit-llvm -o - %s | opt -S -mem2reg | FileCheck %s
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve.fp -mfloat-abi hard -fallow-half-arguments-and-returns -O0 -disable-O0-optnone -DPOLYMORPHIC -S -emit-llvm -o - %s | opt -S -mem2reg | FileCheck %s

// REQUIRES: aarch64-registered-target || arm-registered-target

#include <arm_mve.h>

// CHECK-LABEL: @test_vshrnbq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 3, i32 0, i32 0, i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vshrnbq_n_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vshrnbq(a, b, 3);
#else /* POLYMORPHIC */
    return vshrnbq_n_s16(a, b, 3);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrnbq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 9, i32 0, i32 0, i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vshrnbq_n_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vshrnbq(a, b, 9);
#else /* POLYMORPHIC */
    return vshrnbq_n_s32(a, b, 9);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrnbq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 0, i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vshrnbq_n_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vshrnbq(a, b, 1);
#else /* POLYMORPHIC */
    return vshrnbq_n_u16(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrnbq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 3, i32 0, i32 0, i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vshrnbq_n_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vshrnbq(a, b, 3);
#else /* POLYMORPHIC */
    return vshrnbq_n_u32(a, b, 3);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrntq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 0, i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vshrntq_n_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vshrntq(a, b, 1);
#else /* POLYMORPHIC */
    return vshrntq_n_s16(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrntq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 10, i32 0, i32 0, i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vshrntq_n_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vshrntq(a, b, 10);
#else /* POLYMORPHIC */
    return vshrntq_n_s32(a, b, 10);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrntq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 6, i32 0, i32 0, i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vshrntq_n_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vshrntq(a, b, 6);
#else /* POLYMORPHIC */
    return vshrntq_n_u16(a, b, 6);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrntq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 10, i32 0, i32 0, i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vshrntq_n_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vshrntq(a, b, 10);
#else /* POLYMORPHIC */
    return vshrntq_n_u32(a, b, 10);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrnbq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 4, i32 0, i32 0, i32 0, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vshrnbq_m_n_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshrnbq_m(a, b, 4, p);
#else /* POLYMORPHIC */
    return vshrnbq_m_n_s16(a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrnbq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 13, i32 0, i32 0, i32 0, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vshrnbq_m_n_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshrnbq_m(a, b, 13, p);
#else /* POLYMORPHIC */
    return vshrnbq_m_n_s32(a, b, 13, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrnbq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 7, i32 0, i32 0, i32 1, i32 1, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vshrnbq_m_n_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshrnbq_m(a, b, 7, p);
#else /* POLYMORPHIC */
    return vshrnbq_m_n_u16(a, b, 7, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrnbq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 15, i32 0, i32 0, i32 1, i32 1, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vshrnbq_m_n_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshrnbq_m(a, b, 15, p);
#else /* POLYMORPHIC */
    return vshrnbq_m_n_u32(a, b, 15, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrntq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 6, i32 0, i32 0, i32 0, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vshrntq_m_n_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshrntq_m(a, b, 6, p);
#else /* POLYMORPHIC */
    return vshrntq_m_n_s16(a, b, 6, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrntq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 13, i32 0, i32 0, i32 0, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vshrntq_m_n_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshrntq_m(a, b, 13, p);
#else /* POLYMORPHIC */
    return vshrntq_m_n_s32(a, b, 13, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrntq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 0, i32 1, i32 1, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vshrntq_m_n_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshrntq_m(a, b, 1, p);
#else /* POLYMORPHIC */
    return vshrntq_m_n_u16(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshrntq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 10, i32 0, i32 0, i32 1, i32 1, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vshrntq_m_n_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshrntq_m(a, b, 10, p);
#else /* POLYMORPHIC */
    return vshrntq_m_n_u32(a, b, 10, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrnbq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 5, i32 0, i32 1, i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vrshrnbq_n_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vrshrnbq(a, b, 5);
#else /* POLYMORPHIC */
    return vrshrnbq_n_s16(a, b, 5);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrnbq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 10, i32 0, i32 1, i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vrshrnbq_n_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vrshrnbq(a, b, 10);
#else /* POLYMORPHIC */
    return vrshrnbq_n_s32(a, b, 10);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrnbq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 2, i32 0, i32 1, i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vrshrnbq_n_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vrshrnbq(a, b, 2);
#else /* POLYMORPHIC */
    return vrshrnbq_n_u16(a, b, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrnbq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 12, i32 0, i32 1, i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vrshrnbq_n_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vrshrnbq(a, b, 12);
#else /* POLYMORPHIC */
    return vrshrnbq_n_u32(a, b, 12);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrntq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 4, i32 0, i32 1, i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vrshrntq_n_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vrshrntq(a, b, 4);
#else /* POLYMORPHIC */
    return vrshrntq_n_s16(a, b, 4);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrntq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 11, i32 0, i32 1, i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vrshrntq_n_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vrshrntq(a, b, 11);
#else /* POLYMORPHIC */
    return vrshrntq_n_s32(a, b, 11);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrntq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 1, i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vrshrntq_n_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vrshrntq(a, b, 1);
#else /* POLYMORPHIC */
    return vrshrntq_n_u16(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrntq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 6, i32 0, i32 1, i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vrshrntq_n_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vrshrntq(a, b, 6);
#else /* POLYMORPHIC */
    return vrshrntq_n_u32(a, b, 6);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrnbq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 1, i32 0, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vrshrnbq_m_n_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshrnbq_m(a, b, 1, p);
#else /* POLYMORPHIC */
    return vrshrnbq_m_n_s16(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrnbq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 14, i32 0, i32 1, i32 0, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vrshrnbq_m_n_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshrnbq_m(a, b, 14, p);
#else /* POLYMORPHIC */
    return vrshrnbq_m_n_s32(a, b, 14, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrnbq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 2, i32 0, i32 1, i32 1, i32 1, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vrshrnbq_m_n_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshrnbq_m(a, b, 2, p);
#else /* POLYMORPHIC */
    return vrshrnbq_m_n_u16(a, b, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrnbq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 12, i32 0, i32 1, i32 1, i32 1, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vrshrnbq_m_n_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshrnbq_m(a, b, 12, p);
#else /* POLYMORPHIC */
    return vrshrnbq_m_n_u32(a, b, 12, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrntq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 4, i32 0, i32 1, i32 0, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vrshrntq_m_n_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshrntq_m(a, b, 4, p);
#else /* POLYMORPHIC */
    return vrshrntq_m_n_s16(a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrntq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 6, i32 0, i32 1, i32 0, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vrshrntq_m_n_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshrntq_m(a, b, 6, p);
#else /* POLYMORPHIC */
    return vrshrntq_m_n_s32(a, b, 6, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrntq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 6, i32 0, i32 1, i32 1, i32 1, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vrshrntq_m_n_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshrntq_m(a, b, 6, p);
#else /* POLYMORPHIC */
    return vrshrntq_m_n_u16(a, b, 6, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshrntq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 10, i32 0, i32 1, i32 1, i32 1, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vrshrntq_m_n_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshrntq_m(a, b, 10, p);
#else /* POLYMORPHIC */
    return vrshrntq_m_n_u32(a, b, 10, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrnbq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 7, i32 1, i32 0, i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqshrnbq_n_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqshrnbq(a, b, 7);
#else /* POLYMORPHIC */
    return vqshrnbq_n_s16(a, b, 7);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrnbq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 15, i32 1, i32 0, i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqshrnbq_n_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqshrnbq(a, b, 15);
#else /* POLYMORPHIC */
    return vqshrnbq_n_s32(a, b, 15);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrnbq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 3, i32 1, i32 0, i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqshrnbq_n_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vqshrnbq(a, b, 3);
#else /* POLYMORPHIC */
    return vqshrnbq_n_u16(a, b, 3);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrnbq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 3, i32 1, i32 0, i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqshrnbq_n_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vqshrnbq(a, b, 3);
#else /* POLYMORPHIC */
    return vqshrnbq_n_u32(a, b, 3);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrntq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 5, i32 1, i32 0, i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqshrntq_n_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqshrntq(a, b, 5);
#else /* POLYMORPHIC */
    return vqshrntq_n_s16(a, b, 5);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrntq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 6, i32 1, i32 0, i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqshrntq_n_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqshrntq(a, b, 6);
#else /* POLYMORPHIC */
    return vqshrntq_n_s32(a, b, 6);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrntq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 0, i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqshrntq_n_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vqshrntq(a, b, 1);
#else /* POLYMORPHIC */
    return vqshrntq_n_u16(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrntq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 15, i32 1, i32 0, i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqshrntq_n_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vqshrntq(a, b, 15);
#else /* POLYMORPHIC */
    return vqshrntq_n_u32(a, b, 15);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrnbq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 7, i32 1, i32 0, i32 0, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqshrnbq_m_n_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrnbq_m(a, b, 7, p);
#else /* POLYMORPHIC */
    return vqshrnbq_m_n_s16(a, b, 7, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrnbq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 0, i32 0, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqshrnbq_m_n_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrnbq_m(a, b, 1, p);
#else /* POLYMORPHIC */
    return vqshrnbq_m_n_s32(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrnbq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 0, i32 1, i32 1, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqshrnbq_m_n_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrnbq_m(a, b, 1, p);
#else /* POLYMORPHIC */
    return vqshrnbq_m_n_u16(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrnbq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 8, i32 1, i32 0, i32 1, i32 1, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqshrnbq_m_n_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrnbq_m(a, b, 8, p);
#else /* POLYMORPHIC */
    return vqshrnbq_m_n_u32(a, b, 8, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrntq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 0, i32 0, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqshrntq_m_n_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrntq_m(a, b, 1, p);
#else /* POLYMORPHIC */
    return vqshrntq_m_n_s16(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrntq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 11, i32 1, i32 0, i32 0, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqshrntq_m_n_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrntq_m(a, b, 11, p);
#else /* POLYMORPHIC */
    return vqshrntq_m_n_s32(a, b, 11, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrntq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 3, i32 1, i32 0, i32 1, i32 1, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqshrntq_m_n_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrntq_m(a, b, 3, p);
#else /* POLYMORPHIC */
    return vqshrntq_m_n_u16(a, b, 3, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrntq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 0, i32 1, i32 1, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqshrntq_m_n_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrntq_m(a, b, 1, p);
#else /* POLYMORPHIC */
    return vqshrntq_m_n_u32(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrunbq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 5, i32 1, i32 0, i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqshrunbq_n_s16(uint8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqshrunbq(a, b, 5);
#else /* POLYMORPHIC */
    return vqshrunbq_n_s16(a, b, 5);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrunbq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 13, i32 1, i32 0, i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqshrunbq_n_s32(uint16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqshrunbq(a, b, 13);
#else /* POLYMORPHIC */
    return vqshrunbq_n_s32(a, b, 13);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshruntq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 2, i32 1, i32 0, i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqshruntq_n_s16(uint8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqshruntq(a, b, 2);
#else /* POLYMORPHIC */
    return vqshruntq_n_s16(a, b, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshruntq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 7, i32 1, i32 0, i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqshruntq_n_s32(uint16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqshruntq(a, b, 7);
#else /* POLYMORPHIC */
    return vqshruntq_n_s32(a, b, 7);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrunbq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 7, i32 1, i32 0, i32 1, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqshrunbq_m_n_s16(uint8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrunbq_m(a, b, 7, p);
#else /* POLYMORPHIC */
    return vqshrunbq_m_n_s16(a, b, 7, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshrunbq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 7, i32 1, i32 0, i32 1, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqshrunbq_m_n_s32(uint16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshrunbq_m(a, b, 7, p);
#else /* POLYMORPHIC */
    return vqshrunbq_m_n_s32(a, b, 7, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshruntq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 7, i32 1, i32 0, i32 1, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqshruntq_m_n_s16(uint8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshruntq_m(a, b, 7, p);
#else /* POLYMORPHIC */
    return vqshruntq_m_n_s16(a, b, 7, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshruntq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 7, i32 1, i32 0, i32 1, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqshruntq_m_n_s32(uint16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshruntq_m(a, b, 7, p);
#else /* POLYMORPHIC */
    return vqshruntq_m_n_s32(a, b, 7, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrnbq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 5, i32 1, i32 1, i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqrshrnbq_n_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqrshrnbq(a, b, 5);
#else /* POLYMORPHIC */
    return vqrshrnbq_n_s16(a, b, 5);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrnbq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 13, i32 1, i32 1, i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqrshrnbq_n_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqrshrnbq(a, b, 13);
#else /* POLYMORPHIC */
    return vqrshrnbq_n_s32(a, b, 13);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrnbq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 7, i32 1, i32 1, i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqrshrnbq_n_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vqrshrnbq(a, b, 7);
#else /* POLYMORPHIC */
    return vqrshrnbq_n_u16(a, b, 7);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrnbq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 8, i32 1, i32 1, i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqrshrnbq_n_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vqrshrnbq(a, b, 8);
#else /* POLYMORPHIC */
    return vqrshrnbq_n_u32(a, b, 8);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrntq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 7, i32 1, i32 1, i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqrshrntq_n_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqrshrntq(a, b, 7);
#else /* POLYMORPHIC */
    return vqrshrntq_n_s16(a, b, 7);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrntq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 2, i32 1, i32 1, i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqrshrntq_n_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqrshrntq(a, b, 2);
#else /* POLYMORPHIC */
    return vqrshrntq_n_s32(a, b, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrntq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 1, i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqrshrntq_n_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vqrshrntq(a, b, 1);
#else /* POLYMORPHIC */
    return vqrshrntq_n_u16(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrntq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 11, i32 1, i32 1, i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqrshrntq_n_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vqrshrntq(a, b, 11);
#else /* POLYMORPHIC */
    return vqrshrntq_n_u32(a, b, 11);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrnbq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 2, i32 1, i32 1, i32 0, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqrshrnbq_m_n_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrnbq_m(a, b, 2, p);
#else /* POLYMORPHIC */
    return vqrshrnbq_m_n_s16(a, b, 2, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrnbq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 12, i32 1, i32 1, i32 0, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqrshrnbq_m_n_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrnbq_m(a, b, 12, p);
#else /* POLYMORPHIC */
    return vqrshrnbq_m_n_s32(a, b, 12, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrnbq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 5, i32 1, i32 1, i32 1, i32 1, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqrshrnbq_m_n_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrnbq_m(a, b, 5, p);
#else /* POLYMORPHIC */
    return vqrshrnbq_m_n_u16(a, b, 5, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrnbq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 11, i32 1, i32 1, i32 1, i32 1, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqrshrnbq_m_n_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrnbq_m(a, b, 11, p);
#else /* POLYMORPHIC */
    return vqrshrnbq_m_n_u32(a, b, 11, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrntq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 4, i32 1, i32 1, i32 0, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqrshrntq_m_n_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrntq_m(a, b, 4, p);
#else /* POLYMORPHIC */
    return vqrshrntq_m_n_s16(a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrntq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 6, i32 1, i32 1, i32 0, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqrshrntq_m_n_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrntq_m(a, b, 6, p);
#else /* POLYMORPHIC */
    return vqrshrntq_m_n_s32(a, b, 6, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrntq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 7, i32 1, i32 1, i32 1, i32 1, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqrshrntq_m_n_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrntq_m(a, b, 7, p);
#else /* POLYMORPHIC */
    return vqrshrntq_m_n_u16(a, b, 7, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrntq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 15, i32 1, i32 1, i32 1, i32 1, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqrshrntq_m_n_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrntq_m(a, b, 15, p);
#else /* POLYMORPHIC */
    return vqrshrntq_m_n_u32(a, b, 15, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrunbq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 7, i32 1, i32 1, i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqrshrunbq_n_s16(uint8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqrshrunbq(a, b, 7);
#else /* POLYMORPHIC */
    return vqrshrunbq_n_s16(a, b, 7);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrunbq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 1, i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqrshrunbq_n_s32(uint16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqrshrunbq(a, b, 1);
#else /* POLYMORPHIC */
    return vqrshrunbq_n_s32(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshruntq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 1, i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqrshruntq_n_s16(uint8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqrshruntq(a, b, 1);
#else /* POLYMORPHIC */
    return vqrshruntq_n_s16(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshruntq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 3, i32 1, i32 1, i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqrshruntq_n_s32(uint16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqrshruntq(a, b, 3);
#else /* POLYMORPHIC */
    return vqrshruntq_n_s32(a, b, 3);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrunbq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 4, i32 1, i32 1, i32 1, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqrshrunbq_m_n_s16(uint8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrunbq_m(a, b, 4, p);
#else /* POLYMORPHIC */
    return vqrshrunbq_m_n_s16(a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshrunbq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 10, i32 1, i32 1, i32 1, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqrshrunbq_m_n_s32(uint16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshrunbq_m(a, b, 10, p);
#else /* POLYMORPHIC */
    return vqrshrunbq_m_n_s32(a, b, 10, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshruntq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshrn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 3, i32 1, i32 1, i32 1, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqrshruntq_m_n_s16(uint8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshruntq_m(a, b, 3, p);
#else /* POLYMORPHIC */
    return vqrshruntq_m_n_s16(a, b, 3, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshruntq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshrn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 13, i32 1, i32 1, i32 1, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqrshruntq_m_n_s32(uint16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshruntq_m(a, b, 13, p);
#else /* POLYMORPHIC */
    return vqrshruntq_m_n_s32(a, b, 13, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_n_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vsli.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 2)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vsliq_n_s8(int8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vsliq(a, b, 2);
#else /* POLYMORPHIC */
    return vsliq_n_s8(a, b, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vsli.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 10)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vsliq_n_s16(int16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vsliq(a, b, 10);
#else /* POLYMORPHIC */
    return vsliq_n_s16(a, b, 10);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vsli.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vsliq_n_s32(int32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vsliq(a, b, 1);
#else /* POLYMORPHIC */
    return vsliq_n_s32(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vsli.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vsliq_n_u8(uint8x16_t a, uint8x16_t b)
{
#ifdef POLYMORPHIC
    return vsliq(a, b, 1);
#else /* POLYMORPHIC */
    return vsliq_n_u8(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vsli.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vsliq_n_u16(uint16x8_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vsliq(a, b, 1);
#else /* POLYMORPHIC */
    return vsliq_n_u16(a, b, 1);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vsli.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 28)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vsliq_n_u32(uint32x4_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vsliq(a, b, 28);
#else /* POLYMORPHIC */
    return vsliq_n_u32(a, b, 28);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_m_n_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vsli.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 4, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vsliq_m_n_s8(int8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsliq_m(a, b, 4, p);
#else /* POLYMORPHIC */
    return vsliq_m_n_s8(a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vsli.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vsliq_m_n_s16(int16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsliq_m(a, b, 1, p);
#else /* POLYMORPHIC */
    return vsliq_m_n_s16(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vsli.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vsliq_m_n_s32(int32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsliq_m(a, b, 1, p);
#else /* POLYMORPHIC */
    return vsliq_m_n_s32(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_m_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vsli.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 5, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vsliq_m_n_u8(uint8x16_t a, uint8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsliq_m(a, b, 5, p);
#else /* POLYMORPHIC */
    return vsliq_m_n_u8(a, b, 5, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vsli.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 3, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vsliq_m_n_u16(uint16x8_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsliq_m(a, b, 3, p);
#else /* POLYMORPHIC */
    return vsliq_m_n_u16(a, b, 3, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsliq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vsli.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 9, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vsliq_m_n_u32(uint32x4_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsliq_m(a, b, 9, p);
#else /* POLYMORPHIC */
    return vsliq_m_n_u32(a, b, 9, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_n_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vsri.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 3)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vsriq_n_s8(int8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vsriq(a, b, 3);
#else /* POLYMORPHIC */
    return vsriq_n_s8(a, b, 3);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vsri.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 2)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vsriq_n_s16(int16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vsriq(a, b, 2);
#else /* POLYMORPHIC */
    return vsriq_n_s16(a, b, 2);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vsri.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 28)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vsriq_n_s32(int32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vsriq(a, b, 28);
#else /* POLYMORPHIC */
    return vsriq_n_s32(a, b, 28);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vsri.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 3)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vsriq_n_u8(uint8x16_t a, uint8x16_t b)
{
#ifdef POLYMORPHIC
    return vsriq(a, b, 3);
#else /* POLYMORPHIC */
    return vsriq_n_u8(a, b, 3);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vsri.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 3)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vsriq_n_u16(uint16x8_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vsriq(a, b, 3);
#else /* POLYMORPHIC */
    return vsriq_n_u16(a, b, 3);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vsri.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 26)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vsriq_n_u32(uint32x4_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vsriq(a, b, 26);
#else /* POLYMORPHIC */
    return vsriq_n_u32(a, b, 26);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_m_n_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vsri.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 4, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vsriq_m_n_s8(int8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsriq_m(a, b, 4, p);
#else /* POLYMORPHIC */
    return vsriq_m_n_s8(a, b, 4, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vsri.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vsriq_m_n_s16(int16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsriq_m(a, b, 1, p);
#else /* POLYMORPHIC */
    return vsriq_m_n_s16(a, b, 1, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vsri.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 27, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vsriq_m_n_s32(int32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsriq_m(a, b, 27, p);
#else /* POLYMORPHIC */
    return vsriq_m_n_s32(a, b, 27, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_m_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vsri.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 7, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vsriq_m_n_u8(uint8x16_t a, uint8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsriq_m(a, b, 7, p);
#else /* POLYMORPHIC */
    return vsriq_m_n_u8(a, b, 7, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vsri.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 9, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vsriq_m_n_u16(uint16x8_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsriq_m(a, b, 9, p);
#else /* POLYMORPHIC */
    return vsriq_m_n_u16(a, b, 9, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vsriq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vsri.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 13, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vsriq_m_n_u32(uint32x4_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vsriq_m(a, b, 13, p);
#else /* POLYMORPHIC */
    return vsriq_m_n_u32(a, b, 13, p);
#endif /* POLYMORPHIC */
}
