/******************************************************************************
 *                    _   _____   __________                                  *
 *                   | | / / _ | / __/_  __/     Visibility                   *
 *                   | |/ / __ |_\ \  / /          Across                     *
 *                   |___/_/ |_/___/ /_/       Space and Time                 *
 *                                                                            *
 * This file is part of VAST. It is subject to the license terms in the       *
 * LICENSE file found in the top-level directory of this distribution and at  *
 * http://vast.io/license. No part of VAST, including this file, may be       *
 * copied, modified, propagated, or distributed except according to the terms *
 * contained in the LICENSE file.                                             *
 ******************************************************************************/

#pragma once

#include <ostream>

#include "vast/detail/fdoutbuf.hpp"

namespace vast::detail {

/// An output stream which wraps a ::fdoutbuf.
class fdostream : public std::ostream {
public:
  fdostream(int fd);

private:
  fdoutbuf buf_;
};

} // namespace vast::detail

