; String pool GC and compaction

(define (first-of s)
  (string (string-ref s 0)))

(define (rest-of s)
  (substring s 1 (string-length s)))

(define (rotate s)
  (string-append (rest-of s)
                 (first-of s)))

(define (rotations s)
  (letrec
    ((rot (lambda (s n)
            (if (zero? n)
                '()
                (cons s (rot (rotate s) (- n 1)))))))
    (rot s (string-length s))))

(define (permute str)
  (cond ((= (string-length str) 0) '())
        ((= (string-length str) 1) (list str))
        ((= (string-length str) 2) (rotations str))
        (else (apply append
                     (map (lambda (rotn)
                            (map (lambda (perm)
                                   (string-append
                                     (first-of rotn)
                                     perm))
                                 (permute (rest-of rotn))))
                          (rotations str))))))

(if (not (= 40320 (length (permute "abcdefgh"))))
    (error "string permutations failed"))
