% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_metadata.R
\name{core_metadata}
\alias{core_metadata}
\title{Get core metadata from tsn}
\usage{
core_metadata(tsn, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Get core metadata from tsn
}
\examples{
\dontrun{
# coverage and currrency data
core_metadata(tsn=28727)
core_metadata(tsn=28727, wt = "xml")
# no coverage or currrency data
core_metadata(183671)
core_metadata(183671, wt = "xml")
}
}
