% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowCumsums.R
\name{rowCumsums}
\alias{rowCumsums}
\alias{colCumsums}
\alias{rowCumprods}
\alias{colCumprods}
\alias{rowCummins}
\alias{colCummins}
\alias{rowCummaxs}
\alias{colCummaxs}
\title{Cumulative sums, products, minima and maxima for each row (column) in a
matrix}
\usage{
rowCumsums(x, rows = NULL, cols = NULL, dim. = dim(x), ...,
  useNames = TRUE)

colCumsums(x, rows = NULL, cols = NULL, dim. = dim(x), ...,
  useNames = TRUE)

rowCumprods(x, rows = NULL, cols = NULL, dim. = dim(x), ...,
  useNames = TRUE)

colCumprods(x, rows = NULL, cols = NULL, dim. = dim(x), ...,
  useNames = TRUE)

rowCummins(x, rows = NULL, cols = NULL, dim. = dim(x), ...,
  useNames = TRUE)

colCummins(x, rows = NULL, cols = NULL, dim. = dim(x), ...,
  useNames = TRUE)

rowCummaxs(x, rows = NULL, cols = NULL, dim. = dim(x), ...,
  useNames = TRUE)

colCummaxs(x, rows = NULL, cols = NULL, dim. = dim(x), ...,
  useNames = TRUE)
}
\arguments{
\item{x}{An NxK \code{\link[base]{matrix}} or, if \code{dim.} is specified,
an N * K \code{\link[base]{vector}}.}

\item{rows}{A \code{\link[base]{vector}} indicating subset of rows to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{cols}{A \code{\link[base]{vector}} indicating subset of columns to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{dim.}{An \code{\link[base]{integer}} \code{\link[base]{vector}} of
length two specifying the dimension of \code{x}, also when not a
\code{\link[base]{matrix}}.  \emph{Comment:} The reason for this argument
being named with a period at the end is purely technical (we get a run-time
error if we try to name it \code{dim}).}

\item{...}{Not used.}

\item{useNames}{If \code{\link[base:logical]{TRUE}} (default), names
attributes of the result are set, otherwise not.}
}
\value{
Returns a \code{\link[base]{numeric}} NxK \code{\link[base]{matrix}}
of the same mode as \code{x}, except when \code{x} is of mode
\code{\link[base]{logical}}, then the return type is
\code{\link[base]{integer}}.
}
\description{
Cumulative sums, products, minima and maxima for each row (column) in a
matrix.
}
\examples{
x <- matrix(1:12, nrow = 4, ncol = 3)
print(x)

yr <- rowCumsums(x)
print(yr)

yc <- colCumsums(x)
print(yc)

yr <- rowCumprods(x)
print(yr)

yc <- colCumprods(x)
print(yc)

yr <- rowCummaxs(x)
print(yr)

yc <- colCummaxs(x)
print(yc)

yr <- rowCummins(x)
print(yr)

yc <- colCummins(x)
print(yc)
}
\seealso{
See \code{\link[base]{cumsum}}(), \code{\link[base]{cumprod}}(),
\code{\link[base]{cummin}}(), and \code{\link[base]{cummax}}().
}
\author{
Henrik Bengtsson
}
\keyword{array}
\keyword{iteration}
\keyword{univar}
