% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWeights.R
\name{plotWeightsHeatmap}
\alias{plotWeightsHeatmap}
\title{Plot heatmap of the weights}
\usage{
plotWeightsHeatmap(object, view, features = "all", factors = "all",
  threshold = 0, ...)
}
\arguments{
\item{object}{a trained \code{\link{MOFAmodel}} object.}

\item{view}{character vector with the view name(s),
 or numeric vector with the index of the view(s) to use. 
Default is 'all'}

\item{features}{character vector with the feature name(s),
 or numeric vector with the index of the feature(s) to use. 
Default is 'all'}

\item{factors}{character vector with the factor name(s),
 or numeric vector with the index of the factor(s) to use. 
Default is 'all'}

\item{threshold}{threshold on absolute weight values, so that loadings
with a magnitude below this threshold (in all factors) are removed}

\item{...}{extra arguments passed to \code{\link[pheatmap]{pheatmap}}.}
}
\value{
produces a heatmap of feature weights for all factors
}
\description{
Function to visualize the loadings for a given set of factors in a given view. \cr 
This is useful to visualize the overall pattern of the weights
 but not to individually characterise the factors. \cr
To inspect the loadings of individual factors, use the functions
 \code{\link{plotWeights}} and \code{\link{plotTopWeights}}
}
\details{
The weights, or the loadings, provide the mapping between the high-dimensional space (the genes) and the low-dimensional space (the factors). \cr
They define a score for each gene on each factor, such that genes with no association with the factor are expected to 
have values close to zero, whereas genes with strong association with the factor are expected to have large absolute values. \cr
The sign of the loading indicates the direction of the effect: A positive loading indicates that the feature is more active 
in the cells with positive factor values, while a negative loading indicates that the feature is more active in the cells with negative factor values.
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
plotWeightsHeatmap(MOFA_CLL, view="Mutations")
plotWeightsHeatmap(MOFA_CLL, view="Mutations", factors=1:3)

# Example on the scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)
plotWeightsHeatmap(MOFA_scMT, view="RNA expression")
}
