`cylinder.med` is first generated by salome 9.2.2. The mesh version is then modified by HDFView by changing the mesh version from 4.0.0 to 3.0.0 so that it can also be read in gmsh.

`box.med` is generated by code_aster 13.6 using the following command file. A specfic displacement field is prescribed to an orthotropic hexahedral element, and we verify if meshio is able to read the current stress/strain/energy data.

```
DEBUT()

mesh = LIRE_MAILLAGE(FORMAT='MED', INFO=2, UNITE=20)

mesh = DEFI_GROUP(
    reuse=mesh, MAILLAGE=mesh,
    CREA_GROUP_NO=(_F(NOM='Left', NOEUD=('N1', 'N2', 'N3', 'N4')),
                   _F(NOM='Right', NOEUD=('N5', 'N6', 'N7', 'N8'))))

model = AFFE_MODELE(
    AFFE=_F(MODELISATION=('3D', ), PHENOMENE='MECANIQUE', TOUT='OUI'),
    MAILLAGE=mesh
)

mat = DEFI_MATERIAU(
    ELAS_ORTH=_F(RHO=1.37486e-09, E_L=5329.16, E_T=2418.93, E_N=1746.66,
                 G_LT=1202.6, G_TN=515.638, G_LN=569.752,
                 NU_LT=0.450006, NU_TN=0.564862, NU_LN=0.397544,
                 ALPHA_L=1.0163e-05, ALPHA_T=2.67311e-05, ALPHA_N=6.86122e-05))

load = AFFE_CHAR_MECA(
    MODELE=model, DDL_IMPO=(_F(GROUP_NO='Left', DX=0, DY=0, DZ=0),
                            _F(GROUP_NO='Right', DX=1, DY=1, DZ=1))
)

fieldmat = AFFE_MATERIAU(
    AFFE=_F(MATER=(mat, ), TOUT='OUI'),
    MODELE=model
)

resu = MECA_STATIQUE(
    CHAM_MATER=fieldmat,
    EXCIT=_F(CHARGE=load),
    MODELE=model,
    OPTION='SANS',
    SOLVEUR=_F(METHODE='MUMPS')
)

resu = CALC_CHAMP(
    reuse=resu, RESULTAT=resu, CONTRAINTE='SIEF_ELNO', DEFORMATION='EPSI_ELNO', ENERGIE=('ENEL_ELEM', 'ENEL_ELNO'))

IMPR_RESU(
    FORMAT='MED',
    RESU=_F(RESULTAT=resu),
    UNITE=80
)

FIN()
```
