# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.keyvault import KeyVaultManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKeyVaultManagementKeysOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KeyVaultManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_keys_create_if_not_exist(self, resource_group):
        response = self.client.keys.create_if_not_exist(
            resource_group_name=resource_group.name,
            vault_name="str",
            key_name="str",
            parameters={
                "properties": {
                    "attributes": {
                        "created": 0,
                        "enabled": bool,
                        "exp": 0,
                        "exportable": False,
                        "nbf": 0,
                        "recoveryLevel": "str",
                        "updated": 0,
                    },
                    "curveName": "str",
                    "keyOps": ["str"],
                    "keySize": 0,
                    "keyUri": "str",
                    "keyUriWithVersion": "str",
                    "kty": "str",
                    "release_policy": {
                        "contentType": "application/json; charset=utf-8",
                        "data": bytes("bytes", encoding="utf-8"),
                    },
                    "rotationPolicy": {
                        "attributes": {"created": 0, "expiryTime": "str", "updated": 0},
                        "lifetimeActions": [
                            {
                                "action": {"type": "str"},
                                "trigger": {"timeAfterCreate": "str", "timeBeforeExpiry": "str"},
                            }
                        ],
                    },
                },
                "tags": {"str": "str"},
            },
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_keys_get(self, resource_group):
        response = self.client.keys.get(
            resource_group_name=resource_group.name,
            vault_name="str",
            key_name="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_keys_list(self, resource_group):
        response = self.client.keys.list(
            resource_group_name=resource_group.name,
            vault_name="str",
            api_version="2025-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_keys_get_version(self, resource_group):
        response = self.client.keys.get_version(
            resource_group_name=resource_group.name,
            vault_name="str",
            key_name="str",
            key_version="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_keys_list_versions(self, resource_group):
        response = self.client.keys.list_versions(
            resource_group_name=resource_group.name,
            vault_name="str",
            key_name="str",
            api_version="2025-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
