# -*- coding: utf-8 -*-
###############################################################################
# PySword - A native Python reader of the SWORD Project Bible Modules         #
# --------------------------------------------------------------------------- #
# Copyright (c) 2008-2019 Various PySword developers:                         #
# Kenneth Arnold, Joshua Gross, Tomas Groth, Ryan Hiebert, Philip Ridout,     #
# Matthew Wardrop                                                             #
# --------------------------------------------------------------------------- #
# Permission is hereby granted, free of charge, to any person obtaining a     #
# copy of this software and associated documentation files (the "Software"),  #
# to deal in the Software without restriction, including without limitation   #
# the rights to use, copy, modify, merge, publish, distribute, sublicense,    #
# and/or sell copies of the Software, and to permit persons to whom the       #
# Software is furnished to do so, subject to the following conditions:        #
#                                                                             #
# The above copyright notice and this permission notice shall be included     #
# in all copies or substantial portions of the Software.                      #
#                                                                             #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING     #
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER         #
# DEALINGS IN THE SOFTWARE.                                                   #
###############################################################################

# List of canons supported by SWORD.
# Auto-generated by canon-parser.py, formatted by YAPF

canons = {
    u'kjv': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 40, 16, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 68, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 15, 23, 29, 22, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 53]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 24, 34, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 8, 8, 12, 10, 17, 9, 20, 18, 7, 8, 6, 7, 5, 11, 15, 50, 14, 9, 13, 31, 6, 10, 22, 12, 14, 9, 11,
                12, 24, 11, 22, 22, 28, 12, 40, 22, 13, 17, 13, 11, 5, 26, 17, 11, 9, 14, 20, 23, 19, 9, 6, 7, 23, 13,
                11, 11, 17, 12, 8, 12, 11, 10, 13, 20, 7, 35, 36, 5, 24, 20, 28, 23, 10, 12, 20, 72, 13, 19, 16, 8, 18,
                12, 13, 17, 7, 18, 52, 17, 16, 15, 5, 23, 11, 13, 12, 9, 9, 5, 8, 28, 22, 35, 45, 48, 43, 13, 31, 7,
                10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 13,
                10, 7, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 16, 20, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 13, 13, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 30, 37, 31, 28, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 16, 9]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [17, 10, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 13, 15, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [15, 13, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 14]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [14]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 17, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'calvin': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 15, 34, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 68, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 15, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 38, 38, 28, 25, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9,
                11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9,
                24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20,
                17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43,
                14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9,
                8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 16, 20, 12, 29, 17, 18, 20, 8, 16]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 13, 13, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 23, 20, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 30, 37, 31, 28, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 16, 9]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 13, 15, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [15, 13, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 51, 53, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 40, 38, 40, 30, 35, 28, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 30, 25, 21, 23, 25, 38, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 22, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'catholic': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 54, 33, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 29, 28, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 30, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 35, 28, 32, 22, 29, 35, 41, 30, 25, 19, 66,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 31, 19, 29, 23, 22, 20, 22, 21, 20, 23, 29, 26, 22, 19, 19,
                26, 69, 28, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 32, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 16, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 32, 44, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 20, 32, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 20, 22, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 41, 66, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                18, 17, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 23, 14, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 38, 17, 19, 19, 73, 18, 37, 40, 36, 47, 31]),
            (u'Tobit', u'Tob', u'Tob', [22, 14, 17, 21, 23, 19, 17, 21, 6, 14, 19, 22, 18, 15]),
            (u'Judith', u'Jdt', u'Jdt', [16, 28, 10, 15, 24, 21, 32, 36, 14, 23, 23, 20, 20, 19, 14, 25]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'I Maccabees', u'1Macc', u'1Macc', [64, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 54, 53, 49, 41, 24]),
            (u'II Maccabees', u'2Macc', u'2Macc', [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 39]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 14, 14,
                24, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 32, 26, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9,
                11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 24, 21, 11, 7, 9,
                24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20,
                17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 9, 29, 22, 35, 45, 48, 43,
                14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9,
                8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 17, 16, 12, 14, 14]),
            (u'Wisdom', u'Wis', u'Wis', [16, 24, 19, 20, 23, 25, 30, 21, 19, 21, 26, 27, 19, 31, 19, 29, 21, 25, 22]),
            (u'Sirach', u'Sir', u'Sir', [
                30, 18, 31, 31, 17, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 30, 32, 28, 27, 28, 34, 26, 29,
                30, 26, 28, 25, 31, 24, 33, 31, 26, 31, 31, 34, 35, 30, 27, 25, 35, 23, 26, 20, 25, 25, 16, 29, 30
            ]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 24, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 11, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 23, 25, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Baruch', u'Bar', u'Bar', [22, 35, 38, 37, 9, 72]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 100, 34, 30, 29, 28, 27, 27, 21, 45, 13, 64, 43]),
            (u'Hosea', u'Hos', u'Hos', [9, 25, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 15, 10]),
            (u'Joel', u'Joel', u'Joel', [20, 27, 5, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 14, 14, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [14, 14, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [17, 17, 10, 16, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 24]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 49, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'catholic2': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 54, 33, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 29, 28, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 30, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 35, 28, 32, 22, 29, 35, 41, 30, 25, 19, 66,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 31, 19, 29, 23, 22, 20, 22, 21, 20, 23, 29, 26, 22, 19, 19,
                26, 69, 28, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 32, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 16, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 32, 44, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 20, 32, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 20, 22, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 41, 66, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                18, 17, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 23, 14, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 38, 17, 19, 19, 73, 18, 37, 40, 36, 47, 31]),
            (u'Tobit', u'Tob', u'Tob', [22, 14, 17, 21, 23, 19, 17, 21, 6, 14, 19, 22, 18, 15]),
            (u'Judith', u'Jdt', u'Jdt', [16, 28, 10, 15, 24, 21, 32, 36, 14, 23, 23, 20, 20, 19, 14, 25]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 13, 12, 6, 18, 19, 19, 24]),
            (u'I Maccabees', u'1Macc', u'1Macc', [64, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 54, 53, 49, 41, 24]),
            (u'II Maccabees', u'2Macc', u'2Macc', [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 39]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 14, 14,
                24, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 32, 26, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9,
                11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 24, 21, 11, 7, 9,
                24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20,
                17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 9, 29, 22, 35, 45, 48, 43,
                14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9,
                8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 17, 16, 12, 14, 14]),
            (u'Wisdom', u'Wis', u'Wis', [16, 24, 19, 20, 23, 25, 30, 21, 19, 21, 26, 27, 19, 31, 19, 29, 21, 25, 22]),
            (u'Sirach', u'Sir', u'Sir', [
                30, 18, 31, 31, 17, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 30, 32, 28, 27, 28, 34, 26, 29,
                30, 26, 28, 25, 31, 24, 33, 31, 26, 31, 31, 34, 35, 30, 27, 25, 35, 23, 26, 20, 25, 25, 16, 29, 30
            ]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 24, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 11, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 23, 25, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Baruch', u'Bar', u'Bar', [22, 35, 38, 37, 9, 72]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 100, 34, 30, 29, 28, 27, 27, 21, 45, 13, 64, 43]),
            (u'Hosea', u'Hos', u'Hos', [9, 25, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 15, 10]),
            (u'Joel', u'Joel', u'Joel', [20, 27, 5, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 14, 14, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [14, 14, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [17, 17, 10, 16, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 24]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 49, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'darbyfr': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 15, 34, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 40, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 69, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 15, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 38, 38, 27, 25, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 8, 8, 12, 10, 17, 9, 20, 18, 7, 8, 5, 7, 5, 11, 15, 50, 14, 9, 13, 31, 6, 10, 22, 12, 14, 9, 11,
                12, 24, 11, 22, 22, 28, 12, 40, 22, 13, 17, 13, 11, 5, 26, 17, 11, 9, 14, 20, 23, 19, 9, 6, 7, 23, 13,
                11, 11, 17, 12, 8, 12, 11, 10, 13, 20, 7, 35, 36, 5, 24, 20, 28, 23, 10, 12, 20, 72, 13, 19, 16, 8, 18,
                12, 13, 17, 7, 18, 52, 17, 16, 15, 5, 23, 11, 13, 12, 9, 9, 5, 8, 28, 22, 35, 45, 48, 43, 13, 31, 7,
                10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 13,
                10, 7, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 16, 20, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 13, 13, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 30, 37, 31, 28, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 16, 9]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 13, 15, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [15, 13, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 51, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [52, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'german': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 54, 33, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 29, 28, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 30, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 35, 28, 32, 22, 29, 35, 41, 30, 25, 19, 65,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 31, 19, 29, 23, 22, 20, 22, 21, 20, 23, 29, 26, 22, 19, 19,
                26, 69, 28, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 16, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 32, 44, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 20, 32, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 20, 22, 25, 29, 39, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 41, 66, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                18, 17, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 23, 14, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 38, 17, 19, 19, 73, 18, 37, 40, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 32, 26, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9,
                11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9,
                24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20,
                17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43,
                14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9,
                8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 12, 14, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 23, 20, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 11, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 23, 25, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 33, 34, 30, 29, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [9, 25, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 15, 10]),
            (u'Joel', u'Joel', u'Joel', [20, 27, 5, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 14, 14, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [14, 14, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [17, 17, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 24]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'kjva': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 40, 16, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 68, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 15, 23, 29, 22, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 53]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 24, 34, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 8, 8, 12, 10, 17, 9, 20, 18, 7, 8, 6, 7, 5, 11, 15, 50, 14, 9, 13, 31, 6, 10, 22, 12, 14, 9, 11,
                12, 24, 11, 22, 22, 28, 12, 40, 22, 13, 17, 13, 11, 5, 26, 17, 11, 9, 14, 20, 23, 19, 9, 6, 7, 23, 13,
                11, 11, 17, 12, 8, 12, 11, 10, 13, 20, 7, 35, 36, 5, 24, 20, 28, 23, 10, 12, 20, 72, 13, 19, 16, 8, 18,
                12, 13, 17, 7, 18, 52, 17, 16, 15, 5, 23, 11, 13, 12, 9, 9, 5, 8, 28, 22, 35, 45, 48, 43, 13, 31, 7,
                10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 13,
                10, 7, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 16, 20, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 13, 13, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 30, 37, 31, 28, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 16, 9]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [17, 10, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 13, 15, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [15, 13, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
            (u'I Esdras', u'1Esd', u'1Esd', [58, 30, 24, 63, 73, 34, 15, 96, 55]),
            (u'II Esdras', u'2Esd', u'2Esd', [40, 48, 36, 52, 56, 59, 70, 63, 47, 59, 46, 51, 58, 48, 63, 78]),
            (u'Tobit', u'Tob', u'Tob', [22, 14, 17, 21, 22, 17, 18, 21, 6, 12, 19, 22, 18, 15]),
            (u'Judith', u'Jdt', u'Jdt', [16, 28, 10, 15, 24, 21, 32, 36, 14, 23, 23, 20, 20, 19, 13, 25]),
            (u'Additions to Esther', u'AddEsth', u'AddEsth', [1, 1, 1, 1, 1, 1, 1, 1, 1, 13, 12, 6, 18, 19, 16, 24]),
            (u'Wisdom', u'Wis', u'Wis', [16, 24, 19, 20, 23, 25, 30, 21, 18, 21, 26, 27, 19, 31, 19, 29, 21, 25, 22]),
            (u'Sirach', u'Sir', u'Sir', [
                30, 18, 31, 31, 15, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 30, 32, 28, 27, 28, 34, 26, 29,
                30, 26, 28, 25, 31, 24, 31, 26, 20, 26, 31, 34, 35, 30, 24, 25, 33, 22, 26, 20, 25, 25, 16, 29, 30
            ]),
            (u'Baruch', u'Bar', u'Bar', [22, 35, 37, 37, 9, 73]),
            (u'Prayer of Azariah', u'PrAzar', u'PrAzar', [68]),
            (u'Susanna', u'Sus', u'Sus', [64]),
            (u'Bel and the Dragon', u'Bel', u'Bel', [42]),
            (u'Prayer of Manasses', u'PrMan', u'PrMan', [1]),
            (u'I Maccabees', u'1Macc', u'1Macc', [64, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 53, 53, 49, 41, 24]),
            (u'II Maccabees', u'2Macc', u'2Macc', [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 45, 26, 46, 39]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 14]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [14]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 17, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'leningrad': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 54, 33, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 29, 28, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 30, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 35, 28, 32, 22, 29, 35, 41, 30, 25, 19, 65,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 31, 19, 29, 23, 22, 20, 22, 21, 20, 23, 29, 26, 22, 19, 19,
                26, 69, 28, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 16, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 32, 44, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 20, 32, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 20, 22, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 23, 20, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 11, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 23, 25, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Hosea', u'Hos', u'Hos', [9, 25, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 15, 10]),
            (u'Joel', u'Joel', u'Joel', [20, 27, 5, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 14, 14, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [14, 14, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [17, 17, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 24]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 41, 66, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                18, 17, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 23, 14, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9,
                11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9,
                24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20,
                17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43,
                14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9,
                8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 32, 26, 17
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 12, 14, 14]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 33, 34, 30, 29, 28, 27, 27, 21, 45, 13]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 38, 17, 19, 19, 72, 18, 37, 40, 36, 47, 31]),
        ],
        u'nt': [],
    },
    u'luther': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 54, 33, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 29, 28, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 30, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 35, 28, 32, 22, 29, 35, 41, 30, 25, 19, 65,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 31, 19, 29, 23, 22, 20, 22, 21, 20, 23, 29, 26, 22, 19, 19,
                26, 69, 28, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 16, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 32, 44, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 20, 32, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 20, 22, 25, 29, 39, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 41, 66, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                18, 17, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 23, 14, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 38, 17, 19, 19, 73, 18, 37, 40, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 32, 26, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9,
                11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9,
                24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20,
                17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43,
                14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9,
                8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 12, 14, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 23, 20, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 11, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 23, 25, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 33, 34, 30, 29, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [9, 25, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 15, 10]),
            (u'Joel', u'Joel', u'Joel', [20, 27, 5, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 14, 14, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [14, 14, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [17, 17, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 24]),
            (u'Judith', u'Jdt', u'Jdt', [11, 18, 12, 14, 26, 20, 24, 28, 15, 21, 17, 21, 31, 16, 16, 31]),
            (u'Wisdom', u'Wis', u'Wis', [16, 25, 19, 20, 24, 27, 30, 21, 19, 21, 26, 27, 19, 31, 19, 29, 21, 25, 21]),
            (u'Tobit', u'Tob', u'Tob', [25, 23, 25, 22, 29, 23, 20, 23, 12, 13, 20, 22, 22, 17]),
            (u'Sirach', u'Sir', u'Sir', [
                38, 23, 34, 36, 18, 37, 40, 22, 25, 34, 35, 19, 32, 27, 21, 30, 31, 33, 27, 33, 31, 33, 37, 47, 34, 28,
                33, 30, 35, 27, 40, 28, 32, 31, 26, 28, 34, 39, 41, 32, 29, 26, 37, 26, 32, 23, 31, 28, 20, 31, 38
            ]),
            (u'Baruch', u'Bar', u'Bar', [22, 35, 38, 37, 9, 73]),
            (u'I Maccabees', u'1Macc', u'1Macc', [68, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 54, 54, 49, 41, 24]),
            (u'II Maccabees', u'2Macc', u'2Macc', [36, 33, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 40]),
            (u'Additions to Esther', u'AddEsth', u'AddEsth', [4, 8, 12, 12, 16, 9, 8]),
            (u'Additions to Daniel', u'AddDan', u'AddDan', [64, 41, 66]),
            (u'Prayer of Manasses', u'PrMan', u'PrMan', [16]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'lxx': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 25, 26, 32, 23, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 39, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 33, 20, 31, 29, 44, 36, 30, 23, 23, 57, 39, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 29, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 40, 21, 29, 23, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 40, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 34, 45, 41, 50, 28, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 40, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 19, 29, 23, 22, 20, 22, 21, 20, 23, 30, 26, 24, 19, 19,
                27, 69, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 16, 27, 26, 35, 33, 43, 23, 24, 33, 15, 64, 10, 18, 28, 54, 9, 49, 34, 16, 36]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 32, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 32, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 16, 23, 29, 23, 44, 25,
                12, 25, 11, 32, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 26, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 44, 26, 22, 51, 41, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 71, 39, 34, 32, 38, 51, 66, 28, 33, 44, 54, 34, 31, 34, 42, 24, 46, 21, 43, 43, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [22, 25, 27, 44, 27, 35, 20, 29, 37, 36, 21, 22, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 41, 81, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                18, 18, 17, 23, 14, 42, 22, 18, 31, 19, 23, 16, 23, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 31, 31
            ]),
            (u'I Esdras', u'1Esd', u'1Esd', [58, 30, 24, 63, 73, 34, 15, 96, 55]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 37, 23, 19, 19, 73, 18, 38, 40, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 22, 14, 10, 17, 35, 13, 17, 7, 30, 19, 24, 24]),
            (u'Judith', u'Jdt', u'Jdt', [16, 28, 10, 15, 24, 21, 32, 36, 14, 23, 23, 20, 20, 19, 14, 25]),
            (u'Tobit', u'Tob', u'Tob', [22, 14, 17, 21, 23, 19, 18, 21, 6, 14, 19, 22, 19, 15]),
            (u'I Maccabees', u'1Macc', u'1Macc', [64, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 53, 54, 49, 41, 24]),
            (u'II Maccabees', u'2Macc', u'2Macc', [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 39]),
            (u'III Maccabees', u'3Macc', u'3Macc', [29, 33, 30, 21, 51, 41, 23]),
            (u'IV Maccabees', u'4Macc', u'4Macc',
             [35, 24, 21, 26, 38, 35, 25, 29, 32, 21, 27, 20, 27, 20, 32, 25, 24, 24]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 13, 9, 9, 13, 11, 18, 10, 40, 8, 9, 6, 7, 6, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9, 11,
                13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 6, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9, 24,
                14, 12, 12, 19, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 7, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20, 17, 8,
                19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 36, 45, 48, 43, 14, 31,
                7, 10, 10, 9, 26, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 7, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24,
                15, 10, 8, 12, 15, 22, 10, 11, 20, 14, 9, 6, 7
            ]),
            (u'Prayer of Manasses', u'PrMan', u'PrMan', [15]),
            (u'Proverbs', u'Prov', u'Prov', [
                35, 23, 38, 28, 23, 40, 28, 37, 25, 33, 31, 31, 27, 36, 38, 33, 30, 24, 29, 30, 31, 31, 36, 77, 31, 29,
                29, 30, 49, 35, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 20, 12, 30, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 17, 13, 14, 15]),
            (u'Job', u'Job', u'Job', [
                22, 18, 26, 21, 27, 30, 22, 22, 35, 22, 20, 25, 28, 22, 35, 23, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 34, 24, 41, 35, 32, 34, 22
            ]),
            (u'Wisdom', u'Wis', u'Wis', [16, 25, 19, 20, 24, 27, 30, 21, 19, 21, 27, 27, 19, 31, 19, 29, 21, 25, 22]),
            (u'Sirach', u'Sir', u'Sir', [
                30, 18, 31, 31, 15, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 31, 32, 28, 27, 28, 34, 26, 29,
                30, 26, 28, 40, 31, 26, 33, 31, 26, 31, 31, 35, 35, 30, 27, 27, 33, 24, 26, 20, 25, 25, 16, 29, 30
            ]),
            (u'Psalms of Solomon', u'PssSol', u'PssSol',
             [8, 41, 16, 29, 22, 9, 10, 40, 20, 9, 9, 8, 12, 10, 15, 15, 51, 14]),
            (u'Hosea', u'Hos', u'Hos', [11, 25, 5, 19, 15, 12, 16, 14, 17, 15, 12, 15, 16, 10]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 15, 17, 14, 15]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 14, 15, 16, 20]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21, 21]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [17, 11, 10, 11]),
            (u'Nahum', u'Nah', u'Nah', [15, 14, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 21]),
            (u'Haggai', u'Hag', u'Hag', [15, 24]),
            (u'Zechariah', u'Zech', u'Zech', [21, 17, 11, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 24, 6]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 23, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 26, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 20, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 23, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 42, 10, 39, 28,
                46, 64, 31, 33, 47, 44, 24, 22, 19, 32, 24, 40, 44, 26, 22, 22, 32, 30, 28, 28, 16, 44, 38, 46, 63, 34
            ]),
            (u'Baruch', u'Bar', u'Bar', [22, 35, 38, 37, 9]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Epistle of Jeremiah', u'EpJer', u'EpJer', [73]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 13, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Prayer of Azariah', u'PrAzar', u'PrAzar', [68]),
            (u'Susanna', u'Sus', u'Sus', [64]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 100, 37, 31, 29, 28, 27, 27, 21, 45, 13]),
            (u'Bel and the Dragon', u'Bel', u'Bel', [42]),
            (u'I Enoch', u'1En', u'1En', [
                9, 3, 1, 1, 10, 8, 6, 4, 11, 22, 2, 6, 10, 25, 12, 4, 8, 16, 3, 8, 10, 14, 4, 6, 7, 6, 5, 3, 2, 3, 3,
                6, 4, 3, 1, 4, 6, 6, 14, 10, 9, 3, 4, 1, 6, 8, 4, 10, 4, 5, 5, 9, 7, 10, 4, 8, 3, 6, 3, 25, 13, 16, 12,
                2, 12, 3, 13, 5, 30, 4, 17, 37, 8, 17, 9, 14, 9, 17, 6, 8, 10, 20, 11, 6, 10, 6, 4, 3, 77, 43, 19, 17,
                14, 11, 7, 8, 10, 16, 16, 13, 9, 11, 15, 13, 2, 19, 3, 15
            ]),
            (u'Odes', u'Odes', u'Odes', [19, 43, 10, 20, 20, 19, 45, 88, 79, 88, 55, 32, 79, 46]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [52, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 26, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 14]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 9, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'mt': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 54, 33, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 29, 28, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 30, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 35, 28, 32, 22, 29, 35, 41, 30, 25, 19, 65,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 31, 19, 29, 23, 22, 20, 22, 21, 20, 23, 29, 26, 22, 19, 19,
                26, 69, 28, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 16, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 32, 44, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 20, 32, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 20, 22, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 23, 20, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 11, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 23, 25, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Hosea', u'Hos', u'Hos', [9, 25, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 15, 10]),
            (u'Joel', u'Joel', u'Joel', [20, 27, 5, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 14, 14, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [14, 14, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [17, 17, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 24]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9,
                11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9,
                24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20,
                17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43,
                14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9,
                8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 32, 26, 17
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 12, 14, 14]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 33, 34, 30, 29, 28, 27, 27, 21, 45, 13]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 38, 17, 19, 19, 72, 18, 37, 40, 36, 47, 31]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 41, 66, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                18, 17, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 23, 14, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
        ],
        u'nt': [],
    },
    u'nrsv': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 40, 16, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 68, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 15, 23, 29, 22, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 53]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 24, 34, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 8, 8, 12, 10, 17, 9, 20, 18, 7, 8, 6, 7, 5, 11, 15, 50, 14, 9, 13, 31, 6, 10, 22, 12, 14, 9, 11,
                12, 24, 11, 22, 22, 28, 12, 40, 22, 13, 17, 13, 11, 5, 26, 17, 11, 9, 14, 20, 23, 19, 9, 6, 7, 23, 13,
                11, 11, 17, 12, 8, 12, 11, 10, 13, 20, 7, 35, 36, 5, 24, 20, 28, 23, 10, 12, 20, 72, 13, 19, 16, 8, 18,
                12, 13, 17, 7, 18, 52, 17, 16, 15, 5, 23, 11, 13, 12, 9, 9, 5, 8, 28, 22, 35, 45, 48, 43, 13, 31, 7,
                10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 13,
                10, 7, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 16, 20, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 13, 13, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 30, 37, 31, 28, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 16, 9]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [17, 10, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 13, 15, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [15, 13, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 14]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'nrsva': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 40, 16, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 68, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 15, 23, 29, 22, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 53]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 24, 34, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 8, 8, 12, 10, 17, 9, 20, 18, 7, 8, 6, 7, 5, 11, 15, 50, 14, 9, 13, 31, 6, 10, 22, 12, 14, 9, 11,
                12, 24, 11, 22, 22, 28, 12, 40, 22, 13, 17, 13, 11, 5, 26, 17, 11, 9, 14, 20, 23, 19, 9, 6, 7, 23, 13,
                11, 11, 17, 12, 8, 12, 11, 10, 13, 20, 7, 35, 36, 5, 24, 20, 28, 23, 10, 12, 20, 72, 13, 19, 16, 8, 18,
                12, 13, 17, 7, 18, 52, 17, 16, 15, 5, 23, 11, 13, 12, 9, 9, 5, 8, 28, 22, 35, 45, 48, 43, 13, 31, 7,
                10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 13,
                10, 7, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 16, 20, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 13, 13, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 30, 37, 31, 28, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 16, 9]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [17, 10, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 13, 15, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [15, 13, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
            (u'Tobit', u'Tob', u'Tob', [22, 14, 17, 21, 22, 18, 16, 21, 6, 13, 18, 22, 17, 15]),
            (u'Judith', u'Jdt', u'Jdt', [16, 28, 10, 15, 24, 21, 32, 36, 14, 23, 23, 20, 20, 19, 14, 25]),
            (u'Esther (Greek)', u'EsthGr', u'EsthGr', [22, 23, 15, 17, 14, 14, 10, 17, 32, 13, 12, 6, 18, 19, 16, 24]),
            (u'Wisdom', u'Wis', u'Wis', [16, 24, 19, 20, 23, 25, 30, 21, 18, 21, 26, 27, 19, 31, 19, 29, 21, 25, 22]),
            (u'Sirach', u'Sir', u'Sir', [
                30, 18, 31, 31, 15, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 30, 31, 28, 27, 27, 34, 26, 29,
                30, 26, 28, 25, 31, 24, 33, 31, 26, 31, 31, 34, 35, 30, 22, 25, 33, 23, 26, 20, 25, 25, 16, 29, 30
            ]),
            (u'Baruch', u'Bar', u'Bar', [22, 35, 37, 37, 9, 73]),
            (u'Prayer of Azariah', u'PrAzar', u'PrAzar', [68]),
            (u'Susanna', u'Sus', u'Sus', [64]),
            (u'Bel and the Dragon', u'Bel', u'Bel', [42]),
            (u'I Maccabees', u'1Macc', u'1Macc', [64, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 53, 53, 49, 41, 24]),
            (u'II Maccabees', u'2Macc', u'2Macc', [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 45, 26, 46, 39]),
            (u'I Esdras', u'1Esd', u'1Esd', [58, 30, 24, 63, 73, 34, 15, 96, 55]),
            (u'Prayer of Manasses', u'PrMan', u'PrMan', [15]),
            (u'Additional Psalm', u'AddPs', u'AddPs', [7]),
            (u'III Maccabees', u'3Macc', u'3Macc', [29, 33, 30, 21, 51, 41, 23]),
            (u'II Esdras', u'2Esd', u'2Esd', [40, 48, 36, 52, 56, 59, 140, 63, 47, 59, 46, 51, 58, 48, 63, 78]),
            (u'IV Maccabees', u'4Macc', u'4Macc',
             [35, 24, 21, 26, 38, 35, 23, 29, 32, 21, 27, 19, 27, 20, 32, 25, 24, 24]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 14]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'orthodox': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 25, 26, 32, 23, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 39, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 33, 20, 31, 29, 44, 36, 30, 23, 23, 57, 39, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 29, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 40, 21, 29, 23, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 40, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 34, 45, 41, 50, 28, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 40, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 19, 29, 23, 22, 20, 22, 21, 20, 23, 30, 26, 24, 19, 19,
                27, 69, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 16, 27, 26, 35, 33, 43, 23, 24, 33, 15, 64, 10, 18, 28, 54, 9, 49, 34, 16, 36]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 32, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 32, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 16, 23, 29, 23, 44, 25,
                12, 25, 11, 32, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 26, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 44, 26, 22, 51, 41, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 71, 39, 34, 32, 38, 51, 66, 28, 33, 44, 54, 34, 31, 34, 42, 24, 46, 21, 43, 43, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [22, 25, 27, 44, 27, 35, 20, 29, 37, 36, 21, 22, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 41, 81, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                18, 18, 17, 23, 14, 42, 22, 18, 31, 19, 23, 16, 23, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 31, 31
            ]),
            (u'I Esdras', u'1Esd', u'1Esd', [58, 30, 24, 63, 73, 34, 15, 96, 55]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 37, 23, 19, 19, 73, 18, 38, 40, 36, 47, 31]),
            (u'Tobit', u'Tob', u'Tob', [22, 14, 17, 21, 23, 19, 18, 21, 6, 14, 19, 22, 19, 15]),
            (u'Judith', u'Jdt', u'Jdt', [16, 28, 10, 15, 24, 21, 32, 36, 14, 23, 23, 20, 20, 19, 14, 25]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 22, 14, 10, 17, 35, 13, 17, 7, 30, 19, 24, 24]),
            (u'I Maccabees', u'1Macc', u'1Macc', [64, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 53, 54, 49, 41, 24]),
            (u'II Maccabees', u'2Macc', u'2Macc', [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 39]),
            (u'III Maccabees', u'3Macc', u'3Macc', [29, 33, 30, 21, 51, 41, 23]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 13, 9, 9, 13, 11, 18, 10, 40, 8, 9, 6, 7, 6, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9, 11,
                13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 6, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9, 24,
                14, 12, 12, 19, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 7, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20, 17, 8,
                19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 36, 45, 48, 43, 14, 31,
                7, 10, 10, 9, 26, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 7, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24,
                15, 10, 8, 12, 15, 22, 10, 11, 20, 14, 9, 6, 7
            ]),
            (u'Prayer of Manasses', u'PrMan', u'PrMan', [15]),
            (u'Job', u'Job', u'Job', [
                22, 18, 26, 21, 27, 30, 22, 22, 35, 22, 20, 25, 28, 22, 35, 23, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 34, 24, 41, 35, 32, 34, 22
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                35, 23, 38, 28, 23, 40, 28, 37, 25, 33, 31, 31, 27, 36, 38, 33, 30, 24, 29, 30, 31, 31, 36, 77, 31, 29,
                29, 30, 49, 35, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 20, 12, 30, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 17, 13, 14, 15]),
            (u'Wisdom', u'Wis', u'Wis', [16, 25, 19, 20, 24, 27, 30, 21, 19, 21, 27, 27, 19, 31, 19, 29, 21, 25, 22]),
            (u'Sirach', u'Sir', u'Sir', [
                30, 18, 31, 31, 15, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 31, 32, 28, 27, 28, 34, 26, 29,
                30, 26, 28, 40, 31, 26, 33, 31, 26, 31, 31, 35, 35, 30, 27, 27, 33, 24, 26, 20, 25, 25, 16, 29, 30
            ]),
            (u'Hosea', u'Hos', u'Hos', [11, 25, 5, 19, 15, 12, 16, 14, 17, 15, 12, 15, 16, 10]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 15, 17, 14, 15]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 14, 15, 16, 20]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21, 21]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [17, 11, 10, 11]),
            (u'Nahum', u'Nah', u'Nah', [15, 14, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 21]),
            (u'Haggai', u'Hag', u'Hag', [15, 24]),
            (u'Zechariah', u'Zech', u'Zech', [21, 17, 11, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 24, 6]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 23, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 26, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 20, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 23, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 42, 10, 39, 28,
                46, 64, 31, 33, 47, 44, 24, 22, 19, 32, 24, 40, 44, 26, 22, 22, 32, 30, 28, 28, 16, 44, 38, 46, 63, 34
            ]),
            (u'Baruch', u'Bar', u'Bar', [22, 35, 38, 37, 9]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Epistle of Jeremiah', u'EpJer', u'EpJer', [73]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 13, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Susanna', u'Sus', u'Sus', [64]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 100, 37, 31, 29, 28, 27, 27, 21, 45, 13]),
            (u'Bel and the Dragon', u'Bel', u'Bel', [42]),
            (u'IV Maccabees', u'4Macc', u'4Macc',
             [35, 24, 21, 26, 38, 35, 25, 29, 32, 21, 27, 20, 27, 20, 32, 25, 24, 24]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [52, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 26, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 14]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 9, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'segond': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 29, 28, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 68, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 15, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 23, 14, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 38, 38, 28, 25, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9,
                11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9,
                24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20,
                17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43,
                14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9,
                8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 8, 16]),
            (u'Song of Solomon', u'Song', u'Song', [17, 17, 11, 16, 16, 12, 14, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 23, 20, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 11, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 30, 37, 31, 28, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [9, 25, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 16, 9]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 14, 14, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [14, 14, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 51, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'synodal': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 56, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 15, 34, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 68, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 16, 26, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 36]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 15, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 53]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Prayer of Manasses', u'PrMan', u'PrMan', [12]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31]),
            (u'I Esdras', u'1Esd', u'1Esd', [58, 31, 24, 63, 70, 34, 15, 92, 55]),
            (u'Tobit', u'Tob', u'Tob', [22, 14, 17, 21, 22, 18, 17, 21, 6, 13, 18, 22, 18, 15]),
            (u'Judith', u'Jdt', u'Jdt', [16, 28, 10, 15, 24, 21, 32, 36, 14, 23, 23, 20, 20, 19, 14, 25]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 35, 27, 26, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 39, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9, 11,
                13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9, 24,
                14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20, 17, 8,
                19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43, 14, 31,
                7, 10, 10, 9, 26, 9, 10, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24,
                14, 10, 7, 12, 15, 21, 10, 11, 9, 14, 9, 6, 7
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 29, 23, 35, 27, 36, 18, 32, 31, 28, 26, 35, 33, 33, 28, 25, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [16, 17, 11, 16, 16, 12, 14, 14]),
            (u'Wisdom', u'Wis', u'Wis', [16, 24, 19, 20, 24, 27, 30, 21, 19, 21, 27, 28, 19, 31, 19, 29, 20, 25, 21]),
            (u'Sirach', u'Sir', u'Sir', [
                30, 18, 31, 35, 18, 37, 39, 22, 23, 34, 34, 18, 32, 27, 20, 31, 31, 33, 28, 31, 31, 31, 37, 37, 29, 27,
                33, 30, 31, 27, 37, 25, 33, 26, 23, 29, 34, 39, 42, 32, 29, 26, 36, 27, 31, 23, 31, 28, 18, 31, 38
            ]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 25, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Epistle of Jeremiah', u'EpJer', u'EpJer', [72]),
            (u'Baruch', u'Bar', u'Bar', [22, 35, 38, 37, 9]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 100, 34, 31, 28, 28, 27, 27, 21, 45, 13, 64, 42]),
            (u'Hosea', u'Hos', u'Hos', [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 15, 10]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 13, 15, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [15, 13, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
            (u'I Maccabees', u'1Macc', u'1Macc', [64, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 53, 53, 49, 41, 24]),
            (u'II Maccabees', u'2Macc', u'2Macc', [36, 33, 40, 50, 27, 31, 42, 36, 29, 38, 38, 45, 26, 46, 39]),
            (u'III Maccabees', u'3Macc', u'3Macc', [25, 24, 22, 16, 36, 37, 20]),
            (u'II Esdras', u'2Esd', u'2Esd', [40, 48, 36, 52, 56, 59, 70, 63, 47, 60, 46, 51, 58, 48, 63, 78]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 26, 33, 24]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 32, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 17, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'synodalprot': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 56, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 15, 34, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 68, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 24, 16, 26, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 15, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 53]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 3]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 35, 27, 26, 17
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 12, 9, 9, 13, 11, 18, 10, 39, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9, 11,
                13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9, 24,
                14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20, 17, 8,
                19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43, 14, 31,
                7, 10, 10, 9, 26, 9, 10, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24,
                14, 10, 7, 12, 15, 21, 10, 11, 9, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [16, 17, 11, 16, 16, 12, 14, 14]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 25, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 33, 34, 31, 28, 28, 27, 27, 21, 45, 13]),
            (u'Hosea', u'Hos', u'Hos', [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 15, 10]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 14, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 13, 15, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [15, 13, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [15, 23]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 26, 33, 24]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 32, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 17, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
        ],
    },
    u'vulg': {
        u'ot': [
            (u'Genesis', u'Gen', u'Gen', [
                31, 25, 24, 26, 31, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35,
                46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 32, 25
            ]),
            (u'Exodus', u'Exod', u'Exod', [
                22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37,
                21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 36
            ]),
            (u'Leviticus', u'Lev', u'Lev', [
                17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 45,
                34
            ]),
            (u'Numbers', u'Num', u'Num', [
                54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 34, 15, 34, 45, 41, 50, 13, 32, 22, 30, 35, 41, 30, 25, 18, 65,
                23, 31, 39, 17, 54, 42, 56, 29, 34, 13
            ]),
            (u'Deuteronomy', u'Deut', u'Deut', [
                46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19,
                26, 68, 29, 20, 30, 52, 29, 12
            ]),
            (u'Joshua', u'Josh', u'Josh',
             [18, 24, 17, 25, 16, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 43, 34, 16, 33]),
            (u'Judges', u'Judg', u'Judg',
             [36, 23, 31, 24, 32, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 24]),
            (u'Ruth', u'Ruth', u'Ruth', [22, 23, 18, 22]),
            (u'I Samuel', u'1Sam', u'1Sam', [
                28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 15, 23, 28, 23, 44, 25,
                12, 25, 11, 31, 13
            ]),
            (u'II Samuel', u'2Sam', u'2Sam',
             [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25]),
            (u'I Kings', u'1Kgs', u'1Kgs',
             [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54]),
            (u'II Kings', u'2Kgs', u'2Kgs',
             [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30]),
            (u'I Chronicles', u'1Chr', u'1Chr', [
                54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 46, 40, 14, 17, 29, 43, 27, 17, 19, 7, 30, 19, 32, 31, 31, 32,
                34, 21, 30
            ]),
            (u'II Chronicles', u'2Chr', u'2Chr', [
                17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23,
                9, 27, 36, 27, 21, 33, 25, 33, 27, 23
            ]),
            (u'Ezra', u'Ezra', u'Ezra', [11, 70, 13, 24, 17, 22, 28, 36, 15, 44]),
            (u'Nehemiah', u'Neh', u'Neh', [11, 20, 31, 23, 19, 19, 73, 18, 38, 39, 36, 46, 31]),
            (u'Tobit', u'Tob', u'Tob', [25, 23, 25, 23, 28, 22, 20, 24, 12, 13, 21, 22, 23, 17]),
            (u'Judith', u'Jdt', u'Jdt', [12, 18, 15, 17, 29, 21, 25, 34, 19, 20, 21, 20, 31, 18, 15, 31]),
            (u'Esther', u'Esth', u'Esth', [22, 23, 15, 17, 14, 14, 10, 17, 32, 13, 12, 6, 18, 19, 19, 24]),
            (u'Job', u'Job', u'Job', [
                22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 23, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14,
                23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 35, 28, 25, 16
            ]),
            (u'Psalms', u'Ps', u'Ps', [
                6, 13, 9, 10, 13, 11, 18, 10, 39, 8, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9, 11,
                13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 6, 26, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9, 24,
                13, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20, 17, 8,
                19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43, 14, 31,
                7, 10, 10, 9, 26, 9, 10, 2, 29, 176, 7, 8, 9, 4, 8, 5, 7, 5, 6, 8, 8, 3, 18, 3, 3, 21, 27, 9, 8, 24,
                14, 10, 8, 12, 15, 21, 10, 11, 9, 14, 9, 6
            ]),
            (u'Proverbs', u'Prov', u'Prov', [
                33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28,
                27, 28, 27, 33, 31
            ]),
            (u'Ecclesiastes', u'Eccl', u'Eccl', [18, 26, 22, 17, 19, 11, 30, 17, 18, 20, 10, 14]),
            (u'Song of Solomon', u'Song', u'Song', [16, 17, 11, 16, 17, 12, 13, 14]),
            (u'Wisdom', u'Wis', u'Wis', [16, 25, 19, 20, 24, 27, 30, 21, 19, 21, 27, 27, 19, 31, 19, 29, 20, 25, 20]),
            (u'Sirach', u'Sir', u'Sir', [
                40, 23, 34, 36, 18, 37, 40, 22, 25, 34, 36, 19, 32, 27, 22, 31, 31, 33, 28, 33, 31, 33, 38, 47, 36, 28,
                33, 30, 35, 27, 42, 28, 33, 31, 26, 28, 34, 39, 41, 32, 28, 26, 37, 27, 31, 23, 31, 28, 19, 31, 38
            ]),
            (u'Isaiah', u'Isa', u'Isa', [
                31, 22, 26, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13,
                29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 26, 13, 15, 22, 26, 11, 23, 15, 12,
                17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24
            ]),
            (u'Jeremiah', u'Jer', u'Jer', [
                19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24,
                22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 20, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34
            ]),
            (u'Lamentations', u'Lam', u'Lam', [22, 22, 66, 22, 22]),
            (u'Baruch', u'Bar', u'Bar', [22, 35, 38, 37, 9, 72]),
            (u'Ezekiel', u'Ezek', u'Ezek', [
                28, 9, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21,
                36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35
            ]),
            (u'Daniel', u'Dan', u'Dan', [21, 49, 100, 34, 31, 28, 28, 27, 27, 21, 45, 13, 65, 42]),
            (u'Hosea', u'Hos', u'Hos', [11, 24, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 15, 10]),
            (u'Joel', u'Joel', u'Joel', [20, 32, 21]),
            (u'Amos', u'Amos', u'Amos', [15, 16, 15, 13, 27, 15, 17, 14, 15]),
            (u'Obadiah', u'Obad', u'Obad', [21]),
            (u'Jonah', u'Jonah', u'Jonah', [16, 11, 10, 11]),
            (u'Micah', u'Mic', u'Mic', [16, 13, 12, 13, 14, 16, 20]),
            (u'Nahum', u'Nah', u'Nah', [15, 13, 19]),
            (u'Habakkuk', u'Hab', u'Hab', [17, 20, 19]),
            (u'Zephaniah', u'Zeph', u'Zeph', [18, 15, 20]),
            (u'Haggai', u'Hag', u'Hag', [14, 24]),
            (u'Zechariah', u'Zech', u'Zech', [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21]),
            (u'Malachi', u'Mal', u'Mal', [14, 17, 18, 6]),
            (u'I Maccabees', u'1Macc', u'1Macc', [67, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 54, 54, 49, 41, 24]),
            (u'II Maccabees', u'2Macc', u'2Macc', [36, 33, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 40]),
        ],
        u'nt': [
            (u'Matthew', u'Matt', u'Matt', [
                25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 26, 35, 30, 34, 46, 46, 39, 51, 46, 75,
                66, 20
            ]),
            (u'Mark', u'Mark', u'Mark', [45, 28, 35, 40, 43, 56, 37, 39, 49, 52, 33, 44, 37, 72, 47, 20]),
            (u'Luke', u'Luke', u'Luke',
             [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53]),
            (u'John', u'John', u'John',
             [51, 25, 36, 54, 47, 72, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25]),
            (u'Acts', u'Acts', u'Acts', [
                26, 47, 26, 37, 42, 15, 59, 40, 43, 48, 30, 25, 52, 27, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32,
                44, 31
            ]),
            (u'Romans', u'Rom', u'Rom', [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27]),
            (u'I Corinthians', u'1Cor', u'1Cor', [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24]),
            (u'II Corinthians', u'2Cor', u'2Cor', [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13]),
            (u'Galatians', u'Gal', u'Gal', [24, 21, 29, 31, 26, 18]),
            (u'Ephesians', u'Eph', u'Eph', [23, 22, 21, 32, 33, 24]),
            (u'Philippians', u'Phil', u'Phil', [30, 30, 21, 23]),
            (u'Colossians', u'Col', u'Col', [29, 23, 25, 18]),
            (u'I Thessalonians', u'1Thess', u'1Thess', [10, 20, 13, 18, 28]),
            (u'II Thessalonians', u'2Thess', u'2Thess', [12, 17, 18]),
            (u'I Timothy', u'1Tim', u'1Tim', [20, 15, 16, 16, 25, 21]),
            (u'II Timothy', u'2Tim', u'2Tim', [18, 26, 17, 22]),
            (u'Titus', u'Titus', u'Titus', [16, 15, 15]),
            (u'Philemon', u'Phlm', u'Phlm', [25]),
            (u'Hebrews', u'Heb', u'Heb', [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25]),
            (u'James', u'Jas', u'Jas', [27, 26, 18, 17, 20]),
            (u'I Peter', u'1Pet', u'1Pet', [25, 25, 22, 19, 14]),
            (u'II Peter', u'2Pet', u'2Pet', [21, 22, 18]),
            (u'I John', u'1John', u'1John', [10, 29, 24, 21, 21]),
            (u'II John', u'2John', u'2John', [13]),
            (u'III John', u'3John', u'3John', [15]),
            (u'Jude', u'Jude', u'Jude', [25]),
            (u'Revelation of John', u'Rev', u'Rev',
             [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]),
            (u'Prayer of Manasses', u'PrMan', u'PrMan', [15]),
            (u'I Esdras', u'1Esd', u'1Esd', [58, 31, 24, 63, 73, 34, 15, 97, 56]),
            (u'II Esdras', u'2Esd', u'2Esd', [40, 48, 36, 52, 56, 59, 140, 63, 47, 60, 46, 51, 58, 48, 63, 78]),
            (u'Additional Psalm', u'AddPs', u'AddPs', [7]),
            (u'Laodiceans', u'EpLao', u'EpLao', [20]),
        ],
    },
}
