/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

class ExtremityTriangle
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final boolean fill;
    private final HColor backgroundColor;
    private final Point2D contact;

    @Override
    public Point2D somePoint() {
        return this.contact;
    }

    public ExtremityTriangle(Point2D p1, double angle, boolean fill, HColor backgroundColor, int xWing, int yAperture) {
        this.backgroundColor = backgroundColor;
        this.fill = fill;
        this.contact = new Point2D.Double(p1.getX(), p1.getY());
        angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.addPoint(-xWing, -yAperture);
        this.polygon.addPoint(-xWing, yAperture);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(angle + 1.5707963267948966);
        this.polygon = this.polygon.translate(p1.getX(), p1.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.backgroundColor != null) {
            ug = ug.apply(this.backgroundColor.bg());
        } else if (this.fill) {
            ug = ug.apply(HColorUtils.changeBack(ug));
        }
        ug.draw(this.polygon);
    }
}

