NAME
oss_imux - Input Muplexer audio driver.

DESCRIPTION
IMUX is a virtual recording engine that permits up to 8 audio recording
applications to run at the same time. Generally most soundcards permit only a
single recording application to record the input source (via mic, line or CD).
With IMUX, you can use up to 8 recording applications to record the same
source in different sample rates, bits/sample and channels (mono/stereo).
IMUX does all the rate and format conversion in software. The applications
think that they are actually getting data from the physical device. For
instance, if you want to record the input from a CDROM in .wav format at
48Khz/8/Mono and at the same time you want to record the same stream in .mp3
format in 44.1Khz 16 bit stereo, with IMUX, you can start the wave recording
application on the first IMUX device and start the MP3 encoder on the second
IMUX device and both applications will run simultaneously thinking that they
are getting data from the physical soundcard.

CONFIGURATION
To add the IMUX driver you first need to ensure that there is a physical
soundcard present and then you can run ossdetect -i to add it. You may want
to select a master device by setting imux_masterdev, but the autodetection
should provide a good default. After OSS restart, imux should be available.

USAGE
Connect an input source to the soundcard's line-in jack. Using the Mixer app
like ossmix (or any OSS compliant mixer) set the recording source to Line-In 
(eg ossmix line.rec ON) Now you can start recording the input in multiple 
formats and at different sample rates. The simplest example is:

	ossrecord -s48000 -b16 -c2 -d/dev/oss/oss_imux0/pcmin0 test1.wav &
	ossrecord -s8000 -b8 -d/dev/oss/oss_imux0/pcmin0 test2.wav &

After a few minutes of recording you can stop them by placing the command in
forground mode (type fg %1 or fg %2) and press ^c to stop.

You now have two wav format files. test1.wav is a 48KHz 16bit stereo file and
test2.wav is a 8Khz 8bit Mono file.

You can now playback the files as follows:
o ossplay -v test1.wav and it should show you that the file is indeed
48Khz 16bit stereo.

o ossplay -v test2.wav - you should see that this file is indeed a
8Khz 8bit mono file.

What you have essentially accomplished is recording a single input stream into
two different formats at the same time.

You can now extend this analogy to record the input in mp3 format and RealAudio
format simultaneously.

The IMUX control panel can be displayed by typing ossxmix -d<imux mixer number>
(for e.g. in the above example, IMUX mixer is #2 so we type ossxmix -d2

There are record level control sliders for each input channel and it will show
activity when a recording program is active on a particular channel.


OPTIONS
o imux_masterdev: Selects which physical device to use as the Master device
for the IMUX driver.
Values: -1: automatically selected by OSS, 1-N: Audio device index of the
master device (as reported by ossinfo -a), Default: -1.

o imux_rate: Specifies what is the base sampling rate used by the imux driver.
Values: 5000-96000 Default: 48000

o imux_devices: Specifies number of Input Multiplexer devices to setup.
Values: 2-48 Default: 5


FILES
CONFIGFILEPATH/oss_imux.conf  Device configuration file.

AUTHOR
4Front Technologies

