/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.ivy.core.resolve.IvyNodeUsage;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;

public class MessageLoggerEngine
implements MessageLogger {
    private final Stack loggerStack = new Stack();
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();

    private MessageLogger peekLogger() {
        if (this.loggerStack.isEmpty()) {
            return Message.getDefaultLogger();
        }
        return (MessageLogger)this.loggerStack.peek();
    }

    public final void warn(String string) {
        this.peekLogger().warn(string);
        this.problems.add("WARN:  " + string);
        this.warns.add(string);
    }

    public void error(String string) {
        this.peekLogger().error(string);
        this.problems.add("\tERROR: " + string);
        this.errors.add(string);
    }

    public final List getErrors() {
        return this.errors;
    }

    public final List getProblems() {
        return this.problems;
    }

    public final List getWarns() {
        return this.warns;
    }

    public final void sumupProblems() {
        IvyNodeUsage.sumupProblems(this);
        this.clearProblems();
    }

    public final void clearProblems() {
        Message.getDefaultLogger().clearProblems();
        Iterator iterator = this.loggerStack.iterator();
        while (iterator.hasNext()) {
            ((MessageLogger)iterator.next()).clearProblems();
        }
        this.problems.clear();
        this.errors.clear();
        this.warns.clear();
    }

    public final void debug(String string) {
        this.peekLogger().debug(string);
    }

    public final void deprecated(String string) {
        this.peekLogger().deprecated(string);
    }

    public final void endProgress(String string) {
        this.peekLogger().endProgress(string);
    }

    public final void info(String string) {
        this.peekLogger().info(string);
    }

    public final void rawinfo(String string) {
        this.peekLogger().rawinfo(string);
    }

    public final void log(String string, int n) {
        this.peekLogger().log(string, n);
    }

    public final void progress() {
        this.peekLogger().progress();
    }

    public final void rawlog(String string, int n) {
        this.peekLogger().rawlog(string, n);
    }

    public final void verbose(String string) {
        this.peekLogger().verbose(string);
    }
}

