/*
 * libkysdk-waylandhelper's Library
 *
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhen Sun <sunzhen1@kylinos.cn>
 *
 */

/* Generated by wayland-scanner 1.18.0 */

#ifndef CUSTOM_CLIENT_PROTOCOL_H
#define CUSTOM_CLIENT_PROTOCOL_H

#include "wayland-client.h"
#include <stddef.h>
#include <stdint.h>

/**
 * @since 1.2.0
 */

#ifdef __cplusplus
extern "C" {
#endif

struct ukui_decoration;
struct wl_surface;

/**
 * @page page_iface_ukui_decoration ukui_decoration
 * @section page_iface_ukui_decoration_desc Description
 *
 * This example shows how to add extra functionality to Wayland
 * through an extension. This is the global object of the extension.
 * @section page_iface_ukui_decoration_api API
 * See @ref iface_ukui_decoration.
 */
/**
 * @defgroup iface_ukui_decoration The ukui_decoration interface
 *
 * This example shows how to add extra functionality to Wayland
 * through an extension. This is the global object of the extension.
 */
extern const struct wl_interface ukui_decoration_interface;

#define UKUI_DECORATION_MOVE_SURFACE 0
#define UKUI_DECORATION_SET_UKUI_DECORATION_MODE 1
#define UKUI_DECORATION_SET_UNITY_BORDER_RADIUS 2

/**
 * @ingroup iface_ukui_decoration
 */
#define UKUI_DECORATION_MOVE_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_decoration
 */
#define UKUI_DECORATION_SET_UKUI_DECORATION_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_decoration
 */
#define UKUI_DECORATION_SET_UNITY_BORDER_RADIUS_SINCE_VERSION 1

/** @ingroup iface_ukui_decoration */
static inline void
ukui_decoration_set_user_data(struct ukui_decoration *ukui_decoration, void *user_data)
{
    wl_proxy_set_user_data((struct wl_proxy *)ukui_decoration, user_data);
}

/** @ingroup iface_ukui_decoration */
static inline void *
ukui_decoration_get_user_data(struct ukui_decoration *ukui_decoration)
{
    return wl_proxy_get_user_data((struct wl_proxy *)ukui_decoration);
}

static inline uint32_t
ukui_decoration_get_version(struct ukui_decoration *ukui_decoration)
{
    return wl_proxy_get_version((struct wl_proxy *)ukui_decoration);
}

/** @ingroup iface_ukui_decoration */
static inline void
ukui_decoration_destroy(struct ukui_decoration *ukui_decoration)
{
    wl_proxy_destroy((struct wl_proxy *)ukui_decoration);
}

/**
 * @ingroup iface_ukui_decoration
 *
 * Inform the compositor that the client has a new surface that is
 * covered by the extension.
 */
static inline void
ukui_decoration_move_surface(struct ukui_decoration *ukui_decoration, struct wl_surface *surface)
{
    wl_proxy_marshal((struct wl_proxy *)ukui_decoration,
                     UKUI_DECORATION_MOVE_SURFACE, surface);
}

/**
 * @ingroup iface_ukui_decoration
 *
 * The compositor should perform a move animation on the surface.
 */
static inline void
ukui_decoration_set_ukui_decoration_mode(struct ukui_decoration *ukui_decoration, struct wl_surface *surface, uint32_t mode)
{
    wl_proxy_marshal((struct wl_proxy *)ukui_decoration,
                     UKUI_DECORATION_SET_UKUI_DECORATION_MODE, surface, mode);
}

/**
 * @ingroup iface_ukui_decoration
 *
 * The compositor should perform a move animation on the surface.
 */
static inline void
ukui_decoration_set_unity_border_radius(struct ukui_decoration *ukui_decoration, struct wl_surface *surface, uint32_t topleft, uint32_t topright, uint32_t bottomleft, uint32_t bottomright)
{
    wl_proxy_marshal((struct wl_proxy *)ukui_decoration,
                     UKUI_DECORATION_SET_UNITY_BORDER_RADIUS, surface, topleft, topright, bottomleft, bottomright);
}

#ifdef __cplusplus
}
#endif

#endif
