/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// NumaConfig struct for NumaConfig
type NumaConfig struct {
	GuestNumaId    int32           `json:"guest_numa_id"`
	Cpus           *[]int32        `json:"cpus,omitempty"`
	Distances      *[]NumaDistance `json:"distances,omitempty"`
	MemoryZones    *[]string       `json:"memory_zones,omitempty"`
	SgxEpcSections *[]string       `json:"sgx_epc_sections,omitempty"`
}

// NewNumaConfig instantiates a new NumaConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewNumaConfig(guestNumaId int32) *NumaConfig {
	this := NumaConfig{}
	this.GuestNumaId = guestNumaId
	return &this
}

// NewNumaConfigWithDefaults instantiates a new NumaConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewNumaConfigWithDefaults() *NumaConfig {
	this := NumaConfig{}
	return &this
}

// GetGuestNumaId returns the GuestNumaId field value
func (o *NumaConfig) GetGuestNumaId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.GuestNumaId
}

// GetGuestNumaIdOk returns a tuple with the GuestNumaId field value
// and a boolean to check if the value has been set.
func (o *NumaConfig) GetGuestNumaIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.GuestNumaId, true
}

// SetGuestNumaId sets field value
func (o *NumaConfig) SetGuestNumaId(v int32) {
	o.GuestNumaId = v
}

// GetCpus returns the Cpus field value if set, zero value otherwise.
func (o *NumaConfig) GetCpus() []int32 {
	if o == nil || o.Cpus == nil {
		var ret []int32
		return ret
	}
	return *o.Cpus
}

// GetCpusOk returns a tuple with the Cpus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *NumaConfig) GetCpusOk() (*[]int32, bool) {
	if o == nil || o.Cpus == nil {
		return nil, false
	}
	return o.Cpus, true
}

// HasCpus returns a boolean if a field has been set.
func (o *NumaConfig) HasCpus() bool {
	if o != nil && o.Cpus != nil {
		return true
	}

	return false
}

// SetCpus gets a reference to the given []int32 and assigns it to the Cpus field.
func (o *NumaConfig) SetCpus(v []int32) {
	o.Cpus = &v
}

// GetDistances returns the Distances field value if set, zero value otherwise.
func (o *NumaConfig) GetDistances() []NumaDistance {
	if o == nil || o.Distances == nil {
		var ret []NumaDistance
		return ret
	}
	return *o.Distances
}

// GetDistancesOk returns a tuple with the Distances field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *NumaConfig) GetDistancesOk() (*[]NumaDistance, bool) {
	if o == nil || o.Distances == nil {
		return nil, false
	}
	return o.Distances, true
}

// HasDistances returns a boolean if a field has been set.
func (o *NumaConfig) HasDistances() bool {
	if o != nil && o.Distances != nil {
		return true
	}

	return false
}

// SetDistances gets a reference to the given []NumaDistance and assigns it to the Distances field.
func (o *NumaConfig) SetDistances(v []NumaDistance) {
	o.Distances = &v
}

// GetMemoryZones returns the MemoryZones field value if set, zero value otherwise.
func (o *NumaConfig) GetMemoryZones() []string {
	if o == nil || o.MemoryZones == nil {
		var ret []string
		return ret
	}
	return *o.MemoryZones
}

// GetMemoryZonesOk returns a tuple with the MemoryZones field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *NumaConfig) GetMemoryZonesOk() (*[]string, bool) {
	if o == nil || o.MemoryZones == nil {
		return nil, false
	}
	return o.MemoryZones, true
}

// HasMemoryZones returns a boolean if a field has been set.
func (o *NumaConfig) HasMemoryZones() bool {
	if o != nil && o.MemoryZones != nil {
		return true
	}

	return false
}

// SetMemoryZones gets a reference to the given []string and assigns it to the MemoryZones field.
func (o *NumaConfig) SetMemoryZones(v []string) {
	o.MemoryZones = &v
}

// GetSgxEpcSections returns the SgxEpcSections field value if set, zero value otherwise.
func (o *NumaConfig) GetSgxEpcSections() []string {
	if o == nil || o.SgxEpcSections == nil {
		var ret []string
		return ret
	}
	return *o.SgxEpcSections
}

// GetSgxEpcSectionsOk returns a tuple with the SgxEpcSections field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *NumaConfig) GetSgxEpcSectionsOk() (*[]string, bool) {
	if o == nil || o.SgxEpcSections == nil {
		return nil, false
	}
	return o.SgxEpcSections, true
}

// HasSgxEpcSections returns a boolean if a field has been set.
func (o *NumaConfig) HasSgxEpcSections() bool {
	if o != nil && o.SgxEpcSections != nil {
		return true
	}

	return false
}

// SetSgxEpcSections gets a reference to the given []string and assigns it to the SgxEpcSections field.
func (o *NumaConfig) SetSgxEpcSections(v []string) {
	o.SgxEpcSections = &v
}

func (o NumaConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["guest_numa_id"] = o.GuestNumaId
	}
	if o.Cpus != nil {
		toSerialize["cpus"] = o.Cpus
	}
	if o.Distances != nil {
		toSerialize["distances"] = o.Distances
	}
	if o.MemoryZones != nil {
		toSerialize["memory_zones"] = o.MemoryZones
	}
	if o.SgxEpcSections != nil {
		toSerialize["sgx_epc_sections"] = o.SgxEpcSections
	}
	return json.Marshal(toSerialize)
}

type NullableNumaConfig struct {
	value *NumaConfig
	isSet bool
}

func (v NullableNumaConfig) Get() *NumaConfig {
	return v.value
}

func (v *NullableNumaConfig) Set(val *NumaConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableNumaConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableNumaConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableNumaConfig(val *NumaConfig) *NullableNumaConfig {
	return &NullableNumaConfig{value: val, isSet: true}
}

func (v NullableNumaConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableNumaConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
