---
layout: tutorials
permalink: /tutorials/using-jekyll-with-bundler/
title: Using Jekyll with Bundler
---

> Bundler provides a consistent environment for Ruby projects by tracking and
> installing the exact gems and versions that are needed.

[Bundler](https://bundler.io) can be a great tool to use with Jekyll. Because it
tracks dependencies on a per-project basis, it is particularly useful if you
need to run different versions of Jekyll in different projects, or if you don't
want to install Jekyll at the system or user level. This tutorial will show you
how to create a new Jekyll project using Bundler and without installing Jekyll
outside the project.

## Before You Begin

To complete this tutorial, you'll need to have
[Ruby](https://www.ruby-lang.org/en/) and [Bundler](https://bundler.io/)
installed. You can find the installation instructions on their websites.

## Initialize Bundler

The first thing to do is create a new directory for your project and run
`bundle init`. This creates a new Bundler project (by creating an empty
Gemfile).

```sh
mkdir my-jekyll-website
cd my-jekyll-website
bundle init
```

## Configure Bundler

This step is optional, but encouraged. We're going to configure Bundler to install
gems in the `./vendor/bundle/` project subdirectory. This allows us to install
our dependencies in an isolated environment, ensuring they don't conflict with
other gems on your system. If you skip this step, Bundler will install your
dependencies globally on your system.

```sh
bundle install --path vendor/bundle
```

<div class="note info">
  <h5>Bundler Config is Persistent</h5>
  <p>
    This step is only required once per project. Bundler saves your config in
    <code>./.bundle/config</code>, so future gems will be installed to the same
    location.
  </p>
</div>

## Add Jekyll

Now, we're going to use Bundler to add Jekyll as a dependency of our new
project. This command will add the Jekyll gem to our Gemfile and install it to
the `./vendor/bundle/` folder.

```sh
bundle add jekyll
```

## Create A Jekyll Scaffold

Now that Jekyll is installed, we can use it to create the scaffolding for our
site. We need the `--force` parameter because our folder isn't empty - it
already has some Bundler files in it. We run the `bundle install` separately
because Jekyll gets confused if the Gemfile already exists.

```sh
bundle exec jekyll new --force --skip-bundle .
bundle install
```

## Serve the Site

Your new website is ready! You can serve the website with
`bundle exec jekyll serve` and visit it at
[http://127.0.0.1:4000](http://127.0.0.1:4000). From here, you're ready to
continue developing the site on your own. All of the normal Jekyll commands are
available to you, but you should prefix them with `bundle exec` so that Bundler
runs the version of Jekyll that is installed in your project folder.

## Commit to Source Control

If you're storing your new site in version control, you'll want to ignore the
`./vendor/` and `./.bundle/` folders since they contain user- or
platform-specific information. New users will be able to install the correct
dependencies based on `Gemfile` and `Gemfile.lock`, which should both be checked
in. You can use this `.gitigonre` to get started, if you want.

**.gitignore**

```
# Ignore folders generated by Bundler
vendor
.bundle

# Ignore folders generated by Jekyll
.sass-cache
_site
```

