module VerifyColor240 where

import Data.Word(Word8)
import Verify

import Graphics.Vty.Attributes.Color240(rgbColorToColor240)

oldRgbColorToColor240 :: Integral i => i -> i -> i -> Word8
oldRgbColorToColor240 r g b
    | r < 0 && g < 0 && b < 0 = error "rgbColor with negative color component intensity"
    | r == 8 && g == 8 && b == 8 = 216
    | r == 18 && g == 18 && b == 18 = 217
    | r == 28 && g == 28 && b == 28 = 218
    | r == 38 && g == 38 && b == 38 = 219
    | r == 48 && g == 48 && b == 48 = 220
    | r == 58 && g == 58 && b == 58 = 221
    | r == 68 && g == 68 && b == 68 = 222
    | r == 78 && g == 78 && b == 78 = 223
    | r == 88 && g == 88 && b == 88 = 224
    | r == 98 && g == 98 && b == 98 = 225
    | r == 108 && g == 108 && b == 108 = 226
    | r == 118 && g == 118 && b == 118 = 227
    | r == 128 && g == 128 && b == 128 = 228
    | r == 138 && g == 138 && b == 138 = 229
    | r == 148 && g == 148 && b == 148 = 230
    | r == 158 && g == 158 && b == 158 = 231
    | r == 168 && g == 168 && b == 168 = 232
    | r == 178 && g == 178 && b == 178 = 233
    | r == 188 && g == 188 && b == 188 = 234
    | r == 198 && g == 198 && b == 198 = 235
    | r == 208 && g == 208 && b == 208 = 236
    | r == 218 && g == 218 && b == 218 = 237
    | r == 228 && g == 228 && b == 228 = 238
    | r == 238 && g == 238 && b == 238 = 239
    | r <= 0 && g <= 0 && b <= 0 = 0
    | r <= 0 && g <= 0 && b <= 95 = 1
    | r <= 0 && g <= 0 && b <= 135 = 2
    | r <= 0 && g <= 0 && b <= 175 = 3
    | r <= 0 && g <= 0 && b <= 215 = 4
    | r <= 0 && g <= 0 && b <= 255 = 5
    | r <= 0 && g <= 95 && b <= 0 = 6
    | r <= 0 && g <= 95 && b <= 95 = 7
    | r <= 0 && g <= 95 && b <= 135 = 8
    | r <= 0 && g <= 95 && b <= 175 = 9
    | r <= 0 && g <= 95 && b <= 215 = 10
    | r <= 0 && g <= 95 && b <= 255 = 11
    | r <= 0 && g <= 135 && b <= 0 = 12
    | r <= 0 && g <= 135 && b <= 95 = 13
    | r <= 0 && g <= 135 && b <= 135 = 14
    | r <= 0 && g <= 135 && b <= 175 = 15
    | r <= 0 && g <= 135 && b <= 215 = 16
    | r <= 0 && g <= 135 && b <= 255 = 17
    | r <= 0 && g <= 175 && b <= 0 = 18
    | r <= 0 && g <= 175 && b <= 95 = 19
    | r <= 0 && g <= 175 && b <= 135 = 20
    | r <= 0 && g <= 175 && b <= 175 = 21
    | r <= 0 && g <= 175 && b <= 215 = 22
    | r <= 0 && g <= 175 && b <= 255 = 23
    | r <= 0 && g <= 215 && b <= 0 = 24
    | r <= 0 && g <= 215 && b <= 95 = 25
    | r <= 0 && g <= 215 && b <= 135 = 26
    | r <= 0 && g <= 215 && b <= 175 = 27
    | r <= 0 && g <= 215 && b <= 215 = 28
    | r <= 0 && g <= 215 && b <= 255 = 29
    | r <= 0 && g <= 255 && b <= 0 = 30
    | r <= 0 && g <= 255 && b <= 95 = 31
    | r <= 0 && g <= 255 && b <= 135 = 32
    | r <= 0 && g <= 255 && b <= 175 = 33
    | r <= 0 && g <= 255 && b <= 215 = 34
    | r <= 0 && g <= 255 && b <= 255 = 35
    | r <= 95 && g <= 0 && b <= 0 = 36
    | r <= 95 && g <= 0 && b <= 95 = 37
    | r <= 95 && g <= 0 && b <= 135 = 38
    | r <= 95 && g <= 0 && b <= 175 = 39
    | r <= 95 && g <= 0 && b <= 215 = 40
    | r <= 95 && g <= 0 && b <= 255 = 41
    | r <= 95 && g <= 95 && b <= 0 = 42
    | r <= 95 && g <= 95 && b <= 95 = 43
    | r <= 95 && g <= 95 && b <= 135 = 44
    | r <= 95 && g <= 95 && b <= 175 = 45
    | r <= 95 && g <= 95 && b <= 215 = 46
    | r <= 95 && g <= 95 && b <= 255 = 47
    | r <= 95 && g <= 135 && b <= 0 = 48
    | r <= 95 && g <= 135 && b <= 95 = 49
    | r <= 95 && g <= 135 && b <= 135 = 50
    | r <= 95 && g <= 135 && b <= 175 = 51
    | r <= 95 && g <= 135 && b <= 215 = 52
    | r <= 95 && g <= 135 && b <= 255 = 53
    | r <= 95 && g <= 175 && b <= 0 = 54
    | r <= 95 && g <= 175 && b <= 95 = 55
    | r <= 95 && g <= 175 && b <= 135 = 56
    | r <= 95 && g <= 175 && b <= 175 = 57
    | r <= 95 && g <= 175 && b <= 215 = 58
    | r <= 95 && g <= 175 && b <= 255 = 59
    | r <= 95 && g <= 215 && b <= 0 = 60
    | r <= 95 && g <= 215 && b <= 95 = 61
    | r <= 95 && g <= 215 && b <= 135 = 62
    | r <= 95 && g <= 215 && b <= 175 = 63
    | r <= 95 && g <= 215 && b <= 215 = 64
    | r <= 95 && g <= 215 && b <= 255 = 65
    | r <= 95 && g <= 255 && b <= 0 = 66
    | r <= 95 && g <= 255 && b <= 95 = 67
    | r <= 95 && g <= 255 && b <= 135 = 68
    | r <= 95 && g <= 255 && b <= 175 = 69
    | r <= 95 && g <= 255 && b <= 215 = 70
    | r <= 95 && g <= 255 && b <= 255 = 71
    | r <= 135 && g <= 0 && b <= 0 = 72
    | r <= 135 && g <= 0 && b <= 95 = 73
    | r <= 135 && g <= 0 && b <= 135 = 74
    | r <= 135 && g <= 0 && b <= 175 = 75
    | r <= 135 && g <= 0 && b <= 215 = 76
    | r <= 135 && g <= 0 && b <= 255 = 77
    | r <= 135 && g <= 95 && b <= 0 = 78
    | r <= 135 && g <= 95 && b <= 95 = 79
    | r <= 135 && g <= 95 && b <= 135 = 80
    | r <= 135 && g <= 95 && b <= 175 = 81
    | r <= 135 && g <= 95 && b <= 215 = 82
    | r <= 135 && g <= 95 && b <= 255 = 83
    | r <= 135 && g <= 135 && b <= 0 = 84
    | r <= 135 && g <= 135 && b <= 95 = 85
    | r <= 135 && g <= 135 && b <= 135 = 86
    | r <= 135 && g <= 135 && b <= 175 = 87
    | r <= 135 && g <= 135 && b <= 215 = 88
    | r <= 135 && g <= 135 && b <= 255 = 89
    | r <= 135 && g <= 175 && b <= 0 = 90
    | r <= 135 && g <= 175 && b <= 95 = 91
    | r <= 135 && g <= 175 && b <= 135 = 92
    | r <= 135 && g <= 175 && b <= 175 = 93
    | r <= 135 && g <= 175 && b <= 215 = 94
    | r <= 135 && g <= 175 && b <= 255 = 95
    | r <= 135 && g <= 215 && b <= 0 = 96
    | r <= 135 && g <= 215 && b <= 95 = 97
    | r <= 135 && g <= 215 && b <= 135 = 98
    | r <= 135 && g <= 215 && b <= 175 = 99
    | r <= 135 && g <= 215 && b <= 215 = 100
    | r <= 135 && g <= 215 && b <= 255 = 101
    | r <= 135 && g <= 255 && b <= 0 = 102
    | r <= 135 && g <= 255 && b <= 95 = 103
    | r <= 135 && g <= 255 && b <= 135 = 104
    | r <= 135 && g <= 255 && b <= 175 = 105
    | r <= 135 && g <= 255 && b <= 215 = 106
    | r <= 135 && g <= 255 && b <= 255 = 107
    | r <= 175 && g <= 0 && b <= 0 = 108
    | r <= 175 && g <= 0 && b <= 95 = 109
    | r <= 175 && g <= 0 && b <= 135 = 110
    | r <= 175 && g <= 0 && b <= 175 = 111
    | r <= 175 && g <= 0 && b <= 215 = 112
    | r <= 175 && g <= 0 && b <= 255 = 113
    | r <= 175 && g <= 95 && b <= 0 = 114
    | r <= 175 && g <= 95 && b <= 95 = 115
    | r <= 175 && g <= 95 && b <= 135 = 116
    | r <= 175 && g <= 95 && b <= 175 = 117
    | r <= 175 && g <= 95 && b <= 215 = 118
    | r <= 175 && g <= 95 && b <= 255 = 119
    | r <= 175 && g <= 135 && b <= 0 = 120
    | r <= 175 && g <= 135 && b <= 95 = 121
    | r <= 175 && g <= 135 && b <= 135 = 122
    | r <= 175 && g <= 135 && b <= 175 = 123
    | r <= 175 && g <= 135 && b <= 215 = 124
    | r <= 175 && g <= 135 && b <= 255 = 125
    | r <= 175 && g <= 175 && b <= 0 = 126
    | r <= 175 && g <= 175 && b <= 95 = 127
    | r <= 175 && g <= 175 && b <= 135 = 128
    | r <= 175 && g <= 175 && b <= 175 = 129
    | r <= 175 && g <= 175 && b <= 215 = 130
    | r <= 175 && g <= 175 && b <= 255 = 131
    | r <= 175 && g <= 215 && b <= 0 = 132
    | r <= 175 && g <= 215 && b <= 95 = 133
    | r <= 175 && g <= 215 && b <= 135 = 134
    | r <= 175 && g <= 215 && b <= 175 = 135
    | r <= 175 && g <= 215 && b <= 215 = 136
    | r <= 175 && g <= 215 && b <= 255 = 137
    | r <= 175 && g <= 255 && b <= 0 = 138
    | r <= 175 && g <= 255 && b <= 95 = 139
    | r <= 175 && g <= 255 && b <= 135 = 140
    | r <= 175 && g <= 255 && b <= 175 = 141
    | r <= 175 && g <= 255 && b <= 215 = 142
    | r <= 175 && g <= 255 && b <= 255 = 143
    | r <= 215 && g <= 0 && b <= 0 = 144
    | r <= 215 && g <= 0 && b <= 95 = 145
    | r <= 215 && g <= 0 && b <= 135 = 146
    | r <= 215 && g <= 0 && b <= 175 = 147
    | r <= 215 && g <= 0 && b <= 215 = 148
    | r <= 215 && g <= 0 && b <= 255 = 149
    | r <= 215 && g <= 95 && b <= 0 = 150
    | r <= 215 && g <= 95 && b <= 95 = 151
    | r <= 215 && g <= 95 && b <= 135 = 152
    | r <= 215 && g <= 95 && b <= 175 = 153
    | r <= 215 && g <= 95 && b <= 215 = 154
    | r <= 215 && g <= 95 && b <= 255 = 155
    | r <= 215 && g <= 135 && b <= 0 = 156
    | r <= 215 && g <= 135 && b <= 95 = 157
    | r <= 215 && g <= 135 && b <= 135 = 158
    | r <= 215 && g <= 135 && b <= 175 = 159
    | r <= 215 && g <= 135 && b <= 215 = 160
    | r <= 215 && g <= 135 && b <= 255 = 161
    | r <= 215 && g <= 175 && b <= 0 = 162
    | r <= 215 && g <= 175 && b <= 95 = 163
    | r <= 215 && g <= 175 && b <= 135 = 164
    | r <= 215 && g <= 175 && b <= 175 = 165
    | r <= 215 && g <= 175 && b <= 215 = 166
    | r <= 215 && g <= 175 && b <= 255 = 167
    | r <= 215 && g <= 215 && b <= 0 = 168
    | r <= 215 && g <= 215 && b <= 95 = 169
    | r <= 215 && g <= 215 && b <= 135 = 170
    | r <= 215 && g <= 215 && b <= 175 = 171
    | r <= 215 && g <= 215 && b <= 215 = 172
    | r <= 215 && g <= 215 && b <= 255 = 173
    | r <= 215 && g <= 255 && b <= 0 = 174
    | r <= 215 && g <= 255 && b <= 95 = 175
    | r <= 215 && g <= 255 && b <= 135 = 176
    | r <= 215 && g <= 255 && b <= 175 = 177
    | r <= 215 && g <= 255 && b <= 215 = 178
    | r <= 215 && g <= 255 && b <= 255 = 179
    | r <= 255 && g <= 0 && b <= 0 = 180
    | r <= 255 && g <= 0 && b <= 95 = 181
    | r <= 255 && g <= 0 && b <= 135 = 182
    | r <= 255 && g <= 0 && b <= 175 = 183
    | r <= 255 && g <= 0 && b <= 215 = 184
    | r <= 255 && g <= 0 && b <= 255 = 185
    | r <= 255 && g <= 95 && b <= 0 = 186
    | r <= 255 && g <= 95 && b <= 95 = 187
    | r <= 255 && g <= 95 && b <= 135 = 188
    | r <= 255 && g <= 95 && b <= 175 = 189
    | r <= 255 && g <= 95 && b <= 215 = 190
    | r <= 255 && g <= 95 && b <= 255 = 191
    | r <= 255 && g <= 135 && b <= 0 = 192
    | r <= 255 && g <= 135 && b <= 95 = 193
    | r <= 255 && g <= 135 && b <= 135 = 194
    | r <= 255 && g <= 135 && b <= 175 = 195
    | r <= 255 && g <= 135 && b <= 215 = 196
    | r <= 255 && g <= 135 && b <= 255 = 197
    | r <= 255 && g <= 175 && b <= 0 = 198
    | r <= 255 && g <= 175 && b <= 95 = 199
    | r <= 255 && g <= 175 && b <= 135 = 200
    | r <= 255 && g <= 175 && b <= 175 = 201
    | r <= 255 && g <= 175 && b <= 215 = 202
    | r <= 255 && g <= 175 && b <= 255 = 203
    | r <= 255 && g <= 215 && b <= 0 = 204
    | r <= 255 && g <= 215 && b <= 95 = 205
    | r <= 255 && g <= 215 && b <= 135 = 206
    | r <= 255 && g <= 215 && b <= 175 = 207
    | r <= 255 && g <= 215 && b <= 215 = 208
    | r <= 255 && g <= 215 && b <= 255 = 209
    | r <= 255 && g <= 255 && b <= 0 = 210
    | r <= 255 && g <= 255 && b <= 95 = 211
    | r <= 255 && g <= 255 && b <= 135 = 212
    | r <= 255 && g <= 255 && b <= 175 = 213
    | r <= 255 && g <= 255 && b <= 215 = 214
    | r <= 255 && g <= 255 && b <= 255 = 215
    | otherwise = error (printf "RGB color %d %d %d does not map to 240 palette."
                                (fromIntegral r :: Int)
                                (fromIntegral g :: Int)
                                (fromIntegral b :: Int))

sameColor :: Int -> Int -> Int -> Bool
sameColor r g b = oldRgbColorToColor240 r g b == rgbColorToColor240 r g b

genVal :: Gen Int
genVal = chooseInt (0, 255)

sameColorCheck :: Property
sameColorCheck = forAll genVal (\r -> forAll genVal (\g -> forAll genVal (sameColor r g)))

tests :: IO [Test]
tests = return
  [ verify "check rgbColorToColor240 optimization is correct" sameColorCheck
  ]

