// Code generated by smithy-go-codegen DO NOT EDIT.

package lakeformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lakeformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the data cell filters on a table.
func (c *Client) ListDataCellsFilter(ctx context.Context, params *ListDataCellsFilterInput, optFns ...func(*Options)) (*ListDataCellsFilterOutput, error) {
	if params == nil {
		params = &ListDataCellsFilterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataCellsFilter", params, optFns, c.addOperationListDataCellsFilterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataCellsFilterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDataCellsFilterInput struct {

	// The maximum size of the response.
	MaxResults *int32

	// A continuation token, if this is a continuation call.
	NextToken *string

	// A table in the Glue Data Catalog.
	Table *types.TableResource

	noSmithyDocumentSerde
}

type ListDataCellsFilterOutput struct {

	// A list of DataCellFilter structures.
	DataCellsFilters []types.DataCellsFilter

	// A continuation token, if not all requested data cell filters have been returned.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataCellsFilterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataCellsFilter{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataCellsFilter{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListDataCellsFilterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataCellsFilter(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDataCellsFilterAPIClient is a client that implements the ListDataCellsFilter
// operation.
type ListDataCellsFilterAPIClient interface {
	ListDataCellsFilter(context.Context, *ListDataCellsFilterInput, ...func(*Options)) (*ListDataCellsFilterOutput, error)
}

var _ ListDataCellsFilterAPIClient = (*Client)(nil)

// ListDataCellsFilterPaginatorOptions is the paginator options for
// ListDataCellsFilter
type ListDataCellsFilterPaginatorOptions struct {
	// The maximum size of the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataCellsFilterPaginator is a paginator for ListDataCellsFilter
type ListDataCellsFilterPaginator struct {
	options   ListDataCellsFilterPaginatorOptions
	client    ListDataCellsFilterAPIClient
	params    *ListDataCellsFilterInput
	nextToken *string
	firstPage bool
}

// NewListDataCellsFilterPaginator returns a new ListDataCellsFilterPaginator
func NewListDataCellsFilterPaginator(client ListDataCellsFilterAPIClient, params *ListDataCellsFilterInput, optFns ...func(*ListDataCellsFilterPaginatorOptions)) *ListDataCellsFilterPaginator {
	if params == nil {
		params = &ListDataCellsFilterInput{}
	}

	options := ListDataCellsFilterPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataCellsFilterPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataCellsFilterPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataCellsFilter page.
func (p *ListDataCellsFilterPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataCellsFilterOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListDataCellsFilter(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListDataCellsFilter(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lakeformation",
		OperationName: "ListDataCellsFilter",
	}
}
