// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservice

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a conditional forwarder that has been set up for your Amazon Web
// Services directory.
func (c *Client) UpdateConditionalForwarder(ctx context.Context, params *UpdateConditionalForwarderInput, optFns ...func(*Options)) (*UpdateConditionalForwarderOutput, error) {
	if params == nil {
		params = &UpdateConditionalForwarderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateConditionalForwarder", params, optFns, c.addOperationUpdateConditionalForwarderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateConditionalForwarderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Updates a conditional forwarder.
type UpdateConditionalForwarderInput struct {

	// The directory ID of the Amazon Web Services directory for which to update the
	// conditional forwarder.
	//
	// This member is required.
	DirectoryId *string

	// The updated IP addresses of the remote DNS server associated with the
	// conditional forwarder.
	//
	// This member is required.
	DnsIpAddrs []string

	// The fully qualified domain name (FQDN) of the remote domain with which you will
	// set up a trust relationship.
	//
	// This member is required.
	RemoteDomainName *string

	noSmithyDocumentSerde
}

// The result of an UpdateConditionalForwarder request.
type UpdateConditionalForwarderOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateConditionalForwarderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateConditionalForwarder{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateConditionalForwarder{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateConditionalForwarderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateConditionalForwarder(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateConditionalForwarder(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ds",
		OperationName: "UpdateConditionalForwarder",
	}
}
